/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.CreatedRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonLeafNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecursiveNodeMoveRenameProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecursiveNodeMoveRenameProcessor.class);
    private final ExplorationViewRepresentation m_representation;
    private final RecursiveElementRefactoringDescriptor m_recursiveDescriptor;
    private final AssignableToArtifactRefactoringDescriptor m_assignableDescriptor;
    private final ArchitecturalViewNode m_rootNode;
    private InternalNonRecursiveNonLeafNodeCollector m_collector;
    private int m_colliding;
    private int m_moveables;

    private static Set<String> getExisting(AssignableToArtifactRefactoringDescriptor descriptor, ArchitecturalViewNode target) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'getExisting' must not be null";
        if (target == null) {
            return Collections.emptySet();
        }
        HashSet<String> existing = new HashSet<String>();
        for (ArchitecturalViewNode nextChild : target.getNodeChildren(n -> true, false)) {
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            existing.add(descriptor.getRelevantNamePartForRename(nextChild.getName()));
        }
        return existing;
    }

    private static State determineState(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'determineState' must not be null";
        assert (source != null) : "Parameter 'source' of method 'determineState' must not be null";
        assert (source != target) : "Same instances";
        LOGGER.debug("Determine state " + source.getElementInfo(true, false) + " -> " + (target != null ? target.getElementInfo(true, false) : "<no target>"));
        State state = State.EMPTY;
        Set<String> existing = RecursiveNodeMoveRenameProcessor.getExisting(descriptor, target);
        for (ArchitecturalViewNode nextChild : source.getNodeChildren(n -> true, false)) {
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            String nextRelevantNamePart = descriptor.getRelevantNamePartForRename(nextChild.getName());
            if (existing.contains(nextRelevantNamePart)) {
                state = State.CONTAINS_ONLY_COLLIDING;
                LOGGER.debug("Colliding '" + nextRelevantNamePart + "'");
                continue;
            }
            state = State.CONTAINS_AT_LEAST_ONE_MOVABLE;
            LOGGER.debug("First movable '" + nextRelevantNamePart + "'");
            break;
        }
        LOGGER.debug("Determine state " + source.getElementInfo(true, false) + " -> " + (target != null ? target.getElementInfo(true, false) : "<no target>") + " - done");
        return state;
    }

    static State check(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target, ExplorationViewRepresentation representation) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'check' must not be null";
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'check' must not be null";
        assert (source != target) : "Same instances";
        assert (representation != null) : "Parameter 'representation' of method 'check' must not be null";
        LOGGER.debug("Check " + source.getElementInfo(true, false));
        State state = RecursiveNodeMoveRenameProcessor.determineState(descriptor, source, target);
        if (state != State.CONTAINS_AT_LEAST_ONE_MOVABLE) {
            CheckVisitor checkVisitor = new CheckVisitor(descriptor, source, target, state, representation);
            source.accept(checkVisitor);
            state = checkVisitor.getState();
        }
        LOGGER.debug("Check " + source.getElementInfo(true, false) + " - done [" + String.valueOf((Object)state) + "]");
        return state;
    }

    static String getRecursiveNodeMoveTargetName(RecursiveElementRefactoringDescriptor recursiveDescriptor, RecursiveNode source, ArchitecturalViewNode target, boolean recursive) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getRecursiveNodeMoveTargetName' must not be null";
        assert (source != null) : "Parameter 'source' of method 'getRecursiveNodeMoveTarget' must not be null";
        assert (target != null) : "Parameter 'target' of method 'getRecursiveNodeMoveTarget' must not be null";
        assert (source != target) : "Same instances";
        if (recursive) {
            String sourceShortName = source.getFirstUnderlyingElement().getShortName();
            if (target instanceof RecursiveNode) {
                return target.getName() + recursiveDescriptor.getSeparator() + sourceShortName;
            }
            return sourceShortName;
        }
        String sourceName = source.getFirstUnderlyingElement().getName();
        if (target instanceof RecursiveNode) {
            return target.getName() + recursiveDescriptor.getSeparator() + sourceName;
        }
        return sourceName;
    }

    static void isRecursiveElementNameValid(ValidationResult result, RecursiveElementRefactoringDescriptor descriptor, String name) {
        assert (result != null) : "Parameter 'result' of method 'isRecursiveElementNameValid' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'isRecursiveElementNameValid' must not be null";
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            result.addError("Must not be empty");
        } else if (!descriptor.isValidNameForRename(name)) {
            result.addError("Not a valid name");
        }
    }

    static ITextValidator getNameValidator(final RecursiveElementRefactoringDescriptor recursiveDescriptor) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                RecursiveNodeMoveRenameProcessor.isRecursiveElementNameValid(result, recursiveDescriptor, newInput);
                return result;
            }
        };
    }

    static ITextValidator getRenameValidator(final RecursiveElementRefactoringDescriptor recursiveDescriptor, final AssignableToArtifactRefactoringDescriptor assignableDescriptor, final NonRecursiveNonLeafNode root, final RecursiveNode node, final ExplorationViewRepresentation representation) {
        assert (recursiveDescriptor != null) : "Parameter 'recursiveDescriptor' of method 'getRenameValidator' must not be null";
        assert (assignableDescriptor != null) : "Parameter 'assignableDescriptor' of method 'getRenameValidator' must not be null";
        assert (root != null) : "Parameter 'root' of method 'getRenameValidator' must not be null";
        assert (node != null) : "Parameter 'node' of method 'getRenameValidator' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getRenameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public final ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                RecursiveNodeMoveRenameProcessor.isRecursiveElementNameValid(result, recursiveDescriptor, newInput);
                if (result.isSuccess()) {
                    List<String> splitName = recursiveDescriptor.split(newInput);
                    RecursiveNode target = ArchitecturalViewElementResolver.resolveByShortName(splitName, RecursiveNode.class, root, representation);
                    if (node == target) {
                        result.addError("Name must be different");
                    } else if (target != null) {
                        State state = RecursiveNodeMoveRenameProcessor.check(assignableDescriptor, node, target, representation);
                        switch (state) {
                            case CONTAINS_ONLY_COLLIDING: {
                                result.addError("All contained assignables collide with existing ones");
                                break;
                            }
                            case EMPTY: 
                            case CONTAINS_AT_LEAST_ONE_MOVABLE: {
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)("Unhandled state: " + String.valueOf((Object)state)));
                                }
                                break;
                            }
                        }
                    }
                }
                return result;
            }
        };
    }

    RecursiveNodeMoveRenameProcessor(ExplorationViewRepresentation representation, RecursiveElementRefactoringDescriptor recursiveDescriptor, AssignableToArtifactRefactoringDescriptor assignableDescriptor, ArchitecturalViewNode rootNode) {
        assert (representation != null) : "Parameter 'representation' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (recursiveDescriptor != null) : "Parameter 'descriptor' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (assignableDescriptor != null) : "Parameter 'assignableDescriptor' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        assert (rootNode != null) : "Parameter 'rootNode' of method 'RecursiveNodeMoveRenameProcessor' must not be null";
        this.m_representation = representation;
        this.m_recursiveDescriptor = recursiveDescriptor;
        this.m_assignableDescriptor = assignableDescriptor;
        this.m_rootNode = rootNode;
    }

    int getNumberOfColliding() {
        return this.m_colliding;
    }

    public int getNumberOfMoveables() {
        return this.m_moveables;
    }

    private RecursiveNode findElsewhere(List<String> shortNames, ExplorationViewRepresentation representation) {
        assert (shortNames != null && !shortNames.isEmpty()) : "Parameter 'shortNames' of method 'findElsewhere' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'findElsewhere' must not be null";
        LOGGER.debug("Search recursive element '" + String.valueOf(shortNames) + "'");
        ArchitecturalViewElement found = null;
        if (this.m_collector == null) {
            LOGGER.debug("Collecting 'NonRecursiveNonLeafNode' instances");
            this.m_collector = new InternalNonRecursiveNonLeafNodeCollector();
            this.m_representation.accept(this.m_collector);
            LOGGER.debug("Collecting 'NonRecursiveNonLeafNode' instances - done");
        }
        for (NonRecursiveNonLeafNode next : this.m_collector.getNodes()) {
            RecursiveNode nextFoundElsewhere = ArchitecturalViewElementResolver.resolveByShortName(shortNames, RecursiveNode.class, next, representation);
            if (nextFoundElsewhere == null) continue;
            found = nextFoundElsewhere;
            break;
        }
        LOGGER.debug("Search recursive element '" + String.valueOf(shortNames) + "' - done " + (String)(found == null ? "[not found]" : "[found in '" + found.getElementInfo(true, false) + "']"));
        return found;
    }

    RecursiveNode getOrCreateRecursiveElement(String name, ExplorationViewRepresentation representation) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getRecursiveElement' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'getOrCreateRecursiveElement' must not be null";
        LOGGER.debug("Get recursive element '" + name + "'");
        ArrayList<RecursiveNode> createdRecursiveNodes = new ArrayList<RecursiveNode>();
        List<String> shortNames = this.m_recursiveDescriptor.split(name);
        RecursiveNode recursiveLeafNode = null;
        int i = 0;
        ArchitecturalViewNode currentNode = this.m_rootNode;
        NamedElement currentUnderlyingParent = currentNode.getFirstUnderlyingElement();
        for (String nextShortName : shortNames) {
            ++i;
            RecursiveNode nextRecursiveNode = ArchitecturalViewElementResolver.resolveByShortName(Collections.singletonList(nextShortName), RecursiveNode.class, currentNode, representation);
            if (nextRecursiveNode != null) {
                if (nextRecursiveNode.isDeleted()) {
                    LOGGER.debug("Recycled already deleted node: " + nextRecursiveNode.getElementInfo(true, false));
                    nextRecursiveNode.setDeleted(false);
                    nextRecursiveNode.setDeletedRecycled(true);
                }
                currentUnderlyingParent = nextRecursiveNode.getFirstUnderlyingElement();
            } else {
                RecursiveNode nextFoundElsewhere = this.findElsewhere(shortNames.subList(0, i), representation);
                if (nextFoundElsewhere != null) {
                    LOGGER.debug("Using recursive node found elsewhere: " + nextFoundElsewhere.getElementInfo(true, false));
                    currentUnderlyingParent = nextFoundElsewhere.getFirstUnderlyingElement();
                    nextRecursiveNode = nextFoundElsewhere.copy(currentNode);
                    NodeHandler.reset(nextRecursiveNode);
                    createdRecursiveNodes.add(nextRecursiveNode);
                } else {
                    currentUnderlyingParent = this.m_recursiveDescriptor.createPrototype(currentUnderlyingParent, nextShortName, null);
                    assert (currentUnderlyingParent != null && currentUnderlyingParent instanceof IRecursiveElement) : "Unexpected class in method 'getRecursiveElement': " + String.valueOf(currentUnderlyingParent);
                    LOGGER.debug("Created prototype element: " + String.valueOf(currentUnderlyingParent));
                    nextRecursiveNode = new CreatedRecursiveNode((ArchitecturalViewElement)currentNode, this.m_representation.getPresentationMode(), (IRecursiveElement)((Object)currentUnderlyingParent));
                    createdRecursiveNodes.add(nextRecursiveNode);
                }
                currentNode.addChild(nextRecursiveNode);
            }
            recursiveLeafNode = nextRecursiveNode;
            currentNode = nextRecursiveNode;
        }
        if (!createdRecursiveNodes.isEmpty()) {
            createdRecursiveNodes.forEach(c -> RepresentationHandler.addProgrammingElementsToParents(c));
            FocusHandler.finishElementCreation(createdRecursiveNodes, this.m_representation);
        }
        LOGGER.debug("Get recursive element '" + name + "' - done");
        assert (recursiveLeafNode != null) : "'leafNode' of method 'getOrCreateRecursiveElement' must not be null";
        return recursiveLeafNode;
    }

    private void process(RecursiveNode source, ArchitecturalViewNode target, IMoveableConsumer consumer) {
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'process' must not be null";
        assert (source != target) : "Same instances";
        assert (consumer != null) : "Parameter 'consumer' of method 'process' must not be null";
        LOGGER.debug("Process " + source.getElementInfo(true, false) + " -> " + target.getElementInfo(true, false));
        ArrayList<AssignableToArtifactNode> colliding = new ArrayList<AssignableToArtifactNode>();
        ArrayList<AssignableToArtifactNode> moveables = new ArrayList<AssignableToArtifactNode>();
        Set<String> existing = RecursiveNodeMoveRenameProcessor.getExisting(this.m_assignableDescriptor, target);
        for (ArchitecturalViewNode nextChild : source.getNodeChildren(n -> true, false)) {
            String nextRelevantNamePart = this.m_assignableDescriptor.getRelevantNamePartForRename(nextChild.getName());
            if (!(nextChild instanceof AssignableToArtifactNode)) continue;
            if (existing.contains(nextRelevantNamePart)) {
                LOGGER.trace("Colliding '" + nextRelevantNamePart + "'");
                colliding.add((AssignableToArtifactNode)nextChild);
                ++this.m_colliding;
                continue;
            }
            LOGGER.trace("Moveable '" + nextRelevantNamePart + "'");
            moveables.add((AssignableToArtifactNode)nextChild);
            ++this.m_moveables;
        }
        LOGGER.debug("Detected " + moveables.size() + " moveable(s) and " + colliding.size() + " colliding");
        consumer.consume(source, target, moveables, colliding);
        LOGGER.debug("Process " + source.getElementInfo(true, false) + " -> " + target.getElementInfo(true, false) + " - done");
    }

    private Set<RecursiveNode> skip(RecursiveNode source, ArchitecturalViewNode target) {
        List<RecursiveNode> recursiveTargetParents;
        int index;
        assert (source != null) : "Parameter 'source' of method 'skip' must not be null";
        assert (target != null) : "Parameter 'target' of method 'skip' must not be null";
        assert (source != target) : "Same instances";
        if (target instanceof RecursiveNode && (index = (recursiveTargetParents = target.getParents(RecursiveNode.class, ExplorationViewRepresentation.class, NonRecursiveNode.class)).indexOf(source)) != -1) {
            List<RecursiveNode> subList = recursiveTargetParents.subList(0, index);
            THashSet skip = new THashSet(subList.size() + 1);
            skip.add((RecursiveNode)target);
            skip.addAll(subList);
            return skip;
        }
        return Collections.emptySet();
    }

    void process(RecursiveNode source, ArchitecturalViewNode target, boolean recursive, IMoveableConsumer consumer, ExplorationViewRepresentation representation) {
        assert (source != null) : "Parameter 'source' of method 'process' must not be null";
        assert (target != null) : "Parameter 'target' of method 'process' must not be null";
        assert (source != target) : "Same instances";
        assert (consumer != null) : "Parameter 'consumer' of method 'process' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'process' must not be null";
        LOGGER.debug("Process '" + source.getElementInfo(true, false) + "' -> '" + target.getElementInfo(true, false) + "'" + (recursive ? " [recursive]" : ""));
        this.process(source, target, consumer);
        if (recursive) {
            Set<RecursiveNode> skip = this.skip(source, target);
            source.accept(new ProcessVisitor(source, target, skip, consumer, representation));
        }
        LOGGER.debug("Process '" + source.getElementInfo(true, false) + "' -> '" + target.getElementInfo(true, false) + "'" + (recursive ? " [recursive]" : "") + " - done");
    }

    private static final class CheckVisitor
    extends ArchitecturalViewVisitor
    implements RecursiveNode.IVisitor,
    ArchitecturalViewNode.IVisitor {
        private final AssignableToArtifactRefactoringDescriptor m_descriptor;
        private final RecursiveNode m_source;
        private final ExplorationViewRepresentation m_representation;
        private ArchitecturalViewNode m_currentTarget;
        private State m_state;
        private boolean m_done;

        private CheckVisitor(AssignableToArtifactRefactoringDescriptor descriptor, RecursiveNode source, ArchitecturalViewNode target, State state, ExplorationViewRepresentation representation) {
            assert (descriptor != null) : "Parameter 'descriptor' of method 'CheckVisitor' must not be null";
            assert (source != null) : "Parameter 'source' of method 'ProcessVisitor' must not be null";
            assert (state != null) : "Parameter 'state' of method 'CheckVisitor' must not be null";
            assert (representation != null) : "Parameter 'representation' of method 'CheckVisitor' must not be null";
            this.m_descriptor = descriptor;
            this.m_source = source;
            this.m_currentTarget = target;
            this.m_state = state;
            this.m_representation = representation;
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            if (this.m_source != element) {
                if (this.m_currentTarget != null) {
                    this.m_currentTarget = ArchitecturalViewElementResolver.resolveByShortName(Collections.singletonList(element.getShortName()), RecursiveNode.class, this.m_currentTarget, this.m_representation);
                }
                State state = RecursiveNodeMoveRenameProcessor.determineState(this.m_descriptor, element, this.m_currentTarget);
                switch (state) {
                    case CONTAINS_AT_LEAST_ONE_MOVABLE: 
                    case CONTAINS_ONLY_COLLIDING: {
                        this.m_state = state;
                        break;
                    }
                    case EMPTY: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled state: " + String.valueOf((Object)state);
                        break;
                    }
                }
            }
            if (this.m_state == State.CONTAINS_AT_LEAST_ONE_MOVABLE || this.m_currentTarget == this.m_source) {
                this.m_done = true;
            } else {
                super.visitChildrenOf(element);
            }
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        }

        @Override
        protected boolean done() {
            return this.m_done;
        }

        State getState() {
            return this.m_state;
        }
    }

    static interface IMoveableConsumer {
        public void consume(RecursiveNode var1, ArchitecturalViewNode var2, List<AssignableToArtifactNode> var3, List<AssignableToArtifactNode> var4);
    }

    private static final class InternalNonRecursiveNonLeafNodeCollector
    extends ArchitecturalViewVisitor
    implements NonRecursiveNonLeafNode.IVisitor,
    RecursiveNode.IVisitor {
        private final ArrayDeque<NonRecursiveNonLeafNode> m_stack = new ArrayDeque();
        private final Set<NonRecursiveNonLeafNode> m_collector = new LinkedHashSet<NonRecursiveNonLeafNode>();

        private InternalNonRecursiveNonLeafNodeCollector() {
        }

        @Override
        public void visitNonRecursiveNonLeafNode(NonRecursiveNonLeafNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveNonLeafNode' must not be null";
            if (!element.isExternal()) {
                this.m_stack.push(element);
                this.visitChildrenOf(element);
                this.m_stack.pop();
            }
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            assert (!this.m_stack.isEmpty()) : "No root found for: " + String.valueOf(element);
            this.m_collector.add(this.m_stack.getFirst());
        }

        Set<NonRecursiveNonLeafNode> getNodes() {
            return Collections.unmodifiableSet(this.m_collector);
        }
    }

    private final class ProcessVisitor
    extends ArchitecturalViewVisitor
    implements RecursiveNode.IVisitor,
    ArchitecturalViewNode.IVisitor {
        private final ArrayDeque<ArchitecturalViewNode> m_targetStack = new ArrayDeque();
        private final RecursiveNode m_source;
        private final Set<RecursiveNode> m_skip;
        private final IMoveableConsumer m_consumer;
        private final ExplorationViewRepresentation m_representation;
        private boolean m_done;

        private ProcessVisitor(RecursiveNode source, ArchitecturalViewNode target, Set<RecursiveNode> skip, IMoveableConsumer consumer, ExplorationViewRepresentation representation) {
            assert (source != null) : "Parameter 'source' of method 'ProcessVisitor' must not be null";
            assert (target != null) : "Parameter 'target' of method 'ProcessVisitor' must not be null";
            assert (skip != null) : "Parameter 'skip' of method 'ProcessVisitor' must not be null";
            assert (consumer != null) : "Parameter 'consumer' of method 'ProcessVisitor' must not be null";
            assert (representation != null) : "Parameter 'representation' of method 'ProcessVisitor' must not be null";
            this.m_source = source;
            this.m_skip = skip;
            this.m_consumer = consumer;
            this.m_targetStack.push(target);
            this.m_representation = representation;
        }

        @Override
        public void visitRecursiveNode(RecursiveNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
            if (this.m_source == element) {
                super.visitChildrenOf(element);
            } else if (!this.m_skip.contains(element)) {
                ArchitecturalViewNode currentTarget = this.m_targetStack.peek();
                String nextTargetName = currentTarget.getName() + RecursiveNodeMoveRenameProcessor.this.m_recursiveDescriptor.getSeparator() + element.getFirstUnderlyingElement().getShortName();
                currentTarget = RecursiveNodeMoveRenameProcessor.this.getOrCreateRecursiveElement(nextTargetName, this.m_representation);
                RecursiveNodeMoveRenameProcessor.this.process(element, currentTarget, this.m_consumer);
                if (currentTarget == this.m_source) {
                    this.m_done = true;
                } else {
                    this.m_targetStack.push(currentTarget);
                    super.visitChildrenOf(element);
                    this.m_targetStack.pop();
                }
            }
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        }

        @Override
        protected boolean done() {
            return this.m_done;
        }
    }

    static enum State {
        EMPTY,
        CONTAINS_AT_LEAST_ONE_MOVABLE,
        CONTAINS_ONLY_COLLIDING;

    }
}

