/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IRecursiveElementCreationValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonLeafNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;

final class RecursiveElementCreationValidator
implements IRecursiveElementCreationValidator {
    private final RecursiveElementRefactoringDescriptor m_descriptor;
    private final ITextValidator m_validator;
    private final NonRecursiveNonLeafNode m_rootNode;
    private final ExplorationViewRepresentation m_representation;
    private IRecursiveElementCreationValidator.Action m_action = IRecursiveElementCreationValidator.Action.NONE;
    private ArchitecturalViewNode m_node;

    RecursiveElementCreationValidator(RecursiveElementRefactoringDescriptor descriptor, ITextValidator validator, NonRecursiveNonLeafNode rootNode, ExplorationViewRepresentation representation) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'RecursiveElementCreationValidator' must not be null";
        assert (validator != null) : "Parameter 'validator' of method 'RecursiveElementCreationValidator' must not be null";
        assert (rootNode != null) : "Parameter 'rootNode' of method 'RecursiveElementCreationValidator' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'RecursiveElementCreationValidator' must not be null";
        this.m_rootNode = rootNode;
        this.m_descriptor = descriptor;
        this.m_validator = validator;
        this.m_representation = representation;
    }

    @Override
    public RecursiveElementRefactoringDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public IRecursiveElementCreationValidator.Action getAction() {
        return this.m_action;
    }

    @Override
    public ArchitecturalViewNode getNodeForAction() {
        return this.m_node;
    }

    @Override
    public ArchitecturalViewNode getRootNode() {
        return this.m_rootNode;
    }

    private void finishValidation(String name, ValidationResult result) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'finishValidation' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'finishValidation' must not be null";
        assert (!result.isFailure()) : "Validation already failed";
        RecursiveNode found = ArchitecturalViewElementResolver.resolveByShortName(this.m_descriptor.split(name), RecursiveNode.class, this.m_rootNode, this.m_representation);
        if (found != null) {
            if (found.isDeleted()) {
                this.m_action = IRecursiveElementCreationValidator.Action.CREATE_ELEMENT;
            } else if (found.isRemovedByFocus()) {
                this.m_action = IRecursiveElementCreationValidator.Action.MODIFY_FOCUS;
                this.m_node = found;
            } else {
                result.addError("Element with name '" + name + "' already exists");
            }
        } else {
            this.m_action = IRecursiveElementCreationValidator.Action.CREATE_ELEMENT;
        }
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = this.m_validator.isValid(currentInput, newInput);
        if (result.isSuccess()) {
            this.finishValidation(newInput, result);
        }
        return result;
    }

    @Override
    public ValidationResult isNewElementNameValid(String newInput) {
        return this.m_validator.isValid("", newInput);
    }
}

