/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FindingHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactNameValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationNotApplicable;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperationType;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilterOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.OperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationExecutor
implements IArchitecturalViewOperationExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutor.class);
    private static final String NO_MATCHING_ELEMENTS_FOUND = "no matching elements found";
    private static final String NO_MATCHING_ELEMENT_FOUND = "no matching element found";
    private static final String ELEMENTS_NOT_SUITABLE = "elements not suitable";
    private static final String ELEMENT_NOT_SUITABLE = "element not suitable";
    private static final String TARGET_ELEMENT_NOT_SUITABLE = "target element not suitable";
    private final ArchitecturalViewFile m_file;
    private final ExplorationViewRepresentation m_representation;
    private final String m_identifyingPath;

    private OperationExecutor(ArchitecturalViewFile file, ExplorationViewRepresentation representation) {
        assert (file != null) : "Parameter 'file' of method 'OperationExecutor' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewOperationHandler' must not be null";
        this.m_file = file;
        this.m_representation = representation;
        this.m_identifyingPath = this.m_file.getIdentifyingPath();
    }

    private void notApplicable(IArchitecturalViewOperation operation, String info) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicable' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'notApplicable' must not be empty";
        operation.getNamedElement().addIssue(new ArchitecturalViewOperationNotApplicable(operation.getNamedElement(), "[" + this.m_identifyingPath + "] Operation has no effect (" + info + ")."));
    }

    private void notApplicableTarget(IArchitecturalViewOperation operation, String target) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableTarget' must not be null";
        assert (target != null && target.length() > 0) : "Parameter 'target' of method 'notApplicableTarget' must not be empty";
        this.notApplicable(operation, "target '" + target + "' not found");
    }

    private void notApplicableTargetPos(IArchitecturalViewOperation operation, ArchitecturalViewElement target, int pos) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableTargetPos' must not be null";
        assert (target != null) : "Parameter 'targetParent' of method 'notApplicableTargetPos' must not be null";
        this.notApplicable(operation, "invalid pos " + pos + " underneath '" + target.getRelativePath() + "'");
    }

    private OperationInfo notApplicableTargetOpInfo(IArchitecturalViewOperation operation, String target) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableTargetOpInfo' must not be null";
        assert (target != null && target.length() > 0) : "Parameter 'target' of method 'notApplicableTargetOpInfo' must not be empty";
        this.notApplicableTarget(operation, target);
        return new OperationInfo("", Collections.emptyList(), false);
    }

    private OperationInfo notApplicableTargetPosOpInfo(IArchitecturalViewOperation operation, ArchitecturalViewElement target, int pos) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableTargetPosOpInfo' must not be null";
        assert (target != null) : "Parameter 'targetParent' of method 'notApplicableTargetPosOpInfo' must not be null";
        this.notApplicableTargetPos(operation, target, pos);
        return new OperationInfo("", Collections.emptyList(), false);
    }

    private OperationInfo notApplicablePathsOpInfo(IArchitecturalViewOperation operation, List<String> paths, String info, String pathInfo) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicablePathsOpInfo' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'elements' of method 'notApplicablePathsOpInfo' must not be empty";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'notApplicablePathsOpInfo' must not be empty";
        assert (pathInfo != null && pathInfo.length() > 0) : "Parameter 'pathInfo' of method 'notApplicablePathsOpInfo' must not be empty";
        this.notApplicable(operation, info);
        ArrayList<String> pathsInfo = new ArrayList<String>(paths.size());
        paths.forEach(p -> {
            boolean bl = pathsInfo.add("'" + p + "' " + pathInfo);
        });
        return new OperationInfo("", pathsInfo, false);
    }

    private OperationInfo notApplicableElementsOpInfo(IArchitecturalViewOperation operation, List<? extends ArchitecturalViewElement> elements, String info, String elementInfo) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableElementsOpInfo' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'notApplicableElementsOpInfo' must not be empty";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'notApplicableElementsOpInfo' must not be empty";
        assert (elementInfo != null && elementInfo.length() > 0) : "Parameter 'elementInfo' of method 'notApplicableElementsOpInfo' must not be empty";
        this.notApplicable(operation, info);
        ArrayList<String> elementsInfo = new ArrayList<String>(elements.size());
        elements.forEach(e -> {
            boolean bl = elementsInfo.add("'" + e.getRelativePath() + "' " + elementInfo);
        });
        return new OperationInfo("", elementsInfo, false);
    }

    private OperationInfo notApplicableOpInfo(IArchitecturalViewOperation operation, String info, List<String> elementInfo, boolean containsRefactoring) {
        assert (operation != null) : "Parameter 'operation' of method 'notApplicableOpInfo' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'notApplicableOpInfo' must not be empty";
        assert (elementInfo != null) : "Parameter 'elementInfo' of method 'notApplicableOpInfo' must not be null";
        this.notApplicable(operation, info);
        return new OperationInfo(info, elementInfo, containsRefactoring);
    }

    private boolean isValidTargetPosition(ArchitecturalViewElement target, int pos, IArchitecturalViewOperation operation) {
        assert (target != null) : "Parameter 'target' of method 'isValidTarget' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'isValidTarget' must not be null";
        if (pos < -1) {
            return false;
        }
        List<ArchitecturalViewNode> children = target.getChildren(ArchitecturalViewNode.class);
        return pos <= 0 || pos <= children.size();
    }

    @Override
    public void createArtifact(IArchitecturalViewOperation operation, String targetParent, int targetPos, ArtifactProperties properties, String name, ManualFilter userEditedFilter) {
        assert (operation != null) : "Parameter 'operation' of method 'createArtifact' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'createArtifact' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifact' must not be null";
        assert (name != null) : "Parameter 'name' of method 'createArtifact' must not be null";
        IAssignableTarget target = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target.getArchitecturalViewElement(), targetPos, operation)) {
                if (OperationHandler.isOpCreateArtifactPossible(operation.getPresentationMode(), Collections.singletonList(target.getArchitecturalViewElement())).isAvailable()) {
                    if (ArtifactHandler.getArtifactNameValidator(new AssignableTargetInfo(target, targetPos), null).isValid(null, name).isSuccess()) {
                        OperationHandler.opCreateArtifact(operation.getPresentationMode(), target, targetPos, name, properties, FilterHandler.createFilter(this.m_representation, userEditedFilter), this.m_representation);
                        return;
                    }
                    this.notApplicable(operation, "'" + name + "' is not a valid artifact name");
                    return;
                }
                this.notApplicable(operation, "Create not possible underneath '" + target.getArchitecturalViewElement().getRelativePath() + "'");
                return;
            }
            this.notApplicableTargetPos(operation, target.getArchitecturalViewElement(), targetPos);
            return;
        }
        this.notApplicableTarget(operation, targetParent);
    }

    @Override
    public void createArtifactFromElements(IArchitecturalViewOperation operation, String targetParent, int targetPos, ArtifactProperties properties, String name, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'createArtifactFromElements' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'createArtifactFromElements' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifactFromElements' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createArtifactFromElements' must not be empty";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'createArtifactFromElements' must not be empty";
        IAssignableTarget target = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target.getArchitecturalViewElement(), targetPos, operation)) {
                List<ArchitecturalViewElement> elements = ArchitecturalViewElementResolver.resolve(paths, ArchitecturalViewElement.class, this.m_representation, true);
                if (!elements.isEmpty()) {
                    if (OperationHandler.isOpCreateArtifactFromElementsPossible(operation.getPresentationMode(), elements).isAvailable()) {
                        ArchitecturalViewArtifactNameValidator nameValidator = ArtifactHandler.getArtifactFromElementsNameValidator(new AssignableTargetInfo(target, targetPos), elements);
                        if (nameValidator.isValid(null, name).isSuccess()) {
                            OperationHandler.opCreateArtifactFromElements(operation.getPresentationMode(), target, targetPos, name, properties, elements, this.m_representation);
                            return;
                        }
                        this.notApplicable(operation, "'" + name + "' is not a valid artifact name");
                        return;
                    }
                    this.notApplicable(operation, ELEMENTS_NOT_SUITABLE);
                    return;
                }
                this.notApplicable(operation, NO_MATCHING_ELEMENTS_FOUND);
                return;
            }
            this.notApplicableTargetPos(operation, target.getArchitecturalViewElement(), targetPos);
            return;
        }
        this.notApplicableTarget(operation, targetParent);
    }

    @Override
    public void createArtifactsForElements(IArchitecturalViewOperation operation, String targetParent, int targetPos, ArtifactProperties properties, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'createArtifactsForElements' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'createArtifactsForElements' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifactsForElements' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'createArtifactsForElements' must not be empty";
        IAssignableTarget target = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target.getArchitecturalViewElement(), targetPos, operation)) {
                List<ArchitecturalViewElement> elements = ArchitecturalViewElementResolver.resolve(paths, ArchitecturalViewElement.class, this.m_representation, true);
                if (!elements.isEmpty()) {
                    if (OperationHandler.isOpCreateArtifactsForElementsPossible(operation.getPresentationMode(), elements).isAvailable()) {
                        OperationHandler.opCreateArtifactsForElements(operation.getPresentationMode(), target, targetPos, properties, elements, this.m_representation);
                        return;
                    }
                    this.notApplicable(operation, ELEMENTS_NOT_SUITABLE);
                    return;
                }
                this.notApplicable(operation, NO_MATCHING_ELEMENTS_FOUND);
                return;
            }
            this.notApplicableTargetPos(operation, target.getArchitecturalViewElement(), targetPos);
            return;
        }
        this.notApplicableTarget(operation, targetParent);
    }

    @Override
    public ManualFilterOperation editArtifact(IArchitecturalViewOperation operation, String targetParent, int targetPos, ArtifactProperties properties, String path, String name, ManualFilter userEditedFilter) {
        assert (operation != null) : "Parameter 'operation' of method 'editArtifact' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'editArtifact' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifact' must not be null";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'editArtifact' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'editArtifact' must not be empty";
        IAssignableTarget target = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target.getArchitecturalViewElement(), targetPos, operation)) {
                ArtifactNode artifact = ArchitecturalViewElementResolver.resolve(path, ArtifactNode.class, this.m_representation, true);
                if (artifact != null) {
                    if (OperationHandler.isEditArtifactsPossible(operation.getPresentationMode(), Collections.singletonList(artifact)).isAvailable()) {
                        if (ArtifactHandler.getArtifactNameValidator(new AssignableTargetInfo(target, targetPos), artifact).isValid(null, name).isSuccess()) {
                            EditArtifactResult result = OperationHandler.opEditArtifact(operation.getPresentationMode(), artifact, new AssignableTargetInfo(target, targetPos), name, properties, FilterHandler.createFilter(this.m_representation, userEditedFilter), this.m_representation);
                            if (result != null) {
                                return result.getFilterOperation();
                            }
                            this.notApplicable(operation, "No changes to be applied");
                            return ManualFilterOperation.NONE;
                        }
                        this.notApplicable(operation, "'" + name + "' is not a valid artifact name");
                        return ManualFilterOperation.NONE;
                    }
                    this.notApplicable(operation, "artifact '" + path + "' not editable");
                    return ManualFilterOperation.NONE;
                }
                this.notApplicable(operation, "artifact '" + path + "' not found");
                return ManualFilterOperation.NONE;
            }
            this.notApplicableTargetPos(operation, target.getArchitecturalViewElement(), targetPos);
            return ManualFilterOperation.NONE;
        }
        this.notApplicableTarget(operation, targetParent);
        return ManualFilterOperation.NONE;
    }

    @Override
    public void editArtifacts(IArchitecturalViewOperation operation, String targetParent, int targetPos, ArtifactProperties properties, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'editArtifacts' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'editArtifacts' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifacts' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'editArtifacts' must not be empty";
        IAssignableTarget target = ArchitecturalViewElementResolver.resolve(targetParent, IAssignableTarget.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target.getArchitecturalViewElement(), targetPos, operation)) {
                List<ArtifactNode> artifacts = ArchitecturalViewElementResolver.resolve(paths, ArtifactNode.class, this.m_representation, true);
                if (!artifacts.isEmpty()) {
                    ArchitecturalViewArtifactOperationAvailability availability = OperationHandler.isEditArtifactsPossible(operation.getPresentationMode(), artifacts);
                    if (availability.isAvailable() && OperationHandler.opEditArtifacts(operation.getPresentationMode(), artifacts, new AssignableTargetInfo(target, targetPos), properties, this.m_representation) != null) {
                        return;
                    }
                    this.notApplicable(operation, "artifacts not editable");
                    return;
                }
                this.notApplicable(operation, "no artifacts found to edit");
                return;
            }
            this.notApplicableTargetPos(operation, target.getArchitecturalViewElement(), targetPos);
            return;
        }
        this.notApplicableTarget(operation, targetParent);
    }

    @Override
    public OperationInfo moveElements(IArchitecturalViewOperation operation, String targetParent, int targetPos, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'moveElements' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'moveElements' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'moveElements' must not be empty";
        ArchitecturalViewElement target = ArchitecturalViewElementResolver.resolve(targetParent, ArchitecturalViewElement.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target, targetPos, operation)) {
                List<ArchitecturalViewElement> elements = ArchitecturalViewElementResolver.resolve(paths, ArchitecturalViewElement.class, this.m_representation, true);
                if (!elements.isEmpty()) {
                    if (OperationHandler.isOpMoveElementsPossible(operation.getPresentationMode(), elements, false)) {
                        MovableTargetInfo targetInfo = new MovableTargetInfo(target, targetPos);
                        MoveElementsInfo moveElementsInfo = OperationHandler.isOpMoveElementsTargetPossible(operation.getPresentationMode(), elements, targetInfo);
                        assert (this.m_representation == moveElementsInfo.getRepresentation()) : "Different representations";
                        if (moveElementsInfo.isApplicable()) {
                            moveElementsInfo = OperationHandler.opMoveElements(operation.getPresentationMode(), elements, targetInfo);
                            return new OperationInfo(moveElementsInfo.getInfo(), moveElementsInfo.getElementInfo(), moveElementsInfo.containsRefactoring());
                        }
                        return this.notApplicableOpInfo(operation, TARGET_ELEMENT_NOT_SUITABLE, moveElementsInfo.getElementInfo(), moveElementsInfo.containsRefactoring());
                    }
                    return this.notApplicableElementsOpInfo(operation, elements, ELEMENTS_NOT_SUITABLE, "not movable");
                }
                return this.notApplicablePathsOpInfo(operation, paths, NO_MATCHING_ELEMENTS_FOUND, "not found");
            }
            return this.notApplicableTargetPosOpInfo(operation, target, targetPos);
        }
        return this.notApplicableTargetOpInfo(operation, targetParent);
    }

    @Override
    public DeleteElementsOperationType deleteElements(IArchitecturalViewOperation operation, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'deleteArtifacts' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'deleteArtifacts' must not be empty";
        List<ArchitecturalViewElement> elements = ArchitecturalViewElementResolver.resolve(paths, ArchitecturalViewElement.class, this.m_representation, true);
        if (!elements.isEmpty()) {
            DeleteElementsOperationType type = OperationHandler.isOpDeleteElementsPossible(operation.getPresentationMode(), elements, false);
            if (type != DeleteElementsOperationType.NONE) {
                OperationHandler.opDeleteElements(operation.getPresentationMode(), elements, false, this.m_representation);
                return type;
            }
            this.notApplicable(operation, ELEMENTS_NOT_SUITABLE);
            return DeleteElementsOperationType.NONE;
        }
        this.notApplicable(operation, NO_MATCHING_ELEMENTS_FOUND);
        return DeleteElementsOperationType.NONE;
    }

    @Override
    public void hideElements(IArchitecturalViewOperation operation, List<String> paths) {
        assert (operation != null) : "Parameter 'operation' of method 'hideElements' must not be null";
        assert (paths != null && !paths.isEmpty()) : "Parameter 'paths' of method 'hideElements' must not be empty";
        List<ArchitecturalViewElement> elements = ArchitecturalViewElementResolver.resolve(paths, ArchitecturalViewElement.class, this.m_representation, true);
        if (!elements.isEmpty()) {
            if (OperationHandler.isOpHideElementsPossible(operation.getPresentationMode(), elements)) {
                OperationHandler.opHideElements(operation.getPresentationMode(), elements, this.m_representation);
                return;
            }
            this.notApplicable(operation, ELEMENTS_NOT_SUITABLE);
        }
        this.notApplicable(operation, NO_MATCHING_ELEMENTS_FOUND);
    }

    @Override
    public void createAllowedArtifactDependency(IArchitecturalViewOperation operation, String from, String to) {
        assert (operation != null) : "Parameter 'operation' of method 'createAllowedArtifactDependency' must not be null";
        assert (from != null && from.length() > 0) : "Parameter 'from' of method 'createAllowedArtifactDependency' must not be empty";
        assert (to != null && to.length() > 0) : "Parameter 'to' of method 'createAllowedArtifactDependency' must not be empty";
        ArtifactNode fromArtifact = ArchitecturalViewElementResolver.resolve(from, ArtifactNode.class, this.m_representation, true);
        if (fromArtifact != null) {
            ArtifactNode toArtifact = ArchitecturalViewElementResolver.resolve(to, ArtifactNode.class, this.m_representation, true);
            if (toArtifact != null) {
                ArtifactNodeConnection dependency = OperationHandler.isOpCreateAllowedArtifactConnectionPossible(operation.getPresentationMode(), fromArtifact, toArtifact);
                if (dependency != null) {
                    OperationHandler.opCreateAllowedArtifactConnection(operation.getPresentationMode(), dependency, this.m_representation);
                    return;
                }
                this.notApplicable(operation, ELEMENTS_NOT_SUITABLE);
                return;
            }
            this.notApplicable(operation, "'" + to + "' not found");
            return;
        }
        this.notApplicable(operation, "'" + from + "' not found");
    }

    @Override
    public void deleteDependencies(IArchitecturalViewOperation operation, List<ArchitecturalViewDependencyDescriptor> dependencies) {
        assert (operation != null) : "Parameter 'operation' of method 'deleteDependency' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'deleteDependencies' must not be empty";
        PresentationMode presentationMode = operation.getPresentationMode();
        THashSet allParserDependencies = new THashSet();
        for (ArchitecturalViewDependencyDescriptor nextDescriptor : dependencies) {
            List<ParserDependency> parserDependencies;
            ArchitecturalViewNode toNode;
            nextDescriptor.setNumberOfParserDependencies(0);
            ArchitecturalViewNode fromNode = ArchitecturalViewElementResolver.resolve(nextDescriptor.getFrom(), ArchitecturalViewNode.class, this.m_representation, true);
            if (fromNode == null || (toNode = ArchitecturalViewElementResolver.resolve(nextDescriptor.getTo(), ArchitecturalViewNode.class, this.m_representation, true)) == null || (parserDependencies = OperationHandler.isOpDeleteDependenciesPossible(presentationMode, fromNode, nextDescriptor.isFromAggregated(), toNode, nextDescriptor.isToAggregated(), this.m_representation)).isEmpty()) continue;
            nextDescriptor.setNumberOfParserDependencies(parserDependencies.size());
            allParserDependencies.addAll(parserDependencies);
        }
        if (!allParserDependencies.isEmpty()) {
            OperationHandler.opDeleteParserDependencies(presentationMode, (Set<ParserDependency>)allParserDependencies, this.m_representation);
            return;
        }
        this.notApplicable(operation, "dependencies not suitable");
    }

    @Override
    public void createFinding(IArchitecturalViewOperation operation, String name, String description, boolean ignoreViolations, Set<String> parserDependencyDescriptors) {
        assert (operation != null) : "Parameter 'operation' of method 'createFinding' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createFinding' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'createFinding' must not be null";
        assert (parserDependencyDescriptors != null && !parserDependencyDescriptors.isEmpty()) : "Parameter 'parserDependencyDescriptors' of method 'createFinding' must not be empty";
        PresentationMode presentationMode = operation.getPresentationMode();
        Set<ParserDependency> parserDependencies = OperationHandler.opCreateFinding(presentationMode, name, description, ignoreViolations, parserDependencyDescriptors, this.m_file.getUniqueExistingChild(ArchitecturalViewFindingList.class), this.m_representation);
        if (parserDependencies.isEmpty()) {
            this.notApplicable(operation, "no parser dependencies matched");
        }
    }

    @Override
    public RecursiveElementRefactoringDescriptor createElement(IArchitecturalViewOperation operation, String targetParent, int targetPos, RecursiveElementRefactoringDescriptor.ElementType type, String name) {
        assert (operation != null) : "Parameter 'operation' of method 'createElement' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'createElement' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createElement' must not be null";
        assert (name != null) : "Parameter 'name' of method 'createElement' must not be null";
        ArchitecturalViewElement target = ArchitecturalViewElementResolver.resolve(targetParent, ArchitecturalViewElement.class, this.m_representation, true);
        if (target != null) {
            if (this.isValidTargetPosition(target, targetPos, operation)) {
                RecursiveElementCreationInfo creationInfo = OperationHandler.isOpCreateElementPossible(operation.getPresentationMode(), target);
                if (creationInfo != null) {
                    if (creationInfo.getValidator().isValid("", name).isSuccess()) {
                        OperationHandler.opCreateElement(operation.getPresentationMode(), creationInfo, name, this.m_representation);
                        return creationInfo.getValidator().getDescriptor();
                    }
                    this.notApplicable(operation, "'" + name + "' is not a valid name");
                    return null;
                }
                this.notApplicable(operation, "'" + targetParent + "' is not a suitable target");
                return null;
            }
            this.notApplicableTargetPos(operation, target, targetPos);
            return null;
        }
        this.notApplicableTarget(operation, targetParent);
        return null;
    }

    @Override
    public OperationInfo renameElement(IArchitecturalViewOperation operation, String element, String name) {
        assert (operation != null) : "Parameter 'operation' of method 'renameElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'renameElement' must not be null";
        assert (name != null) : "Parameter 'name' of method 'renameElement' must not be null";
        ArchitecturalViewElement resolved = ArchitecturalViewElementResolver.resolve(element, ArchitecturalViewElement.class, this.m_representation, true);
        if (resolved != null) {
            RenameElementInfo info = OperationHandler.isOpRenameElementPossible(operation.getPresentationMode(), resolved, this.m_representation);
            if (info != null) {
                ValidationResult valid = info.getValidator().isValid("", name);
                if (valid.isSuccess()) {
                    info = OperationHandler.opRenameElement(operation.getPresentationMode(), resolved, name, this.m_representation);
                    return new OperationInfo(info.getInfo(), info.getElementInfo(), info.getContainsRefactoring());
                }
                return this.notApplicableOpInfo(operation, "'" + name + " is not a valid name", Collections.emptyList(), false);
            }
            return this.notApplicableOpInfo(operation, ELEMENT_NOT_SUITABLE, Collections.emptyList(), false);
        }
        return this.notApplicableOpInfo(operation, NO_MATCHING_ELEMENT_FOUND, Collections.emptyList(), false);
    }

    public static void applyOperations(IWorkerContext workerContext, ArchitecturalViewFile file, ExplorationViewRepresentation representation, int includingOperationIndex) {
        int numberOfOperationsToApply;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyOperations' must not be null";
        assert (file != null) : "Parameter 'file' of method 'applyOperations' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyOperations' must not be null";
        List<ArchitecturalViewOperation> operations = file.getOperations();
        assert (includingOperationIndex == -1 || includingOperationIndex >= 0 && includingOperationIndex <= operations.size()) : "'includingOperationIndex' out of range: " + includingOperationIndex + "/" + operations.size();
        int n = numberOfOperationsToApply = includingOperationIndex == -1 ? operations.size() : includingOperationIndex;
        if (!operations.isEmpty()) {
            LOGGER.debug("Applying " + numberOfOperationsToApply + " operation(s)");
            workerContext.working("Applying " + numberOfOperationsToApply + " operation(s)", true);
            OperationExecutor executor = new OperationExecutor(file, representation);
            if (includingOperationIndex == -1) {
                operations.forEach(o -> o.apply(executor));
            } else {
                for (ArchitecturalViewOperation next : operations) {
                    if (next.getIndex() > includingOperationIndex) break;
                    next.apply(executor);
                }
            }
            FindingHandler.updateFindings(file.getFindingList(), representation);
            LOGGER.debug("Applying " + numberOfOperationsToApply + " operation(s) - done");
        }
    }

    public static void applyOperations(IWorkerContext workerContext, ArchitecturalViewFile file, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyOperations' must not be null";
        assert (file != null) : "Parameter 'file' of method 'applyOperations' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyOperations' must not be null";
        OperationExecutor.applyOperations(workerContext, file, representation, -1);
    }
}

