/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Set;

abstract class ArchitectureFilterNameCollector
extends ArchitecturalViewVisitor
implements AssignableNode.IVisitor,
AssignableToArtifactNode.IVisitor {
    private final IReferenceCountProvider m_referenceCountProvider;

    ArchitectureFilterNameCollector(IReferenceCountProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'ArchitectureFilterNameCollector' must not be null";
        this.m_referenceCountProvider = provider;
    }

    protected abstract void process(Set<String> var1);

    protected boolean skipAssignableNode(AssignableNode assignableNode) {
        assert (assignableNode != null) : "Parameter 'assignableNode' of method 'skipAssignableNode' must not be null";
        return false;
    }

    private boolean processAssignableNode(AssignableNode assignableNode) {
        assert (assignableNode != null) : "Parameter 'assignableNode' of method 'processAssignableNode' must not be null";
        List<NamedElement> underlyingElements = assignableNode.getUnderlyingElements();
        assert (underlyingElements != null && !underlyingElements.isEmpty()) : "'underlyingElements' of method 'processAssignableNode' must not be empty";
        if (this.skipAssignableNode(assignableNode)) {
            return false;
        }
        for (NamedElement next : underlyingElements) {
            Class<?> nextClass = next.getClass();
            if (!RootDirectoryPath.class.isAssignableFrom(nextClass) && !InternalLogicalNamespaceRoot.class.isAssignableFrom(nextClass) && this.m_referenceCountProvider.getReferenceCount(next) <= 1) continue;
            return false;
        }
        THashSet architectureFilterNames = new THashSet(underlyingElements.size());
        for (NamedElement next : underlyingElements) {
            String nextArchitectureFilterName = null;
            if (next instanceof IArchitectureFilterNameProvider) {
                nextArchitectureFilterName = ((IArchitectureFilterNameProvider)((Object)next)).getArchitectureFilterName();
            } else assert (false) : "Unhandled element: " + String.valueOf(next);
            assert (nextArchitectureFilterName != null && nextArchitectureFilterName.length() > 0) : "'nextArchitectureFilterName' of method 'processAssignableNode' must not be empty";
            architectureFilterNames.add(nextArchitectureFilterName);
        }
        this.process((Set<String>)architectureFilterNames);
        return true;
    }

    @Override
    public final void visitAssignableNode(AssignableNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitAssignableNode' must not be null";
        if (!this.processAssignableNode(element)) {
            this.visitChildrenOf(element);
        }
    }

    protected void reachedNonRecursiveLeafNode(AssignableToArtifactNode element, boolean match) {
        assert (element != null) : "Parameter 'element' of method 'reachedNonRecursiveLeafNode' must not be null";
    }

    @Override
    public final void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveLeafNode' must not be null";
        boolean match = this.processAssignableNode(element);
        this.reachedNonRecursiveLeafNode(element, match);
    }

    public static interface IReferenceCountProvider {
        public int getReferenceCount(NamedElement var1);
    }
}

