/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateBaselineConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateCurrentConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGatesDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGate;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateExcludeFilter;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateIssueCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateMetricDiffCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateThresholdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.IQualityGateThresholdIssueDiffCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class QualityGateDiffProcessor
extends AbstractDiffProcessor {
    public QualityGateDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
    }

    @Override
    public void process(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        LinkedHashMap<String, QualityGate> currentQualityGatesMap = new LinkedHashMap<String, QualityGate>();
        QualityGates qualityGatesDirectory = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getQualityGatesDirectory();
        QualityGatesDiff qualityGatesDiff = new QualityGatesDiff(parent, qualityGatesDirectory);
        for (QualityGate nextCurrent : qualityGatesDirectory.getChildren(QualityGate.class)) {
            if (!nextCurrent.isChecked()) continue;
            currentQualityGatesMap.put(nextCurrent.getIdentifyingPath(), nextCurrent);
        }
        LinkedHashMap<String, IQualityGate> baselineQualityGatesMap = new LinkedHashMap<String, IQualityGate>();
        for (ISystemFileElement iSystemFileElement : this.getBaselineSystemInfoProcessor().getSystemFileElements()) {
            if (!(iSystemFileElement instanceof IQualityGate)) continue;
            baselineQualityGatesMap.put(iSystemFileElement.getPath(), (IQualityGate)iSystemFileElement);
        }
        for (Map.Entry entry : currentQualityGatesMap.entrySet()) {
            IQualityGate baselineQualityGate = (IQualityGate)baselineQualityGatesMap.remove(entry.getKey());
            if (baselineQualityGate == null) {
                this.processAdded(qualityGatesDiff, (QualityGate)entry.getValue());
                continue;
            }
            this.processModified(qualityGatesDiff, baselineQualityGate, (QualityGate)entry.getValue());
        }
        for (IQualityGate iQualityGate : baselineQualityGatesMap.values()) {
            this.processRemoved(qualityGatesDiff, iQualityGate);
        }
        parent.addChild(qualityGatesDiff);
    }

    private void processAdded(QualityGatesDiff qualityGatesDiff, QualityGate current) {
        assert (qualityGatesDiff != null) : "Parameter 'qualityGatesDiff' of method 'processAdded' must not be null";
        assert (current != null) : "Parameter 'current' of method 'processAdded' must not be null";
        QualityGateDiff addedDiff = new QualityGateDiff((NamedElement)qualityGatesDiff, null, current, IDiffElement.Change.ADDED);
        CurrentSystemConditions currentConditions = current.getUniqueExistingChild(CurrentSystemConditions.class);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)addedDiff, currentConditions, currentConditions.getShortName(), currentConditions.getPresentationName(true), IDiffElement.Change.ADDED);
        for (AbstractCurrentIssueQualityGateCondition currentCondition : currentConditions.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            QualityGateElementDiff currentDiff = new QualityGateElementDiff(currentConditionsDiff, null, currentCondition, IDiffElement.Change.ADDED, currentCondition.getImageResourceName());
            currentConditionsDiff.addChild(currentDiff);
        }
        for (QualityGateExcludeFilter nextExclude : currentConditions.getChildren(QualityGateExcludeFilter.class)) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(currentConditionsDiff, null, nextExclude, IDiffElement.Change.ADDED, nextExclude.getImageResourceName());
            currentConditionsDiff.addChild(filterDiff);
        }
        addedDiff.addChild(currentConditionsDiff);
        DiffAgainstBaselineConditions baselineConditions = current.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        QualityGateBaselineConditionsDiff baselineConditionDiffs = new QualityGateBaselineConditionsDiff((NamedElement)addedDiff, baselineConditions, baselineConditions.getShortName(), baselineConditions.getPresentationName(true), IDiffElement.Change.ADDED);
        for (AbstractQualityGateElement baselineIssueCondition : baselineConditions.getChildren(AbstractQualityGateElement.class)) {
            if (baselineIssueCondition instanceof QualityGateExcludeFilter) continue;
            QualityGateElementDiff diff = new QualityGateElementDiff(baselineConditionDiffs, null, baselineIssueCondition, IDiffElement.Change.ADDED, baselineIssueCondition.getImageResourceName());
            baselineConditionDiffs.addChild(diff);
        }
        for (QualityGateExcludeFilter nextExclude : baselineConditions.getChildren(QualityGateExcludeFilter.class)) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(baselineConditionDiffs, null, nextExclude, IDiffElement.Change.ADDED, nextExclude.getImageResourceName());
            baselineConditionDiffs.addChild(filterDiff);
        }
        addedDiff.addChild(baselineConditionDiffs);
        qualityGatesDiff.addChild(addedDiff);
    }

    private void processModified(NamedElement parent, IQualityGate baseline, QualityGate current) {
        assert (parent != null) : "Parameter 'parent' of method 'computeQualityGateDiff' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'computeQualityGateDiff' must not be null";
        assert (current != null) : "Parameter 'current' of method 'computeQualityGateDiff' must not be null";
        QualityGateDiff diff = new QualityGateDiff(parent, baseline, current, IDiffElement.Change.UNMODIFIED);
        Map<QualityGateElementRecord, IQualityGateElement> baselineElements = this.createBaselineCurrentRecords(baseline);
        Map<QualityGateElementRecord, AbstractQualityGateElement> currentElements = this.createCurrentRecords(current.getUniqueExistingChild(CurrentSystemConditions.class));
        CurrentSystemConditions currentSystemConditions = current.getUniqueExistingChild(CurrentSystemConditions.class);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)diff, currentSystemConditions, currentSystemConditions.getShortName(), currentSystemConditions.getPresentationName(true), null);
        this.processConditionsOfModified(currentConditionsDiff, baselineElements, currentElements);
        diff.addChild(currentConditionsDiff);
        Map<QualityGateElementRecord, IQualityGateElement> baselineBaselineElements = this.createBaselineDiffRecords(baseline);
        Map<QualityGateElementRecord, AbstractQualityGateElement> currentBaselineElements = this.createCurrentDiffRecords(current.getUniqueExistingChild(DiffAgainstBaselineConditions.class));
        DiffAgainstBaselineConditions baselineSystemConditions = current.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        QualityGateBaselineConditionsDiff baselineConditionsDiff = new QualityGateBaselineConditionsDiff((NamedElement)diff, baselineSystemConditions, baselineSystemConditions.getShortName(), baselineSystemConditions.getPresentationName(true), null);
        this.processConditionsOfModified(baselineConditionsDiff, baselineBaselineElements, currentBaselineElements);
        diff.addChild(baselineConditionsDiff);
        parent.addChild(diff);
    }

    private void processConditionsOfModified(NamedElement parentDiff, Map<QualityGateElementRecord, IQualityGateElement> baselineElements, Map<QualityGateElementRecord, AbstractQualityGateElement> currentElements) {
        assert (parentDiff != null) : "Parameter 'parentDiff' of method 'processConditionsOfModified' must not be null";
        assert (baselineElements != null) : "Parameter 'baselineElements' of method 'processConditionsOfModified' must not be null";
        assert (currentElements != null) : "Parameter 'currentElements' of method 'processConditionsOfModified' must not be null";
        ArrayList<QualityGateElementRecord> exactMatches = new ArrayList<QualityGateElementRecord>();
        for (Map.Entry<QualityGateElementRecord, IQualityGateElement> nextBaselineEntry : baselineElements.entrySet()) {
            QualityGateElementRecord baselineRecord = nextBaselineEntry.getKey();
            AbstractQualityGateElement currentElement = currentElements.remove(baselineRecord);
            if (currentElement == null) continue;
            QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, nextBaselineEntry.getValue(), currentElement, IDiffElement.Change.UNMODIFIED, currentElement.getImageResourceName());
            parentDiff.addChild(elementDiff);
            exactMatches.add(baselineRecord);
        }
        exactMatches.forEach(match -> {
            Object v = baselineElements.remove(match);
        });
        ArrayList<QualityGateElementDiff> removedFilters = new ArrayList<QualityGateElementDiff>();
        ArrayList<QualityGateElementDiff> addedFilters = new ArrayList<QualityGateElementDiff>();
        HashSet<QualityGateElementRecord> unmatchedCurrentElements = new HashSet<QualityGateElementRecord>(currentElements.keySet());
        HashMap<RecordMatch, List<RecordMatch>> baselineRecordsToCurrentMatches = new HashMap<RecordMatch, List<RecordMatch>>();
        for (Map.Entry<QualityGateElementRecord, IQualityGateElement> nextBaselineEntry : baselineElements.entrySet()) {
            QualityGateElementRecord baselineRecord = nextBaselineEntry.getKey();
            ArrayList<RecordMatch> currentRecordMatches = new ArrayList<RecordMatch>();
            for (Map.Entry<QualityGateElementRecord, AbstractQualityGateElement> nextCurrentEntry : currentElements.entrySet()) {
                int score;
                QualityGateElementRecord currentRecord = nextCurrentEntry.getKey();
                if (!baselineRecord.m_type.equals(currentRecord.m_type) || (score = this.computeScore(baselineRecord, currentRecord)) < 2) continue;
                RecordMatch match2 = new RecordMatch(baselineRecord, currentRecord, score);
                currentRecordMatches.add(match2);
                unmatchedCurrentElements.remove(currentRecord);
            }
            if (currentRecordMatches.isEmpty()) {
                QualityGateElementDiff diffCondition = new QualityGateElementDiff(parentDiff, nextBaselineEntry.getValue(), null, IDiffElement.Change.REMOVED, nextBaselineEntry.getValue().getImageResourceName());
                if (baselineRecord.m_element instanceof IQualityGateExcludeFilter) {
                    removedFilters.add(diffCondition);
                    continue;
                }
                parentDiff.addChild(diffCondition);
                continue;
            }
            currentRecordMatches.sort(new RecordMatchComparator());
            RecordMatch bestMatch = (RecordMatch)currentRecordMatches.remove(0);
            baselineRecordsToCurrentMatches.put(bestMatch, currentRecordMatches);
        }
        for (QualityGateElementRecord nextUnmatched : unmatchedCurrentElements) {
            AbstractQualityGateElement unmatched = (AbstractQualityGateElement)nextUnmatched.m_element;
            QualityGateElementDiff diffCondition = new QualityGateElementDiff(parentDiff, null, unmatched, IDiffElement.Change.ADDED, unmatched.getImageResourceName());
            if (nextUnmatched.m_element instanceof QualityGateExcludeFilter) {
                addedFilters.add(diffCondition);
                continue;
            }
            parentDiff.addChild(diffCondition);
        }
        if (!baselineRecordsToCurrentMatches.isEmpty()) {
            HashSet<QualityGateElementRecord> unmatchedCurrentRecords = new HashSet<QualityGateElementRecord>(currentElements.keySet());
            unmatchedCurrentRecords.removeAll(unmatchedCurrentElements);
            StrictPair<Set<QualityGateElementRecord>, Set<QualityGateElementRecord>> unmatchedElements = this.processMatches(parentDiff, baselineRecordsToCurrentMatches, unmatchedCurrentRecords);
            Set unmatchedBaselineConditions = (Set)unmatchedElements.getFirst();
            Set unmatchedCurrentConditions = (Set)unmatchedElements.getSecond();
            for (QualityGateElementRecord nextRemoved : unmatchedBaselineConditions) {
                IQualityGateElement removed = (IQualityGateElement)nextRemoved.m_element;
                QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, removed, null, IDiffElement.Change.REMOVED, removed.getImageResourceName());
                if (removed instanceof IQualityGateExcludeFilter) {
                    removedFilters.add(elementDiff);
                    continue;
                }
                parentDiff.addChild(elementDiff);
            }
            for (QualityGateElementRecord nextAdded : unmatchedCurrentConditions) {
                AbstractQualityGateElement added = (AbstractQualityGateElement)nextAdded.m_element;
                QualityGateElementDiff elementDiff = new QualityGateElementDiff(parentDiff, null, added, IDiffElement.Change.ADDED, added.getImageResourceName());
                if (nextAdded.m_element instanceof IQualityGateExcludeFilter) {
                    addedFilters.add(elementDiff);
                    continue;
                }
                parentDiff.addChild(elementDiff);
            }
        }
        for (QualityGateElementDiff next : removedFilters) {
            parentDiff.addChild(next);
        }
        for (QualityGateElementDiff next : addedFilters) {
            parentDiff.addChild(next);
        }
    }

    private StrictPair<Set<QualityGateElementRecord>, Set<QualityGateElementRecord>> processMatches(NamedElement parentDiff, Map<RecordMatch, List<RecordMatch>> bestMatchesToAlternatives, Set<QualityGateElementRecord> unmatchedCurrentRecords) {
        assert (parentDiff != null) : "Parameter 'parentDiff' of method 'processMatches' must not be null";
        assert (bestMatchesToAlternatives != null && !bestMatchesToAlternatives.isEmpty()) : "Parameter 'bestMatchesToAlternatives' of method 'processMatches' must not be empty";
        assert (unmatchedCurrentRecords != null) : "Parameter 'unmatchedCurrentRecords' of method 'processMatches' must not be null";
        ArrayList<RecordMatch> bestMatches = new ArrayList<RecordMatch>(bestMatchesToAlternatives.keySet());
        bestMatches.sort(new RecordMatchComparator());
        HashSet<Object> processedCurrentConditions = new HashSet<Object>();
        HashSet<RecordMatch> matchedBaselines = new HashSet<RecordMatch>();
        LinkedHashSet<QualityGateElementRecord> unmatchedBaselines = new LinkedHashSet<QualityGateElementRecord>();
        LinkedHashSet unmatchedCurrent = new LinkedHashSet();
        boolean conflict = false;
        for (RecordMatch nextBest : bestMatches) {
            List<RecordMatch> alternatives = bestMatchesToAlternatives.remove(nextBest);
            if (processedCurrentConditions.contains(nextBest.m_current.m_element)) {
                if (alternatives.size() > 0) {
                    RecordMatch newBestMatch = alternatives.remove(0);
                    bestMatchesToAlternatives.put(newBestMatch, alternatives);
                    conflict = true;
                    break;
                }
                unmatchedBaselines.add(nextBest.m_baseline);
                break;
            }
            this.createModifiedDiff(parentDiff, nextBest);
            unmatchedCurrentRecords.remove(nextBest.m_current);
            bestMatchesToAlternatives.values().stream().forEach(matches -> {
                boolean bl = matches.remove(nextBest);
            });
            matchedBaselines.add(nextBest);
            processedCurrentConditions.add(nextBest.m_current.m_element);
        }
        if (bestMatchesToAlternatives.isEmpty()) {
            return new StrictPair(Collections.emptySet(), unmatchedCurrentRecords);
        }
        if (conflict) {
            StrictPair<Set<QualityGateElementRecord>, Set<QualityGateElementRecord>> recursiveResult = this.processMatches(parentDiff, bestMatchesToAlternatives, unmatchedCurrentRecords);
            unmatchedBaselines.addAll((Collection)recursiveResult.getFirst());
            unmatchedCurrent.addAll((Collection)recursiveResult.getSecond());
        }
        return new StrictPair(unmatchedBaselines, unmatchedCurrent);
    }

    private void createModifiedDiff(NamedElement parent, RecordMatch match) {
        assert (parent != null) : "Parameter 'parent' of method 'createModifiedDiff' must not be null";
        assert (match != null) : "Parameter 'match' of method 'createModifiedDiff' must not be null";
        AbstractQualityGateElement current = (AbstractQualityGateElement)match.m_current.m_element;
        QualityGateElementDiff diff = new QualityGateElementDiff(parent, (IQualityGateElement)match.m_baseline.m_element, current, IDiffElement.Change.MODIFIED, current.getImageResourceName());
        Map<QualityGateProperty, String> baselineProps = match.m_baseline.m_properties;
        Map<QualityGateProperty, String> currentProps = match.m_current.m_properties;
        for (Map.Entry<QualityGateProperty, String> next : baselineProps.entrySet()) {
            SimplePropertyDiff propDiff;
            String currentValue = currentProps.get((Object)next.getKey());
            String baselineValue = next.getValue();
            if (!next.getValue().equals(currentValue)) {
                propDiff = new SimplePropertyDiff(diff, next.getKey().getStandardName(), next.getKey().getPresentationName(), baselineValue, currentValue, IDiffElement.Change.MODIFIED);
                diff.addChild(propDiff);
                continue;
            }
            propDiff = new SimplePropertyDiff(diff, next.getKey().getStandardName(), next.getKey().getPresentationName(), baselineValue, currentValue, IDiffElement.Change.UNMODIFIED);
            diff.addChild(propDiff);
        }
        parent.addChild(diff);
        QualityGateElementDiff firstFilter = parent.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (namedElement instanceof QualityGateElementDiff) {
                    return ((QualityGateElementDiff)namedElement).getCurrent() instanceof QualityGateExcludeFilter;
                }
                return false;
            }
        }, QualityGateElementDiff.class);
        if (firstFilter != null && !(current instanceof QualityGateExcludeFilter)) {
            parent.moveChild(QualityGateElementDiff.class, diff, parent.getIndexOf(QualityGateElementDiff.class, firstFilter));
        }
    }

    private int computeScore(QualityGateElementRecord baseline, QualityGateElementRecord current) {
        int score = 0;
        for (Map.Entry<QualityGateProperty, String> next : baseline.m_properties.entrySet()) {
            if (!next.getValue().equals(current.m_properties.get((Object)next.getKey()))) continue;
            ++score;
            if (next.getKey() == QualityGateProperty.ISSUE_TYPE) {
                score += 3;
            }
            if (next.getKey() != QualityGateProperty.METRIC_ID) continue;
            score += 2;
        }
        return score;
    }

    private Map<QualityGateElementRecord, IQualityGateElement> createBaselineCurrentRecords(IQualityGate baseline) {
        QualityGateElementRecord record;
        LinkedHashMap<QualityGateElementRecord, IQualityGateElement> baselineRecords = new LinkedHashMap<QualityGateElementRecord, IQualityGateElement>();
        for (IQualityGateIssueCondition nextCondition : baseline.getCurrentSystemConditions().getCurrentSystemConditions()) {
            record = this.createCurrentIssueConditionRecord(nextCondition, nextCondition.getName(), nextCondition instanceof IQualityGateThresholdIssueCondition);
            baselineRecords.put(record, (IQualityGateElement)nextCondition);
        }
        for (IQualityGateExcludeFilter nextExcludeFilter : baseline.getCurrentSystemConditions().getExcludeFilters()) {
            record = this.createBaselineExcludeFilterRecord(nextExcludeFilter, nextExcludeFilter.getName());
            baselineRecords.put(record, (IQualityGateElement)nextExcludeFilter);
        }
        return baselineRecords;
    }

    private Map<QualityGateElementRecord, IQualityGateElement> createBaselineDiffRecords(IQualityGate baseline) {
        QualityGateElementRecord record;
        assert (baseline != null) : "Parameter 'baseline' of method 'computeBaselineBaselineRecords' must not be null";
        LinkedHashMap<QualityGateElementRecord, IQualityGateElement> baselineRecords = new LinkedHashMap<QualityGateElementRecord, IQualityGateElement>();
        for (IQualityGateElement nextCondition : baseline.getDiffAgainstBaselineConditions().getDiffConditions()) {
            record = nextCondition instanceof IQualityGateMetricDiffCondition ? this.createBaselineMetricConditionRecord(nextCondition, nextCondition.getName()) : this.createBaselineIssueConditionRecord(nextCondition, nextCondition.getName(), nextCondition instanceof IQualityGateThresholdIssueDiffCondition);
            baselineRecords.put(record, nextCondition);
        }
        for (IQualityGateExcludeFilter nextExcludeFilter : baseline.getDiffAgainstBaselineConditions().getExcludeFilters()) {
            record = this.createBaselineExcludeFilterRecord(nextExcludeFilter, nextExcludeFilter.getName());
            baselineRecords.put(record, (IQualityGateElement)nextExcludeFilter);
        }
        return baselineRecords;
    }

    private QualityGateElementRecord createBaselineExcludeFilterRecord(IQualityGateExcludeFilter excludeFilter, String filterName) {
        String[] nameParts = this.splitConditionIntoParts(filterName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (nameParts.length > index) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        QualityGateElementRecord record = new QualityGateElementRecord(excludeFilter, conditionType, excludeFilter.getName(), properties);
        return record;
    }

    private QualityGateElementRecord createCurrentIssueConditionRecord(Object condition, String conditionName, boolean isThresholdCondition) {
        String[] nameParts = this.splitConditionIntoParts(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        String operator = Operator.fromStandardName(nameParts[index++]).getPresentationName();
        properties.put(QualityGateProperty.OPERATOR, operator);
        properties.put(QualityGateProperty.LIMIT, nameParts[index++]);
        return new QualityGateElementRecord(condition, conditionType, conditionName, properties);
    }

    private QualityGateElementRecord createBaselineIssueConditionRecord(Object condition, String conditionName, boolean isThresholdCondition) {
        assert (condition != null) : "Parameter 'condition' of method 'createBaselineIssueConditionRecordOfBaseline' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createBaselineIssueConditionRecordOfBaseline' must not be empty";
        String[] nameParts = this.splitConditionIntoParts(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
            properties.put(QualityGateProperty.OPERATOR, Operator.fromStandardName(nameParts[index++]).getPresentationName());
            properties.put(QualityGateProperty.DIFF_THRESHOLD_ABSOLUTE, this.convertNumberProperty(nameParts[index++]));
            properties.put(QualityGateProperty.DIFF_THRESHOLD_RELATIVE, this.convertNumberProperty(nameParts[index++]));
        }
        if (nameParts.length > index) {
            String check = QualityGateDiffCheck.fromStandardName(nameParts[index++]).getPresentationName();
            properties.put(QualityGateProperty.CHECK, check);
        }
        return new QualityGateElementRecord(condition, conditionType, conditionName, properties);
    }

    private String[] splitConditionIntoParts(String conditionName) {
        assert (conditionName != null) : "Parameter 'conditionName' of method 'splitConditionIntoParts' must not be null";
        return conditionName.split("\\" + AbstractQualityGateElement.INNER_NAME_PARTS_SEPARATOR);
    }

    private Map<QualityGateElementRecord, AbstractQualityGateElement> createCurrentRecords(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'computeCurrentRecords' must not be null";
        LinkedHashMap<QualityGateElementRecord, AbstractQualityGateElement> currentRecords = new LinkedHashMap<QualityGateElementRecord, AbstractQualityGateElement>();
        for (AbstractCurrentIssueQualityGateCondition nextCondition : parent.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            boolean isThresholdCondition = nextCondition instanceof ThresholdIssueQualityGateCondition;
            String conditionName = nextCondition.getName();
            QualityGateElementRecord record = this.createCurrentConditionRecord(nextCondition, conditionName, isThresholdCondition);
            currentRecords.put(record, nextCondition);
        }
        for (QualityGateExcludeFilter nextExcludeFilter : parent.getChildren(QualityGateExcludeFilter.class)) {
            String excludeFilterName = nextExcludeFilter.getName();
            QualityGateElementRecord record = this.createExcludeFilterRecord(nextExcludeFilter, excludeFilterName);
            currentRecords.put(record, nextExcludeFilter);
        }
        return currentRecords;
    }

    private Map<QualityGateElementRecord, AbstractQualityGateElement> createCurrentDiffRecords(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'computeCurrentRecords' must not be null";
        LinkedHashMap<QualityGateElementRecord, AbstractQualityGateElement> currentRecords = new LinkedHashMap<QualityGateElementRecord, AbstractQualityGateElement>();
        for (AbstractIssueDiffAgainstBaselineCondition abstractIssueDiffAgainstBaselineCondition : parent.getChildren(AbstractIssueDiffAgainstBaselineCondition.class)) {
            boolean isThresholdCondition = abstractIssueDiffAgainstBaselineCondition instanceof ThresholdIssueDiffAgainstBaselineCondition;
            QualityGateElementRecord record = this.createBaselineIssueConditionRecord(abstractIssueDiffAgainstBaselineCondition, abstractIssueDiffAgainstBaselineCondition.getName(), isThresholdCondition);
            currentRecords.put(record, abstractIssueDiffAgainstBaselineCondition);
        }
        for (MetricValueDiffQualityGateCondition metricValueDiffQualityGateCondition : parent.getChildren(MetricValueDiffQualityGateCondition.class)) {
            QualityGateElementRecord record = this.createBaselineMetricConditionRecord(metricValueDiffQualityGateCondition, metricValueDiffQualityGateCondition.getName());
            currentRecords.put(record, metricValueDiffQualityGateCondition);
        }
        for (QualityGateExcludeFilter qualityGateExcludeFilter : parent.getChildren(QualityGateExcludeFilter.class)) {
            QualityGateElementRecord record = this.createExcludeFilterRecord(qualityGateExcludeFilter, qualityGateExcludeFilter.getName());
            currentRecords.put(record, qualityGateExcludeFilter);
        }
        return currentRecords;
    }

    private QualityGateElementRecord createBaselineMetricConditionRecord(Object condition, String conditionName) {
        assert (condition != null) : "Parameter 'condition' of method 'createBaselineMetricConditionRecordOfBaseline' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createBaselineMetricConditionRecordOfBaseline' must not be empty";
        String[] nameParts = this.splitConditionIntoParts(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.METRIC_ID, nameParts[index++]);
        properties.put(QualityGateProperty.OPERATOR, Operator.fromStandardName(nameParts[index++]).getPresentationName());
        properties.put(QualityGateProperty.DIFF_THRESHOLD_ABSOLUTE, this.convertNumberProperty(nameParts[index++]));
        properties.put(QualityGateProperty.DIFF_THRESHOLD_RELATIVE, this.convertNumberProperty(nameParts[index++]));
        return new QualityGateElementRecord(condition, conditionType, conditionName, properties);
    }

    private String convertNumberProperty(String value) {
        assert (value != null) : "Parameter 'value' of method 'convertNumberProperty' must not be null";
        if (value.equals("n/a")) {
            return value;
        }
        Number number = NumberUtility.parseLocaleIndependently((String)value, (boolean)false);
        if (number == null) {
            return value;
        }
        return NumberUtility.format((Number)number, (boolean)false);
    }

    private QualityGateElementRecord createCurrentConditionRecord(Object condition, String conditionName, boolean isThresholdCondition) {
        assert (condition != null) : "Parameter 'condition' of method 'createCurrentConditionRecord' must not be null";
        assert (conditionName != null && conditionName.length() > 0) : "Parameter 'conditionName' of method 'createCurrentConditionRecord' must not be empty";
        String[] nameParts = this.splitConditionIntoParts(conditionName);
        int index = 0;
        String conditionType = nameParts[index++];
        LinkedHashMap<QualityGateProperty, String> properties = new LinkedHashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (isThresholdCondition) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        String operator = Operator.fromStandardName(nameParts[index++]).getPresentationName();
        properties.put(QualityGateProperty.OPERATOR, operator);
        properties.put(QualityGateProperty.LIMIT, nameParts[index++]);
        QualityGateElementRecord record = new QualityGateElementRecord(condition, conditionType, conditionName, properties);
        return record;
    }

    private QualityGateElementRecord createExcludeFilterRecord(Object excludeFilter, String excludeFilterName) {
        assert (excludeFilter != null) : "Parameter 'excludeFilter' of method 'createExcludeFilter' must not be null";
        assert (excludeFilterName != null && excludeFilterName.length() > 0) : "Parameter 'excludeFilterName' of method 'createExcludeFilter' must not be empty";
        String[] nameParts = this.splitConditionIntoParts(excludeFilterName);
        int index = 0;
        String conditionType = nameParts[index++];
        HashMap<QualityGateProperty, String> properties = new HashMap<QualityGateProperty, String>();
        properties.put(QualityGateProperty.ISSUE_TYPE, nameParts[index++]);
        properties.put(QualityGateProperty.SEVERITY, nameParts[index++]);
        properties.put(QualityGateProperty.RESOLUTION, nameParts[index++]);
        if (nameParts.length > index) {
            String metricId = nameParts[index++];
            properties.put(QualityGateProperty.METRIC_ID, metricId);
        }
        QualityGateElementRecord record = new QualityGateElementRecord(excludeFilter, conditionType, excludeFilterName, properties);
        return record;
    }

    private void processRemoved(QualityGatesDiff qualityGatesDiff, IQualityGate baseline) {
        assert (qualityGatesDiff != null) : "Parameter 'qualityGatesDiff' of method 'processRemoved' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'processRemoved' must not be null";
        QualityGateDiff removedDiff = new QualityGateDiff((NamedElement)qualityGatesDiff, baseline, null, IDiffElement.Change.REMOVED);
        QualityGateCurrentConditionsDiff currentConditionsDiff = new QualityGateCurrentConditionsDiff((NamedElement)removedDiff, null, QualityGateCurrentConditionsDiff.getShortNameString(), QualityGateCurrentConditionsDiff.getPresentationNameString(true), IDiffElement.Change.REMOVED);
        for (IQualityGateIssueCondition currentCondition : baseline.getCurrentSystemConditions().getCurrentSystemConditions()) {
            QualityGateElementDiff currentDiff = new QualityGateElementDiff(currentConditionsDiff, (IQualityGateElement)currentCondition, null, IDiffElement.Change.REMOVED, currentCondition.getImageResourceName());
            currentConditionsDiff.addChild(currentDiff);
        }
        for (IQualityGateExcludeFilter nextExclude : baseline.getCurrentSystemConditions().getExcludeFilters()) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(currentConditionsDiff, (IQualityGateElement)nextExclude, null, IDiffElement.Change.REMOVED, nextExclude.getImageResourceName());
            currentConditionsDiff.addChild(filterDiff);
        }
        removedDiff.addChild(currentConditionsDiff);
        QualityGateBaselineConditionsDiff baselineConditionDiffs = new QualityGateBaselineConditionsDiff((NamedElement)removedDiff, null, QualityGateBaselineConditionsDiff.getShortNameString(), QualityGateBaselineConditionsDiff.getPresentationNameString(false), IDiffElement.Change.REMOVED);
        for (IQualityGateElement baselineCondition : baseline.getDiffAgainstBaselineConditions().getDiffConditions()) {
            QualityGateElementDiff diff = new QualityGateElementDiff(baselineConditionDiffs, baselineCondition, null, IDiffElement.Change.REMOVED, baselineCondition.getImageResourceName());
            baselineConditionDiffs.addChild(diff);
        }
        for (IQualityGateExcludeFilter nextExclude : baseline.getDiffAgainstBaselineConditions().getExcludeFilters()) {
            QualityGateElementDiff filterDiff = new QualityGateElementDiff(baselineConditionDiffs, (IQualityGateElement)nextExclude, null, IDiffElement.Change.REMOVED, nextExclude.getImageResourceName());
            baselineConditionDiffs.addChild(filterDiff);
        }
        removedDiff.addChild(baselineConditionDiffs);
        qualityGatesDiff.addChild(removedDiff);
    }

    private static class QualityGateElementRecord {
        private final Object m_element;
        private final Map<QualityGateProperty, String> m_properties;
        private final String m_conditionText;
        private final String m_type;

        public QualityGateElementRecord(Object element, String type, String conditionText, Map<QualityGateProperty, String> properties) {
            assert (element != null) : "Parameter 'element' of method 'QualityGateElementRecord' must not be null";
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'QualityGateElementRecord' must not be empty";
            assert (conditionText != null && conditionText.length() > 0) : "Parameter 'conditionText' of method 'QualityGateConditionRecord' must not be empty";
            assert (properties != null && !properties.isEmpty()) : "Parameter 'properties' of method 'QualityGateConditionRecord' must not be empty";
            this.m_element = element;
            this.m_type = type;
            this.m_conditionText = conditionText;
            this.m_properties = properties;
        }

        public String toString() {
            return this.m_conditionText;
        }

        public int hashCode() {
            return Objects.hash(this.m_conditionText, this.m_properties, this.m_type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QualityGateElementRecord other = (QualityGateElementRecord)obj;
            return Objects.equals(this.m_conditionText, other.m_conditionText) && Objects.equals(this.m_properties, other.m_properties) && Objects.equals(this.m_type, other.m_type);
        }
    }

    private static enum QualityGateProperty implements IStandardEnumeration
    {
        ISSUE_TYPE("Issue Type"),
        SEVERITY("Severity"),
        RESOLUTION("Resolution"),
        METRIC_ID("Metric Id"),
        OPERATOR("Operator"),
        LIMIT("Limit"),
        DIFF_THRESHOLD_ABSOLUTE("Absolute Threshold"),
        DIFF_THRESHOLD_RELATIVE("Relative Threshold"),
        CHECK("Check");

        private final String m_presentationName;

        private QualityGateProperty(String presentationName) {
            this.m_presentationName = presentationName;
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }
    }

    private static class RecordMatch {
        private final QualityGateElementRecord m_baseline;
        private final QualityGateElementRecord m_current;
        private final int m_score;

        public RecordMatch(QualityGateElementRecord baseline, QualityGateElementRecord current, int score) {
            assert (baseline != null) : "Parameter 'baseline' of method 'RecordMatch' must not be null";
            assert (current != null) : "Parameter 'current' of method 'RecordMatch' must not be null";
            this.m_baseline = baseline;
            this.m_current = current;
            this.m_score = score;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RecordMatch [m_baseline=");
            builder.append(this.m_baseline);
            builder.append(", m_current=");
            builder.append(this.m_current);
            builder.append(", m_score=");
            builder.append(this.m_score);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class RecordMatchComparator
    implements Comparator<RecordMatch> {
        private RecordMatchComparator() {
        }

        @Override
        public int compare(RecordMatch o1, RecordMatch o2) {
            return Integer.compare(o2.m_score, o1.m_score);
        }
    }
}

