/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.BaselineOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.CurrentOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.text.Levenshtein;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;

public final class DuplicateCodeBlockOccurrenceMatcher {
    private DuplicateCodeBlockOccurrenceMatcher() {
    }

    public static int calculateOverlap(int baselineStart, int baselineEnd, int currentStart, int currentEnd) {
        int start = Math.max(baselineStart, currentStart);
        int end = Math.min(baselineEnd, currentEnd);
        return end - start + 1;
    }

    public static StrictPair<DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail, Integer> getChangeDetail(CurrentOccurrenceDto currentOccurrence, BaselineOccurrenceDto baselineOccurrence) {
        DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail;
        if (!currentOccurrence.getIdentifyingPath().equals(baselineOccurrence.getIdentifyingPath())) {
            return null;
        }
        IntBasedHash baselineHash = baselineOccurrence.getHash();
        IntBasedHash currentHash = currentOccurrence.getHash();
        Boolean exactMatch = null;
        int overlap = 0;
        if (baselineHash != null && currentHash != null) {
            StrictPair similarity = Levenshtein.similarity((IntBasedHash)baselineHash, (IntBasedHash)currentHash);
            if (Double.compare((Double)similarity.getFirst(), 0.6) < 0) {
                return null;
            }
            exactMatch = (double)Double.compare((Double)similarity.getFirst(), 1.0) == 0.0 ? Boolean.TRUE : Boolean.FALSE;
            int blockLength = Math.max(baselineOccurrence.getBlockSize(), currentOccurrence.getBlockSize());
            overlap = blockLength - (Integer)similarity.getSecond();
        }
        int currentStart = currentOccurrence.getStart();
        int currentEnd = currentOccurrence.getEnd();
        int baselineStart = baselineOccurrence.getStart();
        int baselineEnd = baselineOccurrence.getEnd();
        if (exactMatch != null && exactMatch == Boolean.TRUE) {
            changeDetail = DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED;
        } else if (currentStart == baselineStart && currentEnd == baselineEnd) {
            changeDetail = exactMatch == null ? DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED : DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.MODIFIED;
        } else if (currentStart < baselineStart && currentEnd >= baselineEnd || currentStart <= baselineStart && currentEnd > baselineEnd) {
            changeDetail = DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.EXTENDED;
        } else if (currentStart > baselineStart && currentEnd <= baselineEnd || currentStart >= baselineStart && currentEnd < baselineEnd) {
            changeDetail = DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REDUCED;
        } else if (currentStart > baselineStart && currentStart < baselineEnd && currentEnd > baselineEnd || currentStart < baselineStart && currentEnd > baselineStart && currentEnd < baselineEnd) {
            changeDetail = DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.MOVED;
        } else {
            return null;
        }
        if (overlap == 0) {
            overlap = DuplicateCodeBlockOccurrenceMatcher.calculateOverlap(baselineStart, baselineEnd, currentStart, currentEnd);
        }
        return new StrictPair((Object)changeDetail, (Object)overlap);
    }
}

