/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.dependenciesview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssue;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewRepresentationInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchitectureIssuesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureIssuesProcessor.class);

    protected void clear(DependenciesViewRepresentationInfo info) {
        assert (info != null) : "Parameter 'info' of method 'clear' must not be null";
        info.clearDependencyInfo(true);
    }

    protected void hasArchitectureViolation(ProgrammingElement from, ProgrammingElement to) {
        assert (from != null) : "Parameter 'from' of method 'hasArchitectureViolation' must not be null";
        assert (to != null) : "Parameter 'to' of method 'hasArchitectureViolation' must not be null";
    }

    protected void hasArchitectureDeprecation(ProgrammingElement from) {
        assert (from != null) : "Parameter 'from' of method 'hasArchitectureDeprecation' must not be null";
    }

    public void process(IVirtualModel virtualModel, final String basedOnArchitectureFileIdentifyingPath, final boolean isLogical, DependenciesViewRepresentationInfo info) {
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'process' must not be null";
        assert (info != null) : "Parameter 'info' of method 'process' must not be null";
        this.clear(info);
        THashMap violationCauseToParserDependencies = new THashMap();
        THashMap deprecationCauseToParserDependencies = new THashMap();
        THashMap parserDependencyToIssues = new THashMap();
        virtualModel.accept(new IVirtualModel.IIssueVisitor((Map)violationCauseToParserDependencies, info, (Map)deprecationCauseToParserDependencies, (Map)parserDependencyToIssues){
            private final /* synthetic */ Map val$violationCauseToParserDependencies;
            private final /* synthetic */ DependenciesViewRepresentationInfo val$info;
            private final /* synthetic */ Map val$deprecationCauseToParserDependencies;
            private final /* synthetic */ Map val$parserDependencyToIssues;
            {
                this.val$violationCauseToParserDependencies = map;
                this.val$info = dependenciesViewRepresentationInfo;
                this.val$deprecationCauseToParserDependencies = map2;
                this.val$parserDependencyToIssues = map3;
            }

            @Override
            public boolean visit(Issue issue) {
                if (!$assertionsDisabled && issue == null) {
                    throw new AssertionError((Object)"Parameter 'issue' of method 'check' must not be null");
                }
                Element affected = issue.getAffectedElement();
                boolean add = false;
                if (issue instanceof ArchitectureCheckIssue) {
                    IProviderId nextProviderId = issue.getProvider();
                    if (basedOnArchitectureFileIdentifyingPath == null || basedOnArchitectureFileIdentifyingPath.equals(nextProviderId.getStandardName())) {
                        if (!($assertionsDisabled || affected != null && affected instanceof ParserDependency)) {
                            throw new AssertionError((Object)("Unexpected class in method 'check': " + String.valueOf(affected)));
                        }
                        add = true;
                        ParserDependency parserDependency = (ParserDependency)affected;
                        ProgrammingElement nextFrom = parserDependency.getFrom();
                        if (!isLogical || nextFrom.includeInLogicalModel()) {
                            Object cause = ((ArchitectureCheckIssue)issue).getRestriction();
                            String nextProvider = issue.getProvider().getPresentationName();
                            if (cause == null || ((String)cause).isEmpty()) {
                                LOGGER.warn("No restriction set for violating parser dependency: " + String.valueOf(parserDependency));
                                cause = nextProvider + ": Violation";
                            } else {
                                cause = nextProvider + ": " + (String)cause;
                            }
                            if (issue instanceof ArchitectureViolationIssue) {
                                ArrayList<ParserDependency> parserDependencies = (ArrayList<ParserDependency>)this.val$violationCauseToParserDependencies.get(cause);
                                if (parserDependencies == null) {
                                    parserDependencies = new ArrayList<ParserDependency>();
                                    this.val$violationCauseToParserDependencies.put(cause, parserDependencies);
                                }
                                parserDependencies.add(parserDependency);
                                if (issue.isIgnored()) {
                                    this.val$info.addViolationsIgnored(Collections.singleton(parserDependency));
                                } else {
                                    if (issue.toBeFixed()) {
                                        this.val$info.addViolationsToBeFixed(Collections.singleton(parserDependency));
                                    }
                                    ArchitectureIssuesProcessor.this.hasArchitectureViolation(nextFrom, parserDependency.getTo());
                                }
                            } else if (issue instanceof ArchitectureDeprecationIssue) {
                                ArrayList<ParserDependency> parserDependencies = (ArrayList<ParserDependency>)this.val$deprecationCauseToParserDependencies.get(cause);
                                if (parserDependencies == null) {
                                    parserDependencies = new ArrayList<ParserDependency>();
                                    this.val$deprecationCauseToParserDependencies.put(cause, parserDependencies);
                                }
                                parserDependencies.add(parserDependency);
                                if (issue.isIgnored()) {
                                    this.val$info.addDeprecationsIgnored(Collections.singleton(parserDependency));
                                } else {
                                    if (issue.toBeFixed()) {
                                        this.val$info.addDeprecationsToBeFixed(Collections.singleton(parserDependency));
                                    }
                                    ArchitectureIssuesProcessor.this.hasArchitectureDeprecation(nextFrom);
                                }
                            } else {
                                LOGGER.warn("Unhandled ArchitectureCheckIssue subclass: " + issue.getClass().getName());
                            }
                        }
                    }
                } else {
                    add = true;
                }
                if (add && affected instanceof ParserDependency) {
                    ArrayList<Issue> issues = (ArrayList<Issue>)this.val$parserDependencyToIssues.get(affected);
                    if (issues == null) {
                        issues = new ArrayList<Issue>(2);
                        this.val$parserDependencyToIssues.put((ParserDependency)affected, issues);
                    }
                    issues.add(issue);
                }
                return true;
            }
        });
        for (Map.Entry nextEntry : violationCauseToParserDependencies.entrySet()) {
            info.addArchitectureViolation((List)nextEntry.getValue(), (String)nextEntry.getKey());
        }
        for (Map.Entry nextEntry : deprecationCauseToParserDependencies.entrySet()) {
            info.addArchitectureDeprecation((List)nextEntry.getValue(), (String)nextEntry.getKey());
        }
        info.addIssues((Map<ParserDependency, List<Issue>>)parserDependencyToIssues);
    }
}

