/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.IReplaceStrategy;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;

final class ArchitectureFileNameReplaceStrategy
implements IReplaceStrategy {
    private static final String QUOTATION_MARK = "\"";
    private final String m_newName;

    ArchitectureFileNameReplaceStrategy(String newName) {
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'ArchitectureFileNameReplaceStrategy' must not be empty";
        this.m_newName = this.strip(newName);
    }

    private static String removeQuotationMarks(String text) {
        assert (text != null) : "Parameter 'text' of method 'hasQuotationMarks' must not be null";
        if (text.startsWith(QUOTATION_MARK) && text.endsWith(QUOTATION_MARK)) {
            return text.replaceAll("^\"|\"$", "");
        }
        return text;
    }

    private static String addQuotationMarks(String text) {
        assert (text != null) : "Parameter 'text' of method 'addQuotationMarks' must not be null";
        return QUOTATION_MARK + text + QUOTATION_MARK;
    }

    @Override
    public String replace(String text) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'replace' must not be empty";
        text = ArchitectureFileNameReplaceStrategy.removeQuotationMarks(text);
        boolean relative = text.startsWith("./");
        boolean ext = CoreFileType.ARCHITECTURE.hasExtension(FileUtility.getExtension((String)text));
        StringBuilder sb = new StringBuilder(relative ? "./" : "");
        sb.append(this.m_newName);
        sb.append(ext ? FileUtility.getExtension((String)text) : "");
        return ArchitectureFileNameReplaceStrategy.addQuotationMarks(sb.toString());
    }

    private String strip(String text) {
        if ((text = FileUtility.removeExtension((String)text)).startsWith("./")) {
            text = text.substring("./".length());
        }
        return text;
    }
}

