/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.api;

import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import groovy.lang.Closure;

final class ElementClosure {
    private final Class<?> m_modelClass;
    private final Closure<?> m_closure;
    private final ElementAccess.IAccessFactory m_factory;

    ElementClosure(ElementAccess.IAccessFactory factory, Class<?> modelClass, Closure<?> closure) {
        assert (factory != null) : "Parameter 'factory' of method 'ElementClosure' must not be null";
        assert (modelClass != null) : "Parameter 'modelClass' of method 'ElementClosure' must not be null";
        assert (closure != null) : "Parameter 'closure' of method 'ElementClosure' must not be null";
        this.m_factory = factory;
        this.m_modelClass = modelClass;
        this.m_closure = closure;
    }

    boolean matches(Class<?> modelClass) {
        return this.m_modelClass.isAssignableFrom(modelClass);
    }

    void execute(NamedElement element) {
        this.m_closure.call(this.m_factory.createAccessObject(element));
    }

    void execute(ElementAccess<? extends NamedElement> element) {
        this.m_closure.call(element);
    }
}

