/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.size;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.InternalDirectoryProcessor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.InternalTopLevelLogicalElementCounter;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetric;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SizeMetricsAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.SIZE_METRICS;
    private static final Logger LOGGER = LoggerFactory.getLogger(SizeMetricsAdapter.class);
    private final List<IMetric> m_metricsToBeCumulated = new ArrayList<IMetric>();
    private final Map<IMetricId, IMetricDescriptor> m_systemMetricIdToDescriptor = new LinkedHashMap<IMetricId, IMetricDescriptor>();
    private final Map<IMetricId, IMetricDescriptor> m_moduleMetricIdToDescriptor = new LinkedHashMap<IMetricId, IMetricDescriptor>();
    private final Map<IMetricLevel, IMetricDescriptor> m_metricLevelToTypesInDirectoryMetricDescriptor = new LinkedHashMap<IMetricLevel, IMetricDescriptor>();
    private final Map<IMetricLevel, IMetricDescriptor> m_metricLevelToComponentsInDirectoryMetricDescriptor = new LinkedHashMap<IMetricLevel, IMetricDescriptor>();
    private final Map<IMetricLevel, IMetricDescriptor> m_metricLevelToTypesInNamespacePerModuleMetricDescriptor = new LinkedHashMap<IMetricLevel, IMetricDescriptor>();
    private final Map<IMetricLevel, IMetricDescriptor> m_metricLevelToTypesInNamespacePerSystemMetricDescriptor = new LinkedHashMap<IMetricLevel, IMetricDescriptor>();
    private final IMetricDescriptor m_numberOfModulesInSystem;
    private final IMetricDescriptor m_numberOfComponentsInSystem;
    private final IMetricDescriptor m_numberOfComponentsIgnoringIssuesInSystem;
    private final IMetricDescriptor m_numberOfComponentsInSystemFullyAnalyzed;
    private final IMetricDescriptor m_numberOfComponentsInModule;
    private final IMetricDescriptor m_numberOfComponentsIgnoringIssuesInModule;
    private final IMetricDescriptor m_numberOfComponentsInModuleFullyAnalyzed;
    private final IMetricDescriptor m_numberOfTypesInSystem;
    private final IMetricDescriptor m_numberOfTypesInModule;
    private final IMetricDescriptor m_numberOfTypesInComponent;
    private final IMetricDescriptor m_numberOfSourceFiles;
    private final IMetricDescriptor m_numberOfSourceFilesFullAnalysis;
    private final IMetricDescriptor m_numberOfSourceFilesTest;
    private final IMetricDescriptor m_numberOfSourceFilesIssueIgnored;
    private final IMetricDescriptor m_numberOfSourceFilesExcluded;
    private final IMetricDescriptor m_fullyAnalyzedLoc;
    private final IMetricDescriptor m_fullyAnalyzedLocModule;
    private final IMetricDescriptor m_issueIgnoringLoc;
    private final IMetricDescriptor m_numberOfLogicalTopLevelProgrammingElementsInSystem;
    private final IMetricDescriptor m_numberOfLogicalTopLevelProgrammingElementsInModule;

    public SizeMetricsAdapter(IAnalyzerController controller) {
        super(controller, ID);
        IMetricsProvider metricsProvider = this.getInstallation().getExtension(IMetricsProvider.class);
        for (IMetric metric : metricsProvider.getMetricDescriptors(IMetric.class)) {
            if (metric.getLevel() != CoreMetricLevel.SYSTEM) continue;
            this.m_metricsToBeCumulated.add(metric);
            this.addMetricDescriptor(metric);
        }
        MetricProvider coreMetricProvider = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfModulesInSystem = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_MODULES, CoreMetricLevel.SYSTEM);
        this.m_numberOfComponentsInSystem = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS, CoreMetricLevel.SYSTEM);
        this.m_numberOfComponentsIgnoringIssuesInSystem = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS_IGNORING_ISSUES, CoreMetricLevel.SYSTEM);
        this.m_numberOfComponentsInSystemFullyAnalyzed = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS_FULLY_ANALYZED, CoreMetricLevel.SYSTEM);
        this.m_numberOfComponentsInModule = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS, CoreMetricLevel.MODULE);
        this.m_numberOfComponentsIgnoringIssuesInModule = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS_IGNORING_ISSUES, CoreMetricLevel.MODULE);
        this.m_numberOfComponentsInModuleFullyAnalyzed = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_COMPONENTS_FULLY_ANALYZED, CoreMetricLevel.MODULE);
        this.m_numberOfTypesInSystem = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_TYPES, CoreMetricLevel.SYSTEM);
        this.m_numberOfTypesInModule = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_TYPES, CoreMetricLevel.MODULE);
        this.m_numberOfTypesInComponent = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_TYPES, CoreMetricLevel.COMPONENT);
        this.m_numberOfSourceFiles = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_SOURCEFILES, CoreMetricLevel.SYSTEM);
        this.m_numberOfSourceFilesFullAnalysis = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_SOURCEFILES_FULLY_ANALYZED, CoreMetricLevel.SYSTEM);
        this.m_numberOfSourceFilesTest = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_SOURCEFILES_TEST, CoreMetricLevel.SYSTEM);
        this.m_numberOfSourceFilesIssueIgnored = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_SOURCEFILES_ISSUE_IGNORE, CoreMetricLevel.SYSTEM);
        this.m_numberOfSourceFilesExcluded = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_SOURCEFILES_EXCLUDED, CoreMetricLevel.SYSTEM);
        this.m_fullyAnalyzedLoc = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED, CoreMetricLevel.SYSTEM);
        this.m_fullyAnalyzedLocModule = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED, CoreMetricLevel.MODULE);
        this.m_issueIgnoringLoc = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_ISSUE_IGNORING, CoreMetricLevel.SYSTEM);
        this.m_numberOfLogicalTopLevelProgrammingElementsInSystem = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.SYSTEM);
        this.m_numberOfLogicalTopLevelProgrammingElementsInModule = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.MODULE);
        this.addLanguageSpecificMetricDescriptors(this.getController().getUsedLanguageProviders());
    }

    private void addLanguageSpecificMetricDescriptors(Collection<? extends IMetricAwareLanguageProvider> languageProviders) {
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'addMetricDescriptors' must not be null";
        for (IMetricAwareLanguageProvider iMetricAwareLanguageProvider : languageProviders) {
            IMetricId namespacesMetricId;
            MetricProvider metricProvider = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(iMetricAwareLanguageProvider.getProviderId());
            IMetricId directoriesMetricId = iMetricAwareLanguageProvider.getDirectoriesMetricId();
            if (directoriesMetricId != null) {
                this.m_systemMetricIdToDescriptor.put(directoriesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, directoriesMetricId, CoreMetricLevel.SYSTEM));
                this.m_moduleMetricIdToDescriptor.put(directoriesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, directoriesMetricId, CoreMetricLevel.MODULE));
                IMetricLevel metricLevel = iMetricAwareLanguageProvider.getDirectoryMetricLevel();
                assert (metricLevel != null) : "'metricLevel' of method 'addMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                this.m_metricLevelToTypesInDirectoryMetricDescriptor.put(metricLevel, this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_TYPES, metricLevel));
                this.m_metricLevelToComponentsInDirectoryMetricDescriptor.put(metricLevel, this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_COMPONENTS, metricLevel));
                IMetricId fullyAnalyzedDirectoriesMetricId = iMetricAwareLanguageProvider.getFullyAnalyzedDirectoriesMetricId();
                assert (fullyAnalyzedDirectoriesMetricId != null) : "Missing metric id for fully analyzed directories for language " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                this.m_systemMetricIdToDescriptor.put(fullyAnalyzedDirectoriesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, fullyAnalyzedDirectoriesMetricId, CoreMetricLevel.SYSTEM));
                this.m_moduleMetricIdToDescriptor.put(fullyAnalyzedDirectoriesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, fullyAnalyzedDirectoriesMetricId, CoreMetricLevel.MODULE));
            }
            if ((namespacesMetricId = iMetricAwareLanguageProvider.getNamespacesMetricId()) != null) {
                this.m_systemMetricIdToDescriptor.put(namespacesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, namespacesMetricId, CoreMetricLevel.SYSTEM));
                this.m_moduleMetricIdToDescriptor.put(namespacesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, namespacesMetricId, CoreMetricLevel.MODULE));
                IMetricId fullyAnalyzedNamespacesMetricId = iMetricAwareLanguageProvider.getFullyAnalyzedNamespacesMetricId();
                assert (fullyAnalyzedNamespacesMetricId != null) : "'fullyAnalyzedNamespacesMetricId' of method 'addMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                this.m_systemMetricIdToDescriptor.put(fullyAnalyzedNamespacesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, fullyAnalyzedNamespacesMetricId, CoreMetricLevel.SYSTEM));
                this.m_moduleMetricIdToDescriptor.put(fullyAnalyzedNamespacesMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, fullyAnalyzedNamespacesMetricId, CoreMetricLevel.MODULE));
                IMetricLevel namespaceMetricLevel = iMetricAwareLanguageProvider.getNamespaceMetricLevel();
                assert (namespaceMetricLevel != null) : "'namespaceMetricLevel' of method 'addMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                this.m_metricLevelToTypesInNamespacePerSystemMetricDescriptor.put(namespaceMetricLevel, this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_TYPES_SYSTEM, namespaceMetricLevel, e -> e instanceof LogicalSystemNamespace));
                this.m_metricLevelToTypesInNamespacePerModuleMetricDescriptor.put(namespaceMetricLevel, this.addMetricDescriptorIfNotExistent(metricProvider, CoreMetricId.CORE_TYPES_MODULE, namespaceMetricLevel, e -> e instanceof LogicalModuleNamespace));
            }
            Set<IMetricId> systemSizeMetricIds = iMetricAwareLanguageProvider.getAdditionalSystemSizeMetricIds();
            for (IMetricId nextMetricId : systemSizeMetricIds) {
                this.m_systemMetricIdToDescriptor.put(nextMetricId, this.addMetricDescriptorIfNotExistent(metricProvider, nextMetricId, CoreMetricLevel.SYSTEM));
            }
        }
    }

    private void removeMetricDescriptors(Collection<? extends IMetricAwareLanguageProvider> languageProviders) {
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'removeMetricDescriptors' must not be null";
        ArrayList<IMetricDescriptor> metricDescriptorsToRemove = new ArrayList<IMetricDescriptor>();
        for (IMetricAwareLanguageProvider iMetricAwareLanguageProvider : languageProviders) {
            IMetricDescriptor nextMetricDescriptor = null;
            IMetricId nextDirectoriesMetricId = iMetricAwareLanguageProvider.getDirectoriesMetricId();
            if (nextDirectoriesMetricId != null) {
                nextMetricDescriptor = this.m_systemMetricIdToDescriptor.remove(nextDirectoriesMetricId);
                if (nextMetricDescriptor != null) {
                    metricDescriptorsToRemove.add(nextMetricDescriptor);
                }
                if ((nextMetricDescriptor = this.m_moduleMetricIdToDescriptor.remove(nextDirectoriesMetricId)) != null) {
                    metricDescriptorsToRemove.add(nextMetricDescriptor);
                }
                IMetricLevel nextMetricLevel = iMetricAwareLanguageProvider.getDirectoryMetricLevel();
                assert (nextMetricLevel != null) : "'nextMetricLevel' of method 'removeMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                nextMetricDescriptor = this.m_metricLevelToTypesInDirectoryMetricDescriptor.remove(nextMetricLevel);
                if (nextMetricDescriptor != null) {
                    metricDescriptorsToRemove.add(nextMetricDescriptor);
                }
                if ((nextMetricDescriptor = this.m_metricLevelToComponentsInDirectoryMetricDescriptor.remove(nextMetricLevel)) != null) {
                    metricDescriptorsToRemove.add(nextMetricDescriptor);
                }
            }
            IMetricId nextNamespacesMetricId = iMetricAwareLanguageProvider.getNamespacesMetricId();
            assert (nextNamespacesMetricId != null) : "'nextNamespacesMetricId' of method 'removeMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
            nextMetricDescriptor = this.m_systemMetricIdToDescriptor.remove(nextNamespacesMetricId);
            if (nextMetricDescriptor != null) {
                metricDescriptorsToRemove.add(nextMetricDescriptor);
            }
            if ((nextMetricDescriptor = this.m_moduleMetricIdToDescriptor.remove(nextNamespacesMetricId)) != null) {
                metricDescriptorsToRemove.add(nextMetricDescriptor);
            }
            IMetricLevel nextNamespaceMetricLevel = iMetricAwareLanguageProvider.getNamespaceMetricLevel();
            assert (nextNamespaceMetricLevel != null) : "'nextNamespaceMetricLevel' of method 'removeMetricDescriptors' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
            nextMetricDescriptor = this.m_metricLevelToTypesInNamespacePerSystemMetricDescriptor.remove(nextNamespaceMetricLevel);
            if (nextMetricDescriptor != null) {
                metricDescriptorsToRemove.add(nextMetricDescriptor);
            }
            if ((nextMetricDescriptor = this.m_metricLevelToTypesInNamespacePerModuleMetricDescriptor.remove(nextNamespaceMetricLevel)) != null) {
                metricDescriptorsToRemove.add(nextMetricDescriptor);
            }
            Set<IMetricId> nextSystemSizeMetricIds = iMetricAwareLanguageProvider.getAdditionalSystemSizeMetricIds();
            for (IMetricId nextMetricId : nextSystemSizeMetricIds) {
                nextMetricDescriptor = this.m_systemMetricIdToDescriptor.remove(nextMetricId);
                if (nextMetricDescriptor == null) continue;
                metricDescriptorsToRemove.add(nextMetricDescriptor);
            }
        }
        if (!metricDescriptorsToRemove.isEmpty()) {
            super.remove(metricDescriptorsToRemove);
        }
    }

    @Override
    public void languageAdded(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        this.addLanguageSpecificMetricDescriptors(Collections.singleton(languageProvider));
        super.languageAdded(languageProvider);
    }

    @Override
    public void languageRemoved(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
        this.removeMetricDescriptors(Collections.singleton(languageProvider));
        super.languageRemoved(languageProvider);
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.getSoftwareSystem(), this.m_fullyAnalyzedLoc) == null) {
            throw new RestoreException("Missing expected metric value for fully analyzed lines of code.");
        }
        super.resultSuccessfullyRestored(result);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        SizeMetricsJob job = new SizeMetricsJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class SizeMetricsInternalDirectoryProcessor
    extends InternalDirectoryProcessor {
        private final IMetricDescriptor m_numberOfTypesMetricDescriptor;
        private final IMetricDescriptor m_numberOfComponentsMetricDescriptor;
        private final AnalyzerResult m_analyzerResult;
        private int m_numberOfDirectoriesWithComponents;
        private int m_numberOfDirectoriesFullyAnalyzed;

        SizeMetricsInternalDirectoryProcessor(IMetricDescriptor numberOfComponentsMetricDescriptor, IMetricDescriptor numberOfTypesMetricDescriptor, AnalyzerResult analyzerResult) {
            super(true);
            assert (numberOfComponentsMetricDescriptor != null) : "Parameter 'numberOfComponentsMetricDescriptor' of method 'SizeMetricsInternalDirectoryProcessor' must not be null";
            assert (numberOfTypesMetricDescriptor != null) : "Parameter 'numberOfTypesMetricDescriptor' of method 'SizeMetricsInternalDirectoryProcessor' must not be null";
            assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'SizeMetricsInternalDirectoryProcessor' must not be null";
            this.m_numberOfComponentsMetricDescriptor = numberOfComponentsMetricDescriptor;
            this.m_numberOfTypesMetricDescriptor = numberOfTypesMetricDescriptor;
            this.m_analyzerResult = analyzerResult;
        }

        @Override
        protected void processInternalDirectory(IDirectoryPath directory, int components, int types, int issueIgnoringComponents) {
            assert (directory != null) : "Parameter 'directory' of method 'processInternalDirectory' must not be null";
            assert (types > -1) : "Unexpected number of types: " + types;
            if (directory.containsSourceFiles()) {
                ++this.m_numberOfDirectoriesWithComponents;
                if (issueIgnoringComponents < components) {
                    ++this.m_numberOfDirectoriesFullyAnalyzed;
                }
            }
            SizeMetricsAdapter.this.storeMetricValue(this.m_analyzerResult, directory.getNamedElement(), components, this.m_numberOfComponentsMetricDescriptor);
            SizeMetricsAdapter.this.storeMetricValue(this.m_analyzerResult, directory.getNamedElement(), types, this.m_numberOfTypesMetricDescriptor);
        }

        int getNumberOfDirectoriesWithComponents() {
            return this.m_numberOfDirectoriesWithComponents;
        }

        int getNumberOfFullyAnalyzedDirectories() {
            return this.m_numberOfDirectoriesFullyAnalyzed;
        }

        void reset() {
            this.m_numberOfDirectoriesWithComponents = 0;
            this.m_numberOfDirectoriesFullyAnalyzed = 0;
        }
    }

    private class SizeMetricsJob
    extends AnalyzerJob {
        private SizeMetricsJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        private void collectLogicalTypesRecursively(LogicalProgrammingElement element, List<LogicalProgrammingElement> collector) {
            assert (element != null) : "Parameter 'element' of method 'collectLogicalTypesRecursively' must not be null";
            assert (collector != null) : "Parameter 'collector' of method 'collectLogicalTypesRecursively' must not be null";
            if (element.getPrimaryProgrammingElement() instanceof IType) {
                collector.add(element);
            }
            element.getChildren(LogicalProgrammingElement.class).forEach(c -> this.collectLogicalTypesRecursively((LogicalProgrammingElement)c, collector));
        }

        private Integer getNumberOfLogicalTypes(LogicalNamespace logicalNamespace) {
            assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'getNumberOfLogicalTypes' must not be null";
            ArrayList types = new ArrayList();
            logicalNamespace.getChildren(LogicalProgrammingElement.class).forEach(c -> this.collectLogicalTypesRecursively((LogicalProgrammingElement)c, types));
            return types.size();
        }

        private void intializeValueLists(IWorkerContext workerContext, SoftwareSystem softwareSystem, Collection<? extends IMetricAwareLanguageProvider> usedLanguageProviders, Map<Language, ValueList> languageToTypesInNamespacePerSystemValueList, Map<Module, ValueList> languageToTypesInNamespacePerModuleValueList) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'intializeValueLists' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'intializeValueLists' must not be null";
            assert (usedLanguageProviders != null) : "Parameter 'usedLanguageProviders' of method 'intializeValueLists' must not be null";
            assert (languageToTypesInNamespacePerSystemValueList != null) : "Parameter 'languageToTypesInNamespacePerSystemValueList' of method 'intializeValueLists' must not be null";
            assert (languageToTypesInNamespacePerModuleValueList != null) : "Parameter 'languageToTypesInNamespacePerModuleValueList' of method 'intializeValueLists' must not be null";
            for (IMetricAwareLanguageProvider iMetricAwareLanguageProvider : usedLanguageProviders) {
                IMetricLevel nextNamespaceMetricLevel = iMetricAwareLanguageProvider.getNamespaceMetricLevel();
                assert (nextNamespaceMetricLevel != null) : "'nextNamespaceMetricLevel' of method 'internalRun' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                IMetricDescriptor nextDescriptor = SizeMetricsAdapter.this.m_metricLevelToTypesInNamespacePerSystemMetricDescriptor.get(nextNamespaceMetricLevel);
                assert (nextDescriptor != null) : "'nextDescriptor' of method 'internalRun' must not be null for: " + String.valueOf(iMetricAwareLanguageProvider.getLanguage());
                languageToTypesInNamespacePerSystemValueList.put(iMetricAwareLanguageProvider.getLanguage(), SizeMetricsAdapter.this.createValueList(this.getResult(), nextDescriptor, softwareSystem));
            }
            for (Module module : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                IMetricAwareLanguageProvider nextLp = SizeMetricsAdapter.this.getController().getLanguageProvider(module.getLanguage());
                assert (nextLp != null) : "'nextLp' of method 'internalRun' must not be null for: " + String.valueOf(module.getLanguage());
                IMetricLevel nextNamespaceMetricLevel = nextLp.getNamespaceMetricLevel();
                assert (nextNamespaceMetricLevel != null) : "'nextNamespaceMetricLevel' of method 'internalRun' must not be null for: " + String.valueOf(nextLp.getLanguage());
                IMetricDescriptor nextDescriptor = SizeMetricsAdapter.this.m_metricLevelToTypesInNamespacePerModuleMetricDescriptor.get(nextNamespaceMetricLevel);
                assert (nextDescriptor != null) : "'nextDescriptor' of method 'internalRun' must not be null for: " + String.valueOf(nextLp.getLanguage());
                languageToTypesInNamespacePerModuleValueList.put(module, SizeMetricsAdapter.this.createValueList(this.getResult(), nextDescriptor, module));
            }
        }

        private void calculateLogicalNamespaceMetrics(IWorkerContext workerContext, SoftwareSystem softwareSystem, Map<Language, ValueList> languageToTypesInNamespacePerSystemValueList, Map<Module, ValueList> languageToTypesInNamespacePerModuleValueList) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateLogicalNamespaceMetrics' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateLogicalNamespaceMetrics' must not be null";
            assert (languageToTypesInNamespacePerSystemValueList != null) : "Parameter 'languageToTypesInNamespacePerSystemValueList' of method 'calculateLogicalNamespaceMetrics' must not be null";
            assert (languageToTypesInNamespacePerModuleValueList != null) : "Parameter 'languageToTypesInNamespacePerModuleValueList' of method 'calculateLogicalNamespaceMetrics' must not be null";
            InternalTopLevelLogicalElementCounter systemCounter = new InternalTopLevelLogicalElementCounter(workerContext);
            for (InternalLogicalNamespaceRoot nextInternalLogicalNamespaceRoot : softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(InternalLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextInternalLogicalNamespaceRoot.accept(systemCounter);
                IMetricAwareLanguageProvider languageProvider = SizeMetricsAdapter.this.getController().getLanguageProvider(nextInternalLogicalNamespaceRoot.getLanguage());
                IMetricId namespacesMetricId = languageProvider.getNamespacesMetricId();
                assert (namespacesMetricId != null) : "'namespacesMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                IMetricDescriptor metricDescriptor = SizeMetricsAdapter.this.m_systemMetricIdToDescriptor.get(namespacesMetricId);
                assert (metricDescriptor != null) : "'metricDescriptor' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                List<LogicalNamespace> nonPartLogicalNamespaces = nextInternalLogicalNamespaceRoot.getNonPartLogicalNamespaces();
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, nonPartLogicalNamespaces.size(), metricDescriptor);
                IMetricId namespacesFullyAnalyzedMetricId = languageProvider.getFullyAnalyzedNamespacesMetricId();
                assert (namespacesFullyAnalyzedMetricId != null) : "'namespacesFullyAnalyzedMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                IMetricDescriptor fullyAnalyzedNamespacesMetricDescriptor = SizeMetricsAdapter.this.m_systemMetricIdToDescriptor.get(namespacesFullyAnalyzedMetricId);
                assert (namespacesFullyAnalyzedMetricId != null) : "'namespacesFullyAnalyzedMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                List<LogicalNamespace> namespacesInFullAnalysis = this.removeNamespacesWithOnlyIgnoredElements(nonPartLogicalNamespaces);
                if (namespacesInFullAnalysis == null) {
                    return;
                }
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, namespacesInFullAnalysis.size(), fullyAnalyzedNamespacesMetricDescriptor);
                ValueList valueList = languageToTypesInNamespacePerSystemValueList.get(languageProvider.getLanguage());
                assert (valueList != null) : "'nextValueList' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                for (LogicalNamespace nextLogicalNamespace : nonPartLogicalNamespaces) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    valueList.addValue(nextLogicalNamespace, this.getNumberOfLogicalTypes(nextLogicalNamespace));
                }
            }
            for (ModuleBasedLogicalNamespaceRoot nextModuleBasedLogicalNamespaceRoot : softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(ModuleBasedLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Module module = nextModuleBasedLogicalNamespaceRoot.getPhysicalElement();
                IMetricAwareLanguageProvider languageProvider = SizeMetricsAdapter.this.getController().getLanguageProvider(module.getLanguage());
                IMetricId namespacesMetricId = languageProvider.getNamespacesMetricId();
                assert (namespacesMetricId != null) : "'namespacesMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                IMetricDescriptor metricDescriptor = SizeMetricsAdapter.this.m_moduleMetricIdToDescriptor.get(namespacesMetricId);
                assert (metricDescriptor != null) : "'nextMetricDescriptor' of method 'calculateLogicalNamespaceMetrics' must not be null";
                List<LogicalNamespace> nonPartLogicalNamespaces = nextModuleBasedLogicalNamespaceRoot.getNonPartLogicalNamespaces();
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), module, nonPartLogicalNamespaces.size(), metricDescriptor);
                IMetricId namespacesFullyAnalyzedMetricId = languageProvider.getFullyAnalyzedNamespacesMetricId();
                assert (namespacesFullyAnalyzedMetricId != null) : "'namespacesFullyAnalyzedMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                IMetricDescriptor fullyAnalyzedNamespacesMetricDescriptor = SizeMetricsAdapter.this.m_moduleMetricIdToDescriptor.get(namespacesFullyAnalyzedMetricId);
                assert (namespacesFullyAnalyzedMetricId != null) : "'namespacesFullyAnalyzedMetricId' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(languageProvider.getLanguage());
                List<LogicalNamespace> namespacesInFullAnalysis = this.removeNamespacesWithOnlyIgnoredElements(nonPartLogicalNamespaces);
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), module, namespacesInFullAnalysis.size(), fullyAnalyzedNamespacesMetricDescriptor);
                ValueList valueList = languageToTypesInNamespacePerModuleValueList.get(module);
                assert (valueList != null) : "'nextValueList' of method 'calculateLogicalNamespaceMetrics' must not be null for: " + String.valueOf(module);
                for (LogicalNamespace nextLogicalNamespace : nonPartLogicalNamespaces) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    valueList.addValue(nextLogicalNamespace, this.getNumberOfLogicalTypes(nextLogicalNamespace));
                }
                InternalTopLevelLogicalElementCounter nextModuleCounter = new InternalTopLevelLogicalElementCounter(workerContext);
                nextModuleBasedLogicalNamespaceRoot.accept(nextModuleCounter);
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), module, nextModuleCounter.getNumber(), SizeMetricsAdapter.this.m_numberOfLogicalTopLevelProgrammingElementsInModule);
            }
            if (!workerContext.hasBeenCanceled()) {
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, systemCounter.getNumber(), SizeMetricsAdapter.this.m_numberOfLogicalTopLevelProgrammingElementsInSystem);
            }
        }

        private List<LogicalNamespace> removeNamespacesWithOnlyIgnoredElements(List<LogicalNamespace> logicalNamespaces) {
            assert (logicalNamespaces != null) : "Parameter 'logicalNamespaces' of method 'removeNamespacesWithOnlyIgnoredElements' must not be null";
            ArrayList<LogicalNamespace> namespaceContainingFullyAnalyzedElements = new ArrayList<LogicalNamespace>();
            for (LogicalNamespace next : logicalNamespaces) {
                boolean anyFullyAnalyzed;
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return null;
                }
                List<LogicalProgrammingElement> children = next.getChildrenRecursively(LogicalProgrammingElement.class, LogicalProgrammingElement.class);
                if (children.isEmpty() || !(anyFullyAnalyzed = children.parallelStream().anyMatch(pe -> !pe.ignoreIssues()))) continue;
                namespaceContainingFullyAnalyzedElements.add(next);
            }
            return namespaceContainingFullyAnalyzedElements;
        }

        private void calculateDirectoryMetrics(IWorkerContext workerContext, SoftwareSystem softwareSystem, Map<Module, StrictPair<Integer, Integer>> moduleToNumberOfDirectories) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateDirectoryMetrics' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateDirectoryMetrics' must not be null";
            assert (moduleToNumberOfDirectories != null) : "Parameter 'moduleToNumberOfDirectories' of method 'calculateDirectoryMetrics' must not be null";
            THashMap languageToNumberOfDirectories = new THashMap();
            THashMap languageToNumberOfDirectoriesFullyAnalyzed = new THashMap();
            for (Map.Entry<Module, StrictPair<Integer, Integer>> entry : moduleToNumberOfDirectories.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Module module = entry.getKey();
                IMetricAwareLanguageProvider languageProvider = SizeMetricsAdapter.this.getController().getLanguageProvider(module.getLanguage());
                assert (languageProvider != null) : "'languageProvider' of method 'internalRun' must not be null";
                Integer numberOfDirectoriesInModule = (Integer)entry.getValue().getFirst();
                IMetricDescriptor moduleMetricDescriptor = SizeMetricsAdapter.this.m_moduleMetricIdToDescriptor.get(languageProvider.getDirectoriesMetricId());
                assert (moduleMetricDescriptor != null) : "'moduleMetricDescriptor' of method 'calculateDirectoryMetrics' must not be null";
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), module, numberOfDirectoriesInModule, moduleMetricDescriptor);
                IMetricDescriptor systemMetricDescriptor = SizeMetricsAdapter.this.m_systemMetricIdToDescriptor.get(languageProvider.getDirectoriesMetricId());
                assert (systemMetricDescriptor != null) : "'systemMetricDescriptor' of method 'calculateDirectoryMetrics' must not be null";
                Integer numberInSystem = (Integer)languageToNumberOfDirectories.get(systemMetricDescriptor);
                Integer newNumberInSystem = numberInSystem == null ? numberOfDirectoriesInModule : numberOfDirectoriesInModule + numberInSystem;
                languageToNumberOfDirectories.put(systemMetricDescriptor, newNumberInSystem);
                Integer numberOfDirectoriesInModuleFullyAnalyzed = (Integer)entry.getValue().getSecond();
                IMetricDescriptor moduleMetricDescriptorFullyAnalyzed = SizeMetricsAdapter.this.m_moduleMetricIdToDescriptor.get(languageProvider.getFullyAnalyzedDirectoriesMetricId());
                assert (moduleMetricDescriptorFullyAnalyzed != null) : "'moduleMetricDescriptorFullyAnalyzed' of method 'calculateDirectoryMetrics' must not be null";
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), module, numberOfDirectoriesInModuleFullyAnalyzed, moduleMetricDescriptorFullyAnalyzed);
                IMetricDescriptor systemMetricDescriptorFullyAnalyzed = SizeMetricsAdapter.this.m_systemMetricIdToDescriptor.get(languageProvider.getFullyAnalyzedDirectoriesMetricId());
                assert (systemMetricDescriptorFullyAnalyzed != null) : "'systemMetricDescriptorFullyAnalyzed' of method 'calculateDirectoryMetrics' must not be null";
                Integer numberInSystemFullyAnalyzed = (Integer)languageToNumberOfDirectoriesFullyAnalyzed.get(systemMetricDescriptorFullyAnalyzed);
                Integer newNumberInSystemFullyAnalyzed = numberInSystemFullyAnalyzed == null ? numberOfDirectoriesInModuleFullyAnalyzed : numberOfDirectoriesInModuleFullyAnalyzed + numberInSystemFullyAnalyzed;
                languageToNumberOfDirectoriesFullyAnalyzed.put(systemMetricDescriptorFullyAnalyzed, newNumberInSystemFullyAnalyzed);
            }
            for (Map.Entry<Module, Object> entry : languageToNumberOfDirectories.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, (Number)entry.getValue(), (IMetricDescriptor)((Object)entry.getKey()));
            }
            for (Map.Entry<Module, Object> entry : languageToNumberOfDirectoriesFullyAnalyzed.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, (Number)entry.getValue(), (IMetricDescriptor)((Object)entry.getKey()));
            }
        }

        @Override
        protected void internalRun() {
            Collection<? extends IMetricAwareLanguageProvider> usedLanguageProviders = SizeMetricsAdapter.this.getController().getUsedLanguageProviders();
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.setNumberOfSteps(4 + SizeMetricsAdapter.this.m_metricsToBeCumulated.size() + usedLanguageProviders.size());
            THashMap languageToTypesInNamespacePerSystemValueList = new THashMap();
            THashMap languageToTypesInNamespacePerModuleValueList = new THashMap();
            this.intializeValueLists(workerContext, softwareSystem, usedLanguageProviders, (Map<Language, ValueList>)languageToTypesInNamespacePerSystemValueList, (Map<Module, ValueList>)languageToTypesInNamespacePerModuleValueList);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.endStep();
            THashMap moduleToNumberOfDirectories = new THashMap();
            int numberOfModulesInSystem = 0;
            int numberOfComponentsInSystem = 0;
            int numberOfComponentsIgnoringIssuesInSystem = 0;
            int numberOfTypesInSystem = 0;
            int numberOfSourceFiles = 0;
            int numberOfSourceFilesTest = 0;
            int numberOfSourceFilesIssueIgnore = 0;
            THashSet fullyAnalyzedSourceFiles = new THashSet();
            THashSet issueIgnoringSourceFiles = new THashSet();
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                if (!nextModule.isAutomatic()) {
                    ++numberOfModulesInSystem;
                }
                int n = 0;
                int numberOfComponentsIgnoringIssuesInModule = 0;
                int numberOfTypesInModule = 0;
                int numberOfSourceFilesModule = 0;
                int numberOfSourceFilesTestModule = 0;
                int numberOfSourceFilesIssueIgnoreModule = 0;
                THashSet fullyAnalyzedSourceFilesModule = new THashSet();
                for (IComponent nextComponent : nextModule.getChildrenRecursively(IComponent.class, ProgrammingElement.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    List<SourceFile> sourceFiles = SizeComputationUtility.getInternalNotExcludedSourceFiles(nextComponent);
                    int numberOfSourceFilesForComponent = sourceFiles.size();
                    if (!nextComponent.isExcluded()) {
                        ++n;
                        if (nextComponent.ignoreIssues()) {
                            ++numberOfComponentsIgnoringIssuesInModule;
                            numberOfSourceFilesIssueIgnoreModule += numberOfSourceFilesForComponent;
                            issueIgnoringSourceFiles.addAll(sourceFiles);
                        } else {
                            fullyAnalyzedSourceFilesModule.addAll(sourceFiles);
                        }
                        int nextNumberOfTypesInComponent = nextComponent.getNamedElement().getChildrenRecursively(IType.class, new Class[0]).size();
                        SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextComponent.getNamedElement(), nextNumberOfTypesInComponent, SizeMetricsAdapter.this.m_numberOfTypesInComponent);
                        numberOfTypesInModule += nextNumberOfTypesInComponent;
                        numberOfSourceFilesModule += numberOfSourceFilesForComponent;
                        continue;
                    }
                    numberOfSourceFilesTestModule += numberOfSourceFilesForComponent;
                }
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextModule, n, SizeMetricsAdapter.this.m_numberOfComponentsInModule);
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextModule, numberOfComponentsIgnoringIssuesInModule, SizeMetricsAdapter.this.m_numberOfComponentsIgnoringIssuesInModule);
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextModule, n - numberOfComponentsIgnoringIssuesInModule, SizeMetricsAdapter.this.m_numberOfComponentsInModuleFullyAnalyzed);
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextModule, numberOfTypesInModule, SizeMetricsAdapter.this.m_numberOfTypesInModule);
                int fullyAnalyzedLocInModule = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)fullyAnalyzedSourceFilesModule);
                SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextModule, fullyAnalyzedLocInModule, SizeMetricsAdapter.this.m_fullyAnalyzedLocModule);
                fullyAnalyzedSourceFiles.addAll(fullyAnalyzedSourceFilesModule);
                numberOfTypesInSystem += numberOfTypesInModule;
                numberOfComponentsInSystem += n;
                numberOfComponentsIgnoringIssuesInSystem += numberOfComponentsIgnoringIssuesInModule;
                numberOfSourceFiles += numberOfSourceFilesModule;
                numberOfSourceFilesTest += numberOfSourceFilesTestModule;
                numberOfSourceFilesIssueIgnore += numberOfSourceFilesIssueIgnoreModule;
                IMetricAwareLanguageProvider nextLp = SizeMetricsAdapter.this.getController().getLanguageProvider(nextModule.getLanguage());
                assert (nextLp != null) : "'nextLp' of method 'internalRun' must not be null for: " + String.valueOf(nextModule.getLanguage());
                IMetricId nextDirectoriesMetricId = nextLp.getDirectoriesMetricId();
                if (nextDirectoriesMetricId == null) continue;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                IMetricLevel nextDirectoryMetricLevel = nextLp.getDirectoryMetricLevel();
                assert (nextDirectoryMetricLevel != null) : "'nextDirectoryMetricLevel' of method 'internalRun' must not be null for: " + String.valueOf(nextLp.getLanguage());
                IMetricDescriptor nextNumberOfComponentsMetricDescriptor = SizeMetricsAdapter.this.m_metricLevelToComponentsInDirectoryMetricDescriptor.get(nextDirectoryMetricLevel);
                assert (nextNumberOfComponentsMetricDescriptor != null) : "'nextNumberOfComponentsMetricDescriptor' of method 'internalRun' must not be null";
                IMetricDescriptor nextNumberOfTypesMetricDescriptor = SizeMetricsAdapter.this.m_metricLevelToTypesInDirectoryMetricDescriptor.get(nextDirectoryMetricLevel);
                assert (nextNumberOfTypesMetricDescriptor != null) : "'nextNumberOfTypesMetricDescriptor' of method 'internalRun' must not be null";
                SizeMetricsInternalDirectoryProcessor visitor = new SizeMetricsInternalDirectoryProcessor(nextNumberOfComponentsMetricDescriptor, nextNumberOfTypesMetricDescriptor, this.getResult());
                int numberOfDirectories = 0;
                int numberOfDirectoriesFullyAnalyzed = 0;
                for (RootDirectoryPath nextRootDirectoryPath : nextModule.getChildren(RootDirectoryPath.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    nextRootDirectoryPath.accept(visitor);
                    numberOfDirectories += visitor.getNumberOfDirectoriesWithComponents();
                    numberOfDirectoriesFullyAnalyzed += visitor.getNumberOfFullyAnalyzedDirectories();
                    visitor.reset();
                }
                moduleToNumberOfDirectories.put(nextModule, new StrictPair((Object)numberOfDirectories, (Object)numberOfDirectoriesFullyAnalyzed));
            }
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfModulesInSystem, SizeMetricsAdapter.this.m_numberOfModulesInSystem);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfComponentsInSystem, SizeMetricsAdapter.this.m_numberOfComponentsInSystem);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfComponentsIgnoringIssuesInSystem, SizeMetricsAdapter.this.m_numberOfComponentsIgnoringIssuesInSystem);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfComponentsInSystem - numberOfComponentsIgnoringIssuesInSystem, SizeMetricsAdapter.this.m_numberOfComponentsInSystemFullyAnalyzed);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfTypesInSystem, SizeMetricsAdapter.this.m_numberOfTypesInSystem);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfSourceFiles, SizeMetricsAdapter.this.m_numberOfSourceFiles);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, fullyAnalyzedSourceFiles.size(), SizeMetricsAdapter.this.m_numberOfSourceFilesFullAnalysis);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfSourceFilesTest, SizeMetricsAdapter.this.m_numberOfSourceFilesTest);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, numberOfSourceFilesIssueIgnore, SizeMetricsAdapter.this.m_numberOfSourceFilesIssueIgnored);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, this.getNumberOfExcludedSourceFiles(), SizeMetricsAdapter.this.m_numberOfSourceFilesExcluded);
            this.verifyDisjunctSets((Set<SourceFile>)fullyAnalyzedSourceFiles, (Set<SourceFile>)issueIgnoringSourceFiles);
            int fullyAnalyzedLoc = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)fullyAnalyzedSourceFiles);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, fullyAnalyzedLoc, SizeMetricsAdapter.this.m_fullyAnalyzedLoc);
            int issueIgnoringLoc = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)issueIgnoringSourceFiles);
            SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, issueIgnoringLoc, SizeMetricsAdapter.this.m_issueIgnoringLoc);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.endStep();
            this.calculateDirectoryMetrics(workerContext, softwareSystem, (Map<Module, StrictPair<Integer, Integer>>)moduleToNumberOfDirectories);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.endStep();
            this.calculateLogicalNamespaceMetrics(workerContext, softwareSystem, (Map<Language, ValueList>)languageToTypesInNamespacePerSystemValueList, (Map<Module, ValueList>)languageToTypesInNamespacePerModuleValueList);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.endStep();
            for (IMetric iMetric : SizeMetricsAdapter.this.m_metricsToBeCumulated) {
                Number nextMetricValue;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                workerContext.beginSubTask("Cumulating " + iMetric.getPresentationName());
                IValueList nextValueList = iMetric.collectValues(workerContext, softwareSystem);
                NamedElement nextValueListElement = nextValueList.getElement();
                IMetricValue nextValueListElementMetricValue = nextValueListElement.getUniqueChild(IMetricValue.class);
                if (nextValueListElementMetricValue != null && (nextMetricValue = nextValueListElementMetricValue.getValue()) != null) {
                    SizeMetricsAdapter.this.storeMetricValue(this.getResult(), nextValueListElementMetricValue.getAssociatedElement(), nextValueListElementMetricValue.getValue(), nextValueListElementMetricValue.getMetricDescriptor());
                }
                workerContext.endSubTask();
            }
            for (IMetricAwareLanguageProvider iMetricAwareLanguageProvider : usedLanguageProviders) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Map<IMetricId, Number> nextMetrics = iMetricAwareLanguageProvider.calculateAdditionalSizeMetrics(softwareSystem);
                for (Map.Entry<IMetricId, Number> nextEntry : nextMetrics.entrySet()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    IMetricDescriptor nextMetricDescriptor = SizeMetricsAdapter.this.m_systemMetricIdToDescriptor.get(nextEntry.getKey());
                    assert (nextMetricDescriptor != null) : "'nextMetricDescriptor' of method 'internalRun' must not be null";
                    SizeMetricsAdapter.this.storeMetricValue(this.getResult(), softwareSystem, nextEntry.getValue(), nextMetricDescriptor);
                }
                workerContext.endStep();
            }
        }

        private void verifyDisjunctSets(Set<SourceFile> fullyAnalyzedSourceFiles, Set<SourceFile> issueIgnoringSourceFiles) {
            if (!LOGGER.isDebugEnabled()) {
                return;
            }
            if (!Collections.disjoint(fullyAnalyzedSourceFiles, issueIgnoringSourceFiles)) {
                THashSet join = new THashSet(fullyAnalyzedSourceFiles);
                join.retainAll(issueIgnoringSourceFiles);
                for (SourceFile next : join) {
                    LOGGER.error("Source that is both fully-analyzed and issue ignoring: " + String.valueOf(next));
                }
            }
        }

        private Number getNumberOfExcludedSourceFiles() {
            Workspace workspace = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
            WorkspaceFilter excludeFilter = workspace.getUniqueChild(WorkspaceFilter.class);
            if (excludeFilter != null) {
                return excludeFilter.getNumberOfExcludedFiles();
            }
            return 0;
        }
    }
}

