/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalNamespaceDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.NamespaceCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.LogicalNamespaceCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ModuleNamespaceCyclesAnalyzerAdapter
extends NamespaceCyclesAnalyzerAdapter {
    private final Language m_language;

    public ModuleNamespaceCyclesAnalyzerAdapter(IAnalyzerController controller, IConfigurableAnalyzerId analyzerId, Language language) {
        super(controller, analyzerId);
        assert (language != null) : "Parameter 'language' of method 'ModuleNamespaceCyclesAnalyzerAdapter' must not be null";
        this.m_language = language;
    }

    protected abstract IMetricDescriptor getNumberOfIncomingDependenciesMetric();

    protected abstract IMetricDescriptor getNumberOfOutgoingDependenciesMetric();

    protected abstract IMetricDescriptor getInstabilityMetric();

    protected abstract IMetricDescriptor getAbstractnessMetric();

    protected abstract IMetricDescriptor getDistanceMetric();

    @Override
    protected void runJobs(AnalyzerResult result) {
        NamespaceCyclesInModulesJob job = new NamespaceCyclesInModulesJob(this.getGroup(), result, this.getController(), this.getSoftwareSystem().getUniqueExistingChild(Workspace.class), new LogicalNamespaceDependencyEndpointCollector());
        job.start();
    }

    protected class NamespaceCyclesInModulesJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJobOnModules {
        protected final Map<Module, ModuleBasedLogicalNamespaceRoot> m_moduleToLogicalRoot;
        private final LogicalNamespaceDependencyEndpointCollector m_collector;
        private final ValueList m_abstractness;
        private final ValueList m_distance;

        protected NamespaceCyclesInModulesJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Workspace workspace, LogicalNamespaceDependencyEndpointCollector collector) {
            super(ModuleNamespaceCyclesAnalyzerAdapter.this, group, result, controller, workspace);
            this.m_moduleToLogicalRoot = new THashMap();
            this.m_collector = collector;
            this.setInstabilityMetric(ModuleNamespaceCyclesAnalyzerAdapter.this.getInstabilityMetric());
            this.setNumberOfIncomingDependenciesMetric(ModuleNamespaceCyclesAnalyzerAdapter.this.getNumberOfIncomingDependenciesMetric());
            this.setNumberOfOutgoingDependenciesMetric(ModuleNamespaceCyclesAnalyzerAdapter.this.getNumberOfOutgoingDependenciesMetric());
            this.m_abstractness = ModuleNamespaceCyclesAnalyzerAdapter.this.createValueList(result, ModuleNamespaceCyclesAnalyzerAdapter.this.getAbstractnessMetric(), null);
            this.m_distance = ModuleNamespaceCyclesAnalyzerAdapter.this.createValueList(result, ModuleNamespaceCyclesAnalyzerAdapter.this.getDistanceMetric(), null);
            for (ModuleBasedLogicalNamespaceRoot nextLogicalRoot : this.getSoftwareSystem().getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(ModuleBasedLogicalNamespaceRoot.class)) {
                this.m_moduleToLogicalRoot.put(nextLogicalRoot.getPhysicalElement(), nextLogicalRoot);
            }
        }

        @Override
        protected Language getLanguage() {
            return ModuleNamespaceCyclesAnalyzerAdapter.this.m_language;
        }

        protected LogicalNamespaceDependencyEndpointCollector getCollector() {
            return this.m_collector;
        }

        @Override
        protected Collection<? extends NamedElement> getNamedElements() {
            this.m_collector.reset();
            NamedElement scope = this.getScope();
            assert (scope != null && scope instanceof Module) : "Unexpected class in method 'getNamedElements': " + String.valueOf(scope);
            ModuleBasedLogicalNamespaceRoot logicalRoot = this.m_moduleToLogicalRoot.get(scope);
            if (logicalRoot != null) {
                List<LogicalNamespace> logicalNamespaces = logicalRoot.getNonPartLogicalNamespaces();
                this.m_collector.addLogicalNamespaces(logicalNamespaces);
                return logicalNamespaces;
            }
            return Collections.emptyList();
        }

        @Override
        protected List<IType> getTypes(NamedElement namedElement) {
            assert (namedElement != null && namedElement instanceof LogicalNamespace) : "Unexpected class in method 'getTypes': " + String.valueOf(namedElement);
            return NamespaceCyclesAnalyzerAdapter.getTypes((LogicalNamespace)namedElement);
        }

        @Override
        protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Collection<? extends NamedElement> elements) {
            assert (elements != null) : "Parameter 'elements' of method 'createNodeAdapterSet' must not be null";
            return new ParserDependencyNodeAdapterSet(this.getWorkerContext(), elements, this.m_collector, PE, PD);
        }

        @Override
        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new LogicalNamespaceCycleGroup(null, this.getScope(), ModuleNamespaceCyclesAnalyzerAdapter.this.m_language, isCritical);
        }

        @Override
        protected boolean discardIfContainedInOneModule() {
            return false;
        }

        @Override
        protected void setDistance(NamedElement e, float value) {
            this.m_distance.addValue(e, Float.valueOf(value));
        }

        @Override
        protected void setAbstractness(NamedElement e, float value) {
            this.m_abstractness.addValue(e, Float.valueOf(value));
        }
    }
}

