/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ComponentCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ComponentCyclesInModulesAnalyzerAdapter
extends CyclesAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COMPONENT_CYCLES_MODULE;
    private final IMetricDescriptor m_numberOfIncomingDependencies;
    private final IMetricDescriptor m_numberOfOutgoingDependencies;
    private final IMetricDescriptor m_instability;
    private final IMetricDescriptor m_componentRank;

    public ComponentCyclesInModulesAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfIncomingDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_INCOMING_DEPENDENCIES_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_numberOfOutgoingDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_instability = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_INSTABILITY_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_componentRank = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_COMPONENT_RANK_MODULE, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    protected IIssueId getIssueId() {
        return ComponentCycleGroup.ISSUE_ID;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        ComponentCyclesInModulesJob job = new ComponentCyclesInModulesJob(this.getGroup(), result, this.getController(), this.getSoftwareSystem().getUniqueExistingChild(Workspace.class));
        job.start();
    }

    private class ComponentCyclesInModulesJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJobOnModules {
        private ComponentCyclesInModulesJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Workspace workspace) {
            super(ComponentCyclesInModulesAnalyzerAdapter.this, group, result, controller, workspace);
            this.setInstabilityMetric(ComponentCyclesInModulesAnalyzerAdapter.this.m_instability);
            this.setNumberOfIncomingDependenciesMetric(ComponentCyclesInModulesAnalyzerAdapter.this.m_numberOfIncomingDependencies);
            this.setNumberOfOutgoingDependenciesMetric(ComponentCyclesInModulesAnalyzerAdapter.this.m_numberOfOutgoingDependencies);
            this.setRankMetric(ComponentCyclesInModulesAnalyzerAdapter.this.m_componentRank);
        }

        @Override
        protected Language getLanguage() {
            return null;
        }

        protected Collection<NamedElement> getNamedElements() {
            ArrayList<NamedElement> internalCompilationUnits = new ArrayList<NamedElement>();
            IWorkerContext workerContext = this.getWorkerContext();
            for (IComponent nextComponent : this.getScope().getChildrenRecursively(IComponent.class, ProgrammingElement.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                if (nextComponent.isExcluded()) continue;
                internalCompilationUnits.add(nextComponent.getNamedElement());
            }
            return internalCompilationUnits;
        }

        @Override
        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new ComponentCycleGroup(null, this.getScope(), isCritical);
        }

        @Override
        protected boolean discardIfContainedInOneModule() {
            return false;
        }

        @Override
        protected List<IType> getTypes(NamedElement namedElement) {
            assert (namedElement != null && namedElement instanceof IComponent) : "Unexpected class in method 'getTypes': " + String.valueOf(namedElement);
            return namedElement.getChildrenRecursively(IType.class, new Class[0]);
        }
    }
}

