/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetComputer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BreakupMetricsAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BreakupMetricsAnalyzer.class);
    private static final int COMPONENT_DEPENDENCY_MULTIPLIER = 10;

    private BreakupMetricsAnalyzer() {
    }

    private static int getNumberOfComponentDependencies(Collection<Dependency> dependencies, Set<ComponentDependency> componentDependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getNumberOfComponentDependencies' must not be null";
        assert (componentDependencies != null) : "Parameter 'componentDependencies' of method 'getNumberOfComponentDependencies' must not be null";
        assert (componentDependencies.isEmpty()) : "Parameter 'componentDependencies' of method 'getNumberOfComponentDependencies' must be empty";
        for (Dependency nextDependency : dependencies) {
            IComponent to;
            assert (nextDependency instanceof ParserDependency) : "Unexpected class in method 'getNumberOfComponentDependencies': " + String.valueOf(nextDependency);
            ParserDependency parserDep = (ParserDependency)nextDependency;
            IComponent from = parserDep.getFrom().getParent(IComponent.class, new Class[0]);
            if (from == null || (to = parserDep.getTo().getParent(IComponent.class, new Class[0])) == null) continue;
            ComponentDependency cdep = new ComponentDependency(from, to);
            componentDependencies.add(cdep);
        }
        return componentDependencies.size();
    }

    /*
     * WARNING - void declaration
     */
    static void analyze(AnalyzerCycleGroup group, Set<? extends NodeAdapter> nodes, IWorkerContext workerContext) {
        void var7_11;
        assert (group != null) : "Parameter 'group' of method 'BreakupMetricsAnalyzerNew' must not be null";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'BreakupMetricsAnalyzerNew' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'BreakupMetricsAnalyzerNew' must not be null";
        Set<NamedElement> cyclicNamedElements = group.getCyclicNamedElements();
        int numberOfParserDependencies = 0;
        THashSet componentDependencies = new THashSet();
        THashMap componentDependenciesPerEdge = new THashMap();
        for (NodeAdapter nodeAdapter : nodes) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            assert (cyclicNamedElements.contains(nodeAdapter.getUnderlyingObject())) : "node not found in cyclic elements";
            for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : nodeAdapter.getOutgoingEdges()) {
                if (!cyclicNamedElements.contains(edgeAdapter.getTo().getUnderlyingObject())) continue;
                numberOfParserDependencies += edgeAdapter.getNumberOfParserDependencies();
                if (edgeAdapter.getFrom().getUnderlyingObject() instanceof IComponent) {
                    componentDependenciesPerEdge.put(edgeAdapter, 1);
                    continue;
                }
                componentDependenciesPerEdge.put(edgeAdapter, BreakupMetricsAnalyzer.getNumberOfComponentDependencies(edgeAdapter.getDependencies(), (Set<ComponentDependency>)componentDependencies));
                componentDependencies.clear();
            }
        }
        boolean bl = false;
        int componentDependencyCount = 0;
        Set<INode.IEdge> set = FeedbackArcSetComputer.compute(workerContext, nodes);
        for (INode.IEdge nextEdge : set) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            var7_11 += nextEdge.getWeight();
            componentDependencyCount += ((Integer)componentDependenciesPerEdge.get(nextEdge)).intValue();
        }
        group.setDependenciesInfo(numberOfParserDependencies, (int)var7_11, componentDependencyCount, (int)(var7_11 + 10 * componentDependencyCount));
    }

    static void calculate(Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodeAdapters, IWorkerContext workerContext) {
        assert (cycleGroupToNodeAdapters != null && !cycleGroupToNodeAdapters.isEmpty()) : "Parameter 'cycleGroupToNodeAdapters' of method 'calculate' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculate' must not be null";
        if (cycleGroupToNodeAdapters.size() == 1) {
            for (Map.Entry<AnalyzerCycleGroup, Set<? extends NodeAdapter>> nextEntry : cycleGroupToNodeAdapters.entrySet()) {
                BreakupMetricsAnalyzer.analyze(nextEntry.getKey(), nextEntry.getValue(), workerContext);
            }
        } else {
            TreeMap<AnalyzerCycleGroup, Set<? extends NodeAdapter>> sorted = new TreeMap<AnalyzerCycleGroup, Set<? extends NodeAdapter>>(new Comparator<AnalyzerCycleGroup>(){

                @Override
                public int compare(AnalyzerCycleGroup o1, AnalyzerCycleGroup o2) {
                    if (!$assertionsDisabled && o1 == null) {
                        throw new AssertionError((Object)"Parameter 'o1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && o2 == null) {
                        throw new AssertionError((Object)"Parameter 'o2' of method 'compare' must not be null");
                    }
                    int compare = o2.getNumberOfCyclicElements() - o1.getNumberOfCyclicElements();
                    if (compare == 0) {
                        compare = o2.getFullyQualifiedName().compareTo(o1.getFullyQualifiedName());
                    }
                    return compare;
                }
            });
            sorted.putAll(cycleGroupToNodeAdapters);
            THashMap worker1 = new THashMap();
            THashMap worker2 = new THashMap();
            THashMap currentWorker = worker1;
            int nodesWorker1 = 0;
            int nodesWorker2 = 0;
            for (Map.Entry nextEntry : sorted.entrySet()) {
                int nextNumberOfCyclicElements = nextEntry.getKey().getNumberOfCyclicElements();
                if (nodesWorker1 + nextNumberOfCyclicElements > nodesWorker2 + nextNumberOfCyclicElements) {
                    worker2.put(nextEntry.getKey(), (Set)nextEntry.getValue());
                    nodesWorker2 += nextNumberOfCyclicElements;
                    currentWorker = worker1;
                    continue;
                }
                if (nodesWorker1 + nextNumberOfCyclicElements < nodesWorker2 + nextNumberOfCyclicElements) {
                    worker1.put(nextEntry.getKey(), (Set)nextEntry.getValue());
                    nodesWorker1 += nextNumberOfCyclicElements;
                    currentWorker = worker2;
                    continue;
                }
                currentWorker.put(nextEntry.getKey(), (Set)nextEntry.getValue());
                if (currentWorker == worker1) {
                    nodesWorker1 += nextNumberOfCyclicElements;
                    currentWorker = worker2;
                    continue;
                }
                nodesWorker2 += nextNumberOfCyclicElements;
                currentWorker = worker1;
            }
            assert (cycleGroupToNodeAdapters.size() == worker1.size() + worker2.size()) : "Sizes do not match";
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(new Worker((Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)worker1, workerContext));
            executorService.execute(new Worker((Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)worker2, workerContext));
            executorService.shutdown();
            try {
                executorService.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
            }
        }
    }

    static final class ComponentDependency {
        private final IComponent m_from;
        private final IComponent m_to;

        private ComponentDependency(IComponent from, IComponent to) {
            assert (from != null) : "Parameter 'from' of method 'ComponentDependency' must not be null";
            assert (to != null) : "Parameter 'to' of method 'ComponentDependency' must not be null";
            this.m_from = from;
            this.m_to = to;
        }

        public int hashCode() {
            return Objects.hash(this.m_from, this.m_to);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentDependency other = (ComponentDependency)obj;
            return Objects.equals(this.m_from, other.m_from) && Objects.equals(this.m_to, other.m_to);
        }
    }

    static final class Worker
    implements Runnable {
        private final Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> m_cycleGroupToNodeAdapters;
        private final IWorkerContext m_workerContext;

        Worker(Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodeAdapters, IWorkerContext workerContext) {
            assert (cycleGroupToNodeAdapters != null && !cycleGroupToNodeAdapters.isEmpty()) : "Parameter 'cycleGroupToNodeAdapters' of method 'Worker' must not be empty";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'Worker' must not be null";
            this.m_cycleGroupToNodeAdapters = cycleGroupToNodeAdapters;
            this.m_workerContext = workerContext;
        }

        @Override
        public void run() {
            for (Map.Entry<AnalyzerCycleGroup, Set<? extends NodeAdapter>> nextEntry : this.m_cycleGroupToNodeAdapters.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                BreakupMetricsAnalyzer.analyze(nextEntry.getKey(), nextEntry.getValue(), this.m_workerContext);
            }
        }
    }
}

