/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.complexity;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public final class AverageComplexityAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.AVERAGE_COMPLEXITY_METRICS;
    private final Map<Language, IMetricDescriptor> m_languageToAverageComplexityOnNamespaces = new THashMap();
    private final Map<Language, IMetricAwareLanguageProvider.IWeightedAverageCalculator> m_languageToWeightedAverageCalculator = new THashMap();
    private final Map<Language, IMetricDescriptor> m_languageToAverageComplexityOnNamespacesModule = new THashMap();
    private final Map<Language, IMetricAwareLanguageProvider.IWeightedAverageCalculator> m_languageToWeightedAverageCalculatorModule = new THashMap();
    private final IMetricDescriptor m_averageComplexityOnTypes;
    private final IMetricDescriptor m_averageComplexityOnFiles;
    private final IMetricDescriptor m_averageComplexityOnModules;
    private final IMetricDescriptor m_averageComplexityOnSystem;
    private final IMetricDescriptor m_averageNestingOnTypes;
    private final IMetricDescriptor m_averageNestingOnFiles;
    private final IMetricDescriptor m_averageNestingOnModules;
    private final IMetricDescriptor m_averageNestingOnSystem;

    public AverageComplexityAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_averageComplexityOnTypes = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricLevel.TYPE);
        this.m_averageComplexityOnFiles = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricLevel.SOURCE_FILE);
        this.m_averageComplexityOnModules = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricLevel.MODULE);
        this.m_averageComplexityOnSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricLevel.SYSTEM);
        this.m_averageNestingOnTypes = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricLevel.TYPE);
        this.m_averageNestingOnFiles = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricLevel.SOURCE_FILE);
        this.m_averageNestingOnModules = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricLevel.MODULE);
        this.m_averageNestingOnSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricLevel.SYSTEM);
    }

    @Override
    public void languageAdded(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        Language language = languageProvider.getLanguage();
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        Predicate<NamedElement> systemPredicate = new Predicate<NamedElement>(){

            @Override
            public boolean test(NamedElement element) {
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'test' must not be null");
                }
                return element instanceof LogicalSystemNamespace;
            }
        };
        if (languageProvider.getNamespaceMetricLevel() != null) {
            IMetricDescriptor averageComplexityOnNamespaces = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY_SYSTEM, languageProvider.getNamespaceMetricLevel(), systemPredicate, language);
            this.m_languageToAverageComplexityOnNamespaces.put(language, averageComplexityOnNamespaces);
            this.m_languageToWeightedAverageCalculator.put(language, languageProvider.createWeightedAverageCalculator());
            Predicate<NamedElement> modulePredicate = new Predicate<NamedElement>(){

                @Override
                public boolean test(NamedElement element) {
                    if (!$assertionsDisabled && element == null) {
                        throw new AssertionError((Object)"Parameter 'element' of method 'test' must not be null");
                    }
                    return element instanceof LogicalModuleNamespace;
                }
            };
            IMetricDescriptor averageComplexityOnNamespacesModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_AVERAGE_COMPLEXITY_MODULE, languageProvider.getNamespaceMetricLevel(), modulePredicate, language);
            this.m_languageToAverageComplexityOnNamespacesModule.put(language, averageComplexityOnNamespacesModule);
            this.m_languageToWeightedAverageCalculatorModule.put(language, languageProvider.createWeightedAverageCalculator());
        }
    }

    @Override
    public void languageRemoved(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
        Language language = languageProvider.getLanguage();
        IMetricDescriptor averageComplexityOnNamespaces = this.m_languageToAverageComplexityOnNamespaces.get(language);
        assert (averageComplexityOnNamespaces != null) : "'averageComplexityOnNamespaces' of method 'languageRemoved' must not be null";
        this.remove(Collections.singleton(averageComplexityOnNamespaces));
        this.m_languageToWeightedAverageCalculator.remove(language);
        IMetricDescriptor averageComplexityOnNamespacesModule = this.m_languageToAverageComplexityOnNamespacesModule.get(language);
        assert (averageComplexityOnNamespacesModule != null) : "'averageComplexityOnNamespacesModule' of method 'languageRemoved' must not be null";
        this.remove(Collections.singleton(averageComplexityOnNamespacesModule));
        this.m_languageToWeightedAverageCalculatorModule.remove(language);
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        CalculateAverageComplexityJob job = new CalculateAverageComplexityJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class CalculateAverageComplexityJob
    extends AnalyzerJob
    implements IMetricAwareLanguageProvider.IWeightedAverageCalculationConsumer {
        protected Map<NamedElement, Number> m_sizeMap;
        protected Map<NamedElement, Number> m_valueMap;
        protected IMetricDescriptor m_onTypeDescriptor;
        protected boolean m_calculatingIndentation;

        protected CalculateAverageComplexityJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_sizeMap = new THashMap();
            this.m_valueMap = new THashMap();
            this.m_calculatingIndentation = false;
        }

        private void calculateWeightedAverages(IMetricDescriptor typeDescriptor, IMetricDescriptor sourceDescriptor, IMetricDescriptor moduleDescriptor, IMetricDescriptor systemDescriptor, Function<IRoutine, Integer> metricFunction) {
            IWorkerContext workerContext = this.getWorkerContext();
            double totalSize = 0.0;
            double totalComplexity = 0.0;
            this.m_onTypeDescriptor = typeDescriptor;
            for (Module module : this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Language nextLanguage = module.getLanguage();
                IMetricAwareLanguageProvider.IWeightedAverageCalculator nextCalculator = AverageComplexityAnalyzerAdapter.this.m_languageToWeightedAverageCalculator.get(nextLanguage);
                assert (nextCalculator != null) : "'nextCalculator' of method 'calculateWeightedAverages' must not be null";
                nextCalculator.calculateWeightedAverageOnTypes(workerContext, module, typeDescriptor, metricFunction, this);
                for (IComponent component : module.getChildrenRecursively(IComponent.class, IComponent.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (component.isExcluded()) continue;
                    for (SourceFile src : SizeComputationUtility.getInternalNotExcludedSourceFiles(component)) {
                        nextCalculator.calculateWeightedAverage(workerContext, src, sourceDescriptor, metricFunction, this);
                    }
                }
                StrictPair<Number, Number> tuple = nextCalculator.calculateWeightedAverage(workerContext, module, moduleDescriptor, metricFunction, this);
                if (tuple == null || ((Number)tuple.getFirst()).intValue() <= 0) continue;
                totalSize += ((Number)tuple.getFirst()).doubleValue();
                totalComplexity += ((Number)tuple.getSecond()).doubleValue();
            }
            if (totalSize != 0.0 && totalSize > 0.0) {
                double complexity = totalComplexity / totalSize;
                AverageComplexityAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), complexity, systemDescriptor);
            }
        }

        private void calculate(IWorkerContext workerContext, LogicalNamespace namespace, IMetricDescriptor metricDescriptor, AnalyzerResult result) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculate' must not be null";
            assert (namespace != null) : "Parameter 'namespace' of method 'calculate' must not be null";
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'calculate' must not be null";
            assert (result != null) : "Parameter 'result' of method 'calculate' must not be null";
            double totalValue = 0.0;
            double totalSize = 0.0;
            for (ProgrammingElement nextProgrammingElement : namespace.getTopLevelProgrammingElements()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Number size = this.m_sizeMap.get(nextProgrammingElement);
                if (size != null && size.intValue() > 0) {
                    totalSize += size.doubleValue();
                    totalValue += size.doubleValue() * this.m_valueMap.get(nextProgrammingElement).doubleValue();
                    continue;
                }
                if (!(nextProgrammingElement instanceof IRoutine) || nextProgrammingElement.getRefactoringState() == RefactoringState.DELETED) continue;
                IRoutine routine = (IRoutine)((Object)nextProgrammingElement);
                int statements = routine.getNumberOfStatements();
                int mecc = CalculateAverageComplexityJob.getAverageComplexityInput(routine);
                if (mecc < 0 || statements <= 0) continue;
                totalSize += (double)statements;
                totalValue += (double)(statements * mecc);
            }
            if (totalSize > 0.0) {
                double complexity = totalValue / totalSize;
                AverageComplexityAnalyzerAdapter.this.storeMetricValue(result, namespace, complexity < 1.0 ? 1.0 : complexity, metricDescriptor);
            }
        }

        private static int getAverageComplexityInput(IRoutine r) {
            int mecc = r.getModifiedExtendedCyclomaticComplexity();
            if (mecc < 0) {
                mecc = r.getCyclomaticComplexity();
            }
            return mecc;
        }

        @Override
        protected final void internalRun() {
            Language nextLanguage;
            IWorkerContext workerContext = this.getWorkerContext();
            this.calculateWeightedAverages(AverageComplexityAnalyzerAdapter.this.m_averageComplexityOnTypes, AverageComplexityAnalyzerAdapter.this.m_averageComplexityOnFiles, AverageComplexityAnalyzerAdapter.this.m_averageComplexityOnModules, AverageComplexityAnalyzerAdapter.this.m_averageComplexityOnSystem, r -> CalculateAverageComplexityJob.getAverageComplexityInput(r));
            this.m_calculatingIndentation = true;
            this.calculateWeightedAverages(AverageComplexityAnalyzerAdapter.this.m_averageNestingOnTypes, AverageComplexityAnalyzerAdapter.this.m_averageNestingOnFiles, AverageComplexityAnalyzerAdapter.this.m_averageNestingOnModules, AverageComplexityAnalyzerAdapter.this.m_averageNestingOnSystem, r -> r.getMaxNesting());
            for (InternalLogicalNamespaceRoot nextInternalNamespaceRoot : this.getSoftwareSystem().getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(InternalLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextLanguage = nextInternalNamespaceRoot.getLanguage();
                IMetricDescriptor nextAverageComplexityOnNamespaces = AverageComplexityAnalyzerAdapter.this.m_languageToAverageComplexityOnNamespaces.get(nextLanguage);
                assert (nextAverageComplexityOnNamespaces != null) : "Parameter 'nextAverageComplexityOnNamespaces' of method 'internalRun' must not be null";
                for (LogicalSystemNamespace nextLogicalSystemNamepace : nextInternalNamespaceRoot.getChildrenRecursively(LogicalSystemNamespace.class, new Class[0])) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.calculate(workerContext, nextLogicalSystemNamepace, nextAverageComplexityOnNamespaces, this.getResult());
                }
            }
            for (ModuleBasedLogicalNamespaceRoot nextModuleBasedLogicalNamespaceRoot : this.getSoftwareSystem().getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(ModuleBasedLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextLanguage = nextModuleBasedLogicalNamespaceRoot.getLanguage();
                IMetricDescriptor nextAverageComplexityOnNamespacesModule = AverageComplexityAnalyzerAdapter.this.m_languageToAverageComplexityOnNamespacesModule.get(nextLanguage);
                assert (nextAverageComplexityOnNamespacesModule != null) : "Parameter 'nextAverageComplexityOnNamespacesModule' of method 'internalRun' must not be null";
                for (LogicalModuleNamespace nextLogicalModuleNamepace : nextModuleBasedLogicalNamespaceRoot.getChildrenRecursively(LogicalModuleNamespace.class, new Class[0])) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.calculate(workerContext, nextLogicalModuleNamepace, nextAverageComplexityOnNamespacesModule, this.getResult());
                }
            }
        }

        @Override
        public IMetricDescriptor getMetricOnTypesDescriptor() {
            return this.m_onTypeDescriptor;
        }

        @Override
        public void addToSizeMap(NamedElement element, Number value) {
            assert (element != null) : "Parameter 'element' of method 'addToSizeMap' must not be null";
            assert (value != null) : "Parameter 'value' of method 'addToSizeMap' must not be null";
            this.m_sizeMap.put(element, value);
        }

        @Override
        public void addToValueMap(NamedElement element, Number value) {
            if (!this.m_calculatingIndentation) {
                assert (element != null) : "Parameter 'element' of method 'addToComplexityeMap' must not be null";
                assert (value != null) : "Parameter 'value' of method 'addToComplexityeMap' must not be null";
                this.m_valueMap.put(element, value);
            }
        }

        @Override
        public void consume(NamedElement element, Number value, IMetricDescriptor metricDescriptor) {
            assert (element != null) : "Parameter 'element' of method 'consume' must not be null";
            assert (value != null) : "Parameter 'value' of method 'consume' must not be null";
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'consume' must not be null";
            AverageComplexityAnalyzerAdapter.this.storeMetricValue(this.getResult(), element, value, metricDescriptor);
        }
    }
}

