/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ResolutionPatternMigration;
import com.hello2morrow.sonargraph.core.controller.system.ThresholdExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.ResolutionMatcher;
import com.hello2morrow.sonargraph.core.controller.system.migration.VirtualModelMigration;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IVirtualModelExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.VirtualModels;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginProvider;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringProcessor;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.IPersistableVirtualModel;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.VirtualModelPersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualModelExtension
extends VirtualModelProvider
implements IVirtualModelExtension,
IModifiableFileProvider,
IModifiableFileDeltaKey,
ISoftwareSystemLifecycleListener,
ResolutionPatternMigration.IModifiableModelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualModelExtension.class);
    private final IFinishModelProcessor m_finishModelProcessor;
    private final INamedElementResolver m_namedElementResolver;
    private final IRefactoringProcessor m_refactoringProcessor;
    private final IPluginProvider m_pluginResourceProvider;
    private final boolean m_createDefaultModifiableModel;

    VirtualModelExtension(Installation installation, SoftwareSystem softwareSystem, IRefactoringProcessor refactoringProcessor, IFinishModelProcessor finishModelProcessor, INamedElementResolver namedElementResolver, IPluginProvider pluginResourceProvider) {
        super(installation, softwareSystem);
        assert (refactoringProcessor != null) : "Parameter 'refactoringProcessor' of method 'VirtualModelExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'VirtualModelExtension' must not be null";
        assert (namedElementResolver != null) : "Parameter 'namedElementResolver' of method 'VirtualModelExtension' must not be null";
        assert (pluginResourceProvider != null) : "Parameter 'pluginResourceProvider' of method 'VirtualModelExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_refactoringProcessor = refactoringProcessor;
        this.m_namedElementResolver = namedElementResolver;
        this.m_pluginResourceProvider = pluginResourceProvider;
        this.m_createDefaultModifiableModel = this.m_finishModelProcessor.getLicenseProvider().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS);
        finishModelProcessor.addListener(this);
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        VirtualModels models = files.getVirtualModels();
        VirtualModelMigration migration = new VirtualModelMigration(this.getSoftwareSystem().getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT);
        migration.migrate(this.getInstallation().getVersion().toString(), models.getDirectoryFile(), result);
        if (this.m_createDefaultModifiableModel) {
            this.createDefaultModifiableModel();
        }
    }

    @Override
    public INamedElementResolver getResolver() {
        return this.m_namedElementResolver;
    }

    @Override
    public Root getRootForResolver() {
        return this.getSoftwareSystem();
    }

    @Override
    public Version getVersion() {
        return this.getInstallation().getVersion();
    }

    @Override
    public VirtualModelPersistence getPersistence() {
        return new VirtualModelPersistence(this.getInstallation().getVersion(), this.getSoftwareSystem().getClassLoader(), this.m_pluginResourceProvider);
    }

    private ModifiableModel createDefaultModifiableModel() {
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        VirtualModels models = files.getVirtualModels();
        ParserModel factsModel = files.getParserModel();
        ModifiableModel defaultModifiableModel = new ModifiableModel(factsModel, new TFile((File)models.getFile(), SoftwareSystem.DEFAULT_MODIFIABLE_MODEL), new ResolutionMatcher(this.getSoftwareSystem(), this.m_namedElementResolver, this.m_refactoringProcessor), files, this.m_refactoringProcessor);
        factsModel.addChild(defaultModifiableModel);
        return defaultModifiableModel;
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, final PrepareRefreshResult prepareRefreshResult) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareRefresh' must not be null";
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return VirtualModelExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!($assertionsDisabled || modifiableFile != null && modifiableFile instanceof ModifiableModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'exists': " + String.valueOf(modifiableFile)));
                }
                return !onSystemOpen ? modifiableFile.existsOnDisk() : false;
            }

            @Override
            public boolean recursive() {
                return false;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return VirtualModelExtension.this.getSoftwareSystem().getUniqueExistingChild(Files.class).getVirtualModels();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.MODEL);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return VirtualModel.class.getSimpleName();
            }
        });
        if (!onSystemOpen) {
            deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return VirtualModelExtension.this;
                }

                @Override
                public void visitAdded(ModifiableFileCandidate added) {
                    if (!$assertionsDisabled && added == null) {
                        throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                    }
                    TFile virtualModelFile = added.getFile();
                    String identifyingPath = "./" + virtualModelFile.getName();
                    ModifiableModel currentModel = VirtualModelExtension.this.getSoftwareSystem().getCurrentModel(ModifiableModel.class);
                    if (currentModel != null && currentModel.getIdentifyingPath().equals(identifyingPath)) {
                        prepareRefreshResult.setActiveVirtualModelModification(currentModel, PrepareRefreshResult.AdditionalFileModification.ADDED);
                    }
                }

                @Override
                public void visitModified(IModifiableFile modified) {
                    if (!($assertionsDisabled || modified != null && modified instanceof ModifiableModel)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    ModifiableModel modifiableModel = (ModifiableModel)modified;
                    if (VirtualModelExtension.this.getSoftwareSystem().getCurrentModel(ModifiableModel.class) == modifiableModel) {
                        prepareRefreshResult.setActiveVirtualModelModification(modifiableModel, PrepareRefreshResult.AdditionalFileModification.MODIFIED);
                    }
                }

                @Override
                public void visitDeleted(IModifiableFile deleted) {
                    if (!($assertionsDisabled || deleted != null && deleted instanceof ModifiableModel)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    ModifiableModel modifiableModel = (ModifiableModel)deleted;
                    ModifiableModel currentModel = VirtualModelExtension.this.getSoftwareSystem().getCurrentModel(ModifiableModel.class);
                    if (currentModel == modifiableModel) {
                        prepareRefreshResult.setActiveVirtualModelModification(currentModel, PrepareRefreshResult.AdditionalFileModification.DELETED);
                        if (currentModel.getName().equals(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL)) {
                            prepareRefreshResult.addInfo("Active virtual model has been deleted. '" + SoftwareSystem.DEFAULT_MODIFIABLE_MODEL + "' will be reset to the default content.");
                        } else {
                            prepareRefreshResult.addInfo("Active virtual model has been deleted. Switching to '" + SoftwareSystem.DEFAULT_MODIFIABLE_MODEL + "'");
                            Files files = VirtualModelExtension.this.getSoftwareSystem().getUniqueExistingChild(Files.class);
                            VirtualModels models = files.getVirtualModels();
                            ModifiableModel defaultVirtualModel = models.getFirstChildRecursively(new NameFilter(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL), ModifiableModel.class, new Class[0]);
                            if (!$assertionsDisabled && defaultVirtualModel == null) {
                                throw new AssertionError((Object)"Parameter 'defaultVirtualModel' of method 'switchFromFactsModelToDefaultModel' must not be null");
                            }
                            prepareRefreshResult.switchToModel(defaultVirtualModel);
                        }
                    }
                }
            }, false);
        }
    }

    private void processParentChildStructure(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processParentChildStructure' must not be null";
        HashMap<String, VirtualModel> nameToVirtualModel = new HashMap<String, VirtualModel>();
        HashMap<VirtualModel, String> virtualModelToBasedOn = new HashMap<VirtualModel, String>();
        VirtualModels virtualModels = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getVirtualModels();
        for (VirtualModel virtualModel : virtualModels.getChildrenRecursively(VirtualModel.class, Resolution.class)) {
            nameToVirtualModel.put(virtualModel.getName(), virtualModel);
            String nextBasedOn = virtualModel.getBasedOnVirtualModel();
            if (nextBasedOn == null) continue;
            virtualModelToBasedOn.put(virtualModel, nextBasedOn);
        }
        for (Map.Entry entry : virtualModelToBasedOn.entrySet()) {
            VirtualModel nextVirtualModel = (VirtualModel)entry.getKey();
            String nextBasedOn = (String)entry.getValue();
            VirtualModel nextBasedOnVirtualModel = (VirtualModel)nameToVirtualModel.get(nextBasedOn);
            if (nextBasedOnVirtualModel == null) continue;
            nextVirtualModel.changeParent(nextBasedOnVirtualModel, true);
        }
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter ' result' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return VirtualModelExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof ModifiableModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                ModifiableModel modifiedModifiableModel = (ModifiableModel)modified;
                ModifiableModel currentModifiableModel = VirtualModelExtension.this.getSoftwareSystem().getCurrentModel(ModifiableModel.class);
                if (currentModifiableModel == modifiedModifiableModel) {
                    modifiedModifiableModel.resetResolutions();
                }
                modifiedModifiableModel.removeChildren(new Class[0]);
                OperationResult resultLoad = VirtualModelExtension.this.getPersistence().load(modified.getFile(), modifiedModifiableModel);
                result.addMessagesFrom(resultLoad);
                if (!resultLoad.isFailure()) {
                    modifiedModifiableModel.reloaded(modified.getFile().lastModified());
                }
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof ModifiableModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                ModifiableModel modifiableModel = (ModifiableModel)deleted;
                if (modifiableModel == VirtualModelExtension.this.getSoftwareSystem().getCurrentModel(ModifiableModel.class)) {
                    modifiableModel.resetResolutions();
                    VirtualModelExtension.this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
                    VirtualModelExtension.this.switchToModel(VirtualModelExtension.this.getSoftwareSystem().getParserModel(), result);
                }
                if (modifiableModel.getName().equals(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL)) {
                    modifiableModel.removeChildren(Resolution.class);
                    modifiableModel.setExistsOnDisk(false);
                } else {
                    modifiableModel.remove();
                }
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile virtualModelFile = added.getFile();
                String modelName = virtualModelFile.getName();
                SoftwareSystem softwareSystem = VirtualModelExtension.this.getSoftwareSystem();
                Files files = softwareSystem.getUniqueExistingChild(Files.class);
                VirtualModels virtualModels = files.getVirtualModels();
                ParserModel parserModel = files.getParserModel();
                ModifiableModel model = parserModel.getFirstChild(new NameFilter("./" + modelName), ModifiableModel.class);
                if (model == null) {
                    model = new ModifiableModel(parserModel, new TFile((File)virtualModels.getFile(), modelName), new ResolutionMatcher(softwareSystem, VirtualModelExtension.this.m_namedElementResolver, VirtualModelExtension.this.m_refactoringProcessor), files, VirtualModelExtension.this.m_refactoringProcessor);
                    parserModel.addChild(model);
                } else {
                    model.resetTimestamp();
                }
                model.setExistsOnDisk(true);
                OperationResult resultLoad = VirtualModelExtension.this.getPersistence().load(virtualModelFile, model);
                result.addMessagesFrom(resultLoad);
            }
        }, true);
        this.processParentChildStructure(workerContext);
    }

    void switchFromFactsModelToDefaultModel() {
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        ParserModel factsModel = files.getParserModel();
        assert (factsModel == this.getSoftwareSystem().getCurrentModel()) : "Current model not the facts model: " + String.valueOf(this.getSoftwareSystem().getCurrentModel());
        ModifiableModel defaultVirtualModel = factsModel.getFirstChild(new NameFilter(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL), ModifiableModel.class);
        assert (defaultVirtualModel != null) : "Parameter 'defaultVirtualModel' of method 'switchFromFactsModelToDefaultModel' must not be null";
        this.getSoftwareSystem().setModel(defaultVirtualModel);
        factsModel.setActiveProductionModel(defaultVirtualModel);
        defaultVirtualModel.setNeedsApplication();
    }

    @Override
    public void parserModelModified(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean onSystemOpen, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'parserModelModified' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'parserModelModified' must not be null";
        assert (result != null) : "Parameter 'result' of method 'parserModelModified' must not be null";
        assert (softwareSystem == this.getSoftwareSystem()) : "Different instances";
        ModifiableModel currentModel = softwareSystem.getCurrentModel(ModifiableModel.class);
        if (currentModel != null) {
            ResolutionPatternMigration.migrateIfNecessary(this, currentModel, result);
        }
    }

    @Override
    public void switchToModel(VirtualModel virtualModelToBeSet, OperationResult result) {
        assert (virtualModelToBeSet != null) : "Parameter 'virtualModelToBeSet' of method 'switchToModel' must not be null";
        VirtualModel currentModel = this.getSoftwareSystem().getCurrentModel();
        assert (currentModel != virtualModelToBeSet) : "Model already set: " + String.valueOf(virtualModelToBeSet);
        assert (virtualModelToBeSet.getParent(SoftwareSystem.class, new Class[0]) == this.getSoftwareSystem()) : "Different software system: " + String.valueOf(virtualModelToBeSet);
        this.getSoftwareSystem().getExtension(ThresholdExtension.class).startModelSwitch(this.getSoftwareSystem().getCurrentModel(VirtualModel.class), virtualModelToBeSet);
        if (currentModel instanceof ModifiableModel) {
            ((ModifiableModel)currentModel).resetResolutions();
        }
        ParserModel factsModel = this.getSoftwareSystem().getParserModel();
        factsModel.setActiveProductionModel(null);
        this.getSoftwareSystem().setModel(virtualModelToBeSet);
        if (virtualModelToBeSet instanceof ModifiableModel) {
            factsModel.setActiveProductionModel(virtualModelToBeSet);
            if (!ResolutionPatternMigration.migrateIfNecessary(this, (ModifiableModel)virtualModelToBeSet, result)) {
                ((ModifiableModel)virtualModelToBeSet).setNeedsApplication();
            }
        }
    }

    @Override
    public OperationResult setVirtualModel(IWorkerContext workerContext, VirtualModel virtualModelToBeSet) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setModel' must not be null";
        assert (virtualModelToBeSet != null) : "Parameter 'virtualModelToBeSet' of method 'setModel' must not be null";
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        OperationResult result = new OperationResult("Set Virtual Model");
        this.switchToModel(virtualModelToBeSet, result);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.VIRTUAL_MODEL_CHANGED), result);
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        return result;
    }

    private static boolean replaceStartOfResolutionPatterns(Resolution resolution, String oldStart, String newStart) {
        assert (resolution != null) : "Parameter 'resolution' of method 'replaceStartOfResolutionPatterns' must not be null";
        assert (oldStart != null && oldStart.length() > 0) : "Parameter 'oldName' of method 'replaceStartOfResolutionPatterns' must not be empty";
        assert (newStart != null && newStart.length() > 0) : "Parameter 'newName' of method 'replaceStartOfResolutionPatterns' must not be empty";
        boolean modified = false;
        for (NamedElementIssuePattern nextNamedElementPattern : resolution.getChildren(NamedElementIssuePattern.class)) {
            String nextPattern = nextNamedElementPattern.getPattern();
            if (!nextPattern.startsWith(oldStart)) continue;
            String nextNewPattern = newStart + nextPattern.substring(oldStart.length());
            nextNamedElementPattern.setPattern(nextNewPattern);
            modified = true;
        }
        for (DependencyIssuePattern nextDependencyPattern : resolution.getChildren(DependencyIssuePattern.class)) {
            String nextToPattern;
            String nextFromPattern = nextDependencyPattern.getFromPattern();
            if (nextFromPattern.startsWith(oldStart)) {
                String nextNewFromPattern = newStart + nextFromPattern.substring(oldStart.length());
                nextDependencyPattern.setFromPattern(nextNewFromPattern);
                modified = true;
            }
            if (!(nextToPattern = nextDependencyPattern.getToPattern()).startsWith(oldStart)) continue;
            String nextNewToPattern = newStart + nextToPattern.substring(oldStart.length());
            nextDependencyPattern.setToPattern(nextNewToPattern);
            modified = true;
        }
        return modified;
    }

    private static boolean replaceTargetDirectoriesOfResolutions(Resolution resolution, String oldModuleFqName, String newModuleFqName) {
        MoveRefactoringDefinition move;
        String oldTargetRootFqName;
        assert (resolution != null) : "Parameter 'resolution' of method 'replaceTargetDirectoriesOfResolutions' must not be null";
        assert (oldModuleFqName != null) : "Parameter 'oldModuleFqName' of method 'replaceTargetDirectoriesOfResolutions' must not be null";
        assert (newModuleFqName != null) : "Parameter 'newModuleFqName' of method 'replaceTargetDirectoriesOfResolutions' must not be null";
        if (resolution instanceof MoveRefactoringDefinition && (oldTargetRootFqName = (move = (MoveRefactoringDefinition)resolution).getTargetRootDirectoryFqName()).startsWith(oldModuleFqName)) {
            String newTargetRootFqName = newModuleFqName + oldTargetRootFqName.substring(oldModuleFqName.length());
            move.setTargetRootDirectoryFqName(newTargetRootFqName);
            return true;
        }
        return false;
    }

    private static NamedElementIssuePattern getSingleNamedElementIssuePattern(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getSingleNamedElementIssuePattern' must not be null";
        List<NamedElementIssuePattern> patterns = resolution.getChildren(NamedElementIssuePattern.class);
        if (patterns.size() == 1) {
            return patterns.get(0);
        }
        return null;
    }

    private static boolean updateHashBasedResolutionPattern(CoreIssueId hashBasedCoreIssueId, Resolution resolution, String find, String replacement) {
        ArrayList<Pair<String, IntBasedHash>> elementFqNamesAndHashs;
        Matching matching;
        String patternAsString;
        int pos;
        NamedElementIssuePattern issuePattern = VirtualModelExtension.getSingleNamedElementIssuePattern(resolution);
        if (issuePattern != null && (pos = (patternAsString = issuePattern.getPattern()).lastIndexOf(58)) != -1 && (matching = resolution.getUniqueChild(Matching.class)) != null && !(elementFqNamesAndHashs = new ArrayList<Pair<String, IntBasedHash>>(matching.getElementFqNamesAndHashs())).isEmpty()) {
            boolean modified = false;
            boolean hasHashes = false;
            ArrayList<Pair> translated = new ArrayList<Pair>(elementFqNamesAndHashs.size());
            for (Pair pair2 : elementFqNamesAndHashs) {
                String fqName = (String)pair2.getFirst();
                if (fqName.startsWith(find)) {
                    String nextTranslated = replacement + fqName.substring(find.length());
                    translated.add(new Pair((Object)nextTranslated, (Object)((IntBasedHash)pair2.getSecond())));
                    hasHashes = pair2.getSecond() != null;
                    modified = true;
                    continue;
                }
                translated.add(pair2);
            }
            if (modified) {
                if (hasHashes) {
                    matching.setElementFqNamesAndHashes(translated.stream().map(p -> new StrictPair((Object)((String)p.getFirst()), (Object)((IntBasedHash)p.getSecond()))).collect(Collectors.toList()));
                } else {
                    matching.setElementFqNames(translated.stream().map(p -> (String)p.getFirst()).collect(Collectors.toList()));
                }
                List<String> list = translated.stream().map(pair -> (String)pair.getFirst()).collect(Collectors.toList());
                String hashPart = patternAsString.substring(pos + 1);
                String newHashPart = switch (hashBasedCoreIssueId) {
                    case CoreIssueId.COMPONENT_CYCLE_GROUP -> AnalyzerCycleGroup.translateHashPart(hashPart, list);
                    case CoreIssueId.DUPLICATE_CODE_BLOCK -> DuplicateCodeBlock.translateHashPart(hashPart, list);
                    default -> {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("Unhandled hash-based resolution for: " + String.valueOf(hashBasedCoreIssueId)));
                        }
                        yield "";
                    }
                };
                if (newHashPart != null && !newHashPart.isEmpty()) {
                    String translatedPattern = patternAsString.substring(0, pos + 1) + newHashPart;
                    issuePattern.setPattern(translatedPattern);
                    return true;
                }
            }
        }
        return false;
    }

    void mapResolutionPatterns(Map<String, String> fqNameStartBasedMappings, EnumSet<Modification> modifications, boolean relativeRootDirectoriesChanged, boolean markModifiableModelsAsNeedsSave, OperationResult saveResult) {
        assert (fqNameStartBasedMappings != null && !fqNameStartBasedMappings.isEmpty()) : "Parameter 'fqNameStartBasedMappings' of method 'mapResolutionPatterns' must not be empty";
        List<ModifiableModel> modifiableModels = this.getAvailableModifiableModels();
        if (!modifiableModels.isEmpty()) {
            HashSet<ModifiableModel> modifiedModifiableModels = new HashSet<ModifiableModel>();
            for (Map.Entry<String, String> nextEntry : fqNameStartBasedMappings.entrySet()) {
                String nextToFind = nextEntry.getKey();
                assert (nextToFind != null && nextToFind.length() > 0) : "'nextToFind' of method 'mapResolutionPatterns' must not be empty";
                String nextReplacement = nextEntry.getValue();
                assert (nextReplacement != null && nextReplacement.length() > 0) : "Parameter 'nextReplacement' of method 'mapResolutionPatterns' must not be empty";
                if (nextToFind.equals(nextReplacement)) continue;
                for (ModifiableModel nextModifiableModel : modifiableModels) {
                    List<Resolution> resolutions = nextModifiableModel.getChildren(Resolution.class);
                    if (resolutions.isEmpty()) continue;
                    boolean modified = false;
                    for (Resolution nextResolution : resolutions) {
                        if (relativeRootDirectoriesChanged) {
                            String issueKey = ModifiableModel.getIssueKey(nextResolution);
                            if (CoreIssueId.COMPONENT_CYCLE_GROUP.getStandardName().equals(issueKey)) {
                                modified = VirtualModelExtension.updateHashBasedResolutionPattern(CoreIssueId.COMPONENT_CYCLE_GROUP, nextResolution, nextToFind, nextReplacement) || modified;
                            } else if (CoreIssueId.DUPLICATE_CODE_BLOCK.getStandardName().equals(issueKey)) {
                                modified = VirtualModelExtension.updateHashBasedResolutionPattern(CoreIssueId.DUPLICATE_CODE_BLOCK, nextResolution, nextToFind, nextReplacement) || modified;
                            }
                        }
                        modified = VirtualModelExtension.replaceStartOfResolutionPatterns(nextResolution, nextToFind, nextReplacement) || modified;
                        boolean bl = modified = VirtualModelExtension.replaceTargetDirectoriesOfResolutions(nextResolution, nextToFind, nextReplacement) || modified;
                    }
                    if (!modified) continue;
                    modifiedModifiableModels.add(nextModifiableModel);
                }
            }
            if (!modifiedModifiableModels.isEmpty()) {
                if (modifications != null) {
                    modifications.add(Modification.VIRTUAL_MODEL_MODIFIED);
                }
                if (markModifiableModelsAsNeedsSave || saveResult != null) {
                    for (ModifiableModel nextModifiableModel : modifiedModifiableModels) {
                        nextModifiableModel.setNeedsSave(true);
                    }
                }
                if (saveResult != null) {
                    for (ModifiableModel nextModifiableModel : modifiedModifiableModels) {
                        saveResult.addMessagesFrom(this.getSoftwareSystem().getExtension(VirtualModelExtension.class).saveModifiableModel(nextModifiableModel));
                    }
                }
            }
        }
    }

    @Override
    public OperationResultWithOutcome<ModifiableModel> createModifiableModel(IWorkerContext workerContext, String name, String description, VirtualModel basedOn, boolean set) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createModifiableModel' must not be null";
        assert (this.getModifiableModelNameValidator().isValid(null, name).isSuccess()) : "Not a valid model name: " + name;
        assert (description != null) : "Parameter 'description' of method 'createModifiableModel' must not be null";
        assert (basedOn != null) : "Parameter 'basedOn' of method 'createModifiableModel' must not be null";
        if (set) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create " + (set ? "and set " : "") + "modifiable model '" + name + "'");
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        VirtualModels virtualModels = files.getVirtualModels();
        ModifiableModel newModel = new ModifiableModel(basedOn, new TFile((File)virtualModels.getFile(), name + CoreFileType.MODEL.getDefaultExtension()), new ResolutionMatcher(this.getSoftwareSystem(), this.m_namedElementResolver, this.m_refactoringProcessor), files, this.m_refactoringProcessor);
        newModel.setDescription(description);
        basedOn.addChild(newModel);
        VirtualModelPersistence persistence = this.getPersistence();
        result.addMessagesFrom(persistence.save(newModel));
        if (result.isSuccess()) {
            newModel.setNeedsSave(false);
            newModel.setExistsOnDisk(true);
            newModel.resetTimestamp();
        } else {
            newModel.setNeedsSave(true);
            newModel.setExistsOnDisk(false);
        }
        result.setOutcome((Object)newModel);
        if (set) {
            this.switchToModel(newModel, (OperationResult)result);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.AVAILABLE_VIRTUAL_MODELS_MODIFIED, Modification.VIRTUAL_MODEL_CHANGED), (OperationResult)result);
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.AVAILABLE_VIRTUAL_MODELS_MODIFIED), (OperationResult)result);
        }
        return result;
    }

    @Override
    public OperationResult saveModifiableModel(ModifiableModel modifiableModel) {
        assert (modifiableModel != null) : "Parameter 'modifiableModel' of method 'saveModifiableModel' must not be null";
        assert (modifiableModel.needsSave()) : "Does not need saving: " + modifiableModel.getName();
        OperationResult result = this.getPersistence().save(modifiableModel);
        if (result.isSuccess()) {
            modifiableModel.setNeedsSave(false);
            modifiableModel.setExistsOnDisk(true);
            modifiableModel.resetTimestamp();
        }
        return result;
    }

    @Override
    public OperationResult deleteModifiableModel(IWorkerContext workerContext, ModifiableModel modelToBeDeleted) {
        boolean switchToDefaultModel;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteModifiableModel' must not be null";
        assert (modelToBeDeleted != null) : "Parameter 'virtualModel' of method 'deleteVModifiableModel' must not be null";
        assert (this.isDeletable(modelToBeDeleted)) : "Not deletable: " + String.valueOf(modelToBeDeleted);
        OperationResult result = new OperationResult("Delete modifiable model '" + modelToBeDeleted.getName() + "'");
        VirtualModel currentModel = this.getSoftwareSystem().getCurrentModel();
        List<ModifiableModel> childModels = modelToBeDeleted.getChildrenRecursively(ModifiableModel.class, new Class[0]);
        boolean bl = switchToDefaultModel = currentModel == modelToBeDeleted || childModels.contains(currentModel);
        if (switchToDefaultModel) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        if (modelToBeDeleted.existsOnDisk()) {
            if (!modelToBeDeleted.getFile().exists()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Modifiable model file no longer exists. Refresh of software system needed.", new Object[0]);
                return result;
            }
            if (modelToBeDeleted.getTimestamp() != modelToBeDeleted.getFile().lastModified()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Modifiable model file has been changed on disk. Refresh of software system needed.", new Object[0]);
                return result;
            }
        }
        for (ModifiableModel nextChildModel : childModels) {
            if (!nextChildModel.existsOnDisk()) continue;
            if (!nextChildModel.getFile().exists()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Modifiable (child) model file no longer exists. Refresh of software system needed.", new Object[0]);
                return result;
            }
            if (nextChildModel.getTimestamp() == nextChildModel.getFile().lastModified()) continue;
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Modifiable (child) model file has been changed on disk. Refresh of software system needed.", new Object[0]);
            return result;
        }
        if (modelToBeDeleted.existsOnDisk()) {
            try {
                modelToBeDeleted.getFile().rm();
            }
            catch (IOException ex) {
                String msg = "Failed to delete modifiable model file '" + modelToBeDeleted.getAbsolutePath() + "'";
                LOGGER.error(msg, (Throwable)ex);
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
                return result;
            }
        }
        for (ModifiableModel nextChildModel : childModels) {
            try {
                nextChildModel.getFile().rm();
            }
            catch (IOException ex) {
                String msg = "Failed to delete modifiable (child) model file '" + nextChildModel.getAbsolutePath() + "'";
                LOGGER.warn(msg, (Throwable)ex);
                result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
            }
        }
        ModifiableModel defaultModel = null;
        defaultModel = modelToBeDeleted.getName().equals(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL) ? this.createDefaultModifiableModel() : this.findModifiableModelByIdentifyingPath(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL);
        EnumSet<Modification> modifications = EnumSet.of(Modification.AVAILABLE_VIRTUAL_MODELS_MODIFIED);
        if (switchToDefaultModel) {
            this.switchToModel(defaultModel, result);
            modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
        }
        modelToBeDeleted.remove();
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        if (switchToDefaultModel) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public void save(IPersistableVirtualModel virtualModel, OutputStream outputStream, OperationResult result) {
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        this.getPersistence().save(virtualModel, outputStream, result);
    }

    @Override
    public void load(IPersistableVirtualModel virtualModel, InputStream inputStream, OperationResult result) {
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'load' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'load' must not be null";
        assert (result != null) : "Parameter 'result' of method 'load' must not be null";
        result.addMessagesFrom(this.getPersistence().load(inputStream, virtualModel));
    }
}

