/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.DirectoryFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.NamespaceFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

final class ToBeMovedRenamedElementsCollector {
    private final Map<Language, Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>> m_languageToRefactorables;
    private final Map<Language, Predicate<IRefactorable>> m_languageToPredicate;
    private final List<NamedElement> m_namedElements;
    private IDomainRoot.Domain m_basedOnDomain;
    private Language m_language;
    private Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> m_refactorables;
    private Predicate<IRefactorable> m_inclusionPredicate;
    private Class<? extends IRefactorable> m_usedRefactorableClass;
    private MoveRenameRefactoringElementType m_refactoringElementType;

    ToBeMovedRenamedElementsCollector(Map<Language, Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>> languageToRefactorables, Map<Language, Predicate<IRefactorable>> languageToPredicate, int size) {
        assert (languageToRefactorables != null) : "Parameter 'languageToRefactorables' of method 'ToBeMovedRenamedElementsCollector' must not be null";
        assert (languageToPredicate != null) : "Parameter 'languageToPredicate' of method 'ToBeMovedRenamedElementsCollector' must not be null";
        assert (size > 0) : "'size' must be greater than 0";
        this.m_languageToRefactorables = languageToRefactorables;
        this.m_languageToPredicate = languageToPredicate;
        this.m_namedElements = new ArrayList<NamedElement>(size);
    }

    IDomainRoot.Domain getBasedOnDomain() {
        assert (this.m_basedOnDomain != null) : "'m_basedOnDomain' of method 'getBasedOnDomain' must not be null";
        return this.m_basedOnDomain;
    }

    Language getLanguage() {
        assert (this.m_language != null) : "'m_language' of method 'getLanguage' must not be null";
        return this.m_language;
    }

    MoveRenameRefactoringElementType getRefactoringElementType() {
        assert (this.m_refactoringElementType != null) : "'m_refactoringElementType' of method 'getRefactoringElementType' must not be null";
        return this.m_refactoringElementType;
    }

    List<NamedElement> getNamedElements() {
        return this.m_namedElements;
    }

    private String include(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'include' must not be null";
        assert (this.m_refactorables != null) : "'m_refactorables' of method 'include' must not be null";
        assert (this.m_inclusionPredicate != null) : "'m_inclusionPredicate' of method 'include' must not be null";
        if (this.m_usedRefactorableClass == null) {
            for (Class<? extends IRefactorable> nextClass : this.m_refactorables.keySet()) {
                if (!nextClass.isAssignableFrom(element.getClass())) continue;
                if (!this.m_inclusionPredicate.test((IRefactorable)((Object)element))) {
                    return "Excluded by refactorable predicate: '" + element.getClass().getSimpleName() + "'";
                }
                this.m_usedRefactorableClass = nextClass;
                this.m_namedElements.add(element);
                return null;
            }
            return "Element has no refactorable class entry: '" + element.getClass().getSimpleName() + "'";
        }
        if (!this.m_usedRefactorableClass.isAssignableFrom(element.getClass())) {
            return "Mixed element selection: '" + this.m_usedRefactorableClass.getClass().getSimpleName() + "'/'" + element.getClass().getSimpleName() + "'";
        }
        if (!this.m_inclusionPredicate.test((IRefactorable)((Object)element))) {
            return "Excluded by refactorable predicate: '" + element.getClass().getSimpleName() + "'";
        }
        this.m_namedElements.add(element);
        return null;
    }

    private void setRefactoringElementType(MoveRenameRefactoringElementType refactoringElementType) {
        assert (refactoringElementType != null) : "Parameter 'refactoringElementType' of method 'setRefactoringElementType' must not be null";
        if (this.m_refactoringElementType != null) {
            assert (this.m_refactoringElementType == refactoringElementType) : "Different refactoring element types: " + String.valueOf((Object)this.m_refactoringElementType) + " != " + String.valueOf((Object)refactoringElementType);
        } else {
            this.m_refactoringElementType = refactoringElementType;
        }
    }

    private String checkLanguageAndDomain(NamedElement element) {
        IDomainRoot.Domain nextDomain;
        assert (element != null) : "Parameter 'element' of method 'checkLanguageAndDomain' must not be null";
        Language nextLanguage = element.getLanguage();
        if (nextLanguage == null) {
            return "Named element has no language '" + element.getClass().getSimpleName() + "'";
        }
        if (this.m_language == null) {
            this.m_language = nextLanguage;
            this.m_refactorables = this.m_languageToRefactorables.get(this.m_language);
            if (this.m_refactorables == null) {
                return "Language '" + String.valueOf(this.m_language) + "' does not support any move/rename refactorings";
            }
            this.m_inclusionPredicate = this.m_languageToPredicate.get(nextLanguage);
            assert (this.m_inclusionPredicate != null) : "'m_inclusionPredicate' of method 'checkLanguageAndDomain' must not be null";
        } else if (this.m_language != nextLanguage) {
            return "Different languages selected";
        }
        if ((nextDomain = element.getDomain()) == null) {
            return "Named element has no domain '" + element.getClass().getSimpleName() + "'";
        }
        if (this.m_basedOnDomain == null) {
            this.m_basedOnDomain = nextDomain;
        } else if (this.m_basedOnDomain != nextDomain) {
            return "Different domains selected";
        }
        return null;
    }

    String addElement(Element element) {
        NamedElement namedElement;
        assert (element != null) : "Parameter 'element' of method 'addElement' must not be null";
        if (element instanceof INamedElementNode) {
            namedElement = ((INamedElementNode)((Object)element)).getNamedElement();
        } else {
            if (!(element instanceof NamedElement)) {
                return "Not a named element: '" + element.getClass().getSimpleName() + "'";
            }
            namedElement = (NamedElement)element;
        }
        if (namedElement.isExternal()) {
            return "Named element is external";
        }
        if (namedElement.getRefactoringState().hasBeenDeleted()) {
            return "Named element already deleted";
        }
        String checkLanguageAndDomain = this.checkLanguageAndDomain(namedElement);
        if (checkLanguageAndDomain != null) {
            return checkLanguageAndDomain;
        }
        assert (this.m_basedOnDomain != null) : "'m_basedOnDomain' of method 'addElement' must not be null";
        assert (this.m_refactorables != null) : "'m_refactorables' of method 'addElement' must not be null";
        switch (this.m_basedOnDomain) {
            case LOGICAL_SYSTEM_SCOPE: 
            case LOGICAL_MODULE_SCOPE: 
            case ARCHITECTURE_LOGICAL: {
                return "Only physical domains supported";
            }
            case ARCHITECTURE_PHYSICAL: {
                if (namedElement instanceof DirectoryFragmentComponentContainer) {
                    String include = this.include((NamedElement)((DirectoryFragmentComponentContainer)namedElement).getRepresentedElement());
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.DIRECTORY);
                    break;
                }
                if (namedElement instanceof NamespaceFragmentComponentContainer) {
                    String include = this.include((NamedElement)((NamespaceFragmentComponentContainer)namedElement).getRepresentedElement());
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.NAMESPACE);
                    break;
                }
                if (namedElement instanceof AssignedElement) {
                    String include = this.include(((AssignedElement)namedElement).getRepresentedElement());
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.COMPONENT);
                    break;
                }
                return "Class not refactorable '" + namedElement.getClass().getSimpleName() + "'";
            }
            case PHYSICAL: {
                if (namedElement instanceof DirectoryFragment) {
                    String include = this.include(namedElement);
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.DIRECTORY);
                    break;
                }
                if (namedElement instanceof NamespaceFragment) {
                    String include = this.include(namedElement);
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.NAMESPACE);
                    break;
                }
                if (namedElement instanceof IComponent) {
                    String include = this.include(namedElement);
                    if (include != null) {
                        return include;
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.COMPONENT);
                    break;
                }
                if (namedElement instanceof ProgrammingElement) {
                    String include = this.include(namedElement);
                    if (include != null) {
                        return include;
                    }
                    if (namedElement.getParent() instanceof ProgrammingElement) {
                        return "Not a top-level programming element '" + namedElement.getPresentationName(false) + "'";
                    }
                    this.setRefactoringElementType(MoveRenameRefactoringElementType.ELEMENT);
                    break;
                }
                return "Class not refactorable '" + namedElement.getClass().getSimpleName() + "'";
            }
            default: {
                assert (false) : "Unhandled domain: " + String.valueOf((Object)this.m_basedOnDomain);
                return "Unhandled domain '" + String.valueOf((Object)this.m_basedOnDomain) + "'";
            }
        }
        return null;
    }
}

