/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.enterprise.SonargraphEnterpriseExtension;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerConfigurationUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewOperationExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureDiagramExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureFileUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.AuthorsExtension;
import com.hello2morrow.sonargraph.core.controller.system.BalancedDependencyRepresentationExtension;
import com.hello2morrow.sonargraph.core.controller.system.DashboardExtension;
import com.hello2morrow.sonargraph.core.controller.system.DependenciesExtension;
import com.hello2morrow.sonargraph.core.controller.system.DynamicSystemExtension;
import com.hello2morrow.sonargraph.core.controller.system.ElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.ExportExtension;
import com.hello2morrow.sonargraph.core.controller.system.FinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.GraphExtension;
import com.hello2morrow.sonargraph.core.controller.system.GraphRepresentationExtension;
import com.hello2morrow.sonargraph.core.controller.system.GroovyExtension;
import com.hello2morrow.sonargraph.core.controller.system.GroovyScriptRunConfigurationUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.GroovyScriptUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.HierarchicalIssueExtension;
import com.hello2morrow.sonargraph.core.controller.system.IAnalyzerConfigurationInfoProvider;
import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.IssueExtension;
import com.hello2morrow.sonargraph.core.controller.system.IssueRankingExtension;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.MetricsExtension;
import com.hello2morrow.sonargraph.core.controller.system.ModelDestructionVisitor;
import com.hello2morrow.sonargraph.core.controller.system.NotificationExtension;
import com.hello2morrow.sonargraph.core.controller.system.PersistenceAccessor;
import com.hello2morrow.sonargraph.core.controller.system.PluginConfigurationExtension;
import com.hello2morrow.sonargraph.core.controller.system.PluginConfigurationUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.PropertiesExtension;
import com.hello2morrow.sonargraph.core.controller.system.QualityGateExtension;
import com.hello2morrow.sonargraph.core.controller.system.QualityGateUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelImportExportExtension;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelImportExtension;
import com.hello2morrow.sonargraph.core.controller.system.RefactoringProcessor;
import com.hello2morrow.sonargraph.core.controller.system.RefreshProcessor;
import com.hello2morrow.sonargraph.core.controller.system.RelevantSoftwareSystemSourceFileIterator;
import com.hello2morrow.sonargraph.core.controller.system.RemoteSelectionExtension;
import com.hello2morrow.sonargraph.core.controller.system.ReportExtension;
import com.hello2morrow.sonargraph.core.controller.system.ScmExtension;
import com.hello2morrow.sonargraph.core.controller.system.SearchExtension;
import com.hello2morrow.sonargraph.core.controller.system.SnapshotExtension;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemDataTransferExtension;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemNameValidator;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemSettingsUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.SystemDiffExtension;
import com.hello2morrow.sonargraph.core.controller.system.ThresholdExtension;
import com.hello2morrow.sonargraph.core.controller.system.TreeMapExtension;
import com.hello2morrow.sonargraph.core.controller.system.UndoRedoExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceProfileUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ModifiableFileBasedUndoRedoProvider;
import com.hello2morrow.sonargraph.core.controller.system.context.DefaultContext;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ITransactionProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerExecutionLevelChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.InstallationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.programming.IssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemFromSnapshotCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.core.model.system.SystemDirectoryLocationInfo;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystemPropertiesReader;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XmlSystemPersistenceProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.PersistentLocations;
import com.hello2morrow.sonargraph.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SoftwareSystemController
extends Extension
implements ISoftwareSystemController,
ISoftwareSystemCreator,
ISoftwareSystemFromSnapshotCreator,
IAnalyzerConfigurationInfoProvider {
    private final EnumSet<OptionalExtensionId> m_disabledExtensions;
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final PersistenceAccessor m_persistenceAccessor;
    private final FinishModelProcessor m_finishModelProcessor;
    private final Installation m_installation;
    private final ElementResolver m_resolver;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode m_backgroundTaskExecutionMode;
    private final ILicenseProvider m_licenseProvider;
    private IContext m_defaultContext;
    private AnalyzerExecutionLevel m_analyzerExecutionLevel;
    private PersistentRecentlyUsedList m_recentlyUsedList;
    private PersistentLocations m_globalLocations;
    private PersistentLocations m_softwareSystemLocations;
    private SoftwareSystem m_softwareSystem;
    private RefreshProcessor m_refreshProcessor;

    static {
        TrueZipFacade.initialize();
    }

    public SoftwareSystemController(ILicenseProvider licenseProvider, Set<LanguageProvider> languageProviders, ScriptOutputStreamProvider scriptOutputStreamProvider, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode, AnalyzerExecutionLevel level, EnumSet<OptionalExtensionId> disabledExtensions) {
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'SoftwareSystemController' must not be null";
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'SoftwareSystemController' must not be null";
        assert (scriptOutputStreamProvider != null) : "Parameter 'scriptOutputStreamProvider' of method 'SoftwareSystemController' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'SoftwareSystemController' must not be null";
        assert (level != null) : "Parameter 'level' of method 'SoftwareSystemController' must not be null";
        assert (disabledExtensions != null) : "Parameter 'disabledExtensions' of method 'SoftwareSystemController' must not be null";
        this.m_licenseProvider = licenseProvider;
        this.m_languageProviderAccessor = new LanguageProviderAccessor(languageProviders);
        this.m_backgroundTaskExecutionMode = backgroundTaskExecutionMode;
        this.m_analyzerExecutionLevel = level;
        this.m_disabledExtensions = EnumSet.copyOf(disabledExtensions);
        this.m_installation = new Installation(licenseProvider.getProductVersion());
        this.m_installation.addProviderIds(Collections.singleton(CoreProviderId.INSTANCE));
        THashSet issueIds = new THashSet(Arrays.asList(CoreIssueId.values()));
        issueIds.add(ArchitectureViolationIssueId.INSTANCE);
        issueIds.add(ArchitectureDeprecationIssueId.INSTANCE);
        this.m_installation.addIssueIds((Set<? extends IIssueId>)issueIds);
        this.m_installation.addAvailableIssueTypes((Set<IIssueAffectedElementType>)new THashSet(Arrays.asList(IssueAffectedElementType.values())));
        this.m_installation.addExtension(this);
        this.m_installation.addExtension(new MetricsExtension(this.m_languageProviderAccessor, this.m_installation));
        this.m_installation.addExtension(new QualityModelImportExtension(this.m_languageProviderAccessor));
        PropertiesExtension propertiesExtension = this.m_installation.addExtension(new PropertiesExtension());
        this.m_installation.addExtension(new ExportExtension(this.m_installation, propertiesExtension, this.m_backgroundTaskExecutionMode));
        this.m_installation.addExtension(new SonargraphEnterpriseExtension());
        NotificationExtension notificationExtension = this.m_installation.addExtension(new NotificationExtension(this.m_installation));
        this.m_resolver = new ElementResolver(this.m_installation);
        for (LanguageProvider nextLanguageProvider : this.m_languageProviderAccessor.getAvailableLanguageProviders()) {
            if (!licenseProvider.isLanguageAvailable(nextLanguageProvider.getLanguage()) || licenseProvider.getLicensedSize(nextLanguageProvider.getLanguage()) == -1) {
                assert (false) : "Unavailable/unlicensed language: " + String.valueOf(nextLanguageProvider.getLanguage());
                throw new IllegalArgumentException("Unavailable/unlicensed language: " + String.valueOf(nextLanguageProvider.getLanguage()));
            }
            this.m_installation.addProviderIds(Collections.singleton(nextLanguageProvider.getProviderId()));
            this.m_installation.addIssueIds(nextLanguageProvider.getIssueIds());
        }
        this.m_finishModelProcessor = new FinishModelProcessor(this.m_languageProviderAccessor, licenseProvider, notificationExtension, scriptOutputStreamProvider);
        this.m_languageProviderAccessor.getAvailableLanguageProviders().forEach(lp -> lp.initialize(this.m_installation, (IFinishModelProcessor)this.m_finishModelProcessor));
        this.m_persistenceAccessor = new PersistenceAccessor(this, this.m_installation, this.m_languageProviderAccessor);
        this.m_installation.addExtension(new DynamicSystemExtension(this, this.m_languageProviderAccessor, this.m_persistenceAccessor));
        this.m_installation.addExtension(new PluginExtension(this, this.m_languageProviderAccessor, this.m_finishModelProcessor));
        this.m_installation.addExtension(new HierarchicalIssueExtension(this.m_installation, this.m_finishModelProcessor));
        if (this.m_licenseProvider.getProduct() != SonargraphProduct.SONARGRAPH_BUILD && this.m_licenseProvider.isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            this.m_installation.addExtension(new RemoteSelectionExtension(this.m_installation, licenseProvider.getProduct(), this.m_resolver, this.m_finishModelProcessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.REMOTE_SELECTION)));
        }
        this.m_installation.getExtensions().forEach(e -> e.finishInstallationInitialization());
        this.m_installation.finishInitialization();
    }

    @Override
    public void shutdown() {
        this.m_installation.getExtensions().stream().filter(e -> e != this).forEach(e -> e.shutdown());
    }

    @Override
    public ITransactionProvider getTransactionProvider() {
        return this.m_finishModelProcessor;
    }

    @Override
    public INamedElementResolver getElementResolver() {
        return this.m_resolver;
    }

    @Override
    public boolean isLanguageAvailable(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLanguageAvailable' must not be null";
        return this.m_licenseProvider.isLanguageAvailable(language);
    }

    @Override
    public int getUsedSize(Language language) {
        return this.m_languageProviderAccessor.getUsedSize(language);
    }

    @Override
    public LanguageProvider getLanguageProvider(Language language) {
        return this.m_languageProviderAccessor.getLanguageProvider(language);
    }

    @Override
    public Installation getInstallation() {
        return this.m_installation;
    }

    @Override
    public ISoftwareSystemProvider.BackgroundTaskExecutionMode getBackgroundTaskExecutionMode() {
        return this.m_backgroundTaskExecutionMode;
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.m_analyzerExecutionLevel;
    }

    @Override
    public AnalyzerExecutionLevel getLastAppliedAnalyzerExecutionLevel() {
        return this.m_softwareSystem != null ? this.m_softwareSystem.getExtension(AnalyzerExtension.class).getLastAppliedAnalyzerExecutionLevel() : null;
    }

    @Override
    public IContext getDefaultContext() {
        if (this.m_defaultContext == null) {
            this.m_defaultContext = new DefaultContext(this);
        }
        return this.m_defaultContext;
    }

    @Override
    public void setAnalyzerExecutionLevel(AnalyzerExecutionLevel level) {
        assert (level != null) : "Parameter 'level' of method 'setAnalyzerExecutionLevel' must not be null";
        if (!this.m_analyzerExecutionLevel.equals((Object)level)) {
            if (this.m_softwareSystem != null) {
                AnalyzerExecutionLevel from = this.m_analyzerExecutionLevel;
                this.m_analyzerExecutionLevel = level;
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerExecutionLevelChangedEvent(this));
                this.m_softwareSystem.getExtension(AnalyzerExtension.class).changedAnalyzerExecutionLevel(from, level);
            } else {
                this.m_analyzerExecutionLevel = level;
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerExecutionLevelChangedEvent(this));
            }
        }
    }

    @Override
    public boolean hasSoftwareSystem() {
        return this.m_softwareSystem != null && this.m_softwareSystem.isValid();
    }

    @Override
    public SoftwareSystem getSoftwareSystem() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m_softwareSystem;
    }

    @Override
    public ISoftwareSystemProvider.PathType getPathType(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'getPathType' must not be empty";
        if (this.getSoftwareSystemDirectoryValidator().isValid(null, new TFile(path)).isSuccess()) {
            return ISoftwareSystemProvider.PathType.SOFTWARE_SYSTEM;
        }
        if (this.getSnapshotLocationValidator().isValid(null, new TFile(path)).isSuccess()) {
            return ISoftwareSystemProvider.PathType.SNAPSHOT;
        }
        return null;
    }

    @Override
    public PersistentRecentlyUsedList getRecentlyUsedList() {
        if (this.m_recentlyUsedList == null) {
            this.m_recentlyUsedList = new PersistentRecentlyUsedList(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir().getAbsolutePath() + "/" + this.m_finishModelProcessor.getLicenseProvider().getProduct().getDirectoryName() + "/softwaresystem.rud", 20);
        }
        if (this.m_recentlyUsedList.getNumberOfEntries() > 0) {
            List allEntries = this.m_recentlyUsedList.getAll();
            ArrayList<String> toBeRemoved = new ArrayList<String>(allEntries.size());
            ArrayList<TFile> allValidPathsAsFiles = new ArrayList<TFile>(allEntries.size());
            for (String nextPath : allEntries) {
                if (this.getPathType(nextPath) == null) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                boolean isDuplicate = false;
                TFile nextPathAsFile = new TFile(nextPath);
                for (TFile nextAlreadyAddedPathAsFile : allValidPathsAsFiles) {
                    if (!FileUtility.areEqual((TFile)nextPathAsFile, (TFile)nextAlreadyAddedPathAsFile)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                allValidPathsAsFiles.add(nextPathAsFile);
            }
            toBeRemoved.forEach(r -> this.m_recentlyUsedList.remove(r));
        }
        return this.m_recentlyUsedList;
    }

    private void initPersistentSaveLocations() {
        if (this.m_softwareSystemLocations == null && this.m_softwareSystem != null) {
            this.m_softwareSystemLocations = new PersistentLocations(this.m_softwareSystem.getHiddenDataDirectory().getAbsolutePath() + "/softwaresystem.slo");
        }
        if (this.m_globalLocations == null) {
            this.m_globalLocations = new PersistentLocations(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir().getAbsolutePath() + "/" + this.m_finishModelProcessor.getLicenseProvider().getProduct().getDirectoryName() + "/softwaresystem.slo");
        }
    }

    @Override
    public String getLocation(String topic) {
        assert (topic != null && topic.length() > 0) : "Parameter 'topic' of method 'getLocation' must not be empty";
        this.initPersistentSaveLocations();
        String location = this.m_softwareSystem != null ? this.m_softwareSystemLocations.getLocation(topic) : null;
        return location != null ? location : this.m_globalLocations.getLocation(topic);
    }

    @Override
    public void setLocation(String topic, String location) {
        assert (topic != null && topic.length() > 0) : "Parameter 'topic' of method 'setLocation' must not be empty";
        this.initPersistentSaveLocations();
        if (this.m_softwareSystem != null) {
            this.m_softwareSystemLocations.setLocation(topic, location);
        } else {
            this.m_globalLocations.setLocation(topic, location);
        }
    }

    @Override
    public ITextValidator getSoftwareSystemNameValidator() {
        return new SoftwareSystemNameValidator();
    }

    @Override
    public IPathValidator getSoftwareSystemBaseDirectoryValidator() {
        return SoftwareSystemBaseDirectory.getValidator();
    }

    @Override
    public IPathValidator getSoftwareSystemDirectoryValidator() {
        return SoftwareSystemDirectory.getValidator();
    }

    @Override
    public IPathValidator getSnapshotLocationValidator() {
        return SnapshotExtension.getLocationValidator();
    }

    @Override
    public String validateOverwrite(TFile baseDirectory, String systemName) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'validateOverwrite' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'validateOverwrite' must not be empty";
        return Files.validateSystemOverwrite(baseDirectory, systemName);
    }

    private void initializeSoftwareSystem(SoftwareSystem system, boolean enableWorkspaceFilter, OperationResult result) {
        assert (system != null) : "Parameter 'system' of method 'initializeSoftwareSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initializeSoftwareSystem' must not be null";
        system.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
        system.setClassLoader(this.m_languageProviderAccessor.getClassLoader());
        this.m_resolver.add(system);
        RefactoringProcessor refactoringProcessor = new RefactoringProcessor(this.m_languageProviderAccessor, system, this.m_resolver);
        system.addExtension(this);
        system.addExtension(new SoftwareSystemDataTransferExtension(this.m_languageProviderAccessor));
        IssueExtension issueExtension = new IssueExtension(this.m_languageProviderAccessor, system, refactoringProcessor, this.m_finishModelProcessor);
        system.addExtension(issueExtension);
        system.addExtension(new DependenciesExtension(system));
        system.addExtension(new SearchExtension(system));
        system.addExtension(new GraphExtension(system, this.m_finishModelProcessor, this.m_resolver));
        StructureItemRegistry structureItemRegistry = new StructureItemRegistry();
        this.m_languageProviderAccessor.getAvailableLanguageProviders().forEach(lp -> structureItemRegistry.createStructure(lp.getLanguage(), lp.getPhysicalStructureItems()));
        system.addExtension(new GraphRepresentationExtension(this.m_languageProviderAccessor, system, this.m_finishModelProcessor, this.m_resolver, structureItemRegistry));
        system.addExtension(new BalancedDependencyRepresentationExtension(this.m_languageProviderAccessor, system, this.m_finishModelProcessor, this.m_resolver, structureItemRegistry));
        system.addExtension(new QualityModelImportExportExtension(this.m_languageProviderAccessor, system, this.m_finishModelProcessor));
        system.addExtension(new ReportExtension(this.m_installation, system, this.m_finishModelProcessor.getLicenseProvider().getAvailableFeatures(), this.m_finishModelProcessor.getLicenseProvider().getUnavailableFeatures()));
        SnapshotExtension snapshotExtension = new SnapshotExtension(this.m_languageProviderAccessor, this, system, this.m_backgroundTaskExecutionMode, this.m_finishModelProcessor);
        system.addExtension(snapshotExtension);
        system.addExtension(new WorkspaceExtension(this.m_languageProviderAccessor, this.m_installation, system, this.m_finishModelProcessor));
        system.addExtension(new WorkspaceProfileExtension(this.m_installation, system, this.m_finishModelProcessor));
        AnalyzerExtension analyzerExtension = new AnalyzerExtension(this.m_languageProviderAccessor, this.m_installation, system, this.m_finishModelProcessor, this, this.m_resolver, this.m_licenseProvider.getProduct());
        system.addExtension(analyzerExtension);
        system.addExtension(new SystemDiffExtension(system, analyzerExtension, this.m_finishModelProcessor, this.m_licenseProvider.getProduct()));
        system.addExtension(new ThresholdExtension(system, this.m_installation.getExtension(IMetricsProvider.class), issueExtension, this.m_finishModelProcessor));
        VirtualModelExtension virtualModelExtension = system.addExtension(new VirtualModelExtension(this.m_installation, system, refactoringProcessor, this.m_finishModelProcessor, this.m_resolver, this.m_installation.getExtension(PluginExtension.class)));
        ArchitecturalViewExtension architecturalViewExtension = new ArchitecturalViewExtension(this.m_languageProviderAccessor, this.m_installation, system, this.m_resolver, this.m_finishModelProcessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.ARCHITECTURAL_VIEW));
        system.addExtension(architecturalViewExtension);
        system.addExtension(new ArchitecturalViewOperationExtension(this.m_languageProviderAccessor, this.m_installation, system, this.m_resolver, this.m_finishModelProcessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.ARCHITECTURAL_VIEW)));
        system.addExtension(new QualityGateExtension(this.m_installation, this.m_softwareSystem, this.m_finishModelProcessor));
        TreeMapExtension treeMapExtension = new TreeMapExtension(this.m_installation, system, this.m_finishModelProcessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.TREEMAP));
        system.addExtension(treeMapExtension);
        ArrayList<IAssignableAttributeRetriever> lpRetrievers = new ArrayList<IAssignableAttributeRetriever>();
        this.m_languageProviderAccessor.getAvailableLanguageProviders().forEach(lp -> {
            boolean bl = lpRetrievers.addAll(lp.createAssignableAttributeRetrievers());
        });
        system.addExtension(new ArchitectureExtension(this.m_installation, system, lpRetrievers, this.m_finishModelProcessor));
        ArchitectureDiagramExtension architectureDiagramExtension = new ArchitectureDiagramExtension(system, this.m_finishModelProcessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.ARCHITECTURE_DIAGRAM));
        system.addExtension(architectureDiagramExtension);
        PluginConfigurationExtension pluginConfigurationExtension = new PluginConfigurationExtension(this.m_installation.getVersion(), system, this.m_finishModelProcessor, this.m_installation.getExtension(PluginExtension.class));
        system.addExtension(pluginConfigurationExtension);
        system.addExtension(new ScmExtension(this.m_languageProviderAccessor, system, this.m_finishModelProcessor));
        system.addExtension(new AuthorsExtension(system));
        system.addExtension(new GroovyExtension(this.m_languageProviderAccessor, this.m_installation, system, this.m_finishModelProcessor.getScriptOutputStreamProvider(), this.m_finishModelProcessor));
        system.addExtension(new DashboardExtension(this.m_installation, system, this.m_finishModelProcessor, this.m_languageProviderAccessor, !this.m_disabledExtensions.contains((Object)OptionalExtensionId.DASHBOARD)));
        system.addExtension(new IssueRankingExtension(system));
        UndoRedoExtension undoRedoExtension = new UndoRedoExtension(this.m_installation, system, snapshotExtension, analyzerExtension, this.m_finishModelProcessor, system.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT && !this.m_disabledExtensions.contains((Object)OptionalExtensionId.UNDO_REDO));
        if (undoRedoExtension.isEnabled()) {
            undoRedoExtension.addUndoRedoProvider(new SoftwareSystemUndoRedoProvider(system, this.m_languageProviderAccessor, this.m_persistenceAccessor));
            undoRedoExtension.addUndoRedoProvider(new VirtualModelUndoRedoProvider(virtualModelExtension));
            undoRedoExtension.addUndoRedoProvider(new ArchitecturalViewUndoRedoProvider(architecturalViewExtension));
            undoRedoExtension.addUndoRedoProvider(new ModifiableFileBasedUndoRedoProvider<TreeMapsDirectory, TreeMapFile>(treeMapExtension));
            undoRedoExtension.addUndoRedoProvider(new GroovyScriptUndoRedoProvider(system));
            undoRedoExtension.addUndoRedoProvider(new GroovyScriptRunConfigurationUndoRedoProvider(system));
            undoRedoExtension.addUndoRedoProvider(new AnalyzerConfigurationUndoRedoProvider(this.m_installation, system));
            undoRedoExtension.addUndoRedoProvider(new PluginConfigurationUndoRedoProvider(pluginConfigurationExtension));
            undoRedoExtension.addUndoRedoProvider(new ArchitectureFileUndoRedoProvider(system));
            undoRedoExtension.addUndoRedoProvider(new WorkspaceProfileUndoRedoProvider(system));
            undoRedoExtension.addUndoRedoProvider(new QualityGateUndoRedoProvider(system));
            undoRedoExtension.addUndoRedoProvider(new SoftwareSystemSettingsUndoRedoProvider(system, this.m_languageProviderAccessor));
        }
        system.addExtension(undoRedoExtension);
        this.m_languageProviderAccessor.getAvailableLanguageProviders().forEach(lp -> lp.initialize(system, (IFinishModelProcessor)this.m_finishModelProcessor));
        system.getExtensions().forEach(e -> e.finishSoftwareSystemInitialization(result));
        system.setState(SoftwareSystemState.OPENED);
        system.finishInitialization();
    }

    @Override
    public OperationResult createSoftwareSystem(IWorkerContext workerContext, TFile directory, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions, String systemName, String description, ImportQualityModel qualityModel) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSoftwareSystem' must not be null";
        assert (directory != null) : "Parameter 'directory' of method 'createSoftwareSystem' must not be null";
        assert (this.getSoftwareSystemNameValidator().isValid(null, systemName).isSuccess()) : "Not a valid name: " + systemName;
        assert (openOptions != null) : "Parameter 'openOptions' of method 'createSoftwareSystem' must not be null";
        assert (description != null) : "Parameter 'description' of method 'createSoftwareSystem' must not be null";
        OperationResult result = new OperationResult("Create software system");
        if (directory.exists() && !directory.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, "'" + directory.getAbsolutePath() + "' is not a directory.", new Object[0]);
            return result;
        }
        TFile systemDirectory = new TFile((File)directory, Files.getSystemDirectoryRelPath(systemName)).getNormalizedAbsoluteFile();
        workerContext.working("Create system", true);
        if (FileUtility.removeRecursively((TFile)systemDirectory, (OperationResult)result).isFailure()) {
            return result;
        }
        systemDirectory = FileUtility.getOrCreateDirectory((TFile)systemDirectory, (OperationResult)result);
        if (result.isSuccess()) {
            TFile systemFile = FileUtility.getOrCreateFile((TFile)new TFile((File)systemDirectory, "system.sonargraph"), (OperationResult)result);
            if (result.isSuccess()) {
                SoftwareSystem softwareSystem = this.createSoftwareSystem(systemName, StringUtility.createTimebasedId((String)systemName), systemFile, new Properties(), false);
                if (result.isSuccess()) {
                    assert (softwareSystem != null) : "'softwareSystem' of method 'createSoftwareSystem' must not be null";
                    this.m_softwareSystem = softwareSystem;
                    this.m_softwareSystem.setDescription(description);
                    workerContext.working("Initialize system", true);
                    this.initializeSoftwareSystem(softwareSystem, !openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.DISABLE_WORKSPACE_FILTER), result);
                    if (result.isSuccess()) {
                        result.addMessagesFrom(this.m_persistenceAccessor.getPersistence(null).save(this.m_softwareSystem, this.m_languageProviderAccessor.getClassLoader()));
                        if (result.isSuccess()) {
                            TrueZipFacade.clear((TFile)systemFile);
                            this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
                            this.m_refreshProcessor = new RefreshProcessor(this.m_languageProviderAccessor, this.m_finishModelProcessor, this.m_installation, softwareSystem, this.m_backgroundTaskExecutionMode);
                            OperationResult loadQualityModelResult = null;
                            if (qualityModel != null) {
                                loadQualityModelResult = this.m_softwareSystem.getExtension(QualityModelImportExportExtension.class).importQualityModel(workerContext, qualityModel, null);
                            }
                            this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
                            if (loadQualityModelResult != null) {
                                boolean isFailure = result.isFailure();
                                result.addMessagesFrom(loadQualityModelResult);
                                if (!isFailure) {
                                    result.setIsSuccess(true);
                                }
                            }
                            if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL)) {
                                this.m_softwareSystem.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                            }
                            this.m_installation.getExtension(PluginExtension.class).softwareSystemOpened(this.m_softwareSystem, false, result);
                            this.m_finishModelProcessor.finishSoftwareSystemCreate(workerContext, this.m_softwareSystem, result);
                        }
                    }
                    if (result.isFailure()) {
                        this.release();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void initializeFromSnapshot(SoftwareSystem softwareSystem, TFile systemBaseDirectory) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initializeFromSnapshot' must not be null";
        assert (systemBaseDirectory != null) : "Parameter 'systemBaseDirectory' of method 'initializeFromSnapshot' must not be null";
        softwareSystem.addChild(new Files(softwareSystem, this.m_finishModelProcessor.getLicenseProvider().getProduct(), systemBaseDirectory));
        softwareSystem.setModel(softwareSystem.getParserModel());
        softwareSystem.addChild(new LogicalSystemNamespaces(softwareSystem));
        softwareSystem.addChild(new LogicalModuleNamespaces(softwareSystem));
        softwareSystem.addChild(new Representations(softwareSystem));
    }

    @Override
    public void finishInitializationFromSnapshot(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishInitializationFromSnapshot' must not be null";
        softwareSystem.getUniqueExistingChild(Files.class).finishInitializationFromSnapshot(softwareSystem.getId(), softwareSystem.getName());
    }

    @Override
    public SoftwareSystem createSoftwareSystem(String name, String id, TFile systemFile, Properties systemProperties, boolean isTemporary) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'createSoftwareSystem' must not be null";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'createSoftwareSystem' must not be empty";
        SoftwareSystem softwareSystem = new SoftwareSystem(id, name, this.m_installation.getVersion(), systemProperties);
        TFile normalizedSystemFile = systemFile.getNormalizedAbsoluteFile();
        TFile systemDirectory = normalizedSystemFile.getParentFile();
        assert (systemDirectory != null) : "'systemDirectory' of method 'initializeSoftwareSystem' must not be null";
        TFile systemBaseDirectory = systemDirectory.getParentFile();
        assert (systemBaseDirectory != null) : "'systemBaseDirectory' of method 'initializeSoftwareSystem' must not be null";
        softwareSystem.addChild(new Files(softwareSystem, this.m_finishModelProcessor.getLicenseProvider().getProduct(), systemBaseDirectory, softwareSystem.getId(), softwareSystem.getName(), isTemporary));
        softwareSystem.setModel(softwareSystem.getParserModel());
        assert (softwareSystem.getUniqueChild(Workspace.class) == null) : "Workspace already added";
        softwareSystem.addChild(new Workspace(softwareSystem));
        softwareSystem.addChild(new LogicalSystemNamespaces(softwareSystem));
        softwareSystem.addChild(new LogicalModuleNamespaces(softwareSystem));
        softwareSystem.addChild(new Representations(softwareSystem));
        return softwareSystem;
    }

    @Override
    public OperationResultWithOutcome<WorkspaceDependency> createWorkspaceDependency(SoftwareSystem softwareSystem, String language, String from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        return WorkspaceExtension.createWorkspaceDependency(this.m_languageProviderAccessor, softwareSystem, language, from, toId, toName, type, dependencyData);
    }

    @Override
    public OperationResultWithOutcome<Module> createModule(SoftwareSystem softwareSystem, String languageStandardName, String moduleTypeStandardName, String id, String moduleName, String description) {
        return WorkspaceExtension.createModule(this.m_languageProviderAccessor, softwareSystem, languageStandardName, moduleTypeStandardName, id, moduleName, description);
    }

    @Override
    public OperationResult openSnapshot(IWorkerContext workerContext, TFile snapshotFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSoftwareSystemFromSnapshot' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'openSoftwareSystemFromSnapshot' must not be null";
        OperationResult result = new OperationResult("Open system from snapshot");
        OperationResultWithOutcome<SoftwareSystem> loadSnapshotResult = SnapshotExtension.load(workerContext, this, snapshotFile, this.m_languageProviderAccessor);
        result.addMessagesFrom(loadSnapshotResult);
        if (result.isSuccess()) {
            this.m_softwareSystem = (SoftwareSystem)loadSnapshotResult.getOutcome();
            this.m_softwareSystem.setLoadedFromSnapshot(snapshotFile);
            this.m_refreshProcessor = new RefreshProcessor(this.m_languageProviderAccessor, this.m_finishModelProcessor, this.m_installation, this.m_softwareSystem, this.m_backgroundTaskExecutionMode);
            this.initializeSoftwareSystem(this.m_softwareSystem, true, result);
            if (result.isSuccess()) {
                SnapshotExtension.finishOpenSnapshot(this.m_softwareSystem, snapshotFile);
                this.m_softwareSystem.setState(SoftwareSystemState.MODEL_LOADED);
                PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(this.m_softwareSystem.getUsedLanguages(), Collections.emptySet());
                this.m_refreshProcessor.prepareAdditionalSystemFilesRefresh(workerContext, true, prepareRefreshResult);
                this.m_refreshProcessor.processAdditionalSystemFilesPrepareRefreshResult(workerContext, null, result, prepareRefreshResult);
                this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishApplySnapshot(workerContext, this.m_softwareSystem, null));
                if (this.m_finishModelProcessor.getLicenseProvider().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
                    workerContext.working("Switch to default virtual model", true);
                    this.m_softwareSystem.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                }
                this.m_installation.getExtension(PluginExtension.class).softwareSystemOpened(this.m_softwareSystem, true, result);
                this.m_finishModelProcessor.finishSoftwareSystemOpen(workerContext, this.m_softwareSystem, null, true, result);
                this.m_finishModelProcessor.notifyParserModelModification(this.m_softwareSystem);
                this.m_softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext, true);
            } else {
                this.release();
            }
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<List<TFile>> isOpenSnapshotAttachedPossible(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) {
        return SnapshotExtension.isOpenSnapshotAttachedPossible(workerContext, snapshotFile, targetDirectory);
    }

    @Override
    public OperationResult openSnapshotAttached(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) {
        SnapshotExtension.ExtractionInfo extractionInfo;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSnapshotAttached' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'openSnapshotAttached' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'openSnapshotAttached' must not be null";
        OperationResult result = new OperationResult("Open snapshot attached '" + snapshotFile.getAbsolutePath() + "'");
        try {
            extractionInfo = SnapshotExtension.extractSystemDefintionFilesSnapshot(workerContext, snapshotFile, targetDirectory);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_EXTRACT, (Throwable)e);
            return result;
        }
        assert (extractionInfo != null) : "'extractionInfo' of method 'openSnapshotAttached' must not be null";
        TFile softwareSystemDirectory = extractionInfo.getTargetSystemDirectory();
        assert (softwareSystemDirectory != null) : "Parameter 'softwareSystemDirectory' of method 'openSnapshotAttached' must not be null";
        TrueZipFacade.clear();
        workerContext.working("Load system", true);
        this.m_softwareSystem = this.loadSoftwareSystem(softwareSystemDirectory, true, result, EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class));
        if (result.isSuccess()) {
            assert (this.m_softwareSystem != null) : "'m_softwareSystem' of method 'openSnapshotAttached' must not be null";
            this.m_refreshProcessor = new RefreshProcessor(this.m_languageProviderAccessor, this.m_finishModelProcessor, this.m_installation, this.m_softwareSystem, this.m_backgroundTaskExecutionMode);
            this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishLoadFromPersistence(this.m_installation, this.m_softwareSystem, result, true));
            this.initializeSoftwareSystem(this.m_softwareSystem, true, result);
            if (result.isSuccess()) {
                PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(this.m_softwareSystem.getUsedLanguages(), Collections.emptySet());
                this.m_refreshProcessor.prepareAdditionalSystemFilesRefresh(workerContext, true, prepareRefreshResult);
                this.m_refreshProcessor.processAdditionalSystemFilesPrepareRefreshResult(workerContext, null, result, prepareRefreshResult);
                result.addMessagesFromMaintainingCurrentOutcome((OperationResult)prepareRefreshResult);
                if (result.isSuccess()) {
                    assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'openSoftwareSystem' must not be null";
                    this.m_softwareSystem.getExtension(WorkspaceExtension.class).refreshWorkspaceDependencies(prepareRefreshResult, null);
                    if (this.m_finishModelProcessor.getLicenseProvider().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
                        workerContext.working("Switch to default virtual model", true);
                        this.m_softwareSystem.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                    }
                    OperationResultWithOutcome<SoftwareSystem> loadFromSnaphotResult = this.m_softwareSystem.getExtension(SnapshotExtension.class).loadSnaphot(workerContext, snapshotFile);
                    result.addMessagesFromAffectingCurrentOutcome(loadFromSnaphotResult);
                    if (result.isSuccess()) {
                        this.m_softwareSystem.getExtension(SnapshotExtension.class).attachSnapshot(workerContext, (SoftwareSystem)loadFromSnaphotResult.getOutcome(), result);
                        workerContext.working("Finish software system open", true);
                        this.m_installation.getExtension(PluginExtension.class).softwareSystemOpened(this.m_softwareSystem, true, result);
                        this.m_finishModelProcessor.finishSoftwareSystemOpen(workerContext, this.m_softwareSystem, null, true, result);
                        result.setIsSuccess(true);
                        this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
                        this.m_finishModelProcessor.notifyParserModelModification(this.m_softwareSystem);
                        this.m_softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext, true);
                    }
                }
            }
            if (result.isFailure()) {
                SnapshotExtension.finishFailedExtraction(extractionInfo, result);
                this.release();
            } else {
                this.m_softwareSystem.getExtension(SnapshotExtension.class).finishSuccessfulExtraction(extractionInfo, result);
            }
        } else assert (this.m_softwareSystem == null) : "'m_softwareSystem' of method 'openSnapshotAttached' must be null";
        TrueZipFacade.clear();
        return result;
    }

    private void initializeExternalQualityModel(TFile qualityModel, OperationResult result) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'initializeExternalQualityModel' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initializeExternalQualityModel' must not be null";
        if (!(qualityModel.exists() && qualityModel.isArchive() && qualityModel.canRead())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, "Specified quality model '" + qualityModel.getNormalizedAbsolutePath() + "' does not exist or is not accessible.", new Object[0]);
            return;
        }
        String extension = FileUtility.getExtension((String)qualityModel.getName());
        if (!CoreFileType.QUALITY_MODEL.hasExtension(extension)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_FILE_EXTENSION, "qualityModel has an invalid file extension '" + extension + "'. Must be one of '" + StringUtility.concat((char)',', (String[])CoreFileType.QUALITY_MODEL.getExtensions()) + "'", new Object[0]);
            return;
        }
        if (qualityModel.listFiles().length == 0) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.EMPTY, "Specified quality model '" + qualityModel.getNormalizedAbsolutePath() + "' is empty.", new Object[0]);
        }
        TFile qualityModelAbsolute = qualityModel.getAbsoluteFile();
        this.m_softwareSystem.getExtensions(IQualityModelProvider.class).forEach(qmp -> qmp.setQualityModelRoot(qualityModelAbsolute));
        this.m_softwareSystem.setExternalQualityModel(qualityModelAbsolute);
    }

    @Override
    public SoftwareSystem loadSoftwareSystem(TFile file, boolean isTemporary, OperationResult result, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions) {
        assert (file != null) : "Parameter 'file' of method 'loadSoftwareSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadSoftwareSystem' must not be null";
        SoftwareSystemDirectory.checkDirectory(file, result);
        if (result.isFailure()) {
            return null;
        }
        TFile systemFile = new TFile((File)file, "system.sonargraph");
        SoftwareSystemFile.checkSoftwareSystemFile(systemFile, result);
        if (result.isFailure()) {
            return null;
        }
        OperationResultWithOutcome<SoftwareSystemPropertiesReader.SoftwareSystemProperties> readPropertiesResult = SoftwareSystemPropertiesReader.read(systemFile);
        result.addMessagesFrom(readPropertiesResult);
        if (result.isFailure()) {
            return null;
        }
        SoftwareSystemPropertiesReader.SoftwareSystemProperties properties = (SoftwareSystemPropertiesReader.SoftwareSystemProperties)readPropertiesResult.getOutcome();
        Set<Language> detectedLanguages = this.m_languageProviderAccessor.detectAvailableLanguages(properties.getLanguages(), result);
        if (result.isFailure()) {
            return null;
        }
        Properties systemProperties = SystemPropertiesPersistenceProvider.readProperties(new TFile((File)Files.getHiddenSystemsDirectory(this.m_licenseProvider.getProduct()), properties.getId()));
        this.m_languageProviderAccessor.getLanguageProviders(detectedLanguages).forEach(lp -> lp.aboutToLoadSoftwareSystem(systemProperties, result));
        if (result.isFailure()) {
            return null;
        }
        XmlSystemPersistenceProvider persistenceProvider = this.m_persistenceAccessor.getPersistence(detectedLanguages);
        OperationResultWithOutcome<SoftwareSystem> loadXmlResult = persistenceProvider.load(systemFile, SoftwareSystemDirectory.getSoftwareSystemName(file), this.m_languageProviderAccessor.getClassLoader(), systemProperties, isTemporary);
        result.addMessagesFrom(loadXmlResult);
        if (result.isFailure()) {
            return null;
        }
        boolean saveIt = false;
        if (!persistenceProvider.systemCanBeLoaded()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.CANNOT_LOAD_SYSTEM, "System cannot be loaded and must be re-imported", new Object[0]);
            return null;
        }
        if (!persistenceProvider.canLoadSnapshot()) {
            openOptions.remove((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT);
            saveIt = true;
        } else if (persistenceProvider.systemWasMigratedAndNeedsSave()) {
            saveIt = true;
        }
        if (saveIt) {
            OperationResult saveResult = persistenceProvider.save((SoftwareSystem)loadXmlResult.getOutcome(), this.m_languageProviderAccessor.getClassLoader());
            if (saveResult.isFailure()) {
                result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_MIGRATED, "Unable to save auto-migrated system", new Object[0]);
                result.addMessagesFrom(saveResult);
                ((SoftwareSystem)loadXmlResult.getOutcome()).setNeedsSave(true);
            } else {
                result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_MIGRATED, "Your system has been migrated to the newest version of Sonargraph");
            }
        }
        return (SoftwareSystem)loadXmlResult.getOutcome();
    }

    @Override
    public OperationResult openSoftwareSystem(IWorkerContext workerContext, TFile location, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions, IFilePathListener filePathListener, DynamicSystemInfo dynamicSystemInfo, String workspaceProfileName, TFile qualityModel) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSoftwareSystem' must not be null";
        assert (location != null) : "Parameter 'location' of method 'openSoftwareSystem' must not be null";
        assert (openOptions != null) : "Parameter 'openOptions' of method 'openSoftwareSystem' must not be null";
        assert (this.m_softwareSystem == null) : "Software system already opened: " + String.valueOf(this.m_softwareSystem);
        assert (this.m_refreshProcessor == null) : "'m_refreshProcessor' of method 'openSoftwareSystem' must be null";
        TrueZipFacade.clear();
        workerContext.working("Open system", true);
        OperationResult result = new OperationResult("Opening system");
        int[] weights = new int[5];
        int i = 0;
        weights[i++] = 2;
        weights[i++] = 2;
        weights[i++] = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT) ? 10 : 1;
        weights[i++] = 2;
        weights[i++] = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH) ? 120 : 1;
        workerContext.setNumberOfSteps(weights.length, weights);
        workerContext.beginSubTask("Loading software system");
        this.m_softwareSystem = this.loadSoftwareSystem(location, false, result, openOptions);
        workerContext.endSubTask();
        if (result.isFailure()) {
            assert (this.m_softwareSystem == null) : "'m_softwareSystem' of method 'test' must be null";
            return result;
        }
        assert (this.m_softwareSystem != null) : "'m_softwareSystem' of method 'openSoftwareSystem' must not be null";
        this.m_refreshProcessor = new RefreshProcessor(this.m_languageProviderAccessor, this.m_finishModelProcessor, this.m_installation, this.m_softwareSystem, this.m_backgroundTaskExecutionMode);
        this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishLoadFromPersistence(this.m_installation, this.m_softwareSystem, result, false));
        boolean canRelease = true;
        if (result.isSuccess()) {
            workerContext.beginSubTask("Initializing system");
            this.initializeSoftwareSystem(this.m_softwareSystem, !openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.DISABLE_WORKSPACE_FILTER), result);
            workerContext.endSubTask();
            if (result.isSuccess()) {
                if (qualityModel != null) {
                    this.initializeExternalQualityModel(qualityModel, result);
                }
                PrepareRefreshResult prepareRefreshResult = null;
                if (result.isSuccess()) {
                    prepareRefreshResult = new PrepareRefreshResult(this.m_softwareSystem.getUsedLanguages(), (Set<ISoftwareSystemProvider.IRefreshOption>)(openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH) ? new THashSet(Arrays.asList(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL, ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) : Collections.emptySet()));
                    this.m_refreshProcessor.prepareAdditionalSystemFilesRefresh(workerContext, true, prepareRefreshResult);
                    this.m_refreshProcessor.processAdditionalSystemFilesPrepareRefreshResult(workerContext, null, result, prepareRefreshResult);
                    assert (dynamicSystemInfo == null || workspaceProfileName == null || workspaceProfileName.isEmpty()) : "Either 'dynamicSystemInfo' or 'workspaceProfileName' specified but not both (or none)";
                    if (dynamicSystemInfo != null) {
                        prepareRefreshResult.addMessagesFrom(this.m_installation.getExtension(DynamicSystemExtension.class).synchronizeModules(workerContext, dynamicSystemInfo.getModules(), this.m_softwareSystem));
                    } else if (workspaceProfileName != null && !workspaceProfileName.isEmpty()) {
                        WorkspaceProfile profile = this.m_softwareSystem.getExtension(WorkspaceProfileExtension.class).set(workerContext, workspaceProfileName, result);
                        if (result.isSuccess()) {
                            assert (profile != null) : "Parameter 'profile' of method 'openSoftwareSystem' must not be null";
                            this.m_softwareSystem.getExtension(VirtualModelExtension.class).mapResolutionPatterns(profile.getResolutionMappings(), null, true, false, null);
                        }
                    }
                }
                if (result.isSuccess()) {
                    boolean snapshotApplied;
                    workerContext.beginSubTask("Applying snapshot");
                    assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'openSoftwareSystem' must not be null";
                    boolean bl = snapshotApplied = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT) && this.m_softwareSystem.getExtension(SnapshotExtension.class).applyLastSnapshot(workerContext, result);
                    if (snapshotApplied) {
                        for (LanguageProvider nextLanguageProvider : this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages())) {
                            nextLanguageProvider.finishApplySnapshot(workerContext, this.m_softwareSystem, filePathListener);
                        }
                    }
                    workerContext.endSubTask();
                    if (!openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH)) {
                        this.m_softwareSystem.getExtension(WorkspaceExtension.class).refreshWorkspaceDependencies(prepareRefreshResult, null);
                    }
                    if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL)) {
                        workerContext.working("Switch to default virtual model", true);
                        this.m_softwareSystem.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                    }
                    workerContext.beginSubTask("Finish software system open");
                    this.m_installation.getExtension(PluginExtension.class).softwareSystemOpened(this.m_softwareSystem, snapshotApplied, result);
                    this.m_finishModelProcessor.finishSoftwareSystemOpen(workerContext, this.m_softwareSystem, filePathListener, snapshotApplied, result);
                    result.setIsSuccess(true);
                    workerContext.endSubTask();
                    boolean runAnalyzers = true;
                    boolean refreshed = false;
                    if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH)) {
                        workerContext.beginSubTask("Refresh");
                        RefreshProcessor.RefreshInfo refreshInfo = this.m_refreshProcessor.refresh(workerContext, prepareRefreshResult, snapshotApplied, result);
                        runAnalyzers = refreshInfo.runAnalyzers();
                        refreshed = refreshInfo.refreshed();
                        workerContext.endSubTask();
                        if (!refreshed) {
                            canRelease = false;
                        }
                    } else {
                        workerContext.endStep();
                    }
                    this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
                    if (!refreshed && snapshotApplied) {
                        this.m_finishModelProcessor.notifyParserModelModification(this.m_softwareSystem);
                    }
                    if (runAnalyzers || !refreshed && snapshotApplied) {
                        this.m_softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext, snapshotApplied);
                    }
                }
                if (prepareRefreshResult != null) {
                    result.addMessagesFromMaintainingCurrentOutcome(prepareRefreshResult);
                }
            }
        }
        if (canRelease && result.isFailure()) {
            this.release();
        }
        return result;
    }

    @Override
    public OperationResult openSoftwareSystem(IWorkerContext workerContext, TFile location, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions) {
        return this.openSoftwareSystem(workerContext, location, openOptions, null, null, null, null);
    }

    @Override
    public OperationResult saveSoftwareSystem() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        OperationResult result = this.m_persistenceAccessor.getPersistence(this.m_softwareSystem.getUsedLanguages()).save(this.m_softwareSystem, this.m_languageProviderAccessor.getClassLoader());
        if (result.isSuccess()) {
            TFile systemFile = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().getFile();
            TrueZipFacade.clear((TFile)systemFile);
            this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
            this.m_softwareSystem.setNeedsSave(false);
            this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
            this.m_softwareSystem.getUniqueExistingChild(Workspace.class).setExternalConfigurationChanged(false);
        }
        return result;
    }

    @Override
    public OperationResult saveSoftwareSystem(IWorkerContext workerContext) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'saveSoftwareSystem' must not be null";
        OperationResult result = this.saveSoftwareSystem();
        if (result.isSuccess()) {
            this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public OperationResult save(IWorkerContext workerContext, List<IModifiableFile> modifiableFiles, Map<IModifiableFile, IModificationOnSave> modificationsOnSave) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'save' must not be null";
        assert (this.hasSoftwareSystem()) : "No system available";
        assert (modifiableFiles != null && !modifiableFiles.isEmpty()) : "Parameter 'modifiableFiles' of method 'save' must not be empty";
        assert (modificationsOnSave != null) : "Parameter 'modificationsOnSave' of method 'save' must not be null";
        workerContext.working("Save system", true);
        OperationResult result = new OperationResult("Save");
        for (IModifiableFile nextModifiableFile : modificationsOnSave.keySet()) {
            assert (modifiableFiles.contains(nextModifiableFile)) : "Modifiable file (modification on save) not found: " + String.valueOf(nextModifiableFile);
        }
        ArrayList<ArchitectureFile> architectureFiles = new ArrayList<ArchitectureFile>();
        for (IModifiableFile nextModifiableFile : modifiableFiles) {
            assert (nextModifiableFile.needsSave()) : "Does not need save: " + String.valueOf(nextModifiableFile);
            if (nextModifiableFile instanceof SoftwareSystemFile) {
                result.addMessagesFrom(this.saveSoftwareSystem());
                continue;
            }
            if (nextModifiableFile instanceof GroovyScript) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(GroovyExtension.class).saveScript((GroovyScript)nextModifiableFile, modificationsOnSave.get(nextModifiableFile)));
                continue;
            }
            if (nextModifiableFile instanceof FileBasedRunConfiguration) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(GroovyExtension.class).saveRunConfiguration((FileBasedRunConfiguration)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ModifiableModel) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(VirtualModelExtension.class).saveModifiableModel((ModifiableModel)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof AnalyzerConfigurationFile) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(AnalyzerExtension.class).save((AnalyzerConfigurationFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ArchitectureFile) {
                architectureFiles.add((ArchitectureFile)nextModifiableFile);
                continue;
            }
            if (nextModifiableFile instanceof WorkspaceProfile) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(WorkspaceProfileExtension.class).save((WorkspaceProfile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof QualityGate) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(QualityGateExtension.class).save((QualityGate)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ArchitecturalViewFile) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(ArchitecturalViewExtension.class).save((ArchitecturalViewFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof PluginConfigurationFile) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(PluginConfigurationExtension.class).save((PluginConfigurationFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof SoftwareSystemSettingsFile) {
                SoftwareSystemSettingsFile nextSoftwareSystemConfigurationFile = (SoftwareSystemSettingsFile)nextModifiableFile;
                Language language = nextSoftwareSystemConfigurationFile.getLanguage();
                for (SoftwareSystemSettingsExtension nextExtension : this.m_softwareSystem.getExtensions(SoftwareSystemSettingsExtension.class)) {
                    if (!nextExtension.getLanguage().equals(language)) continue;
                    result.addMessagesFrom(nextExtension.save(nextSoftwareSystemConfigurationFile));
                }
                continue;
            }
            if (nextModifiableFile instanceof TreeMapFile) {
                result.addMessagesFrom(this.m_softwareSystem.getExtension(TreeMapExtension.class).save((TreeMapFile)nextModifiableFile));
                continue;
            }
            assert (false) : "Unhandled file type '" + nextModifiableFile.getClass().getName() + "' in save system";
        }
        Set<IAnalyzerId> analyzerIds = null;
        if (!architectureFiles.isEmpty()) {
            analyzerIds = this.m_softwareSystem.getExtension(AnalyzerExtension.class).getAnalyzerIds(AnalyzerGroup.ARCHITECTURE, AnalyzerGroup.ARCHITECTURE_METRICS);
            this.m_softwareSystem.getExtension(AnalyzerExtension.class).cancelAndResetAnalyzers(analyzerIds);
            result.addMessagesFrom(this.m_softwareSystem.getExtension(ArchitectureExtension.class).saveFiles(workerContext, architectureFiles, modificationsOnSave));
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.noneOf(Modification.class), result);
        if (analyzerIds != null) {
            this.m_softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public OperationResult saveSoftwareSystemAs(IWorkerContext workerContext, String name, TFile newBaseDirectory) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (this.getSoftwareSystemNameValidator().isValid(this.m_softwareSystem.getName(), name).isSuccess()) : "Not a valid name: " + name;
        assert (this.getSoftwareSystemBaseDirectoryValidator().isValid(this.m_softwareSystem.getDirectoryFile(), newBaseDirectory).isSuccess()) : "Not a valid path: " + String.valueOf(newBaseDirectory);
        assert (!this.m_softwareSystem.getName().equals(name) || !FileUtility.areEqual((TFile)this.m_softwareSystem.getDirectoryFile(), (TFile)newBaseDirectory)) : "Neither name nor directory changed";
        OperationResult result = new OperationResult("Save system as");
        SystemDirectoryLocationInfo info = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(result, name, newBaseDirectory);
        assert (info.locationIsDifferent()) : "Locations not different";
        if (result.isSuccess()) {
            List<Module> modules = this.m_softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class);
            modules.forEach(m -> m.getChildren(RootDirectoryPath.class).forEach(r -> {
                TFile tFile = r.getFile();
            }));
            this.m_softwareSystem.getUniqueExistingChild(Files.class).copy(result, info);
            if (result.isSuccess()) {
                this.m_softwareSystem.getExtension(AnalyzerExtension.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
                this.m_softwareSystem.getExtension(SnapshotExtension.class).cancelSaveSnapshot();
                THashMap fqNameMappings = new THashMap();
                String oldSystemFqName = this.m_softwareSystem.getFullyQualifiedName();
                this.m_softwareSystem.setName(name);
                String newSystemFqName = this.m_softwareSystem.getFullyQualifiedName();
                if (!oldSystemFqName.equals(newSystemFqName)) {
                    fqNameMappings.put(oldSystemFqName, newSystemFqName);
                }
                this.m_softwareSystem.setId(StringUtility.createTimebasedId((String)name));
                for (Module nextModule : modules) {
                    for (RootDirectoryPath nextRootDirectoryPath : nextModule.getChildren(RootDirectoryPath.class)) {
                        String nextOldFqName = nextRootDirectoryPath.getFullyQualifiedName();
                        nextRootDirectoryPath.rebase();
                        String nextNewFqName = nextRootDirectoryPath.getFullyQualifiedName();
                        if (nextOldFqName.equals(nextNewFqName)) continue;
                        fqNameMappings.put(nextOldFqName, nextNewFqName);
                    }
                }
                this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishSaveSoftwareSystemAs(this.m_installation, this.m_softwareSystem));
                OperationResult saveResult = this.saveSoftwareSystem();
                if (saveResult.isFailure()) {
                    this.m_softwareSystem.setNeedsSave(true);
                    this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
                }
                result.addMessagesFrom(saveResult);
                EnumSet<Modification> modifications = EnumSet.of(Modification.SYSTEM_MODIFIED, Modification.SYSTEM_LOCATION_CHANGED);
                if (!fqNameMappings.isEmpty()) {
                    this.m_softwareSystem.getExtension(VirtualModelExtension.class).mapResolutionPatterns((Map<String, String>)fqNameMappings, modifications, true, false, result);
                }
                result.setIsSuccess(true);
                this.m_finishModelProcessor.finishSoftwareSystemSaveAs(workerContext, this.m_softwareSystem, modifications, result, info.getCurrentDirectory());
                this.m_softwareSystem.getExtension(SnapshotExtension.class).saveSnapshot();
                this.m_softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext);
            }
        }
        return result;
    }

    @Override
    public boolean editRequiresSave(String name, String description) {
        assert (this.hasSoftwareSystem()) : "No system available";
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(name).locationIsDifferent();
    }

    @Override
    public OperationResult editSoftwareSystem(IWorkerContext workerContext, String name, String description, Map<String, String> metaData) {
        assert (this.hasSoftwareSystem()) : "No software system loaded";
        assert (name != null) : "Parameter 'name' of method 'editSoftwareSystem' must not be null";
        assert (this.getSoftwareSystemNameValidator().isValid(this.m_softwareSystem.getName(), name).isSuccess()) : "Not a valid name: " + name;
        assert (description != null) : "Parameter 'description' of method 'editSoftwareSystem' must not be null";
        assert (metaData != null) : "Parameter 'metaData' of method 'editSoftwareSystem' must not be null";
        OperationResult result = new OperationResult("Edit system");
        SystemDirectoryLocationInfo info = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(name);
        if (info.locationIsDifferent()) {
            this.m_softwareSystem.getUniqueExistingChild(Files.class).move(result, info);
        }
        if (result.isSuccess()) {
            EnumSet<Modification> modifications = EnumSet.of(Modification.SYSTEM_MODIFIED);
            this.m_softwareSystem.getExtension(SnapshotExtension.class).cancelSaveSnapshot();
            if (!description.equals(this.m_softwareSystem.getDescription())) {
                this.m_softwareSystem.setDescription(description);
                this.m_softwareSystem.setNeedsSave(true);
            }
            if (!metaData.isEmpty()) {
                for (Map.Entry<String, String> entry : metaData.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue() == null ? "" : entry.getValue();
                    String oldValue = this.m_softwareSystem.getMetaData(key);
                    if (oldValue == null) {
                        oldValue = "";
                    }
                    if (oldValue.equals(value)) continue;
                    this.m_softwareSystem.setMetaData(key, value);
                    this.m_softwareSystem.setNeedsSave(true);
                }
            }
            if (info.locationIsDifferent()) {
                assert (!this.m_softwareSystem.getName().equals(name)) : "Name must be different";
                modifications.add(Modification.SYSTEM_LOCATION_CHANGED);
                String oldFqName = this.m_softwareSystem.getFullyQualifiedName();
                this.m_softwareSystem.setName(name);
                String newFqName = this.m_softwareSystem.getFullyQualifiedName();
                OperationResult saveResult = this.m_persistenceAccessor.getPersistence(this.m_softwareSystem.getUsedLanguages()).save(this.m_softwareSystem, this.m_languageProviderAccessor.getClassLoader());
                this.m_softwareSystem.setNeedsSave(!saveResult.isSuccess());
                this.m_softwareSystem.getUniqueExistingChild(Files.class).writeNameTag(this.m_softwareSystem.getName(), result);
                this.m_softwareSystem.getExtension(VirtualModelExtension.class).mapResolutionPatterns(Collections.singletonMap(oldFqName, newFqName), modifications, false, false, saveResult);
                result.addMessagesFrom(saveResult);
                result.setIsSuccess(true);
                this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
            } else assert (this.m_softwareSystem.getName().equals(name)) : "Name must be the same";
            this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
            this.m_softwareSystem.getExtension(SnapshotExtension.class).saveSnapshot();
        }
        return result;
    }

    private void release() {
        assert (this.m_softwareSystem != null) : "Parameter 'm_softwareSystem' of method 'release' must not be null";
        this.m_finishModelProcessor.release(this.m_installation, this.m_softwareSystem);
        this.m_softwareSystem.getUniqueExistingChild(Files.class).release();
        this.m_resolver.remove(this.m_softwareSystem);
        this.m_softwareSystem.accept(new ModelDestructionVisitor());
        this.m_softwareSystem = null;
        this.m_softwareSystemLocations = null;
        this.m_refreshProcessor = null;
        EventManager.getInstance().dispatch((Object)this, (Event)new InstallationModifiedEvent(this));
        TrueZipFacade.clear();
        Introspector.flushCaches();
        System.gc();
    }

    @Override
    public IPathValidator getPathValidatorOnExtractedAndAttachedSoftwareSystemClose() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m_softwareSystem.getExtension(SnapshotExtension.class).getPathValidatorOnExtractedAndAttachedSoftwareSystemClose();
    }

    @Override
    public boolean offerSaveToOnExtractedAndAttachedSoftwareSystemClose() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m_softwareSystem.getExtension(SnapshotExtension.class).offerSaveToOnExtractedAndAttachedSoftwareSystemClose();
    }

    @Override
    public OperationResult prepareExtractedAndAttachedSoftwareSystemClose(IWorkerContext workerContext, TFile saveTo, boolean delete) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
        return this.m_softwareSystem.getExtension(SnapshotExtension.class).prepareExtractedAndAttachedSoftwareSystemClose(workerContext, saveTo, delete);
    }

    @Override
    public OperationResult closeSoftwareSystem() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        OperationResult result = new OperationResult("Close software system");
        SystemPropertiesPersistenceProvider.storeProperties(this.m_softwareSystem, result);
        SnapshotExtension snapshotExtension = this.m_softwareSystem.getExtension(SnapshotExtension.class);
        snapshotExtension.waitForSaveToComplete();
        String info = this.m_installation.getExtension(PluginExtension.class).discardPersistedSnapshot(this.m_softwareSystem);
        boolean snapshotDeleted = false;
        if (info != null && !info.isEmpty() && snapshotExtension.deleteSnapshot(this.m_softwareSystem)) {
            result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.SNAPSHOT_DELETED, "\n" + info);
            snapshotDeleted = true;
        }
        this.m_softwareSystem.getExtension(AnalyzerExtension.class).finishSoftwareSystemClose(this.m_softwareSystem, snapshotDeleted, result);
        this.m_finishModelProcessor.finishSoftwareSystemClose(this.m_softwareSystem, result);
        this.release();
        return result;
    }

    @Override
    public PrepareRefreshResult prepareRefresh(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> options, Set<Language> limitTo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (options != null) : "Parameter 'options' of method 'prepareRefresh' must not be null";
        assert (limitTo != null) : "Parameter 'limitTo' of method 'prepareRefresh' must not be null";
        assert (this.m_softwareSystem != null) : "No system available";
        assert (this.m_refreshProcessor != null) : "'m_refreshProcessor' of method 'prepareRefresh' must not be null";
        return this.m_refreshProcessor.prepareRefresh(workerContext, options, limitTo);
    }

    @Override
    public OperationResult refresh(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (this.m_softwareSystem != null) : "No system available";
        assert (this.m_refreshProcessor != null) : "'m_refreshProcessor' of method 'refresh' must not be null";
        return this.m_refreshProcessor.refresh(workerContext, prepareRefreshResult);
    }

    @Override
    public OperationResult refresh(IWorkerContext workerContext, List<ModuleDelta> moduleDeltas, Set<ISoftwareSystemProvider.IRefreshOption> options, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshWithDelta' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'refreshWithDelta' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'refreshWithDelta' must not be null";
        assert (this.m_refreshProcessor != null) : "'m_refreshProcessor' of method 'refresh' must not be null";
        return this.m_refreshProcessor.refresh(workerContext, moduleDeltas, options, listener);
    }

    @Override
    public OperationResult clear(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (this.m_refreshProcessor != null) : "'m_refreshProcessor' of method 'clear' must not be null";
        return this.m_refreshProcessor.clear(workerContext);
    }

    @Override
    public IRelevantSourceFileIterator getRelevantSourceFileIterator() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        ArrayList<IRelevantSourceFileIterator> iterators = new ArrayList<IRelevantSourceFileIterator>(this.m_softwareSystem.getUsedLanguages().size());
        this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> {
            boolean bl = iterators.add(lp.getRelevantSourceFileIterator(this.m_softwareSystem));
        });
        return new RelevantSoftwareSystemSourceFileIterator(iterators);
    }

    @Override
    public void visitPresentFilePaths(IFilePathListener listener, IModule ... modules) {
        assert (listener != null) : "Parameter 'listener' of method 'visitPresentFilePaths' must not be null";
        assert (modules != null && modules.length > 0) : "Parameter 'modules' of method 'visitPresentFilePaths' must not be empty";
        this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.visitPresentFilePaths(listener, modules));
    }

    @Override
    public OperationResult applyInstallationSpecificParameters(Map<String, String> parameters) {
        assert (parameters != null && !parameters.isEmpty()) : "Parameter 'parameters' of method 'applyInstallationSpecificParameters' must not be empty";
        OperationResult result = new OperationResult("Apply installation specific parameters");
        this.m_languageProviderAccessor.getAvailableLanguageProviders().forEach(lp -> lp.applyInstallationParameters(parameters, result));
        return result;
    }

    @Override
    public boolean canAddModuleForLanguage(Language language) {
        assert (language != null) : "Parameter 'language' of method 'canAddModuleForLanguage' must not be null";
        if (!this.hasSoftwareSystem()) {
            return false;
        }
        Set<Language> usedLanguages = this.getSoftwareSystem().getUsedLanguages();
        return usedLanguages.isEmpty() || usedLanguages.size() == 1 && usedLanguages.contains(language);
    }

    public static enum OptionalExtensionId {
        UNDO_REDO,
        DASHBOARD,
        ARCHITECTURAL_VIEW,
        TREEMAP,
        ARCHITECTURE_DIAGRAM,
        REMOTE_SELECTION;

    }
}

