/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.MetricValuesRequest;
import com.hello2morrow.sonargraph.core.controller.system.NumberFormatValidator;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IMetricsExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValueContainer;
import com.hello2morrow.sonargraph.core.model.analysis.LanguageBasedMetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptMetricProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.metrics.AggregatedMaxIntegerMetric;
import com.hello2morrow.sonargraph.core.model.metrics.AggregatedSumIntegerMetric;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.metrics.PropertyMetric;
import com.hello2morrow.sonargraph.core.model.metrics.SourceElementCountMetric;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginMetricProvider;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.MetricProviders;
import com.hello2morrow.sonargraph.core.model.system.MetricValues;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsExtension
extends Extension
implements IMetricsExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsExtension.class);
    private final LanguageProviderAccessor m_accessor;
    private final Installation m_installation;

    MetricsExtension(LanguageProviderAccessor accessor, Installation installation) {
        assert (accessor != null) : "Parameter 'accessor' of method 'MetricsExtension' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'MetricsExtension' must not be null";
        this.m_accessor = accessor;
        this.m_installation = installation;
    }

    @Override
    public void finishInstallationInitialization() {
        MetricProviders metricProviders = this.m_installation.getMetricProviders();
        MetricProvider core = new MetricProvider(metricProviders, CoreProviderId.INSTANCE);
        metricProviders.addChild(core);
        this.m_accessor.getAvailableLanguageProviders().forEach(lp -> metricProviders.addChild(new LanguageBasedMetricProvider(metricProviders, lp.getProviderId(), lp.getLanguage())));
        PropertyMetric locMetric = new PropertyMetric(core, CoreMetricId.CORE_LINES_OF_CODE, CoreMetricLevel.SOURCE_FILE, "linesOfCode", false);
        core.addChild(locMetric);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, locMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, locMetric, false));
        PropertyMetric totalLinesMetric = new PropertyMetric(core, CoreMetricId.CORE_TOTAL_LINES, CoreMetricLevel.SOURCE_FILE, "totalLines", false);
        core.addChild(totalLinesMetric);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, totalLinesMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, totalLinesMetric, false));
        PropertyMetric commentLinesMetric = new PropertyMetric(core, CoreMetricId.CORE_COMMENT_LINES, CoreMetricLevel.SOURCE_FILE, "commentLines", false);
        core.addChild(commentLinesMetric);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, commentLinesMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, commentLinesMetric, false));
        PropertyMetric codeCommentLinesMetric = new PropertyMetric(core, CoreMetricId.CORE_CODE_COMMENT_LINES, CoreMetricLevel.SOURCE_FILE, "codeCommentLines", false);
        core.addChild(codeCommentLinesMetric);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, codeCommentLinesMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, codeCommentLinesMetric, false));
        PropertyMetric numberOfStatementsMetric = new PropertyMetric(core, CoreMetricId.CORE_STATEMENTS, CoreMetricLevel.ROUTINE, "numberOfStatements", true);
        core.addChild(numberOfStatementsMetric);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.TYPE, numberOfStatementsMetric, true));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SOURCE_FILE, numberOfStatementsMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, numberOfStatementsMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, numberOfStatementsMetric, false));
        PropertyMetric maxNestingMetric = new PropertyMetric(core, CoreMetricId.CORE_MAX_NESTING, CoreMetricLevel.ROUTINE, "maxNesting", true);
        core.addChild(maxNestingMetric);
        core.addChild(new AggregatedMaxIntegerMetric(core, CoreMetricLevel.TYPE, maxNestingMetric, true));
        core.addChild(new AggregatedMaxIntegerMetric(core, CoreMetricLevel.SOURCE_FILE, maxNestingMetric, false));
        PropertyMetric cyclomaticComplexityMetric = new PropertyMetric(core, CoreMetricId.CORE_CCN, CoreMetricLevel.ROUTINE, "cyclomaticComplexity", true);
        core.addChild(cyclomaticComplexityMetric);
        PropertyMetric modifiedCyclomaticComplexityMetric = new PropertyMetric(core, CoreMetricId.CORE_MODIFIED_CCN, CoreMetricLevel.ROUTINE, "modifiedCyclomaticComplexity", true);
        core.addChild(modifiedCyclomaticComplexityMetric);
        PropertyMetric extendedCyclomaticComplexityMetric = new PropertyMetric(core, CoreMetricId.CORE_EXTENDED_CCN, CoreMetricLevel.ROUTINE, "extendedCyclomaticComplexity", true);
        core.addChild(extendedCyclomaticComplexityMetric);
        PropertyMetric modifiedExtendedCyclomaticComplexityMetric = new PropertyMetric(core, CoreMetricId.CORE_MODIFIED_EXTENDED_CCN, CoreMetricLevel.ROUTINE, "modifiedExtendedCyclomaticComplexity", true);
        core.addChild(modifiedExtendedCyclomaticComplexityMetric);
        PropertyMetric numberOfParametersMetric = new PropertyMetric(core, CoreMetricId.CORE_PARAMETERS, CoreMetricLevel.ROUTINE, "numberOfParameters", true);
        core.addChild(numberOfParametersMetric);
        PropertyMetric numberOfMethodsMetric = new PropertyMetric(core, CoreMetricId.CORE_METHODS, CoreMetricLevel.TYPE, "numberOfMethods", true);
        core.addChild(numberOfMethodsMetric);
        SourceElementCountMetric sourceElementCountMetric = new SourceElementCountMetric(core, CoreMetricLevel.ELEMENT);
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.TYPE, sourceElementCountMetric, true));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SOURCE_FILE, sourceElementCountMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.MODULE, sourceElementCountMetric, false));
        core.addChild(new AggregatedSumIntegerMetric(core, CoreMetricLevel.SYSTEM, sourceElementCountMetric, false));
        this.m_installation.metricDescriptorsChanged();
    }

    @Override
    public <T extends IMetricDescriptor> List<T> getMetricDescriptors(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getRelevantMetrics' must not be null";
        ArrayList<T> result = new ArrayList<T>();
        for (MetricProvider mp : this.getMetricProviders(true)) {
            result.addAll(mp.getChildren(clazz));
        }
        return result;
    }

    private void getAvailableMetricsForElement(MetricProvider mp, Collection<IMetricDescriptor> result, NamedElement element) {
        assert (mp != null) : "Parameter 'mp' of method 'getAvailableMetricsForElement' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getAvailableMetricsForElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getAvailableMetricsForElement' must not be null";
        Class<?> cls = element.getClass();
        for (IMetricDescriptor md : mp.getChildren(IMetricDescriptor.class)) {
            if (!md.getLevel().getAssociatedClass().isAssignableFrom(cls) || !md.providesMetricsForElement(element)) continue;
            result.add(md);
        }
    }

    private NamedElement getElementToRetrieveMetricsFrom(Element element) {
        Element currentDiffElement;
        assert (element != null) : "Parameter 'element' of method 'getElementToRetrieveMetricsFrom' must not be null";
        Element realElement = element instanceof IDiffElement ? ((currentDiffElement = ((IDiffElement)((Object)element)).getCurrentElement()) != null ? currentDiffElement.getElement() : null) : element.getElement();
        if (realElement != null && realElement.isValid() && !realElement.isExternal() && !realElement.isExcluded() && realElement.getRefactoringState() != RefactoringState.DELETED) {
            NamedElement retrieveFrom = null;
            if (realElement instanceof INamedElementNode) {
                retrieveFrom = ((INamedElementNode)((Object)realElement)).getNamedElement();
            } else if (realElement instanceof IArchitectureAssignmentElement) {
                retrieveFrom = ((IArchitectureAssignmentElement)((Object)realElement)).getRepresentedElement();
            } else if (realElement instanceof ModuleBasedLogicalNamespaceRoot) {
                retrieveFrom = ((ModuleBasedLogicalNamespaceRoot)realElement).getPhysicalElement();
            } else if (realElement instanceof SoftwareSystemFile) {
                retrieveFrom = ((SoftwareSystemFile)realElement).getParent(SoftwareSystem.class, new Class[0]);
            } else if (realElement instanceof INamedElementAdapter) {
                List<NamedElement> adaptedTo = ((INamedElementAdapter)((Object)realElement)).getAdaptedTo();
                if (adaptedTo != null && !adaptedTo.isEmpty()) {
                    retrieveFrom = adaptedTo.get(0);
                }
            } else if (realElement instanceof NamedElement) {
                retrieveFrom = (NamedElement)realElement;
            }
            if (retrieveFrom != null) {
                if (retrieveFrom instanceof LogicalProgrammingElement) {
                    ProgrammingElement primary = ((LogicalProgrammingElement)retrieveFrom).getPrimaryProgrammingElement();
                    if (!(primary instanceof IType)) {
                        retrieveFrom = primary;
                    }
                } else if (retrieveFrom instanceof LogicalNamespace) {
                    if (((LogicalNamespace)retrieveFrom).isPart()) {
                        retrieveFrom = null;
                    }
                } else if (retrieveFrom instanceof NamespaceFragment) {
                    LogicalNamespace logicalNamespace = ((NamespaceFragment)retrieveFrom).getModuleNamespace();
                    retrieveFrom = logicalNamespace != null && !logicalNamespace.isPart() ? logicalNamespace : null;
                } else if (retrieveFrom instanceof ModuleBasedLogicalNamespaceRoot) {
                    retrieveFrom = ((ModuleBasedLogicalNamespaceRoot)retrieveFrom).getPhysicalElement();
                }
            }
            return retrieveFrom;
        }
        return null;
    }

    @Override
    public StrictPair<NamedElement, Set<IMetricDescriptor>> getMetricDescriptorsForElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getMetricDescriptorsForElement' must not be null";
        NamedElement namedElement = this.getElementToRetrieveMetricsFrom(element);
        if (namedElement != null) {
            LinkedHashSet metricDescriptors = new LinkedHashSet();
            Language lang = namedElement.getLanguage();
            if (namedElement instanceof SoftwareSystem) {
                this.getMetricProviders(true).stream().forEach(p -> this.getAvailableMetricsForElement((MetricProvider)p, metricDescriptors, namedElement));
            } else {
                this.getMetricProviders(true).stream().filter(p -> p.getLanguage() == null || p.getLanguage() == lang).forEach(p -> this.getAvailableMetricsForElement((MetricProvider)p, metricDescriptors, namedElement));
            }
            if (!metricDescriptors.isEmpty()) {
                return new StrictPair((Object)namedElement, metricDescriptors);
            }
        }
        return null;
    }

    @Override
    public List<? extends IMetricValue> getMetricValues(SoftwareSystem system, IMetricDescriptor metricDescriptor, boolean wait) {
        assert (system != null) : "Parameter 'system' of method 'getMetricValues' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getMetricValues' must not be null";
        ArrayList<IMetricValue> values = new ArrayList<IMetricValue>();
        IAnalyzerId analyzerId = metricDescriptor.getProvidingAnalyzerId();
        if (analyzerId != null) {
            AnalyzerResult result = system.getExtension(AnalyzerExtension.class).getAnalyzerResult(analyzerId, wait);
            if (result != null) {
                for (IMetricValue value : result.getChildrenRecursively(IMetricValue.class, new Class[0])) {
                    if (metricDescriptor != value.getMetricDescriptor()) continue;
                    values.add(value);
                }
            }
        } else {
            assert (metricDescriptor instanceof IMetricValueContainer) : "Unexpected class in method 'getMetricValues': " + String.valueOf(metricDescriptor);
            IMetricValueContainer metricValueContainer = (IMetricValueContainer)((Object)metricDescriptor);
            MetricValues metricValues = system.getMetricValues();
            metricValueContainer.processValues(system, v -> {
                NamedElement nextAssosicatedElement = v.getAssociatedElement();
                if (nextAssosicatedElement != null) {
                    this.addMetricValue(metricValues, v);
                    values.add(v);
                }
            });
        }
        return values;
    }

    private void addMetricValue(MetricValues metricValues, IMetricValue value) {
        assert (metricValues != null) : "Parameter 'metricCValues' of method 'addMetricValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addMetricValue' must not be null";
        NamedElement element = value.getElement();
        if (!element.isValid()) {
            while (element.getParent() != null) {
                element = element.getParent();
            }
            element.setParent(metricValues);
        }
    }

    @Override
    public void requestMetricValues(SoftwareSystem system, Set<IMetricDescriptor> metricDescriptors, NamedElement root, boolean rootOnly, IOriginator originator) {
        assert (system != null) : "Parameter 'system' of method 'requestMetricValues' must not be null";
        assert (system.isValid()) : "Parameter 'system' of method 'requestMetricValues' must be valid";
        assert (metricDescriptors != null && !metricDescriptors.isEmpty()) : "Parameter 'metricDescriptors' of method 'requestMetricValues' must not be empty";
        assert (root != null) : "Parameter 'root' of method 'requestMetricValues' must not be null";
        assert (root.isValid()) : "Parameter 'root' of method 'requestMetricValues' must be valid";
        assert (originator != null) : "Parameter 'originator' of method 'requestMetricValues' must not be null";
        THashSet metricValueContainers = new THashSet();
        THashSet metricDescriptorsAnalyzersBased = new THashSet();
        THashSet neededAnalyzers = new THashSet();
        for (IMetricDescriptor nextMetricDescriptor : metricDescriptors) {
            IAnalyzerId nextNeededAnalyzer = nextMetricDescriptor.getProvidingAnalyzerId();
            if (nextNeededAnalyzer != null) {
                neededAnalyzers.add(nextNeededAnalyzer);
                metricDescriptorsAnalyzersBased.add(nextMetricDescriptor);
                continue;
            }
            assert (nextMetricDescriptor instanceof IMetricValueContainer) : "Unexpected class in method 'requestMetricValues': " + String.valueOf(nextMetricDescriptor);
            metricValueContainers.add((IMetricValueContainer)((Object)nextMetricDescriptor));
        }
        if (!metricValueContainers.isEmpty()) {
            MetricValues metricValues = system.getMetricValues();
            MetricValuesAvailableEvent event = new MetricValuesAvailableEvent(system.getExtension(ISoftwareSystemProvider.class), originator);
            for (IMetricValueContainer next : metricValueContainers) {
                next.processValues(root, v -> {
                    NamedElement nextAssosicatedElement = v.getAssociatedElement();
                    if (nextAssosicatedElement != null && (!rootOnly || nextAssosicatedElement.equals(root))) {
                        this.addMetricValue(metricValues, v);
                        event.add(v);
                    }
                });
            }
            EventManager.getInstance().dispatch((Object)this, (Event)event);
        }
        if (!metricDescriptorsAnalyzersBased.isEmpty()) {
            LOGGER.debug("Request metric values from analyzer extension");
            assert (!neededAnalyzers.isEmpty()) : "'neededAnalyzers' of method 'requestMetricValues' must not be empty";
            ISoftwareSystemProvider provider = system.getExtension(ISoftwareSystemProvider.class);
            MetricValuesRequest request = new MetricValuesRequest(provider, this, (Set<IMetricDescriptor>)metricDescriptorsAnalyzersBased, originator, (Set<IAnalyzerId>)neededAnalyzers, rootOnly ? root : null);
            system.getExtension(AnalyzerExtension.class).requestAnalyzerResults(request);
            LOGGER.debug("Got metric values from analyzer extension");
        }
    }

    @Override
    public IMetricValue getMetricValue(SoftwareSystem system, IWorkerContext workerContext, NamedElement element, IMetricDescriptor md, boolean wait) {
        assert (system != null) : "Parameter 'system' of method 'getMetricValue' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getMetricValue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getMetricValue' must not be null";
        assert (md != null) : "Parameter 'md' of method 'getMetricValue' must not be null";
        if (md instanceof IMetricValueContainer) {
            ArrayList metricValues = new ArrayList();
            IMetricValueContainer metricValueContainer = (IMetricValueContainer)((Object)md);
            metricValueContainer.processValues(element, nextValue -> {
                if (element.equals(nextValue.getAssociatedElement())) {
                    metricValues.add(nextValue);
                }
            });
            if (metricValues.isEmpty()) {
                return new MetricValue(null, element, Float.valueOf(md.isFloat() ? Float.valueOf(0.0f).floatValue() : (float)Integer.valueOf(0).intValue()), md);
            }
            return (IMetricValue)metricValues.get(0);
        }
        AnalyzerResult result = system.getExtension(AnalyzerExtension.class).getAnalyzerResult(md.getProvidingAnalyzerId(), wait);
        return result != null ? result.getMetricValue(element, md) : null;
    }

    @Override
    public Number getMetricValue(SoftwareSystem system, NamedElement element, IMetricLevel level, IMetricId id, boolean wait) {
        assert (system != null) : "Parameter 'system' of method 'getMetricValue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getMetricValue' must not be null";
        assert (level != null) : "Parameter 'level' of method 'getMetricValue' must not be null";
        assert (id != null) : "Parameter 'id' of method 'getMetricValue' must not be null";
        IMetricDescriptor metricDescriptor = this.findMetricByIdAndLevel(id, level);
        if (metricDescriptor == null) {
            return null;
        }
        IMetricValue value = this.getMetricValue(system, (IWorkerContext)DefaultWorkerContext.INSTANCE, element, metricDescriptor, wait);
        return value != null ? (Number)value.getValue() : (Number)null;
    }

    @Override
    public Number getMetricValue(SoftwareSystem system, NamedElement element, IMetricId id) {
        assert (system != null) : "Parameter 'system' of method 'getMetricValue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getMetricValue' must not be null";
        assert (id != null) : "Parameter 'id' of method 'getMetricValue' must not be null";
        IMetricDescriptor metricDescriptor = null;
        block0: for (MetricProvider nextMetricProvider : this.m_installation.getMetricProviders().getChildren(MetricProvider.class)) {
            for (IMetricDescriptor nextMetricDescriptor : nextMetricProvider.getChildren(IMetricDescriptor.class)) {
                if (!id.equals(nextMetricDescriptor.getMetricId()) || !nextMetricDescriptor.getLevel().getAssociatedClass().isAssignableFrom(element.getClass())) continue;
                metricDescriptor = nextMetricDescriptor;
                break block0;
            }
        }
        if (metricDescriptor == null) {
            return null;
        }
        IMetricValue value = this.getMetricValue(system, (IWorkerContext)DefaultWorkerContext.INSTANCE, element, metricDescriptor, true);
        return value != null ? (Number)value.getValue() : (Number)null;
    }

    @Override
    public List<IMetricLevel> getAvailableElementMetricLevels(boolean addSystemLevel, boolean includeScriptMetrics) {
        ArrayList<IMetricLevel> levels = new ArrayList<IMetricLevel>();
        for (MetricProvider nextMetricProvider : this.getMetricProviders(includeScriptMetrics)) {
            for (IMetricDescriptor metric : nextMetricProvider.getChildrenRecursively(IMetricDescriptor.class, new Class[0])) {
                if (!includeScriptMetrics && metric.getProvidingAnalyzerId() == CoreAnalyzerId.SCRIPT_RUNNER) continue;
                IMetricLevel nextLevel = metric.getLevel();
                if (!addSystemLevel && nextLevel == CoreMetricLevel.SYSTEM || levels.contains(nextLevel)) continue;
                levels.add(nextLevel);
            }
        }
        Collections.sort(levels, new Comparator<IMetricLevel>(){

            @Override
            public int compare(IMetricLevel o1, IMetricLevel o2) {
                return o1.getOrderNumber() - o2.getOrderNumber();
            }
        });
        return levels;
    }

    @Override
    public List<IMetricDescriptor> getAvailableSystemMetrics(boolean includeScriptMetrics) {
        return this.getAvailableMetricDescriptorsForLevel(CoreMetricLevel.SYSTEM, includeScriptMetrics);
    }

    @Override
    public Set<IMetricDescriptor> getAvailableMetricDescriptors() {
        THashSet metricDescriptors = new THashSet();
        for (MetricProvider nextMetricProvider : this.getMetricProviders(true)) {
            metricDescriptors.addAll(nextMetricProvider.getChildrenRecursively(IMetricDescriptor.class, new Class[0]));
        }
        return metricDescriptors;
    }

    @Override
    public List<IMetricDescriptor> getAvailableMetricDescriptorsForLevel(IMetricLevel level, boolean includeScriptMetrics) {
        assert (level != null) : "Parameter 'level' of method 'getMetricsForLevel' must not be null";
        ArrayList<IMetricDescriptor> metrics = new ArrayList<IMetricDescriptor>();
        for (MetricProvider nextMetricProvider : this.getMetricProviders(includeScriptMetrics)) {
            for (IMetricDescriptor nextMetricDescriptor : nextMetricProvider.getChildrenRecursively(IMetricDescriptor.class, new Class[0])) {
                if (!includeScriptMetrics && nextMetricDescriptor.getProvidingAnalyzerId() == CoreAnalyzerId.SCRIPT_RUNNER || nextMetricDescriptor.getLevel() != level) continue;
                metrics.add(nextMetricDescriptor);
            }
        }
        return metrics;
    }

    @Override
    public IMetricDescriptor findMetricByIdAndLevel(String metricIdStandardName, String levelStandardName) {
        assert (metricIdStandardName != null && metricIdStandardName.length() > 0) : "Parameter 'metricIdStandardName' of method 'findMetricByIdAndLevel' must not be empty";
        assert (levelStandardName != null && levelStandardName.length() > 0) : "Parameter 'levelStandardName' of method 'findMetricByIdAndLevel' must not be empty";
        return this.m_installation.findMetricByIdAndLevel(metricIdStandardName, levelStandardName);
    }

    @Override
    public IMetricDescriptor findMetricByIdAndLevel(IMetricId id, IMetricLevel level) {
        assert (id != null) : "Parameter 'id' of method 'findMetricByIdAndLevel' must not be null";
        assert (level != null) : "Parameter 'level' of method 'findMetricByIdAndLevel' must not be null";
        return this.m_installation.findMetricByIdAndLevel(id.getStandardName(), level.getStandardName());
    }

    @Override
    public MetricProvider getMetricProvider(IProviderId provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getMetricProvider' must not be null";
        for (MetricProvider nextMetricProvider : this.m_installation.getMetricProviders().getChildren(MetricProvider.class)) {
            if (!nextMetricProvider.getProvider().equals(provider)) continue;
            return nextMetricProvider;
        }
        assert (false) : "Metric provider not found: " + String.valueOf(provider);
        return null;
    }

    private List<MetricProvider> getMetricProviders(boolean includeScriptMetrics) {
        List<MetricProvider> allMetricProviders = this.m_installation.getMetricProviders().getChildren(MetricProvider.class);
        ArrayList<MetricProvider> metricProviders = new ArrayList<MetricProvider>();
        for (MetricProvider nextMetricProvider : allMetricProviders) {
            if (nextMetricProvider instanceof PluginMetricProvider) {
                if (!((PluginMetricProvider)nextMetricProvider).isEnabled()) continue;
                metricProviders.add(nextMetricProvider);
                continue;
            }
            if (nextMetricProvider instanceof ScriptMetricProvider) {
                if (!includeScriptMetrics) continue;
                metricProviders.add(nextMetricProvider);
                continue;
            }
            metricProviders.add(nextMetricProvider);
        }
        return metricProviders;
    }

    @Override
    public List<IMetricId> getAvailableMetricIds() {
        THashSet result = new THashSet();
        for (MetricProvider nextMetricProvider : this.getMetricProviders(true)) {
            for (IMetricDescriptor nextMetricDescriptor : nextMetricProvider.getChildrenRecursively(IMetricDescriptor.class, new Class[0])) {
                result.add(nextMetricDescriptor.getMetricId());
            }
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }

    @Override
    public ITextValidator getNumberValidator(boolean isDecimal) {
        return new NumberFormatValidator(null, null, isDecimal);
    }

    @Override
    public List<NamedElement> getAvailableMetricScopes(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getAvailableMetricScopes' must not be null";
        ArrayList<NamedElement> scopeList = new ArrayList<NamedElement>();
        scopeList.addAll(softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class));
        scopeList.sort((a, b) -> a.getName().compareTo(b.getName()));
        scopeList.add(0, softwareSystem);
        return scopeList;
    }

    @Override
    public NamedElement getModuleScopeOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getModuleScopeOf' must not be null";
        if (element instanceof ILogicalElement) {
            ModuleBasedLogicalNamespaceRoot root = element.getParent(ModuleBasedLogicalNamespaceRoot.class, new Class[0]);
            return root == null ? null : root.getPhysicalElement();
        }
        return element.getParent(Module.class, new Class[0]);
    }
}

