/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerResultConsumer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public final class MetricValuesRequest
implements IAnalyzerResultConsumer {
    private final ISoftwareSystemProvider m_provider;
    private final Object m_emitter;
    private final Set<IMetricDescriptor> m_metricDescriptors;
    private final IOriginator m_originator;
    private final Set<IAnalyzerId> m_analyzerIds;
    private final NamedElement m_targetObject;

    public MetricValuesRequest(ISoftwareSystemProvider provider, Object emitter, Set<IMetricDescriptor> metricDescriptors, IOriginator originator, Set<IAnalyzerId> analyzerIds, NamedElement targetObject) {
        assert (provider != null) : "Parameter 'provider' of method 'MetricValuesRequest' must not be null";
        assert (emitter != null) : "Parameter 'emitter' of method 'MetricValuesRequest' must not be null";
        assert (metricDescriptors != null && !metricDescriptors.isEmpty()) : "Parameter 'metricDescriptors' of method 'MetricValuesRequest' must not be empty";
        assert (originator != null) : "Parameter 'originator' of method 'MetricValuesRequest' must not be null";
        assert (analyzerIds != null && !analyzerIds.isEmpty()) : "Parameter 'analyzerIds' of method 'MetricValuesRequest' must not be empty";
        this.m_provider = provider;
        this.m_emitter = emitter;
        this.m_metricDescriptors = new THashSet(metricDescriptors);
        this.m_originator = originator;
        this.m_analyzerIds = new THashSet(analyzerIds);
        this.m_targetObject = targetObject;
    }

    @Override
    public Set<IAnalyzerId> getAnalyzerIds() {
        return Collections.unmodifiableSet(this.m_analyzerIds);
    }

    @Override
    public IOriginator getOriginator() {
        return this.m_originator;
    }

    @Override
    public void consume(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'consume' must not be null";
        MetricValuesAvailableEvent event = new MetricValuesAvailableEvent(this.m_provider, this.m_originator);
        for (IMetricValue value : result.getChildrenRecursively(IMetricValue.class, new Class[0])) {
            IMetricDescriptor nextMetricDescriptor = value.getMetricDescriptor();
            if (!this.m_metricDescriptors.contains(nextMetricDescriptor) || this.m_targetObject != null && !this.m_targetObject.equals(value.getAssociatedElement())) continue;
            event.add(value);
        }
        if (!event.isEmpty()) {
            EventManager.getInstance().dispatch(this.m_emitter, (Event)event);
        }
    }
}

