/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LanguageProviderAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageProviderAccessor.class);
    private final Map<Language, LanguageProvider> m_availableLanguageToLanguageProvider = new LinkedHashMap<Language, LanguageProvider>();
    private final AggregatingClassLoader m_aggregatingClassLoader;
    private final Map<Language, Size> m_sizeInfo;

    LanguageProviderAccessor(Set<LanguageProvider> languageProviders) {
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'LanguageProviderAccessor' must not be null";
        this.m_sizeInfo = new THashMap(languageProviders.size());
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(languageProviders.size());
        for (LanguageProvider nextLanguageProvider : languageProviders) {
            Language language = nextLanguageProvider.getLanguage();
            this.m_sizeInfo.put(language, new Size());
            LanguageProvider previous = this.m_availableLanguageToLanguageProvider.put(language, nextLanguageProvider);
            assert (previous == null) : "Already added language provider for language name: " + language.getStandardName();
            classLoaders.add(nextLanguageProvider.getClass().getClassLoader());
        }
        if (classLoaders.isEmpty()) {
            classLoaders.add(this.getClass().getClassLoader());
            LOGGER.warn("No language providers exist, adding default classloader for 'core' bundle");
        }
        this.m_aggregatingClassLoader = new AggregatingClassLoader(classLoaders);
    }

    AggregatingClassLoader getClassLoader() {
        return this.m_aggregatingClassLoader;
    }

    Set<Language> detectAvailableLanguages(Set<String> languageNames, OperationResult result) {
        assert (languageNames != null) : "Parameter 'languageNames' of method 'detectLanguages' must not be null";
        assert (result != null) : "Parameter 'result' of method 'detectLanguages' must not be null";
        if (result.isSuccess()) {
            THashSet detectedLanguages = new THashSet();
            for (String languageStandardName : languageNames) {
                Language language = this.getLanguage(languageStandardName);
                if (language == null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.LANGUAGE_NOT_AVAILABLE, "Detected language '" + languageStandardName + "' not available.", new Object[0]);
                }
                detectedLanguages.add(language);
            }
            if (result.isSuccess()) {
                return detectedLanguages;
            }
        }
        return null;
    }

    void resetSizes() {
        for (Size nextSize : this.m_sizeInfo.values()) {
            nextSize.reset();
        }
    }

    void incrementSize(Language language, int inc) {
        assert (language != null) : "Parameter 'language' of method 'incrementSize' must not be null";
        Size size = this.m_sizeInfo.get(language);
        size.increment(inc);
    }

    int getUsedSize(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getUsedSize' must not be null";
        Size size = this.m_sizeInfo.get(language);
        if (size == null) {
            return 0;
        }
        return size.getSize();
    }

    public Language getLanguage(String standardName) {
        assert (standardName != null && standardName.length() > 0) : "Parameter 'standardName' of method 'getLanguage' must not be empty";
        for (Language nextLanguage : this.m_availableLanguageToLanguageProvider.keySet()) {
            if (!nextLanguage.getStandardName().equals(standardName)) continue;
            return nextLanguage;
        }
        return null;
    }

    public Set<Language> getAvailableLanguages() {
        return Collections.unmodifiableSet(this.m_availableLanguageToLanguageProvider.keySet());
    }

    public Collection<LanguageProvider> getAvailableLanguageProviders() {
        return Collections.unmodifiableCollection(this.m_availableLanguageToLanguageProvider.values());
    }

    public LanguageProvider getLanguageProvider(String standardName) {
        assert (standardName != null) : "Parameter 'standardName' of method 'getLanguageProvider' must not be null";
        Language language = this.getLanguage(standardName);
        if (language != null) {
            LanguageProvider languageProvider = this.m_availableLanguageToLanguageProvider.get(language);
            assert (languageProvider != null) : "'languageProvider' of method 'getLanguageProvider' must not be null";
            return languageProvider;
        }
        return null;
    }

    public LanguageProvider getLanguageProvider(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLanguageProvider' must not be null";
        return this.m_availableLanguageToLanguageProvider.get(language);
    }

    Set<LanguageProvider> getLanguageProviders(Set<Language> languages) {
        assert (languages != null) : "Parameter 'languages' of method 'getLanguageProviders' must not be null";
        if (languages.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet languageProviders = new THashSet();
        for (Language nextLanguage : languages) {
            languageProviders.add(this.getLanguageProvider(nextLanguage));
        }
        return languageProviders;
    }

    static final class Size {
        private int m_size;

        Size() {
        }

        void reset() {
            this.m_size = 0;
        }

        void increment(int inc) {
            assert (inc >= 0) : "inc must not be negative";
            this.m_size += inc;
        }

        int getSize() {
            return this.m_size;
        }
    }
}

