/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ExplorationViewRepresentationExcelExportVisitor;
import com.hello2morrow.sonargraph.core.controller.system.PropertiesExtension;
import com.hello2morrow.sonargraph.core.controller.system.WriteExcelExportExecutor;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IMetricsExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.export.IExportExtension;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.event.ExportFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.ExportStartedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.MetricAccessKey;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ColumnDatatype;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.export.Sort;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExportExtension
extends Extension
implements IExportExtension {
    private static final String NAMED_ELEMENT_NAME = "Element";
    private static final String DEPENDENCY_NAME = "Dependency";
    private static final String WORKSPACE_DEPENDENCY = "Workspace Dependency";
    private final Installation m_installation;
    private final PropertiesExtension m_propertiesExtension;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode m_backgroundTaskExecutionMode;

    public ExportExtension(Installation installation, PropertiesExtension propertiesExtension, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode) {
        assert (installation != null) : "Parameter 'installation' of method 'ExportExtension' must not be null";
        assert (propertiesExtension != null) : "Parameter 'propertiesExtension' of method 'ExportExtension' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'ExportExtension' must not be null";
        this.m_installation = installation;
        this.m_propertiesExtension = propertiesExtension;
        this.m_backgroundTaskExecutionMode = backgroundTaskExecutionMode;
    }

    private String getIdentification(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getIdentification' must not be null";
        if (element instanceof Issue) {
            element = ((Issue)element).getAffectedElement();
        }
        if (element instanceof INamedElementNode) {
            element = ((INamedElementNode)((Object)element)).getNamedElement();
        }
        if (element instanceof IParserDependenciesProvidingEdge) {
            IParserDependenciesProvidingEdge dependency = (IParserDependenciesProvidingEdge)((Object)element);
            return dependency.getFromEndPoint().getFullyQualifiedName() + "->" + dependency.getToEndPoint().getFullyQualifiedName();
        }
        if (element instanceof Dependency) {
            Dependency dependency = (Dependency)element;
            return dependency.getUnderlyingFrom().getFullyQualifiedName() + "->" + dependency.getUnderlyingTo().getFullyQualifiedName();
        }
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getIdentification': " + String.valueOf(element);
        return ((NamedElement)element).getFullyQualifiedName();
    }

    private List<NamedElementIssuePattern> getNamedElementIssuePattern(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getNamedElementIssuePattern' must not be null";
        ArrayList<NamedElementIssuePattern> namedElementIssuePatterns = new ArrayList<NamedElementIssuePattern>(resolution.getChildren(NamedElementIssuePattern.class));
        Collections.sort(namedElementIssuePatterns, new Comparator<NamedElementIssuePattern>(){

            @Override
            public int compare(NamedElementIssuePattern ip1, NamedElementIssuePattern ip2) {
                if (!$assertionsDisabled && ip1 == null) {
                    throw new AssertionError((Object)"Parameter 'ip1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && ip2 == null) {
                    throw new AssertionError((Object)"Parameter 'ip2' of method 'compare' must not be null");
                }
                return ip1.getPattern().compareTo(ip2.getPattern());
            }
        });
        return namedElementIssuePatterns;
    }

    private List<DependencyIssuePattern> getDependencyIssuePatterns(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getDependencyIssuePatterns' must not be null";
        ArrayList<DependencyIssuePattern> dependencyIssuePatterns = new ArrayList<DependencyIssuePattern>(resolution.getChildren(DependencyIssuePattern.class));
        Collections.sort(dependencyIssuePatterns, new Comparator<DependencyIssuePattern>(){

            @Override
            public int compare(DependencyIssuePattern ip1, DependencyIssuePattern ip2) {
                if (!$assertionsDisabled && ip1 == null) {
                    throw new AssertionError((Object)"Parameter 'ip1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && ip2 == null) {
                    throw new AssertionError((Object)"Parameter 'ip2' of method 'compare' must not be null");
                }
                int compared = ip1.getFromPattern().compareTo(ip2.getFromPattern());
                if (compared == 0) {
                    compared = ip1.getToPattern().compareTo(ip2.getToPattern());
                }
                return compared;
            }
        });
        return dependencyIssuePatterns;
    }

    private void populateSystemMetrics(IWorkerContext workerContext, IThresholdProvider thresholdProvider, IMetricAccessor metricsAccessor, SoftwareSystem softwareSystem, ExportData exportData, List<IMetricDescriptor> metrics) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'populateSystemMetrics' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateSystemMetrics' must not be null";
        workerContext.setNumberOfSteps(1);
        exportData.addColumn("Metric Name");
        exportData.addColumn("Description");
        exportData.addColumn("Min", ColumnDatatype.NUMBER);
        exportData.addColumn("Max", ColumnDatatype.NUMBER);
        exportData.addColumn("Value", ColumnDatatype.NUMBER);
        Collections.sort(metrics, new Comparator<IMetricDescriptor>(){

            @Override
            public int compare(IMetricDescriptor o1, IMetricDescriptor o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }
        });
        workerContext.beginBlockOfWork(metrics.size());
        for (IMetricDescriptor metric : metrics) {
            Number value = metricsAccessor.getMetricValue(softwareSystem, softwareSystem, metric.getMetricId());
            if (value != null) {
                String name = metric.getName();
                String description = metric.getDescription();
                IMetricThreshold th = thresholdProvider.getThreshold(metric);
                Number lowerThreshold = th != null ? (Number)th.getLowerThreshold() : (Number)null;
                Number upperThreshold = th != null ? (Number)th.getUpperThreshold() : (Number)null;
                exportData.addRow(new Object[]{name, description, lowerThreshold, upperThreshold, value});
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    private String getFullyQualifiedName(NamedElement element, Map<NamedElement, String> elementToFullyQualifiedName) {
        assert (element != null) : "Parameter 'element' of method 'getFullyQualifiedName' must not be null";
        assert (elementToFullyQualifiedName != null) : "Parameter 'elementToFullyQualifiedName' of method 'getFullyQualifiedName' must not be null";
        String fqName = elementToFullyQualifiedName.get(element);
        if (fqName == null) {
            fqName = element.getFullyQualifiedName();
            elementToFullyQualifiedName.put(element, fqName);
        }
        return fqName;
    }

    private String getInfo(NamedElement element, Number metricValue, IMetricThreshold threshold, ThresholdViolationIssue issue) {
        assert (element != null) : "Parameter 'element' of method 'getInfo' must not be null";
        if (metricValue != null) {
            if (issue != null) {
                String type;
                assert (threshold != null) : "Parameter 'threshold' of method 'getInfo' must not be null";
                double lowerThreshold = threshold.getLowerThreshold().doubleValue();
                double upperThreshold = threshold.getUpperThreshold().doubleValue();
                double value = metricValue.doubleValue();
                if (value < lowerThreshold) {
                    type = "Lower threshold violation";
                } else {
                    assert (value > upperThreshold) : "Not an upper threshold violation: " + String.valueOf(threshold) + " - " + String.valueOf(metricValue);
                    type = "Upper threshold violation";
                }
                IResolution resolution = issue.getResolution();
                if (resolution != null) {
                    return resolution.ignores() ? type + " ignored by ignore definition" : type + " converted to task";
                }
                return type;
            }
            IComponent component = element.getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (component != null && component.ignoreIssues()) {
                if (threshold != null) {
                    double lowerThreshold = threshold.getLowerThreshold().doubleValue();
                    double upperThreshold = threshold.getUpperThreshold().doubleValue();
                    double value = metricValue.doubleValue();
                    if (value < lowerThreshold) {
                        return "Lower threshold violation ignored by issue filter";
                    }
                    if (value > upperThreshold) {
                        return "Upper threshold violation ignored by issue filter";
                    }
                }
                return "Ignored by issue filter";
            }
        }
        return "";
    }

    private void populateLevelMetrics(IWorkerContext workerContext, IThresholdProvider thresholdProvider, IMetricsExtension metricsExtension, SoftwareSystem softwareSystem, ExportData exportData, IMetricLevel metricLevel, final Map<NamedElement, String> elementToFullyQualifiedName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'populateLevelMetrics' must not be null";
        assert (thresholdProvider != null) : "Parameter 'thresholdProvider' of method 'populateLevelMetrics' must not be null";
        assert (metricsExtension != null) : "Parameter 'metricsExtension' of method 'populateLevelMetrics' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'populateLevelMetrics' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateLevelMetrics' must not be null";
        assert (elementToFullyQualifiedName != null) : "Parameter 'elementToFullyQualifiedName' of method 'populateLevelMetrics' must not be null";
        workerContext.setNumberOfSteps(1);
        exportData.addColumn("Metric Name");
        exportData.addColumn("Description");
        exportData.addColumn("Min", ColumnDatatype.NUMBER);
        exportData.addColumn("Max", ColumnDatatype.NUMBER);
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("Value", ColumnDatatype.NUMBER);
        exportData.addColumn("Info");
        List<IMetricDescriptor> metrics = metricsExtension.getAvailableMetricDescriptorsForLevel(metricLevel, true);
        Collections.sort(metrics, new Comparator<IMetricDescriptor>(){

            @Override
            public int compare(IMetricDescriptor o1, IMetricDescriptor o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }
        });
        workerContext.beginBlockOfWork(metrics.size());
        for (IMetricDescriptor metric : metrics) {
            String name = metric.getName();
            String description = metric.getDescription();
            IMetricThreshold nextMetricThreshold = thresholdProvider.getThreshold(metric);
            Number lowerThreshold = nextMetricThreshold != null ? (Number)nextMetricThreshold.getLowerThreshold() : (Number)null;
            Number upperThreshold = nextMetricThreshold != null ? (Number)nextMetricThreshold.getUpperThreshold() : (Number)null;
            exportData.addRow(new Object[]{name, description, lowerThreshold, upperThreshold, "", null, ""});
            List<? extends IMetricValue> metricValues = metricsExtension.getMetricValues(softwareSystem, metric, true);
            Collections.sort(metricValues, new Comparator<IMetricValue>(){

                @Override
                public int compare(IMetricValue o1, IMetricValue o2) {
                    Number n1 = o1.getValue();
                    Number n2 = o2.getValue();
                    if (n1 instanceof Comparable && n2 instanceof Comparable) {
                        Comparable c2 = (Comparable)((Object)n2);
                        Comparable c1 = (Comparable)((Object)n1);
                        int comp = c2.compareTo(c1);
                        if (comp == 0) {
                            return ExportExtension.this.getFullyQualifiedName(o1.getAssociatedElement(), elementToFullyQualifiedName).compareTo(ExportExtension.this.getFullyQualifiedName(o2.getAssociatedElement(), elementToFullyQualifiedName));
                        }
                        return comp;
                    }
                    return 0;
                }
            });
            for (IMetricValue iMetricValue : metricValues) {
                NamedElement nextAssociatedElement = iMetricValue.getAssociatedElement();
                ThresholdViolationIssue thresholdViolationIssue = null;
                if (nextMetricThreshold != null) {
                    List<Issue> nextIssues = nextAssociatedElement.getIssues(CoreIssueId.THRESHOLD_VIOLATION);
                    for (Issue nextIssue : nextIssues) {
                        if (!(nextIssue instanceof ThresholdViolationIssue) || ((ThresholdViolationIssue)nextIssue).getThreshold() != nextMetricThreshold) continue;
                        thresholdViolationIssue = (ThresholdViolationIssue)nextIssue;
                        break;
                    }
                }
                exportData.addRow(new Object[]{null, null, null, null, this.getFullyQualifiedName(nextAssociatedElement, elementToFullyQualifiedName), iMetricValue.getValue(), this.getInfo(nextAssociatedElement, iMetricValue.getValue(), nextMetricThreshold, thresholdViolationIssue)});
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    private List<Issue> getSortedIssues(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'getIssues' must not be null";
        ArrayList<Issue> sortedIssues = new ArrayList<Issue>(issues.size());
        for (Issue next : issues) {
            if (next.getResolution() != null) continue;
            sortedIssues.add(next);
        }
        Collections.sort(sortedIssues, new Comparator<Issue>(){

            @Override
            public int compare(Issue i1, Issue i2) {
                if (!$assertionsDisabled && i1 == null) {
                    throw new AssertionError((Object)"Parameter 'i1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && i2 == null) {
                    throw new AssertionError((Object)"Parameter 'i2' of method 'compare' must not be null");
                }
                int compared = i1.getSeverity().ordinal() - i2.getSeverity().ordinal();
                if (compared == 0) {
                    compared = i1.getKey().compareTo(i2.getKey());
                }
                return compared;
            }
        });
        return sortedIssues;
    }

    private void populateIssues(ExportData exportData, List<Issue> issues) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populate' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'populate' must not be null";
        exportData.addColumn("Issue Key");
        exportData.addColumn("Description");
        exportData.addColumn("Severity");
        exportData.addColumn("Category");
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("To Element");
        exportData.addColumn("Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Provider");
        for (Issue issue : this.getSortedIssues(issues)) {
            String issueKey = issue.getKey();
            String description = issue.getDescription();
            String severity = issue.getSeverity().getStandardName();
            String category = issue.getId().getCategory().getStandardName();
            int lineNumber = issue.getLineNumber();
            String provider = issue.getProvider().getStandardName();
            Element affected = issue.getAffectedElement();
            String elementFQN = "n/a";
            String elementToFQN = "n/a";
            if (affected instanceof NamedElement) {
                elementFQN = ((NamedElement)affected).getFullyQualifiedName();
                elementToFQN = "n/a";
            } else if (affected instanceof Dependency) {
                Dependency dependency = (Dependency)affected;
                elementFQN = dependency.getUnderlyingFrom().getFullyQualifiedName();
                elementToFQN = dependency.getUnderlyingTo().getFullyQualifiedName();
            } else assert (false) : "Unexpected affected element: " + String.valueOf(affected);
            exportData.addRow(new Object[]{issueKey, description, severity, category, elementFQN, elementToFQN, lineNumber, provider});
        }
    }

    private List<IIssue> getAssociatedIssues(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getAssociatedIssues' must not be null";
        ArrayList<IIssue> associatedIssues = new ArrayList<IIssue>(resolution.getAssociatedIssues());
        Collections.sort(associatedIssues, new Comparator<IIssue>(){

            @Override
            public int compare(IIssue ia1, IIssue ia2) {
                String element1 = ExportExtension.this.getElement(ia1);
                String element2 = ExportExtension.this.getElement(ia2);
                return element1.compareTo(element2);
            }
        });
        return associatedIssues;
    }

    private void populateIgnoreDefinitions(ExportData exportData, List<IgnoreDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateIgnoreDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateIgnoreDefinitions' must not be null";
        exportData.addColumn("Ignore Definition");
        exportData.addColumn("Description");
        exportData.addColumn("Crated", ColumnDatatype.DATE);
        exportData.addColumn("Matched", ColumnDatatype.NUMBER);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new ResolutionComparator());
        for (IgnoreDefinition next : resolutions) {
            String type = next.getPresentationName(true) + " '" + next.getInformation() + "'";
            String description = next.getDescription();
            Date created = next.getDate();
            int matched = next.getMatchingElementsCount();
            exportData.addRow(new Object[]{type, description, created, matched, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.getAssociatedIssues(next)) {
                String elementType = this.getElementType(issue);
                String element = this.getElement(issue);
                String elementTo = this.getElementTo(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.getNamedElementIssuePattern(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.getDependencyIssuePatterns(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private ExportData populateMoveRefactorings(SoftwareSystem system, INamedElementResolver resolver, Collection<MoveRefactoringDefinition> resolutions) {
        ExportData result = new ExportData("Move Refacorings");
        result.addColumn("Action");
        result.addColumn("From Root");
        result.addColumn("From Name");
        result.addColumn("Target Root");
        result.addColumn("Target Name");
        result.addColumn("Rename To");
        result.addColumn("Resulting Name");
        for (MoveRefactoringDefinition mrd : resolutions) {
            String targetRootFqn = mrd.getTargetRootDirectoryFqName();
            RootDirectoryPath targetRoot = resolver.resolve(system, targetRootFqn, RootDirectoryPath.class);
            String toRoot = targetRoot.getName();
            for (IIssue issue : mrd.getAssociatedIssues()) {
                String action = switch (mrd.getRefactoringElementType()) {
                    case MoveRenameRefactoringElementType.COMPONENT -> "Move Component";
                    case MoveRenameRefactoringElementType.DIRECTORY -> "Move Directory";
                    case MoveRenameRefactoringElementType.ELEMENT -> "Move Element";
                    case MoveRenameRefactoringElementType.NAMESPACE -> "Move Namespace/Package";
                    default -> throw new MatchException(null, null);
                };
                NamedElement from = (NamedElement)issue.getAffectedElement();
                String fromRoot = from.getParent(RootDirectoryPath.class, new Class[0]).getName();
                String fromName = from.getOriginal().getName();
                String toName = mrd.getMoveToParentName();
                result.addRow(new Object[]{action, fromRoot, fromName, toRoot, toName, mrd.getNewName(), from.getName()});
            }
        }
        return result;
    }

    private List<ExportData> populateDeleteRefactorings(SoftwareSystem system, INamedElementResolver resolver, Collection<DeleteRefactoringDefinition> resolutions) {
        ExportData deleteRefactorings = new ExportData("Delete Refacorings");
        ExportData cutRefactorings = new ExportData("Cut Dependency Refactorings");
        deleteRefactorings.addColumn("Action");
        deleteRefactorings.addColumn("Element Root");
        deleteRefactorings.addColumn(NAMED_ELEMENT_NAME);
        deleteRefactorings.addColumn("Recursively");
        cutRefactorings.addColumn("Action");
        cutRefactorings.addColumn("Source");
        cutRefactorings.addColumn("Line", ColumnDatatype.NUMBER);
        cutRefactorings.addColumn("Target Element");
        for (DeleteRefactoringDefinition drd : resolutions) {
            for (IIssue issue : drd.getAssociatedIssues()) {
                Element element = issue.getAffectedElement();
                if (element instanceof NamedElement) {
                    NamedElement namedElement = (NamedElement)element;
                    String root = namedElement.getParent(RootDirectoryPath.class, new Class[0]).getName();
                    String name = element.getName();
                    String recursive = Boolean.toString(drd.isIncludingRecursiveElementChildren());
                    deleteRefactorings.addRow(new Object[]{"Delete", root, name, recursive});
                    continue;
                }
                if (!(element instanceof ParserDependency)) continue;
                ParserDependency dep = (ParserDependency)element;
                String source = dep.getFrom().getParent(SourceFile.class, new Class[0]).getName();
                int line = dep.getLineNumber();
                String target = dep.getTo().getName();
                cutRefactorings.addRow(new Object[]{"Cut Dependency", source, line, target});
            }
        }
        return List.of(deleteRefactorings, cutRefactorings);
    }

    private ExportData populateRenameRefactorings(SoftwareSystem system, INamedElementResolver resolver, Collection<RenameRefactoringDefinition> resolutions) {
        ExportData result = new ExportData("Rename Refacorings");
        result.addColumn("Action");
        result.addColumn("From Root");
        result.addColumn("From Name");
        result.addColumn("Rename To");
        result.addColumn("Resulting Name");
        for (RenameRefactoringDefinition mrd : resolutions) {
            for (IIssue issue : mrd.getAssociatedIssues()) {
                NamedElement from = (NamedElement)issue.getAffectedElement();
                String fromRoot = from.getParent(RootDirectoryPath.class, new Class[0]).getName();
                String fromName = from.getOriginal().getName();
                result.addRow(new Object[]{"Rename", fromRoot, fromName, mrd.getNewName(), from.getName()});
            }
        }
        return result;
    }

    private void populateRefactoringDefinitions(ExportData exportData, List<RefactoringDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateRefactoringDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateRefactoringDefinitions' must not be null";
        exportData.addColumn("Refactoring Definition");
        exportData.addColumn("Provider");
        exportData.addColumn("Status");
        exportData.addColumn("Description");
        exportData.addColumn("Information");
        exportData.addColumn("Priority");
        exportData.addColumn("Assignee");
        exportData.addColumn("Created", ColumnDatatype.DATE);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Potentially Done Element");
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new ResolutionComparator());
        for (RefactoringDefinition next : resolutions) {
            String type = next.getName();
            String provider = next.getProvider();
            String status = next.getStatus().getStandardName();
            String description = next.getDescription();
            String information = next.getInformation();
            String priority = next.getPriority().getStandardName();
            String assignee = next.getAssignee();
            Date date = next.getDate();
            exportData.addRow(new Object[]{type, provider, status, description, information, priority, assignee, date, null, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.getAssociatedIssues(next)) {
                String elementType = this.getElementType(issue);
                String element = this.getElement(issue);
                String elementTo = this.getElementTo(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null, null});
            }
            ArrayList<NamedElement> potentiallyDoneElements = new ArrayList<NamedElement>(next.getPotentiallyDoneElements());
            Collections.sort(potentiallyDoneElements, new Comparator<NamedElement>(){

                @Override
                public int compare(NamedElement ne1, NamedElement ne2) {
                    if (!$assertionsDisabled && ne1 == null) {
                        throw new AssertionError((Object)"Parameter 'ne1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && ne2 == null) {
                        throw new AssertionError((Object)"Parameter 'ne2' of method 'compare' must not be null");
                    }
                    return ne1.getFullyQualifiedName().compareTo(ne2.getFullyQualifiedName());
                }
            });
            for (NamedElement nextPotentiallyDone : potentiallyDoneElements) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextPotentiallyDone.getFullyQualifiedName(), null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.getNamedElementIssuePattern(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.getDependencyIssuePatterns(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private void populateTaskDefinitions(ExportData exportData, List<TaskDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateTaskDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateTaskDefinitions' must not be null";
        exportData.addColumn("Task Definition");
        exportData.addColumn("Description");
        exportData.addColumn("Information");
        exportData.addColumn("Priority");
        exportData.addColumn("Assignee");
        exportData.addColumn("Created", ColumnDatatype.DATE);
        exportData.addColumn("Matched", ColumnDatatype.NUMBER);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new ResolutionComparator());
        for (TaskDefinition next : resolutions) {
            String type = next.getPresentationName(true);
            String description = next.getDescription();
            String information = next.getInformation();
            String priority = next.getPriority().getStandardName();
            String assignee = next.getAssignee();
            Date created = next.getDate();
            int matched = next.getMatchingElementsCount();
            exportData.addRow(new Object[]{type, description, information, priority, assignee, created, matched, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.getAssociatedIssues(next)) {
                String elementType = this.getElementType(issue);
                String element = this.getElement(issue);
                String elementTo = this.getElementTo(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.getNamedElementIssuePattern(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.getDependencyIssuePatterns(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private String getElementTo(IIssue issue) {
        IWorkspaceDependencyElement to;
        assert (issue != null) : "'issue' of method 'getElementTo' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof ParserDependency) {
            ParserDependency dependency = (ParserDependency)affectedElement;
            return dependency.getTo().getFullyQualifiedName();
        }
        if (affectedElement instanceof WorkspaceDependency && (to = ((WorkspaceDependency)affectedElement).getTo()) != null) {
            return ((NamedElement)to.getUnderlyingObject()).getFullyQualifiedName();
        }
        return "n/a";
    }

    private String getElementType(IIssue issue) {
        assert (issue != null) : "'issue' of method 'getElementType' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof NamedElement) {
            return NAMED_ELEMENT_NAME;
        }
        if (affectedElement instanceof WorkspaceDependency) {
            return WORKSPACE_DEPENDENCY;
        }
        assert (affectedElement instanceof ParserDependency) : "Unexpected class: " + affectedElement.getClass().getName();
        return DEPENDENCY_NAME;
    }

    private String getElement(IIssue issue) {
        assert (issue != null) : "'issue' of method 'getElement' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof NamedElement) {
            return ((NamedElement)affectedElement).getFullyQualifiedName();
        }
        if (affectedElement instanceof WorkspaceDependency) {
            return ((NamedElement)((WorkspaceDependency)affectedElement).getFrom().getUnderlyingObject()).getFullyQualifiedName();
        }
        assert (affectedElement instanceof ParserDependency) : "Unexpected class: " + affectedElement.getClass().getName();
        ParserDependency dependency = (ParserDependency)affectedElement;
        return dependency.getFrom().getFullyQualifiedName();
    }

    private void populateParserDependencies(IContext context, ExportData exportData, List<ContextParserDependency> dependencies) {
        assert (context != null) : "Parameter 'context' of method 'populateParserDependencies' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateParserDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'populateParserDependencies' must not be null";
        exportData.addColumn("From Module");
        exportData.addColumn("From File");
        exportData.addColumn("Line", ColumnDatatype.NUMBER, Sort.DESCENDING);
        exportData.addColumn("From");
        exportData.addColumn(DEPENDENCY_NAME);
        exportData.addColumn("To Module");
        exportData.addColumn("To File");
        exportData.addColumn("To");
        exportData.addColumn("Violation Info");
        for (ContextParserDependency next : dependencies) {
            ComponentContainer fromModule = next.getFrom().getParent(ComponentContainer.class, new Class[0]);
            ComponentContainer toModule = next.getFrom().getParent(ComponentContainer.class, new Class[0]);
            FilePath fromFilePath = next.getFrom().getParent(FilePath.class, ParentMode.FIRST_PARENT);
            String fromFile = fromFilePath != null ? fromFilePath.getIdentifyingPath() : null;
            int line = next.getLineNumber();
            String from = next.getFrom().getPresentationName(false);
            String dependency = next.getDependencyInfo();
            String to = next.getTo().getPresentationName(false);
            FilePath toFilePath = next.getTo().getParent(FilePath.class, ParentMode.FIRST_PARENT);
            String toFile = toFilePath != null ? toFilePath.getIdentifyingPath() : null;
            String violation = next.isViolation() ? context.getViolationInfo(next.getElement()) : "";
            exportData.addRow(new Object[]{fromModule.getShortName(), fromFile, line, from, dependency, toModule.getShortName(), toFile, to, violation});
        }
    }

    private void populatePairs(ExportData exportData, List<Pair<String, String>> propertiesList) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populatePairs' must not be null";
        assert (propertiesList != null) : "Parameter 'propertiesList' of method 'populatePairs' must not be null";
        exportData.addColumn("Property");
        exportData.addColumn("Value");
        for (Pair<String, String> property : propertiesList) {
            exportData.addRow(new Object[]{property.getFirst(), property.getSecond()});
        }
    }

    @Override
    public void export(TFile file, List<ExportData> exportDataList) {
        List<ExportData> exportDataToUse;
        assert (file != null) : "Parameter 'file' of method 'export' must not be null";
        assert (exportDataList != null) : "Parameter 'exportDataList' of method 'export' must not be null";
        ISoftwareSystemProvider provider = this.m_installation.getExtension(ISoftwareSystemProvider.class);
        if (provider.hasSoftwareSystem()) {
            SoftwareSystem system = provider.getSoftwareSystem();
            ExportData systemInfo = new ExportData("System Info");
            systemInfo.addColumn("System");
            systemInfo.addColumn("Virtual Model");
            systemInfo.addColumn("Absolute Path");
            systemInfo.addColumn("Exported", ColumnDatatype.DATE);
            ModifiableModel modifiableModel = system.getCurrentModel(ModifiableModel.class);
            systemInfo.addRow(new Object[]{system.getFullyQualifiedName(), modifiableModel != null ? modifiableModel.getIdentifyingPath() : "Parser", system.getAbsolutePath(), new Date()});
            exportDataToUse = new ArrayList<ExportData>(exportDataList.size() + 1);
            exportDataToUse.add(systemInfo);
            exportDataToUse.addAll(exportDataList);
        } else {
            exportDataToUse = exportDataList;
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ExportStartedEvent(provider));
        WriteExcelExportExecutor exportExecutor = new WriteExcelExportExecutor();
        exportExecutor.run(file, exportDataToUse, new WriteExcelExportExecutor.IListener(){

            @Override
            public void executorFinished(OperationResultWithOutcome<TFile> result) {
                EventManager.getInstance().dispatch((Object)this, (Event)new ExportFinishedEvent(ExportExtension.this.m_installation.getExtension(ISoftwareSystemProvider.class), result));
            }
        });
        if (this.m_backgroundTaskExecutionMode == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            exportExecutor.awaitCompletion();
        }
    }

    @Override
    public List<ExportData> getMetrics(Collection<? extends NamedElement> elements, Set<IMetricDescriptor> metricDescriptors, Map<MetricAccessKey, IMetricValue> keyToValue, String scope) {
        assert (elements != null) : "Parameter 'elements' of method 'getMetrics' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'getMetrics' must not be null";
        assert (keyToValue != null) : "Parameter 'keyToValue' of method 'getMetrics' must not be null";
        assert (scope != null && scope.length() > 0) : "Parameter 'scope' of method 'getMetrics' must not be empty";
        if (metricDescriptors.isEmpty() || keyToValue.isEmpty()) {
            return Collections.emptyList();
        }
        ExportData exportData = new ExportData("Metrics", "Scope: " + scope);
        exportData.addColumn(NAMED_ELEMENT_NAME, ColumnDatatype.TEXT);
        Sort sort = Sort.DESCENDING;
        for (IMetricDescriptor iMetricDescriptor : metricDescriptors) {
            exportData.addColumn(iMetricDescriptor.getShortName(), ColumnDatatype.NUMBER, sort);
            sort = Sort.NONE;
        }
        for (NamedElement namedElement : elements) {
            Object[] rowData = new Object[1 + metricDescriptors.size()];
            int i = 0;
            rowData[i++] = namedElement.getName();
            for (IMetricDescriptor metric : metricDescriptors) {
                MetricAccessKey key = new MetricAccessKey(namedElement, metric.getShortName());
                IMetricValue value = keyToValue.get(key);
                Object object = rowData[i++] = value == null ? (Number)null : (Number)value.getValue();
            }
            exportData.addRow(rowData);
        }
        return List.of(exportData);
    }

    @Override
    public List<ExportData> getAllMetrics(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getAllMetrics' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = this.m_installation.getExtension(ISoftwareSystemProvider.class);
        if (!softwareSystemProvider.hasSoftwareSystem()) {
            return Collections.emptyList();
        }
        SoftwareSystem softwareSystem = softwareSystemProvider.getSoftwareSystem();
        IMetricsExtension metricsExtension = this.m_installation.getExtension(IMetricsExtension.class);
        IThresholdProvider thresholdProvider = softwareSystem.getExtension(IThresholdProvider.class);
        THashMap elementToFullyQualifiedName = new THashMap();
        workerContext.setNumberOfSteps(2, new int[]{5, 95});
        workerContext.beginSubTask("Get all System Level Metrics");
        ArrayList<ExportData> result = new ArrayList<ExportData>();
        ExportData systemLevel = new ExportData("System");
        List<IMetricDescriptor> systemMetrics = metricsExtension.getAvailableSystemMetrics(true);
        this.populateSystemMetrics(workerContext, thresholdProvider, metricsExtension, softwareSystem, systemLevel, systemMetrics);
        result.add(systemLevel);
        workerContext.endSubTask();
        workerContext.beginSubTask("Get all Element Level Metrics");
        List<IMetricLevel> levels = metricsExtension.getAvailableElementMetricLevels(false, true);
        workerContext.setNumberOfSteps(levels.size());
        for (IMetricLevel metricLevel : levels) {
            workerContext.beginSubTask("Get all Element Level Metrics - " + metricLevel.getPresentationName());
            ExportData elementLevelExportData = new ExportData(metricLevel.getStandardName());
            this.populateLevelMetrics(workerContext, thresholdProvider, metricsExtension, softwareSystem, elementLevelExportData, metricLevel, (Map<NamedElement, String>)elementToFullyQualifiedName);
            result.add(elementLevelExportData);
            workerContext.endSubTask();
        }
        workerContext.endSubTask();
        return result;
    }

    @Override
    public List<ExportData> getIgnoreDefinitions(Collection<IgnoreDefinition> ignoreDefinitions) {
        assert (ignoreDefinitions != null) : "Parameter 'ignoreDefinitions' of method 'getIgnoreDefinitions' must not be null";
        ExportData exportData = new ExportData("Ignore Definitions");
        this.populateIgnoreDefinitions(exportData, new ArrayList<IgnoreDefinition>(ignoreDefinitions));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getTaskDefinitions(Collection<TaskDefinition> taskDefinitions) {
        assert (taskDefinitions != null) : "Parameter 'taskDefinitions' of method 'getTaskDefinitions' must not be null";
        ExportData exportData = new ExportData("Task Definitions");
        this.populateTaskDefinitions(exportData, new ArrayList<TaskDefinition>(taskDefinitions));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getRefactoringDefintions(Collection<? extends RefactoringDefinition> refactoringDefinitions) {
        ExportData ed;
        assert (refactoringDefinitions != null) : "Parameter 'refactoringDefinitions' of method 'getRefactoringDefintions' must not be null";
        ExportData exportData = new ExportData("Refactoring Definitions");
        this.populateRefactoringDefinitions(exportData, new ArrayList<RefactoringDefinition>(refactoringDefinitions));
        List<RefactoringDefinition> applicableRefactorings = refactoringDefinitions.stream().filter(rd -> rd.getStatus() == StatusInfo.Status.APPLICABLE || rd.getStatus() == StatusInfo.Status.PARTIALLY_APPLICABLE).toList();
        if (applicableRefactorings.isEmpty()) {
            return List.of(exportData);
        }
        ArrayList<DeleteRefactoringDefinition> deleteRefactorings = new ArrayList<DeleteRefactoringDefinition>();
        ArrayList<MoveRefactoringDefinition> moveRefactorings = new ArrayList<MoveRefactoringDefinition>();
        ArrayList<RenameRefactoringDefinition> renameRefactorings = new ArrayList<RenameRefactoringDefinition>();
        ArrayList<ExportData> result = new ArrayList<ExportData>();
        ISoftwareSystemProvider provider = this.m_installation.getExtension(ISoftwareSystemProvider.class);
        INamedElementResolver resolver = provider.getElementResolver();
        SoftwareSystem system = provider.getSoftwareSystem();
        assert (system != null);
        result.add(exportData);
        for (RefactoringDefinition rd2 : applicableRefactorings) {
            if (rd2 instanceof DeleteRefactoringDefinition) {
                DeleteRefactoringDefinition d = (DeleteRefactoringDefinition)rd2;
                deleteRefactorings.add(d);
                continue;
            }
            if (rd2 instanceof MoveRefactoringDefinition) {
                MoveRefactoringDefinition d = (MoveRefactoringDefinition)rd2;
                moveRefactorings.add(d);
                continue;
            }
            if (rd2 instanceof RenameRefactoringDefinition) {
                RenameRefactoringDefinition d = (RenameRefactoringDefinition)rd2;
                renameRefactorings.add(d);
                continue;
            }
            assert (false) : "Unexptected class " + rd2.getClass().getName();
        }
        if (!moveRefactorings.isEmpty() && (ed = this.populateMoveRefactorings(system, resolver, moveRefactorings)) != null) {
            result.add(ed);
        }
        if (!renameRefactorings.isEmpty() && (ed = this.populateRenameRefactorings(system, resolver, renameRefactorings)) != null) {
            result.add(ed);
        }
        if (!deleteRefactorings.isEmpty()) {
            result.addAll(this.populateDeleteRefactorings(system, resolver, deleteRefactorings));
        }
        return result;
    }

    @Override
    public List<ExportData> getParserDependencies(IContext context, Collection<ContextParserDependency> dependencies) {
        assert (context != null) : "Parameter 'context' of method 'getParserDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getParserDependencies' must not be null";
        ExportData exportData = new ExportData("Parser Dependencies");
        this.populateParserDependencies(context, exportData, new ArrayList<ContextParserDependency>(dependencies));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getIssues(Collection<? extends Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'getIssues' must not be null";
        ExportData exportData = new ExportData("Issues", "Issues");
        this.populateIssues(exportData, new ArrayList<Issue>(issues));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getProperties(IContext context, Element element) {
        assert (context != null) : "Parameter 'context' of method 'getProperties' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getProperties' must not be null";
        ExportData exportData = new ExportData("Properties", this.getIdentification(element));
        this.populatePairs(exportData, this.m_propertiesExtension.getProperties(context, element));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getRankedIssues(Collection<IssueRank> rankedIssues) {
        assert (rankedIssues != null) : "Parameter 'rankedIssues' of method 'getRankedIssues' must not be null";
        ExportData exportData = new ExportData("Ranked Issues", "Ranked Issues");
        exportData.addColumn("Score", ColumnDatatype.NUMBER, Sort.DESCENDING);
        exportData.addColumn("Urgency", ColumnDatatype.NUMBER);
        exportData.addColumn("Importance", ColumnDatatype.NUMBER);
        exportData.addColumn("Issue Key");
        exportData.addColumn("Description");
        exportData.addColumn("Severity");
        exportData.addColumn("Category");
        exportData.addColumn(NAMED_ELEMENT_NAME);
        exportData.addColumn("To Element");
        exportData.addColumn("Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Provider");
        for (IssueRank next : rankedIssues) {
            Float score = Float.valueOf(next.getScoreValue());
            Float urgency = Float.valueOf(next.getUrgencyValue());
            Float importance = Float.valueOf(next.getImportanceValue());
            Issue issue = (Issue)next.getRankedElement();
            String issueKey = issue.getKey();
            String description = issue.getDescription();
            String severity = issue.getSeverity().getStandardName();
            String category = issue.getId().getCategory().getStandardName();
            int lineNumber = issue.getLineNumber();
            String provider = issue.getProvider().getStandardName();
            Element affected = issue.getAffectedElement();
            String elementFQN = "n/a";
            String elementToFQN = "n/a";
            if (affected instanceof NamedElement) {
                elementFQN = ((NamedElement)affected).getFullyQualifiedName();
                elementToFQN = "n/a";
            } else if (affected instanceof Dependency) {
                Dependency dependency = (Dependency)affected;
                elementFQN = dependency.getUnderlyingFrom().getFullyQualifiedName();
                elementToFQN = dependency.getUnderlyingTo().getFullyQualifiedName();
            } else assert (false) : "Unexpected affected element: " + String.valueOf(affected);
            exportData.addRow(new Object[]{score, urgency, importance, issueKey, description, severity, category, elementFQN, elementToFQN, lineNumber, provider});
        }
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getLeafElementData(TreeMapRepresentation treeMap, Collection<TreeMapNode<NamedElement, TreeMapNodeData>> leafs) {
        assert (treeMap != null) : "Parameter 'treeMap' of method 'getLeafElementData' must not be null";
        assert (leafs != null) : "Parameter 'leafs' of method 'getLeafElementData' must not be null";
        ExportData exportData = new ExportData(treeMap.getParent().getPresentationName(true), "Leaf Elements");
        exportData.addColumn(treeMap.getLeafElement());
        exportData.addColumn(treeMap.getColorAttribute(), ColumnDatatype.NUMBER);
        exportData.addColumn(treeMap.getSizeAttribute(), ColumnDatatype.NUMBER);
        if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL) {
            exportData.addColumn(treeMap.getHeightAttribute(), ColumnDatatype.NUMBER);
        }
        ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>> sorted = new ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>>(leafs);
        Collections.sort(sorted, (l1, l2) -> {
            int value1 = ((TreeMapNodeData)l1.getAssociatedData()).getLeafColorInfoProvider().getValue();
            int value2 = ((TreeMapNodeData)l2.getAssociatedData()).getLeafColorInfoProvider().getValue();
            return Integer.compare(value2, value1);
        });
        for (TreeMapNode treeMapNode : sorted) {
            String name = ((NamedElement)treeMapNode.getAssociatedElement()).getPresentationName(false);
            Integer colorValue = ((TreeMapNodeData)treeMapNode.getAssociatedData()).getLeafColorInfoProvider().getValue();
            Integer sizeValue = Math.round(treeMapNode.getSize());
            if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL) {
                Integer heightValue = ((TreeMapNodeData)treeMapNode.getAssociatedData()).getLeafHeightInfoProvider().getValue();
                exportData.addRow(new Object[]{name, colorValue, sizeValue, heightValue});
                continue;
            }
            exportData.addRow(new Object[]{name, colorValue, sizeValue});
        }
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getTemporalCouplingLinks(SourceFile from, Collection<TemporalCouplingLink> links) {
        assert (from != null) : "Parameter 'from' of method 'getTemporalCouplingLinks' must not be null";
        assert (links != null && links.size() > 0) : "Parameter 'links' of method 'getTemporalCouplingLinks' must not be empty";
        ExportData data = new ExportData("Temporal Coupling", "From: " + from.getIdentifyingPath());
        data.addColumn("Path");
        data.addColumn("Weight", ColumnDatatype.NUMBER);
        for (TemporalCouplingLink link : links) {
            data.addRow(new Object[]{link.getSource().getIdentifyingPath(), link.getWeight()});
        }
        return Collections.singletonList(data);
    }

    @Override
    public List<ExportData> getExplorationViewInfo(ExplorationViewRepresentation representation, IWorkerContext workerContext) {
        assert (representation != null) : "Parameter 'representation' of method 'getExplorationViewInfo' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getExplorationViewInfo' must not be null";
        ExplorationViewRepresentationExcelExportVisitor visitor = new ExplorationViewRepresentationExcelExportVisitor(workerContext);
        representation.accept(visitor);
        return visitor.getResult();
    }

    private static final class ResolutionComparator
    implements Comparator<Resolution> {
        ResolutionComparator() {
        }

        @Override
        public int compare(Resolution r1, Resolution r2) {
            assert (r1 != null) : "Parameter 'r1' of method 'compare' must not be null";
            assert (r2 != null) : "Parameter 'r2' of method 'compare' must not be null";
            return r1.getDate().compareTo(r2.getDate());
        }
    }
}

