/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IDependenciesExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependencyCollector;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingNode;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class DependenciesExtension
extends Extension
implements IDependenciesExtension {
    private final SoftwareSystem m_softwareSystem;

    DependenciesExtension(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'DependencyExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    private FilePath getSourceForElement(Element element) {
        NamedElement namedElement;
        Language usedLanguage;
        assert (element != null) : "Parameter 'element' of method 'getSourceForElement' must not be null";
        if (element instanceof NamedElement && (usedLanguage = (namedElement = (NamedElement)element).getLanguage()) != null) {
            ILanguageProvider languageProvider = this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getLanguageProvider(usedLanguage);
            return languageProvider.getSourceFile(namedElement);
        }
        return null;
    }

    private void collect(IWorkerContext workerContext, IContext context, Collection<ParserDependency> dependencies, ContextParserDependencyCollector collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collect' must not be null";
        assert (context != null) : "Parameter 'context' of method 'collect' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'collect' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collect' must not be null";
        for (ParserDependency next : dependencies) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            ContextParserDependency nextCreated = context.create(next);
            if (nextCreated == null) continue;
            collector.addDependency(nextCreated);
        }
    }

    @Override
    public ContextParserDependencyCollector collectIncomingDependencies(IWorkerContext workerContext, IContext context, Element element) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectIncomingDependencies' must not be null";
        assert (context != null) : "Parameter 'context' of method 'collectIncomingDependencies' must not be null";
        assert (element != null) : "Parameter 'element' of method 'collectIncomingDependencies' must not be null";
        ContextParserDependencyCollector collector = new ContextParserDependencyCollector();
        if (element instanceof IParserDependenciesProvidingEdge) {
            this.collect(workerContext, context, ((IParserDependenciesProvidingEdge)((Object)element)).getParserDependencies(), collector);
        } else if (element instanceof IParserDependenciesProvidingNode) {
            this.collect(workerContext, context, ((IParserDependenciesProvidingNode)((Object)element)).getIncomingParserDependencies(), collector);
        } else {
            FilePath filePath = this.getSourceForElement(element);
            if (filePath != null) {
                for (ProgrammingElement next : filePath.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                    if (workerContext.hasBeenCanceled()) break;
                    this.collect(workerContext, context, next.getIncomingDependencies(new IStandardEnumeration[0]), collector);
                }
            }
        }
        collector.finish(workerContext.hasBeenCanceled());
        return collector;
    }

    @Override
    public ContextParserDependencyCollector collectOutgoingDependencies(IWorkerContext workerContext, IContext context, Element element) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectOutgoingDependencies' must not be null";
        assert (context != null) : "Parameter 'context' of method 'collectOutgoingDependencies' must not be null";
        assert (element != null) : "Parameter 'element' of method 'collectOutgoingDependencies' must not be null";
        ContextParserDependencyCollector collector = new ContextParserDependencyCollector();
        if (element instanceof IParserDependenciesProvidingEdge) {
            this.collect(workerContext, context, ((IParserDependenciesProvidingEdge)((Object)element)).getParserDependencies(), collector);
        } else if (element instanceof IParserDependenciesProvidingNode) {
            this.collect(workerContext, context, ((IParserDependenciesProvidingNode)((Object)element)).getOutgoingParserDependencies(), collector);
        } else {
            FilePath filePath = this.getSourceForElement(element);
            if (filePath != null) {
                for (ProgrammingElement next : filePath.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                    if (workerContext.hasBeenCanceled()) break;
                    this.collect(workerContext, context, next.getOutgoingDependencies(new IParserDependencyType[0]), collector);
                }
            }
        }
        collector.finish(workerContext.hasBeenCanceled());
        return collector;
    }

    @Override
    public Set<ParserDependency> getParserDependencies(AnalyzerCycleGroup cycleGroup) {
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'getParserDependencies' must not be null";
        THashSet parserDependencies = new THashSet();
        THashMap cyclicToRelevantProgrammingElements = new THashMap();
        IIssueId issueId = cycleGroup.getCycleGroupIssueId();
        if (CoreIssueId.NAMESPACE_CYCLE_GROUP.equals(issueId)) {
            for (NamedElement namedElement : cycleGroup.getCyclicNamedElements()) {
                assert (namedElement != null && namedElement instanceof LogicalNamespace) : "Unexpected class in method 'getParserDependencies': " + String.valueOf(namedElement);
                nextProgrammingElements = new THashSet();
                nextProgrammingElements.addAll(((LogicalNamespace)namedElement).getAllProgrammingElements());
                cyclicToRelevantProgrammingElements.put(namedElement, nextProgrammingElements);
            }
        } else if (CoreIssueId.LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP.equals(issueId)) {
            for (NamedElement namedElement : cycleGroup.getCyclicNamedElements()) {
                assert (namedElement != null && namedElement instanceof LogicalProgrammingElement) : "Unexpected class in method 'getParserDependencies': " + String.valueOf(namedElement);
                nextProgrammingElements = new THashSet();
                nextProgrammingElements.addAll(((LogicalProgrammingElement)namedElement).getProgrammingElements());
                for (LogicalProgrammingElement nextLogicalProgrammingElement : namedElement.getChildrenRecursively(LogicalProgrammingElement.class, new Class[0])) {
                    nextProgrammingElements.addAll(nextLogicalProgrammingElement.getProgrammingElements());
                }
                cyclicToRelevantProgrammingElements.put(namedElement, nextProgrammingElements);
            }
        } else if (CoreIssueId.DIRECTORY_CYCLE_GROUP.equals(issueId)) {
            for (NamedElement namedElement : cycleGroup.getCyclicNamedElements()) {
                nextProgrammingElements = new THashSet();
                for (IComponent nextComponent : namedElement.getChildren(IComponent.class)) {
                    nextProgrammingElements.addAll(nextComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0]));
                }
                cyclicToRelevantProgrammingElements.put(namedElement, nextProgrammingElements);
            }
        } else if (CoreIssueId.COMPONENT_CYCLE_GROUP.equals(issueId) || CoreIssueId.MODULE_CYCLE_GROUP.equals(issueId)) {
            for (NamedElement namedElement : cycleGroup.getCyclicNamedElements()) {
                cyclicToRelevantProgrammingElements.put(namedElement, new THashSet(namedElement.getChildrenRecursively(ProgrammingElement.class, new Class[0])));
            }
        } else assert (false) : "Unhandled cycle group: " + String.valueOf(issueId);
        for (Map.Entry entry : cyclicToRelevantProgrammingElements.entrySet()) {
            NamedElement nextFromCyclic = (NamedElement)entry.getKey();
            for (ProgrammingElement nextFromProgrammingElement : (Set)entry.getValue()) {
                block8: for (ParserDependency nextOut : nextFromProgrammingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                    for (Map.Entry nextToEntry : cyclicToRelevantProgrammingElements.entrySet()) {
                        Set nextToProgrammingElements;
                        NamedElement nextToCyclic = (NamedElement)nextToEntry.getKey();
                        if (nextFromCyclic == nextToCyclic || !(nextToProgrammingElements = (Set)nextToEntry.getValue()).contains(nextOut.getTo())) continue;
                        parserDependencies.add(nextOut);
                        continue block8;
                    }
                }
            }
        }
        return parserDependencies;
    }
}

