/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitectureMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureProvider;
import com.hello2morrow.sonargraph.core.controller.system.IFinishModelRefreshProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.ModuleBasedArchitectureFileContentGenerator;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ApplyAndRequireSupport;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureFileLoader;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureFilterNameRetriever;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableCollector;
import com.hello2morrow.sonargraph.core.controller.system.architecture.FileNameRetriever;
import com.hello2morrow.sonargraph.core.controller.system.architecture.PhysicalFilterNameRetriever;
import com.hello2morrow.sonargraph.core.controller.system.architecture.WorkspaceFilterNameRetriever;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IArchitectureFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckConfigurationInconsistent;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IClearableArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectoryPathCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureFilePersistence;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureXmlPersistence;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureExtension
extends ArchitectureProvider
implements IModifiableFileProvider,
IModifiableFileDeltaKey,
IArchitectureExtension,
IArchitectureFileProvider,
IQualityModelProvider,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureExtension.class);
    public static final LinkedHashSet<AnalyzerGroup> GROUPS = new LinkedHashSet<AnalyzerGroup>(Arrays.asList(AnalyzerGroup.ARCHITECTURE, AnalyzerGroup.ARCHITECTURE_METRICS));
    private final IFinishModelRefreshProcessor m_finishModelProcessor;
    private final Map<String, IAssignableAttributeRetriever> m_assignableAttributeRetrievers = new THashMap();

    public ArchitectureExtension(Installation installation, SoftwareSystem softwareSystem, List<IAssignableAttributeRetriever> retrievers, IFinishModelRefreshProcessor finishModelProcessor) {
        super(installation, softwareSystem);
        assert (retrievers != null) : "Parameter 'retrievers' of method 'ArchitectureExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ArchitectureExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        LinkedHashSet<IAssignableAttributeRetriever> allRetrievers = new LinkedHashSet<IAssignableAttributeRetriever>(ArchitectureExtension.createCoreAssignableAttributeRetrievers());
        allRetrievers.addAll(retrievers);
        for (IAssignableAttributeRetriever next : allRetrievers) {
            IAssignableAttributeRetriever previous = this.m_assignableAttributeRetrievers.put(next.getName(), next);
            assert (previous == null) : "Duplicate attribute retriever: " + String.valueOf(next);
        }
        this.m_finishModelProcessor.addListener(this);
    }

    public static List<IAssignableAttributeRetriever> createCoreAssignableAttributeRetrievers() {
        return Arrays.asList(new ArchitectureFilterNameRetriever(), new PhysicalFilterNameRetriever(), new WorkspaceFilterNameRetriever(), new FileNameRetriever());
    }

    @Override
    public String getDefaultRetrieverName() {
        return "ArchitectureFilterName";
    }

    @Override
    public AnalyzerConfigurationFile getArchitectureCheckConfigurationFile() {
        return this.getSoftwareSystem().getExtension(IAnalyzerController.class).getAnalyzerConfigurationFile(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        Architecture architecture = this.getArchitectureDirectory();
        architecture.enforceExistence(result);
        if (result.isSuccess() && (SoftwareSystemFilesDirectory.isOutOfSync(this.getArchitectureCheckConfigurationFile()) || architecture.isOutOfSync(new String[][]{CoreFileType.ARCHITECTURE.getExtensions()}))) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    private OperationResult addArchitectureFile(TFile contentFile, TFile modelFile, ArchitectureFile architectureFile, boolean saveToDisk) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addArchitectureFile' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addArchitectureFile' must not be null";
        OperationResult result = new OperationResult("Add Architecture File");
        ArchitectureFilePersistence persistence = this.getPersistence();
        if (architectureFile == null) {
            Architecture architecture = this.getArchitectureDirectory();
            TFile architectureDirectory = architecture.getFile();
            String archName = modelFile.getName();
            String archRelPath = "./" + archName;
            architectureFile = architecture.getFirstChild(new NameFilter(archRelPath), ArchitectureFile.class);
            assert (architectureFile == null) : "File should not be there: " + archName;
            architectureFile = new ArchitectureFile(architecture, new TFile((File)architectureDirectory, archName), contentFile.lastModified(), this.getSoftwareSystem().getUniqueExistingChild(Files.class));
            architecture.addChild(architectureFile);
            this.addArchitectureFile(architectureFile);
            persistence.load(contentFile, architectureFile, result);
        } else {
            persistence.load(contentFile, architectureFile, result);
            architectureFile.reloaded(contentFile.lastModified(), false);
        }
        if (saveToDisk) {
            OperationResult saveResult = persistence.save(architectureFile, modelFile);
            result.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                architectureFile.setExistsOnDisk(true);
                architectureFile.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        this.addArchitectureFileContentForCompilation(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        return result;
    }

    @Override
    public Set<IAnalyzerId> getAffectedAnalyzerIdsOnModifiableFileInterchange() {
        return Collections.singleton(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        THashSet identifyingPaths = new THashSet();
        final Architecture architectureDirectory = this.getArchitectureDirectory();
        architectureDirectory.checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider((Set)identifyingPaths, result){
            private final /* synthetic */ Set val$identifyingPaths;
            private final /* synthetic */ PrepareRefreshResult val$result;
            {
                this.val$identifyingPaths = set;
                this.val$result = prepareRefreshResult;
            }

            @Override
            public IModifiableFileDeltaKey getKey() {
                return ArchitectureExtension.this;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return architectureDirectory;
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.ARCHITECTURE);
            }

            @Override
            public boolean accept(TFile file) {
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                String identifyingPath = FileUtility.calculateRelativePath((TFile)file, (TFile)architectureDirectory.getFile());
                String normalizedIdentifyingPath = identifyingPath.toLowerCase();
                if (this.val$identifyingPaths.add(normalizedIdentifyingPath)) {
                    return true;
                }
                this.val$result.addWarning(ArchitectureMessageCause.IGNORED_ARCHITECTURE_FILE, "Ignored '" + identifyingPath + "' which differs only in case from already processed architecture file.", new Object[0]);
                return false;
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return ArchitectureFile.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return ArchitectureExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof ArchitectureFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                TFile file = modified.getFile();
                ArchitectureExtension.this.addArchitectureFile(file, file, (ArchitectureFile)modified, false);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof ArchitectureFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                ArchitectureFile doomed = (ArchitectureFile)deleted;
                ArchitectureExtension.this.removeArchitectureFile(doomed.getIdentifyingPath());
                doomed.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                ArchitectureExtension.this.addArchitectureFile(file, file, null, false);
            }

            @Override
            public void visitAdded(ModifiableDirectoryPathCandidate added) {
            }

            @Override
            public void visitDeleted(IModifiableDirectory deleted) {
            }
        }, true);
        if (delta.containsFiles(this) && modifications != null) {
            this.checkArchitectureCheckConfiguration();
            this.reCompile(workerContext);
        }
    }

    private void compile() {
        List<ArchitectureFile> availableArchitectureFiles = this.getAvailableArchitectureFiles();
        if (!availableArchitectureFiles.isEmpty()) {
            availableArchitectureFiles.forEach(a -> a.clear(false));
            ArchitectureFileLoader loader = new ArchitectureFileLoader(this);
            for (ArchitectureFile next : availableArchitectureFiles) {
                if (next.modelLoaded()) continue;
                loader.loadArchitectureFile(next);
            }
        }
    }

    @Override
    public EnumSet<IArchitecturalModelProvider.ArchitectureModel> getSupportedModels() {
        EnumSet<IArchitecturalModelProvider.ArchitectureModel> supportedModels = EnumSet.allOf(IArchitecturalModelProvider.ArchitectureModel.class);
        for (Language nextLanguage : this.getSoftwareSystem().getUsedLanguages()) {
            if (nextLanguage.hasLogicalModel()) continue;
            supportedModels.remove((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
        }
        return supportedModels;
    }

    @Override
    public String getUsedLanguages() {
        return StringUtility.concat((Collection)this.getSoftwareSystem().getUsedLanguages().stream().map(l -> l.getPresentationName()).collect(Collectors.toList()), (String)",");
    }

    void reCompile(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'reCompile' must not be null";
        List<ArchitectureFile> checked = this.resetComponentAssignment(true);
        this.compile();
        this.assignComponents(workerContext, checked);
    }

    private boolean feedComponent(ArchitectureFile architectureFile, IAssignableToArtifact element) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'feedComponent' must not be null";
        assert (element != null) : "Parameter 'element' of method 'feedComponent' must not be null";
        for (Artifact consumer : architectureFile.getArtifactsByPriority()) {
            Artifact.Match match = consumer.offerComponent(element);
            if (match == null) continue;
            match.getFinalOwner().assignComponent(element);
            return true;
        }
        List<UnassignedElements> unassignedNodes = architectureFile.getChildren(UnassignedElements.class);
        assert (unassignedNodes.size() == 2) : "Missing unassigned nodes for " + architectureFile.getName();
        if (element.isExternal()) {
            unassignedNodes.get(1).assignComponent(element);
        } else {
            unassignedNodes.get(0).assignComponent(element);
        }
        return false;
    }

    @Override
    public Collection<IAssignableToArtifact> getUnassignedInternalComponents(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedInternalComponents' must not be null";
        UnassignedInternal unassignedNode = this.getUnassignedInternalNode(model);
        return unassignedNode == null ? Collections.emptyList() : unassignedNode.getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> getUnassignedExternalComponents(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedExternalComponents' must not be null";
        UnassignedExternal unassignedNode = this.getUnassignedExternalNode(model);
        return unassignedNode == null ? Collections.emptyList() : unassignedNode.getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> getUnassignedInternalComponents(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getUnassignedInternalComponents' must not be null";
        return architectureFile.getUniqueExistingChild(UnassignedInternal.class).getAssignedElements();
    }

    @Override
    public Collection<IAssignableToArtifact> getUnassignedExternalComponents(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getUnassignedExternalComponents' must not be null";
        return architectureFile.getUniqueExistingChild(UnassignedExternal.class).getAssignedElements();
    }

    private void checkArchitectureCheckConfiguration() {
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.getAnalyzerConfigurationFile(CoreAnalyzerId.ARCHITECTURE_CHECK);
        if (analyzerConfigurationFile != null) {
            analyzerConfigurationFile.removeIssues();
            AnalyzerConfiguration configuration = analyzerExtension.getConfiguration(CoreAnalyzerId.ARCHITECTURE_CHECK);
            if (configuration != null) {
                Map<String, ArchitectureFile> identifyingPathToArchitectureFile = this.getAvailableArchitectureFiles().stream().collect(Collectors.toMap(ModifiableFile::getIdentifyingPath, a -> a));
                assert (configuration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'checkArchitectureCheckConfiguration': " + String.valueOf(configuration);
                ArchitectureCheckConfiguration architectureCheckConfiguration = (ArchitectureCheckConfiguration)configuration;
                architectureCheckConfiguration.resetWarnings();
                for (String nextIdentifyingPath : architectureCheckConfiguration.getIdentifyingPaths()) {
                    if (identifyingPathToArchitectureFile.containsKey(nextIdentifyingPath)) continue;
                    analyzerConfigurationFile.addIssue(new ArchitectureCheckConfigurationInconsistent(analyzerConfigurationFile, "Architecture file '" + nextIdentifyingPath + "' not found."));
                    architectureCheckConfiguration.setWarning(nextIdentifyingPath, "Architecture file not found.");
                }
            }
        }
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        this.checkArchitectureCheckConfiguration();
    }

    private void clearAllIssues(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'clearAllIssues' must not be null";
        architectureFile.getChildrenRecursively(ArchitectureElement.class, new Class[0]).forEach(a -> a.removeIssues());
        architectureFile.removeIssues(CoreIssueId.ARCHITECTURE_FILE_ERROR, CoreIssueId.ARCHITECTURE_FILE_WARNING);
    }

    private List<ArchitectureFile> resetComponentAssignment(boolean resetChecked) {
        List<ArchitectureFile> checked;
        LOGGER.debug("Reset component assignment");
        List<ArchitectureFile> available = this.getAvailableArchitectureFiles();
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
        if (configuration != null) {
            checked = new ArrayList();
            for (ArchitectureFile nextAvailable : available) {
                nextAvailable.clear(true);
                nextAvailable.setHasDeprecations(false);
                nextAvailable.setHasViolations(false);
                nextAvailable.getChildrenRecursively(ArchitectureElement.class, new Class[0]).forEach(a -> a.removeIssues(CoreIssueId.CYCLIC_ARTIFACT, CoreIssueId.DEPRECATED_ARTIFACT_NOT_EMPTY, CoreIssueId.EMPTY_ARCHITECTURE_ELEMENT, CoreIssueId.UNRESOLVED_REQUIRED_ARTIFACT));
                if (!configuration.isChecked(nextAvailable.getIdentifyingPath())) continue;
                checked.add(nextAvailable);
            }
        } else {
            checked = Collections.emptyList();
        }
        Architecture architecture = this.getArchitectureDirectory();
        if (resetChecked) {
            UnassignedElements node;
            int logicalChecks = 0;
            int physicalChecks = 0;
            for (ArchitectureFile nextAvailable : available) {
                boolean isChecked = checked.contains(nextAvailable);
                nextAvailable.getChildren(IClearableArchitectureElement.class).forEach(a -> a.clear());
                nextAvailable.checked(isChecked);
                if (!isChecked) continue;
                switch (nextAvailable.getModel()) {
                    case PHYSICAL: {
                        ++physicalChecks;
                        break;
                    }
                    case LOGICAL: {
                        ++logicalChecks;
                    }
                }
            }
            if (physicalChecks == 0) {
                node = this.getUnassignedInternalNode(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
                if (node != null) {
                    node.remove();
                }
                if ((node = this.getUnassignedExternalNode(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) != null) {
                    node.remove();
                }
            }
            if (logicalChecks == 0) {
                node = this.getUnassignedInternalNode(IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
                if (node != null) {
                    node.remove();
                }
                if ((node = this.getUnassignedExternalNode(IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) != null) {
                    node.remove();
                }
            }
            architecture.getChildren(UnassignedElements.class).forEach(u -> u.clear());
        } else {
            for (ArchitectureFile nextArchitectureFile : checked) {
                nextArchitectureFile.getChildren(IClearableArchitectureElement.class).forEach(a -> a.clear());
            }
            for (UnassignedElements next : architecture.getChildren(UnassignedElements.class)) {
                next.clear();
            }
        }
        this.m_finishModelProcessor.architectureModelModified();
        LOGGER.debug("Reset component assignment - done");
        return checked;
    }

    private void assignComponents(List<ArchitectureFile> checked, IArchitecturalModelProvider.ArchitectureModel model, List<IAssignableToArtifact> assignableElements) {
        assert (checked != null && checked.size() > 0) : "Parameter 'checked' of method 'assignComponents' must not be null and not be empty";
        assert (model != null) : "Parameter 'model' of method 'assignComponents' must not be null";
        assert (assignableElements != null) : "Parameter 'assignableElements' of method 'assignComponents' must not be null";
        Architecture architecture = this.getArchitectureDirectory();
        UnassignedInternal unassignedInternalComponents = this.getUnassignedInternalNode(model);
        if (unassignedInternalComponents == null) {
            unassignedInternalComponents = new UnassignedInternal(architecture, model);
            architecture.addChild(unassignedInternalComponents);
        } else {
            unassignedInternalComponents.clear();
        }
        UnassignedExternal unassignedExternalComponents = this.getUnassignedExternalNode(model);
        if (unassignedExternalComponents == null) {
            unassignedExternalComponents = new UnassignedExternal(architecture, model);
            architecture.addChild(unassignedExternalComponents);
        } else {
            unassignedExternalComponents.clear();
        }
        for (IAssignableToArtifact nextElement : assignableElements) {
            boolean used = false;
            for (ArchitectureFile nextArchitectureFile : checked) {
                if (!this.feedComponent(nextArchitectureFile, nextElement)) continue;
                used = true;
            }
            if (used) continue;
            if (!nextElement.isExternal()) {
                unassignedInternalComponents.assignComponent(nextElement);
                continue;
            }
            unassignedExternalComponents.assignComponent(nextElement);
        }
        this.m_assignableAttributeRetrievers.values().forEach(r -> r.reset());
        for (ArchitectureFile nextArchitectureFile : checked) {
            nextArchitectureFile.getChildren(Artifact.class).forEach(a -> a.assignmentFinished());
        }
    }

    private boolean assignComponents(List<ArchitectureFile> checked, IArchitecturalModelProvider.ArchitectureModel model, NamedElement root) {
        assert (checked != null) : "Parameter 'checked' of method 'assignComponents' must not be null";
        assert (model != null) : "Parameter 'model' of method 'assignComponents' must not be null";
        assert (root != null) : "Parameter 'root' of method 'assignComponents' must not be null";
        List<ArchitectureFile> modelFiles = checked.stream().filter(f -> f.getModel().equals((Object)model)).collect(Collectors.toList());
        if (!modelFiles.isEmpty()) {
            AssignableCollector collector = new AssignableCollector();
            root.accept(collector);
            this.assignComponents(modelFiles, model, collector.getAssignables());
            return true;
        }
        return false;
    }

    private void assignComponents(IWorkerContext workerContext, List<ArchitectureFile> checked) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'assignComponents' must not be null";
        assert (checked != null) : "Parameter 'checked' of method 'assignComponents' must not be null";
        LOGGER.debug("Assign components");
        if (this.getSoftwareSystem().isClearable()) {
            workerContext.working("Assign components", true);
            int changes = 0;
            this.getArchitectureDirectory().removeChildren(UnassignedElements.class);
            if (this.assignComponents(checked, IArchitecturalModelProvider.ArchitectureModel.LOGICAL, this.getSoftwareSystem().getUniqueExistingChild(LogicalModuleNamespaces.class))) {
                ++changes;
            }
            if (this.assignComponents(checked, IArchitecturalModelProvider.ArchitectureModel.PHYSICAL, this.getSoftwareSystem().getUniqueExistingChild(Workspace.class))) {
                ++changes;
            }
            if (changes > 0) {
                this.m_finishModelProcessor.architectureModelModified();
            }
        }
        checked.forEach(f -> f.accept(new FinishArchitectureModelVisitor()));
        LOGGER.debug("Assign components - done");
    }

    @Override
    public void componentModelModified(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean onSystemOpen) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'componentModelModified' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'parserModelModified' must not be null";
        List<ArchitectureFile> checked = this.resetComponentAssignment(onSystemOpen);
        if (onSystemOpen) {
            this.compile();
        }
        this.assignComponents(workerContext, checked);
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToBeDisptached, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToBeDisptached != null) : "Parameter 'eventsToBeDisptached' of method 'cleared' must not be null";
        this.resetComponentAssignment(false);
    }

    @Override
    public void analyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChanged' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'configurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChanged' must not be null";
        if (mode != AnalyzerConfigurationChangeMode.OPEN && configuration.affects(CoreAnalyzerId.ARCHITECTURE_CHECK)) {
            if (modifications != null) {
                modifications.add(Modification.ARCHITECTURE_MODIFIED);
            }
            this.checkArchitectureCheckConfiguration();
            List<ArchitectureFile> checked = this.resetComponentAssignment(true);
            this.assignComponents(workerContext, checked);
        }
    }

    @Override
    public OperationResult deleteArchitectureFileElements(IWorkerContext workerContext, List<? extends Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteArchitectureFileElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'deleteArchitectureFileElements' must not be empty";
        OperationResult result = new OperationResult("Delete architecture file element(s)");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups(GROUPS, ResetMode.ALL);
        Set<NamedElement> normalized = this.getNormalizedArchitectureFileToDelete(elements);
        ArrayList<String> removedEntries = new ArrayList<String>();
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
        assert (configuration != null) : "'configuration' of method 'deleteArchitectureFileElements' must not be null";
        for (NamedElement nextNamedElement : normalized) {
            if (!(nextNamedElement instanceof ArchitectureFile)) continue;
            ArchitectureFile nextArchitectureFile = (ArchitectureFile)nextNamedElement;
            String identifyingPath = nextArchitectureFile.getIdentifyingPath();
            if (configuration.isChecked(identifyingPath)) {
                removedEntries.add(identifyingPath);
            }
            this.removeArchitectureFile(identifyingPath);
            this.removeArchitectureFileContentForCompilation(identifyingPath);
            SoftwareSystemFilesDirectory.removeFile(nextArchitectureFile.getFile(), false, result);
            nextArchitectureFile.remove();
        }
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (String next : removedEntries) {
            configuration.removeValue(next);
        }
        this.finishWithArchitectureCheckConfigurationUpdate(workerContext, modifications, analyzerExtension, result);
        analyzerExtension.runAnalyzerGroups(allToRestart);
        result.setIsSuccess(true);
        return result;
    }

    private void finishWithArchitectureCheckConfigurationUpdate(IWorkerContext workerContext, EnumSet<Modification> modifications, IAnalyzerController analyzerExtension, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateScriptRunnerConfiguration' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishWithArchitectureCheckConfigurationUpdate' must not be null";
        assert (analyzerExtension != null) : "Parameter 'analyzerExtension' of method 'finishWithArchitectureCheckConfigurationUpdate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateScriptRunnerConfiguration' must not be null";
        AnalyzerConfigurationFile configuration = this.getArchitectureCheckConfigurationFile();
        if (configuration != null) {
            configuration.setNeedsSave(true);
            result.addMessagesFrom(analyzerExtension.save(configuration));
        }
        this.reCompile(workerContext);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
    }

    boolean isChecked(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isChecked' must not be empty";
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
        return configuration != null && configuration.isChecked(identifyingPath);
    }

    @Override
    public OperationResult editArchitectureFile(IWorkerContext workerContext, ArchitectureFile architectureFile, String name) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editArchitectureFile' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'editArchitectureFile' must not be null";
        DirectoryPath directoryPath = architectureFile.getParent(DirectoryPath.class, new Class[0]);
        assert (directoryPath != null) : "'directoryPath' of method 'editArchitectureFile' must not be null";
        assert (this.getArchitectureFileNameValidator(directoryPath, architectureFile).isValid(null, name).isSuccess()) : "Not a valid name: " + name;
        OperationResult result = new OperationResult("Edit '" + architectureFile.getIdentifyingPath() + "'");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups(GROUPS, ResetMode.ALL);
        try {
            if (this.isChecked(architectureFile.getIdentifyingPath())) {
                AnalyzerConfigurationFile config = this.getArchitectureCheckConfigurationFile();
                assert (config != null) : "'config' of method 'editArchitectureFile' must not be null";
                config.setNeedsSave(true);
            }
            Map<ArchitectureFile, String> architectureFileToNewContent = ApplyAndRequireSupport.processApplyAndRequireStatements(this.getAvailableArchitectureFiles(), architectureFile, name);
            for (Map.Entry<ArchitectureFile, String> nextEntry : architectureFileToNewContent.entrySet()) {
                ArchitectureFile nextArchitectureFile = nextEntry.getKey();
                String nextNewContent = nextEntry.getValue();
                nextArchitectureFile.setContent(nextNewContent, true);
                result.addMessagesFrom(this.save(nextArchitectureFile));
            }
            String previousIdentifyingPath = architectureFile.getIdentifyingPath();
            TFile targetFile = new TFile((File)directoryPath.getFile(), name + CoreFileType.ARCHITECTURE.getDefaultExtension());
            try {
                architectureFile.getFile().mv((File)targetFile);
                architectureFile.setPath(targetFile);
                if (architectureFile.needsSave()) {
                    result.addMessagesFrom(this.save(architectureFile));
                }
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE);
                OperationResult operationResult = result;
                analyzerExtension.runAnalyzerGroups(allToRestart);
                return operationResult;
            }
            String content = this.removeArchitectureFileContentForCompilation(previousIdentifyingPath);
            this.addArchitectureFileContentForCompilation(architectureFile.getIdentifyingPath(), content);
            this.changeIdentifyingPathOfArchitectureFile(previousIdentifyingPath, architectureFile.getIdentifyingPath());
            ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
            if (configuration != null) {
                configuration.replaceIfPresent(previousIdentifyingPath, architectureFile.getIdentifyingPath());
            }
            this.finishWithArchitectureCheckConfigurationUpdate(workerContext, EnumSet.noneOf(Modification.class), analyzerExtension, result);
        }
        finally {
            analyzerExtension.runAnalyzerGroups(allToRestart);
        }
        return result;
    }

    OperationResult save(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'save' must not be null";
        this.clearAllIssues(architectureFile);
        architectureFile.setNeedsSave(true);
        OperationResult saveResult = this.getPersistence().save(architectureFile, architectureFile.getFile());
        this.addArchitectureFileContentForCompilation(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        if (saveResult.isSuccess()) {
            TrueZipFacade.sync((TFile)architectureFile.getFile());
            architectureFile.setNeedsSave(false);
        }
        return saveResult;
    }

    @Override
    public List<ArchitectureFile> getApplyingAndRequiringFiles(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getApplyingFiles' must not be null";
        return ApplyAndRequireSupport.getApplyingAndRequiringFiles(this.getAvailableArchitectureFiles(), architectureFile);
    }

    public void getApplyingAndRequiringFilesRecursively(ArchitectureFile architectureFile, Set<ArchitectureFile> collector) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getApplyingAndRequiringFilesRecursively' must not be null";
        List<ArchitectureFile> applyingAndRequiringFiles = this.getApplyingAndRequiringFiles(architectureFile);
        for (ArchitectureFile next : applyingAndRequiringFiles) {
            if (!collector.add(next)) continue;
            this.getApplyingAndRequiringFilesRecursively(next, collector);
        }
    }

    @Override
    public OperationResultWithOutcome<ArchitectureFile> createArchitectureFile(IWorkerContext workerContext, String name, DirectoryPath directoryPath, boolean addExampleSnippet) {
        ArchitectureFile architectureFile;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createArchitectureFile' must not be null";
        assert (name != null) : "Parameter 'name' of method 'createArchitectureFile' must not be null";
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'createArchitectureFile' must not be null";
        assert (this.getArchitectureFileNameValidator(directoryPath, null).isValid(null, name).isSuccess()) : "Not a valid name: " + name;
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Architecture File");
        this.checkOutOfSync((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)directoryPath.getFile(), name + CoreFileType.ARCHITECTURE.getDefaultExtension());
        if (addExampleSnippet) {
            String content = ModuleBasedArchitectureFileContentGenerator.generate(this.getSoftwareSystem());
            architectureFile = new ArchitectureFile(directoryPath, file, file.lastModified(), this.getSoftwareSystem().getUniqueExistingChild(Files.class), content);
        } else {
            architectureFile = new ArchitectureFile(directoryPath, file, file.lastModified(), this.getSoftwareSystem().getUniqueExistingChild(Files.class), ModuleBasedArchitectureFileContentGenerator.generateGeneralComment());
        }
        this.addArchitectureFileContentForCompilation(architectureFile.getIdentifyingPath(), architectureFile.getContent());
        OperationResult saveResult = this.getPersistence().save(architectureFile, file);
        result.addMessagesFrom(saveResult);
        TrueZipFacade.sync((TFile)file);
        if (saveResult.isSuccess()) {
            architectureFile.setExistsOnDisk(true);
            architectureFile.resetTimestamp();
        }
        TrueZipFacade.clear((TFile)file);
        if (result.isSuccess()) {
            directoryPath.addChild(architectureFile);
            result.setOutcome((Object)architectureFile);
        }
        this.addArchitectureFile(architectureFile);
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
        if (configuration != null && configuration.isChecked(architectureFile.getIdentifyingPath())) {
            IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
            Set<AnalyzerGroup> allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups(GROUPS, ResetMode.ALL);
            architectureFile.checked(true);
            this.reCompile(workerContext);
            this.checkArchitectureCheckConfiguration();
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED), (OperationResult)result);
            analyzerExtension.runAnalyzerGroups(allToRestart);
        } else if (addExampleSnippet) {
            ArchitectureFileLoader loader = new ArchitectureFileLoader(this);
            loader.loadArchitectureFile(architectureFile);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED), (OperationResult)result);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    public ArchitectureFile architectureFileGenerated(IWorkerContext workerContext, TFile generatedArchitectureFile, boolean addToArchitectureCheck, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'architectureFileGenerated' must not be null";
        assert (generatedArchitectureFile != null) : "Parameter 'generatedArchitectureFile' of method 'architectureFileGenerated' must not be null";
        assert (result != null) : "Parameter 'result' of method 'architectureFileGenerated' must not be null";
        assert (FileUtility.areEqual((TFile)this.getArchitectureDirectory().getDirectoryFile(), (TFile)generatedArchitectureFile.getParentFile())) : "File not underneath the architecture directory: " + String.valueOf(generatedArchitectureFile);
        Path architectureFile = null;
        for (ArchitectureFile next : this.getAvailableArchitectureFiles()) {
            if (!FileUtility.refersToSameFile((TFile)next.getFile(), (TFile)generatedArchitectureFile)) continue;
            architectureFile = next;
            break;
        }
        boolean checked = false;
        if (architectureFile == null) {
            String architectureFileName = FileUtility.removeExtension((String)generatedArchitectureFile.getName());
            assert (this.getArchitectureFileNameValidator(this.getArchitectureDirectory(), null).isValid(null, architectureFileName).isSuccess()) : "Not a valid name: " + architectureFileName;
            architectureFile = new ArchitectureFile(this.getArchitectureDirectory(), generatedArchitectureFile, generatedArchitectureFile.lastModified(), this.getSoftwareSystem().getUniqueExistingChild(Files.class));
            this.getPersistence().load(generatedArchitectureFile, (ArchitectureFile)architectureFile, result);
            if (result.isSuccess()) {
                this.getArchitectureDirectory().addChild(architectureFile);
                this.addArchitectureFileContentForCompilation(((ModifiableFile)architectureFile).getIdentifyingPath(), ((ArchitectureFile)architectureFile).getContent());
                this.addArchitectureFile((ArchitectureFile)architectureFile);
                ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
                assert (configuration != null) : "Parameter 'configuration' of method 'architectureFileGenerated' must not be null";
                if (configuration.isChecked(((ModifiableFile)architectureFile).getIdentifyingPath())) {
                    checked = true;
                } else if (addToArchitectureCheck) {
                    configuration.addIdentifyingPath(((ModifiableFile)architectureFile).getIdentifyingPath(), true);
                    AnalyzerConfigurationFile analyzerConfigurationFile = this.getArchitectureCheckConfigurationFile();
                    assert (analyzerConfigurationFile != null) : "Parameter 'analyzerConfigurationFile' of method 'architectureFileGenerated' must not be null";
                    analyzerConfigurationFile.setNeedsSave(true);
                    checked = true;
                }
            }
        } else {
            this.addArchitectureFile(generatedArchitectureFile, architectureFile.getFile(), (ArchitectureFile)architectureFile, false);
            checked = addToArchitectureCheck;
        }
        ((ArchitectureFile)architectureFile).checked(checked);
        this.reCompile(workerContext);
        this.checkArchitectureCheckConfiguration();
        return architectureFile;
    }

    @Override
    public void modifyArchitectureFileSource(ArchitectureFile architectureFile, String content, IOriginator originator) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'modifyArchitectureFileSource' must not be null";
        assert (content != null) : "Parameter 'content' of method 'modifyArchitectureFileSource' must not be null";
        assert (originator != null) : "Parameter 'originator' of method 'modifyArchitectureFileSource' must not be null";
        architectureFile.setContent(content, false);
        if (!architectureFile.needsSave()) {
            architectureFile.setNeedsSave(true);
            this.m_finishModelProcessor.finishModification((IWorkerContext)DefaultWorkerContext.INSTANCE, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), originator, new OperationResult("Modify architecture file source"));
        }
    }

    OperationResult saveFiles(IWorkerContext workerContext, List<ArchitectureFile> files, Map<IModifiableFile, IModificationOnSave> modificationsOnSave) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'saveFiles' must not be null";
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'saveFile' must not be empty";
        LOGGER.debug("Save files");
        OperationResult result = new OperationResult("Save architecture files");
        ArchitectureFilePersistence persistence = this.getPersistence();
        for (ArchitectureFile nextArchitectureFile : files) {
            String content;
            String modifiedContent;
            this.clearAllIssues(nextArchitectureFile);
            IModificationOnSave modification = modificationsOnSave.get(nextArchitectureFile);
            if (modification != null && !(modifiedContent = modification.apply(content = nextArchitectureFile.getContent())).equals(content)) {
                nextArchitectureFile.setContent(modifiedContent, true);
            }
            nextArchitectureFile.setNeedsSave(true);
            OperationResult saveResult = persistence.save(nextArchitectureFile, nextArchitectureFile.getFile());
            if (saveResult.isSuccess()) {
                nextArchitectureFile.setNeedsSave(false);
            }
            result.addMessagesFrom(saveResult);
            this.addArchitectureFileContentForCompilation(nextArchitectureFile.getIdentifyingPath(), nextArchitectureFile.getContent());
        }
        this.reCompile(workerContext);
        LOGGER.debug("Save files - done");
        return result;
    }

    @Override
    public OperationResult updateArchitectureCheckStatus(IWorkerContext workerContext, ArchitectureFile file, boolean shouldBeChecked) {
        boolean changed;
        assert (file != null);
        OperationResult result = new OperationResult("Update architecturecheck status");
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration(true);
        if (shouldBeChecked) {
            changed = configuration.addIdentifyingPath(file.getIdentifyingPath(), false);
        } else {
            changed = configuration.removeIdentifyingPath(file.getIdentifyingPath(), false);
            if (changed) {
                file.setHasViolations(false);
                file.setHasDeprecations(false);
            }
        }
        if (changed) {
            result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
        }
        return result;
    }

    @Override
    public OperationResult addToArchitectureCheck(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addToArchitectureCheck' must not be null";
        assert (this.mayBeAddedToArchitectureCheck(elements)) : "Not valid elements to be added";
        OperationResult result = new OperationResult("Add to architecture check");
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration(true);
        for (Element next : elements) {
            assert (next != null && next instanceof ArchitectureFile) : "Unexpected class in method 'addToArchitectureCheck': " + String.valueOf(next);
            configuration.addIdentifyingPath(((ArchitectureFile)next).getIdentifyingPath(), true);
        }
        result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
        return result;
    }

    @Override
    public OperationResult removeFromArchitectureCheck(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeFromArchitectureCheck' must not be null";
        assert (this.mayBeRemovedFromArchitectureCheck(elements)) : "Not valid elements to be removed";
        OperationResult result = new OperationResult("Remove from architecture check");
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration(true);
        for (Element next : elements) {
            assert (next != null && next instanceof ArchitectureFile) : "Unexpected class in method 'removeFromArchitectureCheck': " + String.valueOf(next);
            ArchitectureFile nextArchitectureFile = (ArchitectureFile)next;
            nextArchitectureFile.setHasViolations(false);
            nextArchitectureFile.setHasDeprecations(false);
            configuration.removeIdentifyingPath(nextArchitectureFile.getIdentifyingPath(), true);
        }
        result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
        return result;
    }

    public List<IModifiableFile> getAvailableFiles() {
        ArrayList<IModifiableFile> result = new ArrayList<IModifiableFile>();
        result.addAll(this.getArchitectureDirectory().getChildrenRecursively(ArchitectureFile.class, new Class[0]));
        return result;
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.ARCHITECTURE.equals(modifiableFile.getFileType());
    }

    @Override
    public String getExportBaseDirectory() {
        return "Architecture";
    }

    @Override
    public void exportFile(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof ArchitectureFile) : "Unexpected class in method 'exportFile': " + String.valueOf(modifiableFile);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        ArchitectureFile architectureFile = (ArchitectureFile)modifiableFile;
        result.addMessagesFrom(this.getPersistence().save(architectureFile, targetFile));
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.ARCHITECTURE);
        Architecture architecture = this.getArchitectureDirectory();
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)architecture.getFile(), contentFileIdentifyingPath).getNormalizedFile();
                result.addMessagesFrom(this.addArchitectureFile(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.getAvailableFiles()) {
                assert (nextAvailable != null && nextAvailable instanceof ArchitectureFile) : "Unexpected class in method 'importFiles': " + String.valueOf(nextAvailable);
                if (!nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.addArchitectureFile(contentFile, nextAvailable.getFile(), (ArchitectureFile)nextAvailable, true));
                continue block0;
            }
        }
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        this.removeAllCachedArchitectureFileRelatedInfo();
        this.getArchitectureDirectory().removeAll(result);
    }

    @Override
    public void importFinished(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        this.reCompile(workerContext);
        this.checkArchitectureCheckConfiguration();
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.getArchitectureDirectory().setPath(new TFile((File)qualityModel, "./Architecture"));
    }

    @Override
    public IAssignableAttributeRetriever getAttributeRetriever(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getAttributeRetriver' must not be empty";
        return this.m_assignableAttributeRetrievers.get(name);
    }

    @Override
    public OperationResult exportArchitectureToXmlFile(IWorkerContext workerContext, ArchitectureFile file, TFile targetFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'exportArchitectureToXmlFile' must not be null";
        assert (file != null) : "Parameter 'file' of method 'exportArchitectureToXmlFile' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportArchitectureToXmlFile' must not be null";
        OperationResult result = new OperationResult("Exporting Arhitecture to XML File");
        if (targetFile.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.CANNOT_OVERWRITE_DIRECTORY);
            return result;
        }
        new ArchitectureXmlPersistence().save(file, targetFile, result);
        return result;
    }

    private static final class FinishArchitectureModelVisitor
    implements NamedElement.INamedElementVisitor {
        private FinishArchitectureModelVisitor() {
        }

        @Override
        public void visitChildrenOf(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitChildrenOf' must not be null";
            namedElement.getChildren().forEach(c -> c.accept(this));
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
            namedElement.finishModification();
            this.visitChildrenOf(namedElement);
        }
    }
}

