/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.generic;

import com.hello2morrow.sonargraph.core.controller.system.DeltaDetector;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.generic.workspace.GenericModule;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class GenericDeltaDetector
extends DeltaDetector {
    private final Set<FilePath> m_affectedModuleFiles = new LinkedHashSet<FilePath>();
    private final Set<FilePath> m_affectedFiles = new HashSet<FilePath>();
    private final IIssueId[] m_parserIssueIds;
    private boolean m_changesDetectedInPreceedingModules = false;

    public GenericDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, List<String> ignoreDirectories, IIssueId ... parserIssueIds) {
        super(workerContext, languageProvider, filter, module, ignoreDirectories);
        assert (parserIssueIds != null) : "Parameter 'parserIssueIds' of method 'GenericDeltaDetector' must not be null";
        this.m_parserIssueIds = parserIssueIds;
    }

    @Override
    protected void changesDetectedInPreceedingModules() {
        this.m_changesDetectedInPreceedingModules = true;
    }

    @Override
    public GenericModule getModule() {
        return (GenericModule)super.getModule();
    }

    @Override
    public void synchronize(OperationResult result) {
    }

    public IFileType accepts(TFile file) {
        IFileType[] iFileTypeArray = this.getModule().getSourceFileTypes();
        int n = iFileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileType fileType = iFileTypeArray[n2];
            if (fileType.endsWith(file.getName())) {
                return fileType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void scanDirectories(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'scanDirectories' must not be null";
        super.scanDirectories(result);
        if (this.m_delta == null) {
            return;
        }
        if (this.m_parserIssueIds.length > 0 && (!this.m_delta.isEmpty() || this.m_changesDetectedInPreceedingModules)) {
            GenericModule module = this.getModule();
            for (SourceFile sourceFile : module.getChildrenRecursively(SourceFile.class, SourceFile.class)) {
                if (this.m_delta.isDeleted(sourceFile) || !sourceFile.hasIssues(this.m_parserIssueIds)) continue;
                this.m_delta.modified(sourceFile);
            }
        }
        Visitor visitor = new Visitor();
        this.m_delta.visitModified(visitor);
        this.m_delta.visitDeleted(visitor);
        for (FilePath filePath : this.m_affectedModuleFiles) {
            this.m_delta.modified(filePath);
        }
    }

    private void markAffectedFilesAsModified(ModuleDelta moduleDelta, FilePath sourceFile) {
        LinkedHashSet<SourceFile> affected;
        LinkedHashSet<FilePath> delta = new LinkedHashSet<FilePath>();
        delta.add(sourceFile);
        do {
            affected = new LinkedHashSet<SourceFile>();
            for (FilePath source : delta) {
                if (this.m_affectedFiles.contains(source)) continue;
                this.m_affectedFiles.add(source);
                List<ProgrammingElement> elements = source.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
                for (ProgrammingElement pe : elements) {
                    Iterator<ParserDependency> iterator = pe.getIncomingDependencyIterator();
                    while (iterator.hasNext()) {
                        Module fromModule;
                        ParserDependency dep = iterator.next();
                        ProgrammingElement from = dep.getFrom();
                        SourceFile fromSource = from.getParent(SourceFile.class, new Class[0]);
                        assert (fromSource != null);
                        if (moduleDelta.isModified(fromSource) || moduleDelta.isDeleted(fromSource) || !affected.add(fromSource) || (fromModule = fromSource.getParent(Module.class, new Class[0])) != this.m_module) continue;
                        this.m_affectedModuleFiles.add(fromSource);
                    }
                }
                source.setTimestamp(1L);
            }
        } while ((delta = affected).size() > 0);
    }

    private class Visitor
    implements ModuleDelta.IVisitor {
        private Visitor() {
        }

        @Override
        public void deleted(ModuleDelta delta, FilePath filePath) {
            GenericDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        @Override
        public void modified(ModuleDelta delta, FilePath filePath) {
            GenericDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        @Override
        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        }
    }
}

