/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.treemap;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.treemap.TreeMapCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ITreeMapExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class EditTreeMapCommand
extends TreeMapCommand<IEditTreeMapInteraction> {
    public EditTreeMapCommand(ISoftwareSystemProvider provider, IEditTreeMapInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_TREE_MAP;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        EditTreeMapData data = new EditTreeMapData();
        if (((IEditTreeMapInteraction)this.getInteraction()).collect(data)) {
            ITreeMapExtension extension = this.getController().getSoftwareSystem().getExtension(ITreeMapExtension.class);
            OperationResult result = extension.edit(workerContext, data.getFile(), data.getProperties());
            ((IEditTreeMapInteraction)this.getInteraction()).processEditTreeMapResult(result);
        }
    }

    public static final class EditTreeMapData
    implements ITreeMapCommandInteractionData {
        private TreeMapFile m_file;
        private TreeMapProperties m_properties;

        EditTreeMapData() {
        }

        public void setData(TreeMapFile file, TreeMapProperties properties) {
            assert (file != null) : "Parameter 'file' of method 'setData' must not be null";
            assert (properties != null) : "Parameter 'properties' of method 'setData' must not be null";
            this.m_file = file;
            this.m_properties = properties;
        }

        TreeMapFile getFile() {
            assert (this.m_file != null) : "'m_file' of method 'getFile' must not be null";
            return this.m_file;
        }

        final TreeMapProperties getProperties() {
            assert (this.m_properties != null) : "'m_properties' of method 'getProperties' must not be null";
            return this.m_properties;
        }
    }

    public static interface IEditTreeMapInteraction
    extends ITreeMapCommandInteraction {
        public boolean collect(EditTreeMapData var1);

        public void processEditTreeMapResult(OperationResult var1);
    }
}

