/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.diff;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;

public final class ComputeAndSetBaselineCommand
extends SoftwareSystemBasedCommand<ComputeBaselineCommandInteraction> {
    public ComputeAndSetBaselineCommand(ISoftwareSystemProvider provider, ComputeBaselineCommandInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.COMPUTE_AND_SET_BASELINE;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        BaselineInteractionData data;
        ComputeBaselineCommandInteraction interaction = (ComputeBaselineCommandInteraction)this.getInteraction();
        if (!interaction.collect(data = new BaselineInteractionData())) {
            return;
        }
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        ISystemDiffExtension diffExtension = softwareSystem.getExtension(ISystemDiffExtension.class);
        OperationResultWithOutcome<TFile> result = diffExtension.computeAndSetBaseline(workerContext, data.getFileName(), data.getBaselineReportDirectory(), data.getReportDescription(), data.getBaselineType());
        interaction.processResult(result);
    }

    public static final class BaselineInteractionData
    implements ICommandInteractionData {
        private TFile m_baselineReportDirectory;
        private String m_reportDescription;
        private BaselineType m_type;
        private String m_fileName;

        BaselineInteractionData() {
        }

        public String getReportDescription() {
            return this.m_reportDescription;
        }

        public void setReportDescription(String info) {
            assert (info != null) : "Parameter 'info' of method 'setReportContextInfo' must not be null";
            this.m_reportDescription = info;
        }

        public TFile getBaselineReportDirectory() {
            return this.m_baselineReportDirectory;
        }

        public void setBaselineReportDirectory(TFile directory) {
            assert (directory != null) : "Parameter 'directory' of method 'setBaselineReportDirectory' must not be null";
            this.m_baselineReportDirectory = directory;
        }

        public void setBaselineType(BaselineType type) {
            assert (type != null) : "Parameter 'type' of method 'setBaselineType' must not be null";
            this.m_type = type;
        }

        BaselineType getBaselineType() {
            return this.m_type;
        }

        public void setBaselineFileName(String fileName) {
            assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'setBaselineFileName' must not be empty";
            this.m_fileName = fileName;
        }

        public String getFileName() {
            return this.m_fileName;
        }
    }

    public static interface ComputeBaselineCommandInteraction
    extends ICommandInteraction {
        public boolean collect(BaselineInteractionData var1);

        public void processResult(OperationResultWithOutcome<TFile> var1);
    }
}

