/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class SelectAllCommand
extends ArchitecturalViewCommand<ISelectAllInteraction> {
    public SelectAllCommand(ISoftwareSystemProvider provider, ISelectAllInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.ARCHITECTURAL_VIEW_SELECT_ALL;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        ArchitecturalViewRepresentationData data = new ArchitecturalViewRepresentationData();
        if (!((ISelectAllInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        this.getController().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).selectAll(data.getRepresentation());
    }

    public static interface ISelectAllInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(ArchitecturalViewRepresentationData var1);
    }
}

