/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IThresholdExtension;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class UpdateThresholdsCommand
extends SimpleSoftwareSystemBasedCommand {
    public static final ICommandId ID = CoreCommandId.UPDATE_THRESHOLDS;
    private final List<IMetricThreshold> m_addedThresholds;
    private final List<IMetricThreshold> m_modifiedThresholds;
    private final List<IMetricThreshold> m_removedThresholds;

    public UpdateThresholdsCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<IMetricThreshold> addedThresholds, List<IMetricThreshold> modifiedThresholds, List<IMetricThreshold> removedThresholds) {
        super(provider, interaction);
        this.m_addedThresholds = addedThresholds == null ? Collections.emptyList() : addedThresholds;
        this.m_modifiedThresholds = modifiedThresholds == null ? Collections.emptyList() : modifiedThresholds;
        this.m_removedThresholds = removedThresholds == null ? Collections.emptyList() : removedThresholds;
    }

    @Override
    public ICommandId getId() {
        return ID;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && this.m_addedThresholds.isEmpty() && this.m_modifiedThresholds.isEmpty() && this.m_removedThresholds.isEmpty()) {
            enabled.addErrorMessage("No thresholds specified");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        IThresholdExtension te = this.getController().getSoftwareSystem().getExtension(IThresholdExtension.class);
        OperationResult result = te.updateThresholds(workerContext, new HashSet<IMetricThreshold>(this.m_addedThresholds), new HashSet<IMetricThreshold>(this.m_modifiedThresholds), new HashSet<IMetricThreshold>(this.m_removedThresholds));
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }
}

