/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISearchExtension;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.EnumSet;
import java.util.List;

public final class SearchInSoftwareSystemCommand
extends SonargraphCommand {
    private final String m_pattern;
    private final EnumSet<SearchCriteria> m_criteria;
    private List<NamedElement> m_matching;

    public SearchInSoftwareSystemCommand(ISoftwareSystemProvider provider, String pattern, EnumSet<SearchCriteria> criteria) {
        super(provider);
        assert (pattern != null) : "Parameter 'pattern' of method 'SearchInSoftwareSystemCommand' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'SearchInSoftwareSystemCommand' must not be null";
        this.m_pattern = pattern;
        this.m_criteria = criteria;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SEARCH_IN_SOFTWARE_SYSTEM;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.NONE;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result enabled = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            enabled.addErrorMessage("No system available");
        }
        return enabled;
    }

    public static boolean isPatternValid(ISoftwareSystemProvider provider, String pattern, EnumSet<SearchCriteria> criteria) {
        return provider.getSoftwareSystem().getExtension(ISearchExtension.class).isPatternValid(pattern, criteria);
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        this.m_matching = this.getController().getSoftwareSystem().getExtension(ISearchExtension.class).searchNamedElements(workerContext, this.m_pattern, this.m_criteria);
    }

    public List<NamedElement> getMatching() {
        return this.m_matching;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }
}

