/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.DynamicCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IMetricsExtension;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RequestMetricValuesCommand
extends DynamicCommand {
    private final Set<IMetricDescriptor> m_metricDescriptors;
    private final NamedElement m_root;
    private final boolean m_rootOnly;
    private final IOriginator m_originator;

    public RequestMetricValuesCommand(ISoftwareSystemProvider provider, Set<IMetricDescriptor> metricDescriptors, NamedElement root, boolean rootOnly, IOriginator originator) {
        super(provider);
        assert (metricDescriptors != null && !metricDescriptors.isEmpty()) : "Parameter 'metricDescriptors' of method 'RequestMetricValuesCommand' must not be empty";
        assert (root != null) : "Parameter 'root' of method 'RequestMetricValuesCommand' must not be null";
        assert (originator != null) : "Parameter 'originator' of method 'RequestMetricValuesCommand' must not be null";
        this.m_metricDescriptors = new LinkedHashSet<IMetricDescriptor>(metricDescriptors);
        this.m_root = root;
        this.m_rootOnly = rootOnly;
        this.m_originator = originator;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.REQUEST_METRIC_VALUES;
    }

    @Override
    public Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isSuccess() && !this.m_root.isValid()) {
            result.addErrorMessage("Root no longer valid");
        }
        return result;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        this.getController().getInstallation().getExtension(IMetricsExtension.class).requestMetricValues(this.getSoftwareSystem(), this.m_metricDescriptors, this.m_root, this.m_rootOnly, this.m_originator);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.m_metricDescriptors.hashCode();
        result = 31 * result + this.m_root.hashCode();
        result = 31 * result + Boolean.hashCode(this.m_rootOnly);
        result = 31 * result + this.m_originator.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RequestMetricValuesCommand other = (RequestMetricValuesCommand)obj;
        if (!this.m_metricDescriptors.equals(other.m_metricDescriptors)) {
            return false;
        }
        if (!this.m_root.equals(other.m_root)) {
            return false;
        }
        if (this.m_rootOnly != other.m_rootOnly) {
            return false;
        }
        return this.m_originator.equals(other.m_originator);
    }
}

