/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ModifiableFilesToBeProcessedData
implements ICommandInteractionData {
    private final List<Pair<IModifiableFile, Files.ConflictState>> m_needingSave;
    private final List<IModifiableFile> m_toBeProcessed = new ArrayList<IModifiableFile>();

    ModifiableFilesToBeProcessedData(List<Pair<IModifiableFile, Files.ConflictState>> needingSave) {
        assert (needingSave != null && !needingSave.isEmpty()) : "Parameter 'needingSave' of method 'ModifiableFilesToBeSavedData' must not be empty";
        this.m_needingSave = needingSave;
    }

    public List<Pair<IModifiableFile, Files.ConflictState>> getNeedingSave() {
        return Collections.unmodifiableList(this.m_needingSave);
    }

    protected List<IModifiableFile> getToBeProcessed() {
        return Collections.unmodifiableList(this.m_toBeProcessed);
    }

    protected void setToBeProcessed(List<IModifiableFile> toBeProcessed) {
        assert (toBeProcessed != null) : "Parameter 'toBeProcessed' of method 'setToBeProcessed' must not be null";
        this.m_toBeProcessed.clear();
        for (IModifiableFile next : toBeProcessed) {
            assert (this.needsSave(next)) : next.getIdentifyingPath() + " does not need saving";
            this.m_toBeProcessed.add(next);
        }
    }

    private boolean needsSave(IModifiableFile file) {
        for (Pair<IModifiableFile, Files.ConflictState> next : this.m_needingSave) {
            if (!((IModifiableFile)next.getFirst()).equals(file)) continue;
            return true;
        }
        return false;
    }
}

