/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class LoadSnapshotCommand
extends AbstractOpenCommand {
    public LoadSnapshotCommand(ISoftwareSystemProvider controller, AbstractOpenCommand.IOpenInteraction interaction) {
        super(controller, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.OPEN_SOFTWARE_SYSTEM_FROM_SNAPSHOT;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        AbstractOpenCommand.OpenData softwareSystemData = new AbstractOpenCommand.OpenData();
        if (!this.getInteraction().collectOpenData(softwareSystemData)) {
            return;
        }
        if (this.getController().hasSoftwareSystem()) {
            CloseSoftwareSystemCommand closeSoftwareSystemCommand = new CloseSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), this.getInteraction());
            this.runPrerequisiteCommand(closeSoftwareSystemCommand, workerContext);
            if (closeSoftwareSystemCommand.canceled()) {
                return;
            }
        }
        AbstractOpenCommand.OpenSnapshotData openSnapshotData = new AbstractOpenCommand.OpenSnapshotData(softwareSystemData.getLocation().getParentFile());
        if (!this.getInteraction().confirmOpenSnapshotAttached(openSnapshotData)) {
            return;
        }
        TFile targetDirectory = openSnapshotData.getTargetDirectory();
        if (targetDirectory != null) {
            OperationResultWithOutcome<List<TFile>> isPossibleResult = this.getController().isOpenSnapshotAttachedPossible(workerContext, softwareSystemData.getLocation(), targetDirectory);
            if (isPossibleResult.isFailure()) {
                this.getInteraction().processOpenResult((OperationResult)isPossibleResult);
                return;
            }
            List willBeReplaced = (List)isPossibleResult.getOutcome();
            assert (willBeReplaced != null) : "Parameter 'willBeReplaced' of method 'internalRun' must not be null";
            if (!willBeReplaced.isEmpty()) {
                StringBuilder builder = new StringBuilder("The following files will be replaced:\n\n");
                int index = 1;
                for (TFile nextFile : willBeReplaced) {
                    builder.append("(").append(index).append(") ").append(nextFile.getAbsolutePath()).append(nextFile.isDirectory() ? " (directory)" : "").append("\n");
                    ++index;
                }
                builder.append("\n").append("This cannot be undone! Do you want to continue?");
                if (!this.getInteraction().confirmFileReplaceInOpenSnapshotAttached(builder.toString())) {
                    return;
                }
            }
            OperationResult openResult = this.getController().openSnapshotAttached(workerContext, softwareSystemData.getLocation(), targetDirectory);
            this.getInteraction().processOpenResult(openResult);
        } else {
            OperationResult result = this.getController().openSnapshot(workerContext, softwareSystemData.getLocation());
            this.getInteraction().processOpenResult(result);
        }
    }
}

