/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public abstract class CreateManualModuleCommand
extends SoftwareSystemBasedCommand<ICreateManualModuleInteraction> {
    protected CreateManualModuleCommand(ISoftwareSystemProvider provider, ICreateManualModuleInteraction interaction) {
        super(provider, interaction);
    }

    protected void moduleCreated(Module module, OperationResult result) {
        assert (module != null) : "Parameter 'module' of method 'moduleCreated' must not be null";
        assert (result != null) : "Parameter 'result' of method 'moduleCreated' must not be null";
    }

    protected abstract Module.IModuleType getModuleType();

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateManualModuleData data = new CreateManualModuleData();
        if (((ICreateManualModuleInteraction)this.getInteraction()).collectCreateModuleData(data)) {
            OperationResultWithOutcome<Module> result = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).createModule(workerContext, this.getModuleType(), data.getName(), data.getDescription());
            if (result.isSuccess()) {
                Module module = (Module)result.getOutcome();
                assert (module != null) : "Parameter 'module' of method 'internalRun' must not be null";
                this.moduleCreated(module, (OperationResult)result);
            }
            ((ICreateManualModuleInteraction)this.getInteraction()).processCreateModuleResult((OperationResult)result);
        }
    }

    public static final class CreateManualModuleData
    implements ICommandInteractionData {
        private String m_name;
        private String m_description = "";

        CreateManualModuleData() {
        }

        public final void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public final void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        final String getDescription() {
            assert (this.m_description != null) : "'m_description' of method 'getDescription' must not be null";
            return this.m_description;
        }

        final String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }
    }

    public static interface ICreateManualModuleInteraction
    extends ICommandInteraction {
        public boolean collectCreateModuleData(CreateManualModuleData var1);

        public void processCreateModuleResult(OperationResult var1);
    }
}

