/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;
import java.util.EnumSet;

public abstract class AbstractOpenCommand
extends SonargraphCommand {
    private final IOpenInteraction m_interaction;

    public AbstractOpenCommand(ISoftwareSystemProvider provider, IOpenInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'AbstractOpenCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    protected final boolean isUndoable() {
        return false;
    }

    protected final IOpenInteraction getInteraction() {
        return this.m_interaction;
    }

    public static interface IOpenInteraction
    extends CloseSoftwareSystemCommand.ICloseInteraction {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public boolean collectOpenData(OpenData var1);

        default public void processOpenResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processOpenResult' must not be null";
        }

        public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean var1);

        default public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
            assert (saveResult != null) : "Parameter 'saveResult' of method 'processSaveResultDueToExternalFileChangesOnOpen' must not be null";
        }

        default public boolean confirmOpenSnapshotAttached(OpenSnapshotData data) {
            assert (data != null) : "Parameter 'data' of method 'confirmOpenSnapshotAttached' must not be null";
            return true;
        }

        default public boolean confirmFileReplaceInOpenSnapshotAttached(String question) {
            assert (question != null && question.length() > 0) : "Parameter 'question' of method 'confirmFileReplaceInOpenSnapshotAttached' must not be empty";
            return true;
        }
    }

    public static final class OpenData
    implements ICommandInteractionData {
        private TFile m_location;
        private final EnumSet<ISoftwareSystemProvider.OpenOption> m_flags = EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class);
        private IFilePathListener m_listener;
        private String m_workspaceProfileName;
        private TFile m_qualityModelFile;
        private DynamicSystemInfo m_dynamicSystemInfo;

        public TFile getLocation() {
            assert (this.m_location != null) : "'m_location' of method 'getLocation' must not be null";
            return this.m_location;
        }

        public void setLocation(TFile location) {
            assert (location != null) : "Parameter 'directory' of method 'setDirectory' must not be null";
            this.m_location = location;
        }

        public void setFlags(EnumSet<ISoftwareSystemProvider.OpenOption> flags) {
            assert (flags != null) : "Parameter 'flags' of method 'setFlags' must not be null";
            this.m_flags.addAll(flags);
        }

        public void addFlags(ISoftwareSystemProvider.OpenOption ... flags) {
            assert (flags != null) : "Parameter 'flags' of method 'setFlags' must not be null";
            this.m_flags.addAll(Arrays.asList(flags));
        }

        public EnumSet<ISoftwareSystemProvider.OpenOption> getFlags() {
            return EnumSet.copyOf(this.m_flags);
        }

        public void setListener(IFilePathListener listener) {
            this.m_listener = listener;
        }

        IFilePathListener getListener() {
            return this.m_listener;
        }

        public void setWorkspaceProfileName(String profileName) {
            assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'setWorkspaceProfileName' must not be empty";
            this.m_workspaceProfileName = profileName;
        }

        public String getWorkspaceProfileName() {
            return this.m_workspaceProfileName;
        }

        public void setQualityModelFile(TFile qualityModelFile) {
            assert (qualityModelFile != null) : "Parameter 'qualityModelFile' of method 'setQualityModelFile' must not be null";
            this.m_qualityModelFile = qualityModelFile;
        }

        public TFile getQualityModelFile() {
            return this.m_qualityModelFile;
        }

        public void setDynamicSystemInfo(DynamicSystemInfo dynamicSystemInfo) {
            this.m_dynamicSystemInfo = dynamicSystemInfo;
        }

        public DynamicSystemInfo getDynamicSystemInfo() {
            return this.m_dynamicSystemInfo;
        }
    }

    public static final class OpenSnapshotData
    implements ICommandInteractionData {
        private final TFile m_defaultTargetDirectory;
        private TFile m_targetDirectory;

        OpenSnapshotData(TFile defaultTargetDirectory) {
            assert (defaultTargetDirectory != null) : "Parameter 'defaultTargetDirectory' of method 'OpenSnapshotData' must not be null";
            this.m_defaultTargetDirectory = defaultTargetDirectory;
        }

        public TFile getDefaultTargetDirectory() {
            return this.m_defaultTargetDirectory;
        }

        public void setTargetDirectory(TFile targetDirectory) {
            this.m_targetDirectory = targetDirectory;
        }

        TFile getTargetDirectory() {
            return this.m_targetDirectory;
        }
    }
}

