/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.application;

import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.PluginMetricCharacteristic;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.api.PluginMetricRange;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IPluginExtension;
import com.hello2morrow.sonargraph.core.model.metrics.PluginMetricId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SonargraphPluginRegistry
implements ISonargraphPluginContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphPluginRegistry.class);
    private final Map<SonargraphPlugin, PluginProviderId> m_pluginToProviderId = new THashMap();
    private final Map<PluginProviderId, Set<PluginIssueId>> m_pluginProviderIdToIssueIds = new THashMap();
    private final Map<PluginProviderId, Set<PluginMetricId>> m_pluginProviderIdToMetricId = new THashMap();
    private final Map<String, PluginProgrammingElementMetaData> m_typeToProgrammingElementMetaData = new THashMap();
    private final Map<String, PluginDependencyMetaData> m_typeToDependencyMetaData = new THashMap();
    private final Map<PluginProviderId, Set<PluginDependencyMetaData>> m_pluginProviderIdToDependencMetaData = new THashMap();
    private final Map<PluginProviderId, Set<PluginProgrammingElementMetaData>> m_pluginProviderIdToProgrammingElementMetaData = new THashMap();
    private SonargraphPlugin m_inInitialization;

    SonargraphPluginRegistry() {
        LOGGER.debug("Sonargraph plugin registry instantiated");
        for (SonargraphPlugin nextPlugin : SonargraphPluginManager.getInstance().getPlugins()) {
            LOGGER.debug("Initialize plugin '" + nextPlugin.getId() + "'");
            this.m_inInitialization = nextPlugin;
            PluginProviderId pluginProviderId = new PluginProviderId(nextPlugin.getId(), nextPlugin);
            this.m_pluginToProviderId.put(nextPlugin, pluginProviderId);
            nextPlugin.initialize((ISonargraphPluginContributor)this);
            this.m_inInitialization = null;
        }
    }

    private Set<PluginIssueId> getOrCreateIssueIds(PluginProviderId pluginProviderId) {
        assert (pluginProviderId != null) : "Parameter 'pluginProviderId' of method 'getOrCreateIssueIds' must not be null";
        THashSet pluginIssueIds = this.m_pluginProviderIdToIssueIds.get(pluginProviderId);
        if (pluginIssueIds == null) {
            pluginIssueIds = new THashSet(5);
            this.m_pluginProviderIdToIssueIds.put(pluginProviderId, (Set<PluginIssueId>)pluginIssueIds);
        }
        return pluginIssueIds;
    }

    private Set<PluginDependencyMetaData> getOrCreateDependencyMetaData(PluginProviderId pluginProviderId) {
        assert (pluginProviderId != null) : "Parameter 'pluginProviderId' of method 'getOrCreateDependencyMetaData' must not be null";
        THashSet metaData = this.m_pluginProviderIdToDependencMetaData.get(pluginProviderId);
        if (metaData == null) {
            metaData = new THashSet(5);
            this.m_pluginProviderIdToDependencMetaData.put(pluginProviderId, (Set<PluginDependencyMetaData>)metaData);
        }
        return metaData;
    }

    private Set<PluginProgrammingElementMetaData> getOrCreateProgrammingElementMetaData(PluginProviderId pluginProviderId) {
        assert (pluginProviderId != null) : "Parameter 'pluginProviderId' of method 'getOrCreateProgrammingElementMetaData' must not be null";
        THashSet metaData = this.m_pluginProviderIdToProgrammingElementMetaData.get(pluginProviderId);
        if (metaData == null) {
            metaData = new THashSet(5);
            this.m_pluginProviderIdToProgrammingElementMetaData.put(pluginProviderId, (Set<PluginProgrammingElementMetaData>)metaData);
        }
        return metaData;
    }

    private Set<PluginMetricId> getOrCreateMetricIds(PluginProviderId pluginProviderId) {
        assert (pluginProviderId != null) : "Parameter 'pluginProviderId' of method 'getOrCreateMetricIds' must not be null";
        THashSet metricIds = this.m_pluginProviderIdToMetricId.get(pluginProviderId);
        if (metricIds == null) {
            metricIds = new THashSet();
            this.m_pluginProviderIdToMetricId.put(pluginProviderId, (Set<PluginMetricId>)metricIds);
        }
        return metricIds;
    }

    void initializeSoftwareSystemProvider(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'initializeSoftwareSystemProvider' must not be null";
        if (!this.m_pluginToProviderId.isEmpty()) {
            IPluginExtension pluginExtension = provider.getInstallation().getExtension(IPluginExtension.class);
            for (PluginProviderId next : this.m_pluginToProviderId.values()) {
                pluginExtension.initializePlugin(next, this.getOrCreateIssueIds(next), this.getOrCreateProgrammingElementMetaData(next), this.getOrCreateDependencyMetaData(next), this.getOrCreateMetricIds(next));
            }
        }
    }

    public IPluginIssueId createIssueId(String id, String presentationName, PluginIssueSeverity severity, PluginIssueType type) {
        assert (this.m_inInitialization != null) : "'m_inInitialization' of method 'createIssueId' must not be null";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'createIssueId' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'createIssueId' must not be empty";
        assert (severity != null) : "Parameter 'severity' of method 'createIssueId' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createIssueId' must not be null";
        LOGGER.debug("Create issue id '{}:{}'", (Object)this.m_inInitialization.getId(), (Object)id);
        PluginProviderId pluginProviderId = this.m_pluginToProviderId.get(this.m_inInitialization);
        assert (pluginProviderId != null) : "Plugin not installed: " + this.m_inInitialization.getId();
        Set<PluginIssueId> pluginIssueIds = this.getOrCreateIssueIds(pluginProviderId);
        PluginIssueId issueId = new PluginIssueId(this.m_inInitialization, pluginProviderId, id, presentationName, severity, type);
        boolean added = pluginIssueIds.add(issueId);
        assert (added) : "Plugin issue already added: " + id;
        LOGGER.debug("Create issue id '{}:{}' - done", (Object)this.m_inInitialization.getId(), (Object)id);
        return issueId;
    }

    public IPluginMetricId createMetricId(String name, String description, boolean isFloat, PluginMetricRange range, PluginMetricCharacteristic characteristic, Set<PluginMetricLevel> levels) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'createMetricId' must not be empty";
        assert (range != null) : "Parameter 'range' of method 'createMetricId' must not be null";
        assert (characteristic != null) : "Parameter 'characteristic' of method 'createMetricId' must not be null";
        assert (levels != null && levels.size() > 0) : "Parameter 'levels' of method 'createMetricId' must not be empty";
        PluginProviderId pluginProviderId = this.m_pluginToProviderId.get(this.m_inInitialization);
        assert (pluginProviderId != null) : "Plugin not installed: " + this.m_inInitialization.getId();
        PluginMetricId id = new PluginMetricId(pluginProviderId, name, description, isFloat, range, characteristic, levels);
        LOGGER.debug("Create metric id '{}:{}'", (Object)this.m_inInitialization.getId(), (Object)id);
        THashSet metrics = this.m_pluginProviderIdToMetricId.get(pluginProviderId);
        if (metrics == null) {
            metrics = new THashSet();
            this.m_pluginProviderIdToMetricId.put(pluginProviderId, (Set<PluginMetricId>)metrics);
        }
        if (!metrics.add((PluginMetricId)id)) {
            LOGGER.error("Metric '" + name + "' has already been added to plugin " + this.m_inInitialization.getPresentationName());
            return metrics.stream().filter(metricId -> metricId.getName().equals(name)).findFirst().get();
        }
        LOGGER.debug("Create metric id '{}:{}' - done", (Object)this.m_inInitialization.getId(), (Object)id);
        return id;
    }

    public PluginProgrammingElementMetaData createProgrammingElementMetaData(String type, String imageResourceName, boolean isComponent) {
        assert (this.m_inInitialization != null) : "'m_inInitialization' of method 'createProgrammingElementMetaData' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'createProgrammingElementMetaData' must not be empty";
        assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'createProgrammingElementMetaData' must not be empty";
        LOGGER.debug("Create plugin programming element meta data '" + this.m_inInitialization.getId() + "'");
        PluginProviderId pluginProviderId = this.m_pluginToProviderId.get(this.m_inInitialization);
        assert (pluginProviderId != null) : "Plugin not installed: " + this.m_inInitialization.getId();
        Set<PluginProgrammingElementMetaData> pluginMetaData = this.getOrCreateProgrammingElementMetaData(pluginProviderId);
        PluginProgrammingElementMetaData metaData = this.m_typeToProgrammingElementMetaData.get(type);
        if (metaData == null) {
            metaData = new PluginProgrammingElementMetaData(type, imageResourceName, isComponent);
            this.m_typeToProgrammingElementMetaData.put(type, metaData);
        } else {
            assert (imageResourceName.equals(metaData.getImageResourceName())) : "Different 'imageResourceName'";
            assert (isComponent == metaData.isComponent()) : "Different 'isComponent'";
        }
        boolean added = pluginMetaData.add(metaData);
        assert (added) : "Already added programming element meta data: " + String.valueOf(metaData);
        LOGGER.debug("Create plugin programming element meta data '" + this.m_inInitialization.getId() + "' - done: " + String.valueOf(metaData));
        return metaData;
    }

    public PluginDependencyMetaData createDependencyMetaData(String type, boolean isCompileTimeDependency, boolean isArchitectureRelevant, boolean includeInCycleAnalysis) {
        assert (this.m_inInitialization != null) : "'m_inInitialization' of method 'createDependencyMetaData' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'registerDependencyMetaData' must not be empty";
        LOGGER.debug("Create plugin dependency meta data '" + this.m_inInitialization.getId() + "'");
        PluginProviderId pluginProviderId = this.m_pluginToProviderId.get(this.m_inInitialization);
        assert (pluginProviderId != null) : "Plugin not installed: " + this.m_inInitialization.getId();
        Set<PluginDependencyMetaData> pluginMetaData = this.getOrCreateDependencyMetaData(pluginProviderId);
        PluginDependencyMetaData metaData = this.m_typeToDependencyMetaData.get(type);
        if (metaData == null) {
            metaData = new PluginDependencyMetaData(type, isCompileTimeDependency, isArchitectureRelevant, includeInCycleAnalysis);
            this.m_typeToDependencyMetaData.put(type, metaData);
        } else {
            assert (isCompileTimeDependency == metaData.isCompileTimeDependency()) : "Different 'isCompileTimeDependency'";
            assert (isArchitectureRelevant == metaData.isArchiectureRelevant()) : "Different 'isArchitectureRelevant'";
            assert (includeInCycleAnalysis == metaData.includeInCycleAnalysis()) : "Different 'includeInCycleAnalysis'";
        }
        boolean added = pluginMetaData.add(metaData);
        assert (added) : "Already added dependency meta data: " + String.valueOf(metaData);
        LOGGER.debug("Create plugin dependency meta data '" + this.m_inInitialization.getId() + "' - done: " + String.valueOf(metaData));
        return metaData;
    }
}

