/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.script.model;

import com.hello2morrow.sonargraph.core.api.model.DependencyAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.SourceFileAccess;
import com.hello2morrow.sonargraph.core.api.model.SourceLineAccess;
import com.hello2morrow.sonargraph.core.api.script.model.MetricIdAccess;
import com.hello2morrow.sonargraph.core.api.script.model.NodeAccess;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;

public final class ResultAccess {
    private final ScriptResultSet m_scriptResultSet;

    public ResultAccess(ScriptResultSet scriptResultSet) {
        assert (scriptResultSet != null) : "Parameter 'scriptResultSet' of method 'ResultSetAccess' must not be null";
        this.m_scriptResultSet = scriptResultSet;
    }

    public void addElement(ElementAccess<? extends Element> elementAccess) {
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be empty");
        }
        this.m_scriptResultSet.add(elementAccess.getElement());
    }

    public void addMetricValue(MetricIdAccess id, ElementAccess<? extends NamedElement> elementAccess, Number value) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null");
        }
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null");
        }
        IMetricLevel metricLevel = (IMetricLevel)elementAccess.getMetricLevel();
        if (metricLevel == null) {
            throw new IllegalArgumentException("Metrics are not supported for class '" + elementAccess.getClass().getSimpleName() + "'");
        }
        this.m_scriptResultSet.addMetric(id.getId(), metricLevel, elementAccess.getElement(), value);
    }

    public NodeAccess addNode(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'name' must not be empty");
        }
        return new NodeAccess(this.m_scriptResultSet.addNode(name));
    }

    public NodeAccess addNode(ElementAccess<? extends Element> elementAccess) {
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        return new NodeAccess(this.m_scriptResultSet.addNode(elementAccess.getElement()));
    }

    public NodeAccess addNode(NodeAccess nodeAccess, ElementAccess<? extends Element> elementAccess) {
        if (nodeAccess == null) {
            throw new IllegalArgumentException("Parameter 'nodeAccess' must not be null");
        }
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        return new NodeAccess(this.m_scriptResultSet.addNode(elementAccess.getElement(), nodeAccess.getNode()));
    }

    public NodeAccess addNode(NodeAccess nodeAccess, String name) {
        if (nodeAccess == null) {
            throw new IllegalArgumentException("Parameter 'nodeAccess' must not be null");
        }
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'name' must not be empty");
        }
        return new NodeAccess(this.m_scriptResultSet.addNode(name, nodeAccess.getNode()));
    }

    public NodeAccess addDependencyNode(NodeAccess nodeAccess, DependencyAccess dependencyAccess) {
        if (nodeAccess == null) {
            throw new IllegalArgumentException("Parameter 'nodeAccess' must not be null");
        }
        if (dependencyAccess == null) {
            throw new IllegalArgumentException("Parameter 'dependencyAccess' must not be null");
        }
        return new NodeAccess(this.m_scriptResultSet.addDependencyNode(new AggregatedDependency((ParserDependency)dependencyAccess.getElement()), nodeAccess.getNode()));
    }

    public NodeAccess addDependencyNode(DependencyAccess dependencyAccess) {
        if (dependencyAccess == null) {
            throw new IllegalArgumentException("Parameter 'dependencyAccess' must not be null");
        }
        return new NodeAccess(this.m_scriptResultSet.addDependencyNode(new AggregatedDependency((ParserDependency)dependencyAccess.getElement())));
    }

    public boolean addErrorIssue(ElementAccess<?> elementAccess, String issueId, String description) {
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        return this.m_scriptResultSet.addErrorIssue((Element)elementAccess.getElement(), issueId, description);
    }

    public boolean addInfoIssue(ElementAccess<?> elementAccess, String issueId, String description) {
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        return this.m_scriptResultSet.addInfoIssue((Element)elementAccess.getElement(), issueId, description);
    }

    public boolean addWarningIssue(ElementAccess<?> elementAccess, String issueId, String description) {
        if (elementAccess == null) {
            throw new IllegalArgumentException("Parameter 'elementAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        return this.m_scriptResultSet.addWarningIssue((Element)elementAccess.getElement(), issueId, description);
    }

    public void addWarningIssue(SourceFileAccess sourceFileAccess, String issueId, String description, int line) {
        if (sourceFileAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceFileAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        this.m_scriptResultSet.addWarningIssue((SourceFile)sourceFileAccess.getElement(), issueId, description, line);
    }

    public void addErrorIssue(SourceFileAccess sourceFileAccess, String issueId, String description, SourceLineAccess lineAccess) {
        if (sourceFileAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceFileAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        this.m_scriptResultSet.addErrorIssue((SourceFile)sourceFileAccess.getElement(), issueId, description, lineAccess.getLine());
    }

    public void addWarningIssue(SourceFileAccess sourceFileAccess, String issueId, String description, SourceLineAccess sourceLineAccess) {
        if (sourceFileAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceFileAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        if (sourceLineAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceLineAccess' must not be null");
        }
        this.m_scriptResultSet.addWarningIssue((SourceFile)sourceFileAccess.getElement(), issueId, description, sourceLineAccess.getLine());
    }

    public void addInfoIssue(SourceFileAccess sourceFileAccess, String issueId, String description, int line) {
        if (sourceFileAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceFileAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        this.m_scriptResultSet.addInfoIssue((SourceFile)sourceFileAccess.getElement(), issueId, description, line);
    }

    public void addInfoIssue(SourceFileAccess sourceFileAccess, String issueId, String description, SourceLineAccess sourceLineAccess) {
        if (sourceFileAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceFileAccess' must not be null");
        }
        if (issueId == null || issueId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter 'issueId' must not be empty");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter 'description' must not be null");
        }
        if (sourceLineAccess == null) {
            throw new IllegalArgumentException("Parameter 'sourceLineAccess' must not be null");
        }
        this.m_scriptResultSet.addInfoIssue((SourceFile)sourceFileAccess.getElement(), issueId, description, sourceLineAccess.getLine());
    }
}

