/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.collections;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class MultipleValueMap<K, V> {
    private final Map<K, ArrayList<V>> m_map;

    public MultipleValueMap() {
        this.m_map = new THashMap();
    }

    public MultipleValueMap(int size) {
        this.m_map = new THashMap(size);
    }

    public void compact() {
        this.m_map.values().forEach(l -> l.trimToSize());
    }

    public boolean put(K key, V value) {
        boolean result;
        assert (key != null) : "Parameter 'key' of method 'put' must not be null";
        assert (value != null) : "Parameter 'value' of method 'put' must not be null";
        ArrayList<Object> entry = this.m_map.get(key);
        if (entry == null) {
            entry = new ArrayList();
            this.m_map.put(key, entry);
            result = false;
        } else {
            result = true;
        }
        entry.add(value);
        return result;
    }

    public boolean putIfNotPresent(K key, V value) {
        assert (key != null) : "Parameter 'key' of method 'putIfNotPresent' must not be null";
        assert (value != null) : "Parameter 'value' of method 'putIfNotPresent' must not be null";
        ArrayList<V> list = this.m_map.get(key);
        if (list == null) {
            this.put(key, value);
            return true;
        }
        if (!list.contains(value)) {
            list.add(value);
            return true;
        }
        return false;
    }

    public void putAll(MultipleValueMap<K, V> other) {
        assert (other != null) : "Parameter 'other' of method 'putAll' must not be null";
        for (K key : other.keySet()) {
            for (V value : other.get(key)) {
                this.put(key, value);
            }
        }
    }

    public List<V> get(K key) {
        ArrayList<V> list = this.m_map.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public V getFirst(K key) {
        List<V> values = this.get(key);
        if (values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (V)values.stream().findFirst().get();
    }

    public void removeValuesOf(K key) {
        this.m_map.remove(key);
    }

    public V getFirstValue(K key) {
        List list = this.m_map.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (V)list.get(0);
    }

    public Collection<K> keySet() {
        return this.m_map.keySet();
    }

    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>(this.m_map.size() + 100);
        for (ArrayList<V> list : this.m_map.values()) {
            result.addAll(list);
        }
        return result;
    }

    public boolean remove(K key, V value) {
        assert (key != null) : "remove: 'key' must not be null";
        assert (value != null) : "remove: 'value' must not be null";
        ArrayList<V> list = this.m_map.get(key);
        if (list == null) {
            return false;
        }
        boolean result = list.remove(value);
        if (result && list.size() == 0) {
            this.m_map.remove(key);
        }
        return result;
    }

    public boolean removeValue(V value) {
        Map.Entry<K, ArrayList<V>> theEntry = null;
        for (Map.Entry<K, ArrayList<V>> entry : this.m_map.entrySet()) {
            if (!entry.getValue().remove(value)) continue;
            theEntry = entry;
            break;
        }
        if (theEntry == null) {
            return false;
        }
        if (((ArrayList)theEntry.getValue()).size() == 0) {
            this.m_map.remove(theEntry.getKey());
        }
        return true;
    }

    public boolean isEmpty() {
        return this.m_map.size() == 0;
    }

    public void clear() {
        this.m_map.clear();
    }

    public int size() {
        return this.m_map.size();
    }

    public String toString() {
        return this.m_map.toString();
    }
}

