/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.lexer;

import com.hello2morrow.javapg.runtime.lexer.State;
import com.hello2morrow.javapg.runtime.lexer.Token;
import com.hello2morrow.javapg.runtime.lexer.base.AbstractLexer;
import java.io.IOException;

public abstract class DFALexer
extends AbstractLexer {
    public static final Token errorToken = new Token(1);
    private final int initialState;
    private final int atBolState;
    private final State[] states;
    private final byte[] clsMap;
    private final char[] rangeMap;
    private final String[] literals;
    private String lexeme = null;
    private int lexemeEnd = -1;

    protected DFALexer(State[] states, int initialState, int atBolState, byte[] clsMap, char[] rangeMap, String[] lit) {
        this.initialState = initialState;
        this.atBolState = atBolState;
        this.states = states;
        this.clsMap = clsMap;
        this.rangeMap = rangeMap;
        this.literals = lit;
    }

    @Override
    public String getLexeme() {
        if (this.lexeme == null || this.currentPos != this.lexemeEnd) {
            this.lexeme = super.getLexeme();
            this.lexemeEnd = this.currentPos;
        }
        return this.lexeme;
    }

    @Override
    public void popState() {
        super.popState();
        this.lexeme = null;
    }

    @Override
    public String decode(int token) {
        assert (token >= 0 && token < this.literals.length);
        return this.literals[token];
    }

    @Override
    public int getNumberOfTokens() {
        return this.literals.length;
    }

    @Override
    protected int tokenize() throws IOException {
        this.lexeme = null;
        int ch = this.nextChar();
        if (ch == -1) {
            return 0;
        }
        int stateNo = this.column == 1 ? this.atBolState : this.initialState;
        State currentState = this.states[stateNo];
        Token token = errorToken;
        this.mark();
        while (true) {
            int charClass;
            if (ch == -1) {
                if (token != errorToken) break;
                this.mark();
                break;
            }
            if (ch < 128) {
                charClass = this.clsMap[ch];
            } else {
                int high = this.rangeMap.length / 3;
                charClass = -1;
                int low = 0;
                while (low < high) {
                    int mid = (high + low) / 2;
                    if (this.rangeMap[3 * mid] > ch) {
                        high = mid;
                        continue;
                    }
                    if (ch > this.rangeMap[3 * mid + 1]) {
                        low = mid + 1;
                        continue;
                    }
                    charClass = this.rangeMap[3 * mid + 2];
                    break;
                }
            }
            if (charClass == -1 || (currentState = currentState.onInput(this.states, charClass)) == null) break;
            Token newToken = currentState.getToken();
            if (newToken != null) {
                this.mark();
                token = newToken;
            }
            ch = this.nextChar();
        }
        this.reset();
        return token.getCode(this.isSkipKeywordSearch() ? null : this);
    }
}

