/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.windows;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WinRegistryJava11 {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(WinRegistryJava11.class);
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private WinRegistryJava11() {
        assert (!Platform.isOperatingSystemUnixBased()) : "WinRegistry should only be used on Windows";
        assert (Platform.getJavaVersion() >= 11) : "WinRegistryJava11 must only be instantiated for Java 11 and higher";
    }

    public static String readString(long hkey, String key, String valueName) {
        assert (hkey == -2147483646L || hkey == -2147483647L) : "Invalid hkey";
        if (hkey == -2147483646L) {
            return WinRegistryJava11.readString(systemRoot, hkey, key, valueName);
        }
        return WinRegistryJava11.readString(userRoot, hkey, key, valueName);
    }

    public static Map<String, String> readStringValues(long hkey, String key) {
        assert (hkey == -2147483646L || hkey == -2147483647L) : "Invalid hkey";
        if (hkey == -2147483646L) {
            return WinRegistryJava11.readStringValues(systemRoot, hkey, key);
        }
        return WinRegistryJava11.readStringValues(userRoot, hkey, key);
    }

    public static List<String> readStringSubKeys(int hkey, String key) {
        if (hkey == -2147483646) {
            return WinRegistryJava11.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistryJava11.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, long hkey, String key, String value) {
        long[] handles;
        byte[] valb;
        block3: {
            valb = null;
            handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava11.toCstr(key), 131097);
            if (handles[1] == 0L) break block3;
            return null;
        }
        try {
            valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistryJava11.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, long hkey, String key) {
        long[] handles;
        LinkedHashMap<String, String> results;
        block4: {
            results = new LinkedHashMap<String, String>();
            handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava11.toCstr(key), 131097);
            if (handles[1] == 0L) break block4;
            return null;
        }
        try {
            long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
            long count = info[2];
            int maxlen = (int)info[4];
            int index = 0;
            while ((long)index < count) {
                byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
                String value = WinRegistryJava11.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
                ++index;
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) {
        long[] handles;
        ArrayList<String> results;
        block4: {
            results = new ArrayList<String>();
            handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava11.toCstr(key), 131097);
            if (handles[1] == 0L) break block4;
            return null;
        }
        try {
            long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
            long count = info[0];
            int maxlen = (int)info[3];
            int index = 0;
            while ((long)index < count) {
                byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
                results.add(new String(name).trim());
                ++index;
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }
}

