/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class ResourceProviderAdapter
implements ResourceProviderRegistry.IResourceProviderAdapter {
    private final String[] m_ResourceDirectories;
    private final String m_ResourceBundleName;

    protected ResourceProviderAdapter(String[] resourceDirectories, String resourceBundleName, ResourceProviderAdapter ... dependsUpon) {
        assert (resourceDirectories != null && resourceDirectories.length > 0) : "Parameter 'resourceDirectories' of method 'ResourceProviderAdapter' must not be empty";
        assert (resourceBundleName != null && resourceBundleName.length() > 0) : "Parameter 'resourceBundleName' of method 'register' must not be empty";
        this.m_ResourceDirectories = resourceDirectories;
        this.m_ResourceBundleName = resourceBundleName;
        ArrayList<ResourceProviderRegistry.IResourceProviderAdapter> chain = new ArrayList<ResourceProviderRegistry.IResourceProviderAdapter>();
        chain.add(this);
        if (dependsUpon != null && dependsUpon.length > 0) {
            ResourceProviderAdapter[] resourceProviderAdapterArray = dependsUpon;
            int n = dependsUpon.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceProviderAdapter nextDependsUpon = resourceProviderAdapterArray[n2];
                List<? extends ResourceProviderRegistry.IResourceProviderAdapter> nextChainOfNextDependsUpon = ResourceProviderRegistry.getInstance().getChain(nextDependsUpon);
                for (ResourceProviderRegistry.IResourceProviderAdapter iResourceProviderAdapter : nextChainOfNextDependsUpon) {
                    chain.add(iResourceProviderAdapter);
                }
                ++n2;
            }
        }
        ArrayList copyOfChain = new ArrayList(chain);
        int i = copyOfChain.size() - 1;
        while (i >= 0) {
            ResourceProviderRegistry.IResourceProviderAdapter next = (ResourceProviderRegistry.IResourceProviderAdapter)copyOfChain.get(i);
            int index = chain.indexOf(next);
            while (index != chain.lastIndexOf(next)) {
                chain.remove(index);
                index = chain.indexOf(next);
            }
            --i;
        }
        ResourceProviderRegistry.getInstance().register(chain);
    }

    public final URL getResourceUrl(ResourceProviderRegistry.IResourceType type, String resourceName) {
        return ResourceProviderRegistry.getInstance().getResourceUrl(this, type, resourceName);
    }

    public final String getString(String key, Object ... arguments) {
        return ResourceProviderRegistry.getInstance().getString(this, key, arguments);
    }

    @Override
    public final List<String> getResourceBundlePaths() {
        ArrayList<String> paths = new ArrayList<String>(this.m_ResourceDirectories.length);
        String[] stringArray = this.m_ResourceDirectories;
        int n = this.m_ResourceDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            String nextResourceDirectory = stringArray[n2];
            paths.add((String)(nextResourceDirectory.length() == 0 ? this.m_ResourceBundleName : nextResourceDirectory.replace('/', '.') + "." + this.m_ResourceBundleName));
            ++n2;
        }
        return paths;
    }

    @Override
    public final List<String> getResourcePaths(ResourceProviderRegistry.IResourceType type, String resourceName) {
        assert (type != null) : "Parameter 'type' of method 'getResourcePath' must not be null";
        assert (resourceName != null && resourceName.length() > 0) : "Parameter 'resourceName' of method 'getResourcePath' must not be empty";
        ArrayList<String> paths = new ArrayList<String>(this.m_ResourceDirectories.length);
        String[] stringArray = this.m_ResourceDirectories;
        int n = this.m_ResourceDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            String nextResourceDirectory;
            paths.add(nextResourceDirectory + ((nextResourceDirectory = stringArray[n2]).length() > 0 ? "/" : "") + resourceName + type.getExtension());
            ++n2;
        }
        return paths;
    }
}

