/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.EnumSet;

public final class EnumUtility {
    private static final String COMMA = ",";

    private EnumUtility() {
    }

    public static String concat(EnumSet<?> enumSet, String delimiter) {
        assert (enumSet != null) : "Parameter 'enumSet' of method 'concat' must not be null";
        assert (delimiter != null) : "Parameter 'delimiter' of method 'concat' must not be null";
        StringBuilder sb = new StringBuilder("");
        boolean first = true;
        for (Enum next : enumSet) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append(next.name());
            first = false;
        }
        return sb.toString();
    }

    public static String concatEnumValues(EnumSet<?> enumSet) {
        return EnumUtility.concat(enumSet, COMMA);
    }

    public static <E extends Enum<E>> EnumSet<E> parseEnumValues(String string, Class<E> clazz) {
        String[] elements;
        assert (string != null) : "Parameter 'string' of method 'parseEnumValues' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'parseEnumValues' must not be null";
        EnumSet<Enum> result = EnumSet.noneOf(clazz);
        String[] stringArray = elements = string.split(COMMA);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            element = element.trim();
            for (Enum nextEnumValue : EnumSet.allOf(clazz)) {
                if (!nextEnumValue.name().equals(element)) continue;
                result.add(nextEnumValue);
                break;
            }
            ++n2;
        }
        return result;
    }
}

