/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.persistence;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectPersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectWriter
extends ObjectPersistence
implements IObjectWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectWriter.class);
    private final Map<IPersistable, Integer> m_objectToId = new LinkedHashMap<IPersistable, Integer>(5000);
    private final Map<String, Integer> m_stringToId = new HashMap<String, Integer>();
    private WritableByteChannel m_dataChannel;
    private ByteBuffer m_dataBuffer;
    private ZipOutputStream m_zos;
    private List<String> m_attributes;
    private final Deque<List<String>> m_attrStack = new ArrayDeque<List<String>>();
    private final Map<IPersistable, Integer> m_delayedRefs = new LinkedHashMap<IPersistable, Integer>();

    public void store(TFile file, IPersistable object) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'store' must not be null";
        assert (object != null) : "Parameter 'object' of method 'store' must not be null";
        ArrayList<IPersistable> objects = new ArrayList<IPersistable>(1);
        objects.add(object);
        this.storeChildrenAndAdditionalObjects(file, objects);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void storeChildrenAndAdditionalObjects(TFile file, List<? extends IPersistable> objects) throws IOException {
        if (!ObjectWriter.$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"Parameter 'file' of method 'persist' must not be null");
        }
        if (!ObjectWriter.$assertionsDisabled && objects == null) {
            throw new AssertionError((Object)"Parameter 'objects' of method 'persist' must not be null");
        }
        if (file.exists()) {
            file.rm_r();
        }
        tmpFile = new TFile(file.getPath() + ".tmp");
        try {
            try {
                var4_4 = null;
                var5_7 = null;
                try {
                    dataStream = new FileOutputStream((File)tmpFile);
                    try {
                        zos = new ZipOutputStream(dataStream);
                        try {
                            dataChannel = Channels.newChannel(zos);
                            try {
                                this.m_dataBuffer = ByteBuffer.allocateDirect(65536);
                                this.m_zos = zos;
                                this.m_dataChannel = dataChannel;
                                this.beginSegment("model.dat");
                                this.ensureBufferSpace(6);
                                this.m_dataBuffer.putInt(538970372);
                                this.m_dataBuffer.putShort((short)1);
                                for (IPersistable obj : objects) {
                                    if (!obj.persist()) continue;
                                    this.writeObject(obj);
                                }
                                this.writeBuffer();
                                this.endSegment();
                                if (!this.m_delayedRefs.isEmpty()) {
                                    this.beginSegment("reftable.dat");
                                    this.ensureBufferSpace(8);
                                    this.m_dataBuffer.putInt(538970372);
                                    this.m_dataBuffer.putInt(this.m_delayedRefs.size());
                                    for (Map.Entry entry : this.m_delayedRefs.entrySet()) {
                                        realIndex = this.m_objectToId.get(entry.getKey());
                                        if (!ObjectWriter.$assertionsDisabled && realIndex == null) {
                                            throw new AssertionError((Object)("Missing object: " + ((IPersistable)entry.getKey()).toString()));
                                        }
                                        this.ensureBufferSpace(4);
                                        this.m_dataBuffer.putInt(realIndex);
                                    }
                                    this.writeBuffer();
                                    this.endSegment();
                                }
                                this.writeExtraSegments();
                            }
                            finally {
                                if (dataChannel != null) {
                                    dataChannel.close();
                                }
                            }
                            ** if (zos == null) goto lbl-1000
                        }
                        catch (Throwable var5_8) {
                            if (var4_4 == null) {
                                var4_4 = var5_8;
                            } else if (var4_4 != var5_8) {
                                var4_4.addSuppressed(var5_8);
                            }
                            if (zos != null) {
                                zos.close();
                            }
                            throw var4_4;
                        }
lbl-1000:
                        // 1 sources

                        {
                            zos.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (dataStream == null) goto lbl-1000
                    }
                    catch (Throwable var5_9) {
                        if (var4_4 == null) {
                            var4_4 = var5_9;
                        } else if (var4_4 != var5_9) {
                            var4_4.addSuppressed(var5_9);
                        }
                        if (dataStream != null) {
                            dataStream.close();
                        }
                        throw var4_4;
                    }
lbl-1000:
                    // 1 sources

                    {
                        dataStream.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var5_10) {
                    if (var4_4 == null) {
                        var4_4 = var5_10;
                    } else if (var4_4 != var5_10) {
                        var4_4.addSuppressed(var5_10);
                    }
                    throw var4_4;
                }
            }
            catch (Throwable e) {
                ObjectWriter.LOGGER.error("Failed to write analyzer result: " + file.getName(), e);
                tmpFile.rm_r();
                throw e;
            }
        }
        finally {
            this.m_zos = null;
            this.m_dataChannel = null;
        }
        tmpFile.mv((File)file);
    }

    protected void writeExtraSegments() {
    }

    private void writeObject(IPersistable persistable) throws IOException {
        assert (persistable != null) : "Parameter 'persistable' of method 'writeObject' must not be null";
        this.startObject(persistable.getPersistableType(), persistable);
        persistable.writeAttributes(this);
        if (persistable.hasPersistableChildren()) {
            this.endObject(true);
            for (IPersistable iPersistable : persistable.getPersistableChildren()) {
                if (!iPersistable.persist()) continue;
                this.writeObject(iPersistable);
            }
            this.lastChildWritten();
        } else {
            this.endObject(false);
        }
    }

    private void writeBuffer() throws IOException {
        this.m_dataBuffer.flip();
        this.m_dataChannel.write(this.m_dataBuffer);
        this.m_dataBuffer.clear();
    }

    public void beginSegment(String segmentName) throws IOException {
        assert (segmentName != null && segmentName.length() > 0) : "Parameter 'segmentName' of method 'beginSegment' must not be empty";
        this.m_zos.putNextEntry(new ZipEntry(segmentName));
    }

    public void endSegment() throws IOException {
        this.m_zos.closeEntry();
    }

    private void ensureBufferSpace(int bytes) throws IOException {
        if (this.m_dataBuffer.remaining() < bytes) {
            this.writeBuffer();
            while (this.m_dataBuffer.remaining() < bytes) {
                this.m_dataBuffer = ByteBuffer.allocateDirect(this.m_dataBuffer.capacity() * 2);
            }
        }
    }

    protected void checkAttribute(String attributeName) {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'checkAttribute' must not be empty";
        boolean done = this.m_attributes.add(attributeName);
        assert (done) : "Attribute name '" + attributeName + "' is already in use";
    }

    protected void writeByte(byte value) throws IOException {
        this.ensureBufferSpace(2);
        this.m_dataBuffer.put((byte)98);
        this.m_dataBuffer.put(value);
    }

    @Override
    public void writeByte(String attributeName, byte value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeByte(value);
    }

    protected void writeShort(short value) throws IOException {
        this.ensureBufferSpace(3);
        this.m_dataBuffer.put((byte)104);
        this.m_dataBuffer.putShort(value);
    }

    @Override
    public void writeShort(String attributeName, short value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeShort(value);
    }

    protected void writeInt(int value) throws IOException {
        this.ensureBufferSpace(5);
        this.m_dataBuffer.put((byte)105);
        this.m_dataBuffer.putInt(value);
    }

    @Override
    public void writeInt(String attributeName, int value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeInt(value);
    }

    protected void writeLong(long value) throws IOException {
        this.ensureBufferSpace(9);
        this.m_dataBuffer.put((byte)108);
        this.m_dataBuffer.putLong(value);
    }

    @Override
    public void writeLong(String attributeName, long value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeLong(value);
    }

    protected void writeFloat(float value) throws IOException {
        this.ensureBufferSpace(5);
        this.m_dataBuffer.put((byte)102);
        this.m_dataBuffer.putFloat(value);
    }

    @Override
    public void writeFloat(String attributeName, float value) throws IOException {
        this.checkAttribute(attributeName);
        this.ensureBufferSpace(5);
        this.m_dataBuffer.put((byte)102);
        this.m_dataBuffer.putFloat(value);
    }

    protected void writeDouble(double value) throws IOException {
        this.ensureBufferSpace(9);
        this.m_dataBuffer.put((byte)100);
        this.m_dataBuffer.putDouble(value);
    }

    @Override
    public void writeDouble(String attributeName, double value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeDouble(value);
    }

    protected void writeBoolean(boolean value) throws IOException {
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put(value ? (byte)84 : 70);
    }

    @Override
    public void writeBoolean(String attributeName, boolean value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeBoolean(value);
    }

    protected void writeString(String value) throws IOException {
        if (value == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        } else if (value.length() == 0) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)101);
        } else {
            Integer index = this.m_stringToId.get(value);
            if (index == null) {
                int i = this.m_stringToId.size();
                this.m_stringToId.put(value, i);
                byte[] bytes = value.getBytes(UTF8);
                if (bytes.length < 128) {
                    this.ensureBufferSpace(2 + bytes.length);
                    this.m_dataBuffer.put((byte)115);
                    this.m_dataBuffer.put((byte)bytes.length);
                    this.m_dataBuffer.put(bytes);
                } else if (bytes.length < 32768) {
                    this.ensureBufferSpace(3 + bytes.length);
                    this.m_dataBuffer.put((byte)83);
                    this.m_dataBuffer.putShort((short)bytes.length);
                    this.m_dataBuffer.put(bytes);
                } else {
                    this.ensureBufferSpace(5 + bytes.length);
                    this.m_dataBuffer.put((byte)76);
                    this.m_dataBuffer.putInt(bytes.length);
                    this.m_dataBuffer.put(bytes);
                }
            } else {
                this.ensureBufferSpace(5);
                this.m_dataBuffer.put((byte)109);
                this.m_dataBuffer.putInt(index);
            }
        }
    }

    @Override
    public void writeString(String attributeName, String value) throws IOException {
        this.checkAttribute(attributeName);
        this.writeString(value);
    }

    @Override
    public void writeEnumConstant(String attributeName, Enum<?> obj) throws IOException {
        this.checkAttribute(attributeName);
        this.ensureBufferSpace(1);
        if (obj == null) {
            this.m_dataBuffer.put((byte)48);
        } else {
            this.m_dataBuffer.put((byte)69);
            this.writeString(obj.getClass().getName());
            this.writeString(obj.name());
        }
    }

    protected void writeObjectReference(IPersistable object) throws IOException {
        if (object == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        } else {
            Integer existingRef = this.m_objectToId.get(object);
            this.ensureBufferSpace(5);
            if (existingRef != null) {
                this.m_dataBuffer.put((byte)114);
                this.m_dataBuffer.putInt(existingRef);
            } else {
                Integer index = this.m_delayedRefs.get(object);
                if (index == null) {
                    index = this.m_delayedRefs.size();
                    this.m_delayedRefs.put(object, index);
                }
                this.m_dataBuffer.put((byte)82);
                this.m_dataBuffer.putInt(index);
            }
        }
    }

    @Override
    public final void writeObjectReference(String attributeName, IPersistable object) throws IOException {
        this.checkAttribute(attributeName);
        this.writeObjectReference(object);
    }

    @Override
    public void writeOther(String attributeName, Object obj) throws IOException {
        if (obj instanceof Enum) {
            this.writeEnumConstant(attributeName, (Enum)obj);
        } else {
            this.checkAttribute(attributeName);
            assert (obj == null) : "Cannot handle other objects, must be implemented by subclasses";
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        }
    }

    @Override
    public void writeObjectReferenceArray(String attributeName, IPersistable[] objects) throws IOException {
        this.checkAttribute(attributeName);
        if (objects == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        } else {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)91);
            int i = 0;
            while (i < objects.length) {
                this.writeObjectReference(objects[i]);
                ++i;
            }
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)93);
        }
    }

    @Override
    public <T extends IPersistable> void writeOwnedObjects(String attributeName, T[] objects) throws IOException {
        this.checkAttribute(attributeName);
        this.ensureBufferSpace(1);
        if (objects == null) {
            this.m_dataBuffer.put((byte)48);
        } else if (objects.length == 0) {
            this.m_dataBuffer.put((byte)101);
        } else {
            this.m_dataBuffer.put((byte)91);
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                this.writeObject((IPersistable)obj);
                ++n2;
            }
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)93);
        }
    }

    @Override
    public void writeStringArray(String attributeName, String[] value) throws IOException {
        this.checkAttribute(attributeName);
        if (value == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        } else {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)91);
            int i = 0;
            while (i < value.length) {
                this.writeString(value[i]);
                ++i;
            }
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)93);
        }
    }

    private void startObject(String kind, IPersistable obj) throws IOException {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'startObject' must not be empty";
        assert (obj != null) : "Parameter 'obj' of method 'startObject' must not be null";
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put((byte)111);
        this.writeString(kind);
        Integer entry = this.m_objectToId.put(obj, this.m_objectToId.size());
        assert (entry == null) : "Object has already been stored: " + obj.toString();
        if (this.m_attributes != null) {
            this.m_attrStack.push(this.m_attributes);
        }
        this.m_attributes = new ArrayList<String>();
    }

    private void endObject(boolean hasChildren) throws IOException {
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put((byte)36);
        this.writeString(String.join((CharSequence)":", this.m_attributes));
        if (hasChildren) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)40);
        }
        this.m_attributes = !this.m_attrStack.isEmpty() ? this.m_attrStack.pop() : null;
    }

    private void lastChildWritten() throws IOException {
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put((byte)41);
    }

    @Override
    public void writeIntArray(String attributeName, int[] value) throws IOException {
        this.checkAttribute(attributeName);
        if (value == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)48);
        } else {
            this.ensureBufferSpace(5);
            this.m_dataBuffer.put((byte)73);
            this.m_dataBuffer.putInt(value.length);
            int i = 0;
            while (i < value.length) {
                this.ensureBufferSpace(4);
                this.m_dataBuffer.putInt(value[i]);
                ++i;
            }
        }
    }
}

