/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.client.eclipse.application;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class EclipseRelease
extends Enum<EclipseRelease> {
    public static final /* enum */ EclipseRelease LUNA = new EclipseRelease(4, 4);
    public static final /* enum */ EclipseRelease MARS = new EclipseRelease(4, 5);
    public static final /* enum */ EclipseRelease NEON = new EclipseRelease(4, 6);
    public static final /* enum */ EclipseRelease OXYGEN = new EclipseRelease(4, 7, 0);
    public static final /* enum */ EclipseRelease OXYGEN_1 = new EclipseRelease(4, 7, 1);
    public static final /* enum */ EclipseRelease OXYGEN_2 = new EclipseRelease(4, 7, 2);
    public static final /* enum */ EclipseRelease OXYGEN_3 = new EclipseRelease(4, 7, 3);
    public static final /* enum */ EclipseRelease PHOTON = new EclipseRelease(4, 8);
    public static final /* enum */ EclipseRelease _201809 = new EclipseRelease(4, 9);
    public static final /* enum */ EclipseRelease _201812 = new EclipseRelease(4, 10);
    public static final /* enum */ EclipseRelease _201903 = new EclipseRelease(4, 11);
    public static final /* enum */ EclipseRelease NEXT_RELEASE = new EclipseRelease(4, 12);
    private final int m_major;
    private final int m_minor;
    private final int m_micro;
    public static final EclipseRelease TOO_OLD;
    private static final /* synthetic */ EclipseRelease[] ENUM$VALUES;

    static {
        ENUM$VALUES = new EclipseRelease[]{LUNA, MARS, NEON, OXYGEN, OXYGEN_1, OXYGEN_2, OXYGEN_3, PHOTON, _201809, _201812, _201903, NEXT_RELEASE};
        TOO_OLD = OXYGEN_2;
    }

    private EclipseRelease(int major, int minor) {
        this(major, minor, -1);
    }

    private EclipseRelease(int major, int minor, int micro) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public boolean isPhotonOrLater() {
        return this.isAfter(OXYGEN_3);
    }

    public boolean isSupported() {
        return this.isAfter(TOO_OLD) && this.isBefore(NEXT_RELEASE);
    }

    public boolean isBefore(EclipseRelease other) {
        assert (other != null) : "Parameter 'other' of method 'isBefore' must not be null";
        if (this.getMajor() < other.getMajor()) {
            return true;
        }
        if (this.getMajor() > other.getMajor()) {
            return false;
        }
        if (this.getMinor() < other.getMinor()) {
            return true;
        }
        if (this.getMinor() > other.getMinor()) {
            return false;
        }
        return this.getMicro() < other.getMicro();
    }

    public boolean isAfter(EclipseRelease other) {
        assert (other != null) : "Parameter 'other' of method 'isAfter' must not be null";
        return other.isBefore(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.m_major);
        result.append(".").append(this.m_minor);
        if (this.m_micro > -1) {
            result.append(".").append(this.m_micro);
        }
        return result.toString();
    }

    public static EclipseRelease parse(String eclipseVersionString) {
        if (eclipseVersionString == null || eclipseVersionString.isEmpty()) {
            return TOO_OLD;
        }
        EclipseRelease[] eclipseReleaseArray = EclipseRelease.values();
        int n = eclipseReleaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseRelease release = eclipseReleaseArray[n2];
            if (release.getMicro() > -1 ? eclipseVersionString.startsWith(release.getMajor() + "." + release.getMinor() + "." + release.getMicro() + ".") : eclipseVersionString.startsWith(release.getMajor() + "." + release.getMinor() + ".")) {
                return release;
            }
            ++n2;
        }
        return TOO_OLD;
    }

    public static EclipseRelease getEclipseRelease() {
        return EclipseRelease.parse(EclipseRelease.getEclipseVersion().toString());
    }

    public static Version getEclipseVersion() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.core.runtime.products");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle;
                IExtension ext = iExtensionArray[n2];
                IContributor contributor = ext.getContributor();
                if (contributor != null && "org.eclipse.platform".equals(contributor.getName()) && (bundle = Platform.getBundle((String)contributor.getName())) != null) {
                    return bundle.getVersion();
                }
                ++n2;
            }
        }
        return Version.emptyVersion;
    }

    public Version getProductVersion() {
        Bundle definingBundle;
        IProduct product;
        if (Platform.isRunning() && (product = Platform.getProduct()) != null && (definingBundle = product.getDefiningBundle()) != null) {
            Version platformVersion = definingBundle.getVersion();
            return platformVersion;
        }
        return Version.emptyVersion;
    }

    public static String getProductInfo() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getName();
        }
        return "<unknown product>";
    }

    public static String getInstalledFeaturesInfo() {
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            HashSet<IBundleGroup> features = new HashSet<IBundleGroup>();
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
                int n3 = iBundleGroupArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup feature2 = iBundleGroupArray[n4];
                    features.add(feature2);
                    ++n4;
                }
                ++n2;
            }
            ArrayList<IBundleGroup> sorted = new ArrayList<IBundleGroup>(features);
            sorted.sort(new Comparator<IBundleGroup>(){

                @Override
                public int compare(IBundleGroup bundle1, IBundleGroup bundle2) {
                    return bundle1.getIdentifier().compareTo(bundle2.getIdentifier());
                }
            });
            StringBuilder featureInfo = new StringBuilder();
            sorted.forEach(feature -> {
                StringBuilder stringBuilder2 = featureInfo.append(String.format("\n   %s (%s, %s)", feature.getName(), feature.getIdentifier(), feature.getVersion()));
            });
            return featureInfo.toString();
        }
        return "Failed to determine installed features";
    }

    public static EclipseRelease[] values() {
        EclipseRelease[] eclipseReleaseArray = ENUM$VALUES;
        int n = eclipseReleaseArray.length;
        EclipseRelease[] eclipseReleaseArray2 = new EclipseRelease[n];
        System.arraycopy(ENUM$VALUES, 0, eclipseReleaseArray2, 0, n);
        return eclipseReleaseArray2;
    }

    public static EclipseRelease valueOf(String string) {
        return Enum.valueOf(EclipseRelease.class, string);
    }
}

