/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.GeneratedNamedElementRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.PotentiallyDoneElementsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.MatchingElementsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.RefactoringBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.RefactoringsViewFilterConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class RefactoringsView
extends WorkbenchSlaveView
implements ISelectionChangedListener {
    private final RefactoringsViewFilterConfiguration m_configuration = new RefactoringsViewFilterConfiguration();
    private PropertyTableViewer<RefactoringDefinition> m_refactorings;
    private PropertyTableViewer<IIssue> m_matchingElements;
    private PropertyTableViewer<NamedElement> m_potentiallyDoneElements;
    private PropertyTableViewerBasedTextSearchHandler m_refactoringsTextSearchHandler;
    private PropertyTableViewerBasedTextSearchHandler m_matchingElementsTextSearchHandler;
    private PropertyTableViewerBasedTextSearchHandler m_potentiallyDoneElementsTextSearchHandler;
    private ViewComponent m_selectedViewComponent = ViewComponent.REFACTORINGS;

    @Override
    public IViewId getViewId() {
        return ViewId.REFACTORINGS_VIEW;
    }

    @Override
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    @Override
    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_refactorings.getTable(), this.m_matchingElements.getTable(), this.m_potentiallyDoneElements.getTable());
    }

    @Override
    public List<Control> getViewComponents() {
        return Arrays.asList(this.m_refactorings.getTable(), this.m_matchingElements.getTable(), this.m_potentiallyDoneElements.getTable());
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle(sashForm);
        this.m_refactorings = new PropertyTableViewer<RefactoringDefinition>((Composite)sashForm, new RefactoringBeanAdapter(), "priorityForSort", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_refactorings.addColumn("Model", "virtualModel", "virtualModel", "virtualModelImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addColumn("Refactoring Definition", "refactoringType", "refactoringType", "refactoringImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addColumn("Provider", "provider", "provider", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addEnumColumn("Status", "status", null, null, 10, StatusInfo.Status.class);
        this.m_refactorings.addColumn("Description", "description", null, null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addColumn("Information", "information", null, null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addEnumColumn("Priority", "priority", "priorityForSort", "priorityImage", 10, Priority.class);
        this.m_refactorings.addColumn("Assignee", "assignee", "assignee", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.addColumn("Created", "date", "dateForSort", null, 10, PropertyTableViewer.ColumnType.DATE);
        this.m_matchingElements = new PropertyTableViewer<IIssue>((Composite)sashForm, new MatchingElementsBeanAdapter(), "element", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_matchingElements.addColumn("Matching Element Type", "elementType", "elementType", "elementTypeImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.addColumn("Element", "element", "element", "elementImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.addColumn("Element To", "elementTo", "elementTo", "elementToImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.addColumn("Description", "description", "description", null, 45, PropertyTableViewer.ColumnType.TEXT);
        this.m_potentiallyDoneElements = new PropertyTableViewer<NamedElement>((Composite)sashForm, new PotentiallyDoneElementsBeanAdapter(), "element", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_potentiallyDoneElements.addColumn("Potentially Done Element", "element", "element", "elementImage", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactoringsTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_refactorings, "Refactorings");
        this.m_matchingElementsTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_matchingElements, "Matching Elements");
        this.m_potentiallyDoneElementsTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_potentiallyDoneElements, "Potentially Done");
        sashForm.setWeights(new int[]{50, 25, 25});
        this.refilter();
    }

    @Override
    public final void viewOptionsChanged() {
        this.refilter();
    }

    @Override
    protected void destroyViewContent() {
        this.m_selectedViewComponent = null;
    }

    @Override
    public boolean doubleClicked(Element element) {
        return element instanceof RefactoringDefinition || element instanceof GeneratedNamedElementRefactoringIssue;
    }

    @Override
    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        this.removeListeners();
        ArrayList<RefactoringDefinition> refactoringDefinitions = new ArrayList<RefactoringDefinition>(elements.size());
        for (Element next : elements) {
            assert (next instanceof RefactoringDefinition) : "Unexpected class in method 'finishShowInView': " + String.valueOf(next);
            refactoringDefinitions.add((RefactoringDefinition)next);
        }
        this.m_refactorings.getTableViewer().setSelection((ISelection)new StructuredSelection(refactoringDefinitions.toArray()));
        this.syncMatchingElements((RefactoringDefinition)refactoringDefinitions.get(0));
        this.addListeners();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        super.finishShowInView(sourceViewId, elements, options);
    }

    @Override
    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_refactorings.getTable()) {
            this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
        } else if (component == this.m_matchingElements.getTable()) {
            this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
        } else if (component == this.m_potentiallyDoneElements.getTable()) {
            this.m_selectedViewComponent = ViewComponent.POTENTIALLY_DONE_ELEMENTS;
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    @Override
    public final Control getSelectedViewComponent() {
        switch (this.m_selectedViewComponent) {
            case REFACTORINGS: {
                return this.m_refactorings.getTable();
            }
            case MATCHING_ELEMENTS: {
                return this.m_matchingElements.getTable();
            }
            case POTENTIALLY_DONE_ELEMENTS: {
                return this.m_potentiallyDoneElements.getTable();
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    public ViewComponent getSelectedViewComponentId() {
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'getSelectedViewComponentId' must not be null";
        return this.m_selectedViewComponent;
    }

    @Override
    public List<Element> getSelectedElements() {
        switch (this.m_selectedViewComponent) {
            case REFACTORINGS: {
                return SelectionProviderAdapter.getElementsFromSelection(this.m_refactorings.getSelection());
            }
            case MATCHING_ELEMENTS: {
                return SelectionProviderAdapter.getElementsFromSelection(this.m_matchingElements.getSelection());
            }
            case POTENTIALLY_DONE_ELEMENTS: {
                return SelectionProviderAdapter.getElementsFromSelection(this.m_potentiallyDoneElements.getSelection());
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    @Override
    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof DependencyIssue) {
            Dependency dependency = ((DependencyIssue)element).getAffectedElement();
            if (dependency != null) {
                return dependency.getUnderlyingFrom();
            }
        } else {
            if (element instanceof IIssue) {
                Element affectedElement = ((IIssue)element).getAffectedElement();
                if (affectedElement != null) {
                    return super.getLinkNamedElement(affectedElement);
                }
                return null;
            }
            if (element instanceof Dependency) {
                return ((Dependency)element).getUnderlyingFrom();
            }
        }
        return super.getLinkNamedElement(element);
    }

    private void createNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'createNavigationState' must not be null";
        state.addConstant(ViewData.SELECTED_VIEW_COMPONENT, this.m_selectedViewComponent);
        state.addElementsInformation(Selection.REFACTORINGS, NavigationState.getDescriptors(this.m_refactorings.getSelected(), this.getElementResolver()));
        state.addElementsInformation(Selection.MATCHING_ELEMENTS, NavigationState.getDescriptors(this.m_matchingElements.getSelected().stream().map(s -> s.getAffectedElement()).collect(Collectors.toList()), this.getElementResolver()));
        state.addElementsInformation(Selection.POTENTIALLY_DONE_ELEMENTS, NavigationState.getDescriptors(this.m_potentiallyDoneElements.getSelected(), this.getElementResolver()));
    }

    @Override
    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        this.m_selectedViewComponent = (ViewComponent)((Object)state.getConstant(ViewData.SELECTED_VIEW_COMPONENT));
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'performRestoreNavigationState' must not be null";
        List<Element> selectedRefactorings = state.getElements(Selection.REFACTORINGS, Element.class, this.getElementResolver());
        assert (selectedRefactorings != null) : "'selectedRefactorings' of method 'performRestoreNavigationState' must not be null";
        HashSet<Element> selectedMatchingElements = new HashSet<Element>(state.getElements(Selection.MATCHING_ELEMENTS, Element.class, this.getElementResolver()));
        assert (selectedMatchingElements != null) : "'selectedMatchingElements' of method 'performRestoreNavigationState' must not be null";
        List<Element> selectedPotentiallyDoneElements = state.getElements(Selection.POTENTIALLY_DONE_ELEMENTS, Element.class, this.getElementResolver());
        assert (selectedPotentiallyDoneElements != null) : "'selectedPotentiallyDoneElements' of method 'performRestoreNavigationState' must not be null";
        this.removeListeners();
        this.m_refactorings.setRedraw(false);
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        StructuredSelection refactoringsSelection = new StructuredSelection(selectedRefactorings.toArray());
        this.m_refactorings.getTableViewer().setSelection((ISelection)refactoringsSelection, true);
        Object first = refactoringsSelection.getFirstElement();
        this.syncMatchingElements(first instanceof RefactoringDefinition ? (RefactoringDefinition)first : null);
        ArrayList<IIssue> selectedIssueAccessors = new ArrayList<IIssue>(selectedMatchingElements.size());
        for (IIssue next : this.m_matchingElements.getInputData()) {
            if (!selectedMatchingElements.contains(next.getAffectedElement())) continue;
            selectedIssueAccessors.add(next);
        }
        this.m_matchingElements.getTableViewer().setSelection((ISelection)new StructuredSelection(selectedIssueAccessors.toArray()), true);
        this.m_potentiallyDoneElements.getTableViewer().setSelection((ISelection)new StructuredSelection(selectedPotentiallyDoneElements.toArray()), true);
        if (this.m_selectedViewComponent == ViewComponent.REFACTORINGS) {
            this.m_refactorings.setFocus();
        } else if (this.m_selectedViewComponent == ViewComponent.MATCHING_ELEMENTS) {
            this.m_matchingElements.setFocus();
        } else if (this.m_selectedViewComponent == ViewComponent.POTENTIALLY_DONE_ELEMENTS) {
            this.m_potentiallyDoneElements.setFocus();
        } else assert (false) : "Unhandled view section: " + String.valueOf((Object)this.m_selectedViewComponent);
        this.m_refactorings.setRedraw(true);
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
        this.addListeners();
    }

    @Override
    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        this.createNavigationState(state);
    }

    private void addListeners() {
        this.m_refactorings.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElements.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_potentiallyDoneElements.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_refactorings.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElements.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_potentiallyDoneElements.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.show(this.getSoftwareSystem().getCurrentModel().getResolutions(RefactoringDefinition.class), mode == WorkbenchView.ShowMode.AWAKE);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.removeListeners();
            this.show(this.getSoftwareSystem().getCurrentModel().getResolutions(RefactoringDefinition.class), true);
            this.addListeners();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    @Override
    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.removeListeners();
            this.m_refactorings.setRedraw(false);
            this.m_matchingElements.setRedraw(false);
            this.m_potentiallyDoneElements.setRedraw(false);
            this.m_refactorings.refresh();
            this.m_matchingElements.refresh();
            this.m_potentiallyDoneElements.refresh();
            this.m_refactorings.setRedraw(true);
            this.m_matchingElements.setRedraw(true);
            this.m_potentiallyDoneElements.setRedraw(true);
            this.addListeners();
        }
        super.analyzerModification(modification, analyzerId);
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.show(null, false);
        this.addListeners();
    }

    private void show(List<RefactoringDefinition> resolutions, boolean restoreNavigationState) {
        NavigationState state;
        assert (this.m_refactorings != null) : "'m_refactoringsTable' of method 'show' must not be null";
        this.m_refactorings.setRedraw(false);
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        this.m_refactorings.showData(null);
        this.m_matchingElements.showData(null);
        this.m_potentiallyDoneElements.showData(null);
        this.m_refactorings.showData(resolutions);
        if (restoreNavigationState && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            this.performRestoreNavigationState(state, false);
        }
        this.m_refactorings.setRedraw(true);
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
        this.refilter();
    }

    @Override
    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_refactorings.getTable()) {
            this.m_refactorings.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_matchingElements.getTable()) {
            this.m_matchingElements.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_potentiallyDoneElements.getTable()) {
            this.m_potentiallyDoneElements.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void clearFilter() {
        this.m_configuration.resetToDefault();
        this.refilter();
    }

    private void refilter() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        if (!this.m_configuration.getAssignee().isEmpty()) {
            filters.add(this.m_refactorings.createTextFilter("assignee", this.m_configuration.getAssignee()));
        }
        if (!this.m_configuration.getDescription().isEmpty()) {
            filters.add(this.m_refactorings.createTextFilter("description", this.m_configuration.getDescription()));
        }
        if (!EnumSet.allOf(Priority.class).equals(this.m_configuration.getPriority())) {
            filters.add(this.m_refactorings.createEnumFilter("priority", this.m_configuration.getPriority()));
        }
        if (!EnumSet.allOf(StatusInfo.Status.class).equals(this.m_configuration.getStatus())) {
            filters.add(this.m_refactorings.createEnumFilter("status", this.m_configuration.getStatus()));
        }
        this.m_refactorings.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    @Override
    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_refactorings != null && !this.m_refactorings.isDisposed() && !this.m_refactorings.getFilteredInputData().isEmpty();
    }

    @Override
    public String getExcelExportContentName() {
        return "Refactoring Definitions";
    }

    @Override
    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getRefactoringDefintions(this.m_refactorings.getFilteredInputData());
    }

    @Override
    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    @Override
    public ITextSearchHandler getTextSearchHandler() {
        if (this.m_selectedViewComponent == ViewComponent.REFACTORINGS) {
            return this.m_refactoringsTextSearchHandler;
        }
        if (this.m_selectedViewComponent == ViewComponent.MATCHING_ELEMENTS) {
            return this.m_matchingElementsTextSearchHandler;
        }
        if (this.m_selectedViewComponent == ViewComponent.POTENTIALLY_DONE_ELEMENTS) {
            return this.m_potentiallyDoneElementsTextSearchHandler;
        }
        assert (false) : "Unexpected value for 'm_selectedViewComponent': " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    public void setSelectedIssue(String issueKey) {
        assert (issueKey != null && issueKey.length() > 0) : "Parameter 'issueKey' of method 'setSelectedIssue' must not be empty";
        List refactorings = (List)this.m_refactorings.getTableViewer().getInput();
        for (RefactoringDefinition nextRefactoringDefinition : refactorings) {
            for (IIssue nextIssue : nextRefactoringDefinition.getAssociatedIssues()) {
                Issue issue = (Issue)nextIssue;
                if (!issueKey.startsWith(issue.getKey()) || !issueKey.endsWith(issue.getDescription())) continue;
                this.removeListeners();
                this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
                this.m_refactorings.select(Arrays.asList(nextRefactoringDefinition));
                this.syncMatchingElements(nextRefactoringDefinition);
                this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
                this.m_matchingElements.select(Arrays.asList(nextIssue));
                this.m_matchingElements.getTable().setFocus();
                this.addListeners();
                return;
            }
        }
    }

    private void syncMatchingElements(RefactoringDefinition refactoringDefinition) {
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        if (refactoringDefinition == null) {
            this.m_matchingElements.showData(null);
            this.m_potentiallyDoneElements.showData(null);
        } else {
            this.m_matchingElements.showData(refactoringDefinition.getAssociatedIssues());
            this.m_potentiallyDoneElements.showData(refactoringDefinition.getPotentiallyDoneElements());
        }
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        if (event.getSource() == this.m_refactorings.getTableViewer()) {
            this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object first = selection.getFirstElement();
            this.syncMatchingElements(first instanceof RefactoringDefinition ? (RefactoringDefinition)first : null);
        } else if (event.getSource() == this.m_matchingElements.getTableViewer()) {
            this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
            selectElements = new ArrayList<Object>();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            for (Object next : selection.toList()) {
                assert (next instanceof IIssue) : "Unexpected class: " + String.valueOf(next);
                IIssue nextIIssueAccessor = (IIssue)next;
                selectElements.add(nextIIssueAccessor.getAffectedElement());
            }
        } else if (event.getSource() == this.m_potentiallyDoneElements.getTableViewer()) {
            this.m_selectedViewComponent = ViewComponent.POTENTIALLY_DONE_ELEMENTS;
            selectElements = new ArrayList();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            for (Object next : selection.toList()) {
                assert (next instanceof NamedElement) : "Unexpected class: " + String.valueOf(next);
                selectElements.add((NamedElement)next);
            }
        } else assert (false) : "Unexpected source: " + String.valueOf(event.getSource());
        this.initializeTextSearchData();
        this.addListeners();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    private static enum Selection implements IElementGroup
    {
        REFACTORINGS,
        MATCHING_ELEMENTS,
        POTENTIALLY_DONE_ELEMENTS;

    }

    public static enum ViewComponent implements IStandardEnumeration
    {
        REFACTORINGS,
        MATCHING_ELEMENTS,
        POTENTIALLY_DONE_ELEMENTS;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ViewData implements IStateData
    {
        SELECTED_VIEW_COMPONENT;

    }
}

