/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

final class LicensePropertyValidator
implements ITextValidator {
    private final ILicenseAccess m_licenseAccess;
    private final SonargraphLicense.Property m_property;

    LicensePropertyValidator(ILicenseAccess licenseAccess, SonargraphLicense.Property property) {
        assert (licenseAccess != null) : "Parameter 'licenseAccess' of method 'LicensePropertyValidator' must not be null";
        assert (property != null) : "Parameter 'property' of method 'LicensePropertyValidator' must not be null";
        this.m_licenseAccess = licenseAccess;
        this.m_property = property;
    }

    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        SonargraphLicense license = this.m_licenseAccess.getSonargraphLicense();
        if (license == null) {
            return result;
        }
        OperationResult.IMessageCause cause = license.getValidationError(this.m_property);
        if (cause != null) {
            result.addError(cause.getPresentationName());
        }
        return result;
    }

    public static interface ILicenseAccess {
        public SonargraphLicense getSonargraphLicense();
    }
}

