/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseInfoWidget;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseServerComposite;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseServerDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class LicenseDialog
extends StandardDialog
implements ValidatingTextOrComboWidget.IConsumer,
ValidatingPathWidget.IConsumer {
    private final SonargraphLicenseHandler m_sonargraphLicenseHandler;
    private final ISoftwareSystemProvider m_systemProvider;
    private final IDialogId m_dialogId;
    private final IProxySettingsProvider m_proxySettingsProvider;
    private ConnectionMode m_connectionMode;
    private LicenseServerHost m_licenseServer;
    private ValidatingPathWidget m_textFieldLicenseFilePath;
    private ValidatingTextWidget m_textFieldActivationCode;
    private Composite m_connectionConfiguration;
    private Button m_licenseFileRadioButton;
    private Button m_activationCodeRadioButton;
    private Button m_requestActivationCodeBasedLicenseButton;
    private boolean m_useActivationCode;
    private String m_activationCodeText;
    private LicenseInfoWidget m_licenseInfoWidget;
    private SonargraphLicense m_currentlyShownLicense;
    private StyledText m_feedbackText;
    private boolean m_isDisposed = false;

    private void addFeedbackText(String textToAdd) {
        assert (textToAdd != null) : "Parameter 'textToAdd' of method 'addFeedbackText' must not be null";
        if (!this.m_feedbackText.isDisposed() && !textToAdd.isEmpty()) {
            String currentText = this.m_feedbackText.getText();
            if (currentText.isEmpty()) {
                this.m_feedbackText.setText(textToAdd);
            } else {
                this.m_feedbackText.setText(currentText + "\n" + textToAdd);
                this.m_feedbackText.setTopIndex(this.m_feedbackText.getLineCount() - 1);
            }
        }
    }

    public LicenseDialog(Shell parentShell, SonargraphLicenseHandler sonargraphLicenseHandler, ISoftwareSystemProvider provider, ConnectionMode connectionMode, IDialogId dialogId, IProxySettingsProvider proxySettingsProvider) {
        super(parentShell, SwtResourceProviderAdapter.getInstance().getString("standalone.label.license.title", new Object[0]), 34928);
        assert (sonargraphLicenseHandler != null) : "Parameter 'sonargraphLicenseHandler' of method 'LicenseDialog' must not be null";
        assert (connectionMode != null) : "Parameter 'connectionMode' of method 'LicenseDialog' must not be null";
        assert (dialogId != null) : "Parameter 'dialogId' of method 'LicenseDialog' must not be null";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'LicenseDialogNew' must not be null";
        this.m_systemProvider = provider;
        this.m_sonargraphLicenseHandler = sonargraphLicenseHandler;
        if (this.m_sonargraphLicenseHandler.hasLicense()) {
            this.m_currentlyShownLicense = this.m_sonargraphLicenseHandler.getLicense();
        }
        this.m_connectionMode = connectionMode;
        this.m_licenseServer = LicenseServerComposite.createLicenseServerSettings(true);
        this.m_dialogId = dialogId;
        this.m_proxySettingsProvider = proxySettingsProvider;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point location;
        Shell shell;
        if (initialSize != null && (shell = this.getShell()) != null && !shell.isDisposed() && (location = SwtUtility.calculateScreenCenteredLocation(shell, initialSize)) != null) {
            return location;
        }
        return super.getInitialLocation(initialSize);
    }

    @Override
    public boolean hasValidData() {
        return this.m_sonargraphLicenseHandler.hasLicenseInValidation() && this.m_sonargraphLicenseHandler.getLicenseInValidation().isValid();
    }

    @Override
    protected Point getMinimumSize() {
        return new Point(700, 600);
    }

    @Override
    public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
        assert (source != null) : "Parameter 'source' of method 'setText' must not be null";
        if (this.m_textFieldActivationCode == source) {
            assert (this.m_requestActivationCodeBasedLicenseButton != null) : "'m_requestActivationCodeBasedLicense' of method 'setText' must not be null";
            this.m_activationCodeText = input;
            this.m_requestActivationCodeBasedLicenseButton.setEnabled(this.m_activationCodeText != null && !this.m_activationCodeText.isEmpty() && (this.m_connectionMode == ConnectionMode.ONLINE || HttpConnectionCheck.isValidUrl((String)this.m_licenseServer.getUrl()) == null && this.m_licenseServer.isActive()));
        }
    }

    @Override
    public void setPath(TFile input, boolean inputModified) {
        if (input != null && inputModified) {
            this.loadLicenseInfoFromFile(input);
        }
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        this.addChooseModePanel(composite);
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_licenseInfoWidget = new LicenseInfoWidget((Composite)sashForm);
        this.m_feedbackText = new StyledText((Composite)sashForm, 768);
        this.m_feedbackText.setEditable(false);
        sashForm.setWeights(new int[]{90, 10});
        SwtUtility.applySashSeparatorStyle(sashForm);
        String additionalInfo = "";
        if (this.m_sonargraphLicenseHandler.hasLicense()) {
            String usedActivationCode = this.m_sonargraphLicenseHandler.getLicense().getValue(SonargraphLicense.Property.ACTIVATION_CODE);
            if (usedActivationCode != null) {
                this.m_useActivationCode = true;
                this.m_activationCodeText = usedActivationCode;
                this.m_textFieldActivationCode.setText(this.m_activationCodeText);
                additionalInfo = "(of installed activation code based license)";
            } else {
                this.m_useActivationCode = false;
                additionalInfo = "(of installed file based license)";
            }
        } else {
            this.m_useActivationCode = true;
            additionalInfo = "(no installed license found)";
        }
        this.m_licenseInfoWidget.show(this.m_currentlyShownLicense, additionalInfo, this.m_systemProvider);
        if (this.m_currentlyShownLicense != null) {
            this.process(this.m_currentlyShownLicense.getNonPropertyValidationResults().toArray(new OperationResult[0]));
        }
        this.reLayout();
    }

    @Override
    protected void applyData() {
        super.applyData();
        if (this.m_useActivationCode) {
            this.m_activationCodeRadioButton.setSelection(true);
        } else {
            this.m_licenseFileRadioButton.setSelection(true);
        }
        this.getButton(0).setText("Install");
        this.setStateOfModeSelection();
    }

    @Override
    protected IDialogId getDialogId() {
        return this.m_dialogId;
    }

    protected void okPressed() {
        OperationResult result = this.m_sonargraphLicenseHandler.installLicenseInValidation(false);
        StringBuilder builder = new StringBuilder();
        for (OperationResult.Message nextMessage : result.getMessages()) {
            builder.append(nextMessage.getMessage());
            builder.append("\n");
        }
        MessageBox msgBox = new MessageBox(this.getShell(), result.isSuccess() ? 2 : 1);
        msgBox.setText("Sonargraph - Install License");
        msgBox.setMessage(builder.toString());
        msgBox.open();
        super.okPressed();
    }

    @Override
    protected int getNumberOfColumns() {
        return 3;
    }

    private void updateRequestActivationCodeBasedLicenseState(Composite parent, Label note, String notConnectedLabel) {
        assert (parent != null) : "Parameter 'parent' of method 'updateRequestActivationCodeBasedLicenseState' must not be null";
        assert (note != null) : "Parameter 'note' of method 'updateRequestActivationCodeBasedLicenseState' must not be null";
        assert (notConnectedLabel != null) : "Parameter 'notConnectedLabel' of method 'updateRequestActivationCodeBasedLicenseState' must not be null";
        if (!(parent.isDisposed() || this.m_requestActivationCodeBasedLicenseButton.isDisposed() || note.isDisposed())) {
            if (this.m_connectionMode == ConnectionMode.OFFLINE) {
                this.m_requestActivationCodeBasedLicenseButton.setEnabled(this.m_activationCodeText != null && !this.m_activationCodeText.isEmpty() && HttpConnectionCheck.isValidUrl((String)this.m_licenseServer.getUrl()) == null && this.m_licenseServer.isActive());
                note.setText(notConnectedLabel);
            } else {
                this.m_requestActivationCodeBasedLicenseButton.setEnabled(this.m_activationCodeText != null && !this.m_activationCodeText.isEmpty() && (!this.m_licenseServer.isActive() || HttpConnectionCheck.isValidUrl((String)this.m_licenseServer.getUrl()) == null));
                note.setText("");
            }
            parent.layout(true, true);
        }
    }

    private void addChooseModePanel(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addChooseModePanel' must not be null";
        this.m_activationCodeRadioButton = new Button(parent, 0x1000010);
        this.m_activationCodeRadioButton.setFont(UiResourceManager.getInstance().getFont(1));
        this.m_activationCodeRadioButton.setText(SwtResourceProviderAdapter.getInstance().getString("standalone.label.license.useactivationcode", new Object[0]));
        this.m_activationCodeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.setStateOfModeSelection();
            }
        });
        this.m_activationCodeRadioButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        Composite activationCodeComposite = new Composite(parent, 0);
        GridLayout activationCodeCompositeLayout = new GridLayout(2, false);
        activationCodeCompositeLayout.horizontalSpacing = 0;
        activationCodeCompositeLayout.marginTop = 0;
        activationCodeCompositeLayout.marginBottom = 0;
        activationCodeCompositeLayout.marginHeight = 0;
        activationCodeCompositeLayout.marginLeft = 0;
        activationCodeCompositeLayout.marginRight = 0;
        activationCodeCompositeLayout.marginWidth = 0;
        activationCodeComposite.setLayout((Layout)activationCodeCompositeLayout);
        activationCodeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_textFieldActivationCode = new ValidatingTextWidget(activationCodeComposite, this.m_sonargraphLicenseHandler.getActivationCodeValidator(), this, this.m_activationCodeText, 0);
        this.m_textFieldActivationCode.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.m_requestActivationCodeBasedLicenseButton = new Button(activationCodeComposite, 8);
        this.m_requestActivationCodeBasedLicenseButton.setText(SwtResourceProviderAdapter.getInstance().getString("standalone.label.license.request", new Object[0]));
        this.m_requestActivationCodeBasedLicenseButton.setImage(UiResourceManager.getInstance().getImage("RequestLicenseDetails"));
        this.m_requestActivationCodeBasedLicenseButton.setToolTipText(SwtResourceProviderAdapter.getInstance().getString("standalone.label.license.acceptfloating", new Object[0]));
        this.m_requestActivationCodeBasedLicenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicenseDialog.this.m_activationCodeText != null && !LicenseDialog.this.m_activationCodeText.isEmpty()) {
                    LicenseDialog.this.loadLicenseInfoFromActivationCode();
                }
            }
        });
        this.m_requestActivationCodeBasedLicenseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        StringBuilder info = new StringBuilder();
        info.append("Choose the 'Activation Code' option if you have received a code with the format XXXX-XXXX-XXXX-XXXX.");
        info.append("\n");
        info.append("1. Enter the activation code.");
        info.append("\n");
        info.append("2. Request the license details from the servers at hello2morrow using the 'Request' button on the right. These are shown once they have been received.");
        info.append("\n");
        info.append("3. Confirm the license details are correct and simply press 'Install' on the bottom.");
        Label activationCodeInfo = new Label(parent, 64);
        activationCodeInfo.setText(info.toString());
        activationCodeInfo.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.m_requestActivationCodeBasedLicenseButton.setEnabled(false);
        this.m_connectionConfiguration = new Composite(parent, 0);
        GridLayout connectionConfigurationLayout = new GridLayout(3, false);
        connectionConfigurationLayout.marginBottom = 0;
        connectionConfigurationLayout.marginLeft = 0;
        connectionConfigurationLayout.marginRight = 0;
        connectionConfigurationLayout.marginTop = 0;
        this.m_connectionConfiguration.setLayout((Layout)connectionConfigurationLayout);
        final Label note = new Label(this.m_connectionConfiguration, 0);
        note.setFont(UiResourceManager.getInstance().getFont(1));
        String notConnectedLabel = "No internet connection detected (license server required for using activation codes)";
        if (this.m_connectionMode == ConnectionMode.OFFLINE) {
            note.setText("No internet connection detected (license server required for using activation codes)");
        } else {
            note.setText("");
        }
        note.setLayoutData((Object)new GridData(0, 0x1000008, false, false));
        Link link = new Link(this.m_connectionConfiguration, 16384);
        link.setText("<a>Configure License Server</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseServerHost newLicenseServerHost = LicenseServerDialog.configureLicenseServerHost(LicenseDialog.this.getShell(), LicenseDialog.this.m_sonargraphLicenseHandler);
                if (newLicenseServerHost != null) {
                    LicenseDialog.this.m_licenseServer = newLicenseServerHost;
                    LicenseDialog.this.updateRequestActivationCodeBasedLicenseState(LicenseDialog.this.m_connectionConfiguration.getParent(), note, "No internet connection detected (license server required for using activation codes)");
                }
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        Link internetConnectionLink = new Link(this.m_connectionConfiguration, 16384);
        internetConnectionLink.setText("<a>Configure Internet Connection</a>");
        internetConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.m_connectionMode = ConnectionDialog.getOrConfigureConnectionMode(LicenseDialog.this.getShell(), false, true, LicenseDialog.this.m_proxySettingsProvider);
                LicenseDialog.this.updateRequestActivationCodeBasedLicenseState(LicenseDialog.this.m_connectionConfiguration.getParent(), note, "No internet connection detected (license server required for using activation codes)");
            }
        });
        internetConnectionLink.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.m_connectionConfiguration.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 3, 1));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.m_licenseFileRadioButton = new Button(parent, 0x1000010);
        this.m_licenseFileRadioButton.setFont(UiResourceManager.getInstance().getFont(1));
        this.m_licenseFileRadioButton.setText(SwtResourceProviderAdapter.getInstance().getString("standalone.label.license.usefile", new Object[0]));
        this.m_licenseFileRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.setStateOfModeSelection();
            }
        });
        this.m_licenseFileRadioButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.m_textFieldLicenseFilePath = new ValidatingPathWidget(parent, this, this.m_sonargraphLicenseHandler.getFilePathValidator(), 2, null, false);
        this.m_textFieldLicenseFilePath.setFilterExtensions(new String[]{"*.license", "*.*"});
        this.m_textFieldLicenseFilePath.setLayoutData(new GridData(4, 0, true, false, 2, 1));
        this.m_textFieldLicenseFilePath.getBrowseButton().setText("Browse");
        this.m_textFieldLicenseFilePath.getBrowseButton().setToolTipText("Locate and select a license file.");
        info.setLength(0);
        info.append("Choose the 'License File' option if you have received a  license file.");
        info.append("\n");
        info.append("1. Locate and select the file on your hard drive using the 'Browse' button on the right. The license details are then shown in the lower section.");
        info.append("\n");
        info.append("2. Confirm the license details are correct and simply press 'Install' on the bottom.");
        Label licenseFileInfo = new Label(parent, 64);
        licenseFileInfo.setText(info.toString());
        licenseFileInfo.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
    }

    private void updateLicenseInformation(String additionalInfo, OperationResult result) {
        assert (additionalInfo != null) : "Parameter 'additionalInfo' of method 'updateLicenseInformation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateLicenseInformation' must not be null";
        this.m_licenseInfoWidget.show(this.m_currentlyShownLicense, additionalInfo, this.m_systemProvider);
        this.getButton(0).setEnabled(this.m_currentlyShownLicense != null && this.m_currentlyShownLicense.isValid());
        if (this.m_currentlyShownLicense != null) {
            ArrayList<OperationResult> all = new ArrayList<OperationResult>(this.m_currentlyShownLicense.getNonPropertyValidationResults());
            all.add(result);
            this.process(all.toArray(new OperationResult[all.size()]));
        } else {
            this.process(result);
        }
        this.reLayout();
    }

    private void loadLicenseInfoFromFile(TFile licenseFile) {
        assert (licenseFile != null) : "Parameter 'currentLicenseFileLoaded' of method 'loadLicenseInfoFromFile' must not be null";
        try {
            this.m_feedbackText.setForeground(UiResourceManager.getInstance().getForegroundColor());
            this.m_feedbackText.setText("");
            if (this.m_connectionConfiguration != null) {
                this.m_connectionConfiguration.setEnabled(false);
            }
            this.m_currentlyShownLicense = null;
            OperationResult result = this.m_sonargraphLicenseHandler.loadLicenseFromFile(licenseFile);
            String additionalInfo = "";
            if (this.m_sonargraphLicenseHandler.hasLicenseInValidation()) {
                this.m_currentlyShownLicense = this.m_sonargraphLicenseHandler.getLicenseInValidation();
                additionalInfo = "(of loaded file based license)";
            }
            this.updateLicenseInformation(additionalInfo, result);
        }
        finally {
            if (this.m_connectionConfiguration != null) {
                this.m_connectionConfiguration.setEnabled(true);
            }
        }
    }

    private void loadLicenseInfoFromActivationCode() {
        try {
            this.m_feedbackText.setForeground(UiResourceManager.getInstance().getForegroundColor());
            this.m_feedbackText.setText("");
            this.m_licenseFileRadioButton.setEnabled(false);
            this.m_activationCodeRadioButton.setEnabled(false);
            this.getButton(1).setEnabled(false);
            this.getButton(0).setEnabled(false);
            if (this.m_connectionConfiguration != null) {
                this.m_connectionConfiguration.setEnabled(false);
            }
            this.m_currentlyShownLicense = null;
            ProxySettings proxySettings = this.m_proxySettingsProvider.getProxySettings(false);
            this.m_sonargraphLicenseHandler.setProxySettings(proxySettings);
            OperationResult result = this.m_sonargraphLicenseHandler.loadLicenseFromActivationCode(this.m_activationCodeText.trim(), null, null);
            String additionalInfo = "";
            if (this.m_sonargraphLicenseHandler.hasLicenseInValidation()) {
                this.m_currentlyShownLicense = this.m_sonargraphLicenseHandler.getLicenseInValidation();
                additionalInfo = "(of loaded activation code based license)";
            }
            if (!this.m_isDisposed) {
                this.updateLicenseInformation(additionalInfo, result);
            }
        }
        catch (Throwable throwable) {
            if (!this.m_isDisposed) {
                this.m_licenseFileRadioButton.setEnabled(true);
                this.m_activationCodeRadioButton.setEnabled(true);
                this.getButton(1).setEnabled(true);
                this.getButton(0).setEnabled(this.m_currentlyShownLicense != null && this.m_currentlyShownLicense.isValid());
                if (this.m_connectionConfiguration != null) {
                    this.m_connectionConfiguration.setEnabled(true);
                }
            }
            throw throwable;
        }
        if (!this.m_isDisposed) {
            this.m_licenseFileRadioButton.setEnabled(true);
            this.m_activationCodeRadioButton.setEnabled(true);
            this.getButton(1).setEnabled(true);
            this.getButton(0).setEnabled(this.m_currentlyShownLicense != null && this.m_currentlyShownLicense.isValid());
            if (this.m_connectionConfiguration != null) {
                this.m_connectionConfiguration.setEnabled(true);
            }
        }
    }

    private void process(OperationResult ... results) {
        assert (results != null) : "Parameter 'results' of method 'process' must not be null";
        StringBuilder builder = new StringBuilder();
        OperationResult[] operationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            OperationResult nextResult = operationResultArray[n2];
            for (OperationResult.Message nextMessage : nextResult.getMessages()) {
                builder.append(nextMessage.getMessage());
                builder.append("\n");
            }
            ++n2;
        }
        if (!builder.toString().isEmpty()) {
            Color color;
            if (this.m_currentlyShownLicense != null && this.m_currentlyShownLicense.isValid()) {
                color = UiResourceManager.getInstance().getForegroundColor();
            } else {
                color = UiResourceManager.getInstance().getColor(UiResourceManager.RED);
                if (this.m_currentlyShownLicense != null && !this.m_currentlyShownLicense.isValid() && this.m_useActivationCode && this.m_activationCodeText != null && !this.m_activationCodeText.isEmpty()) {
                    builder.append("NOTE: Your activation code based license has validation errors!");
                    builder.append("\n");
                    builder.append(" Consider to request a new license ticket by using the 'Request' button on the right in the 'Activation Code' section.");
                    builder.append("\n");
                    builder.append(" Check 'Renew License Ticket Automatically' in the 'Help' menu to renew expired tickets automatically.");
                    builder.append("\n");
                }
            }
            this.m_feedbackText.setForeground(color);
            this.addFeedbackText(builder.toString());
        }
    }

    @Override
    public void widgetDisposed(DisposeEvent event) {
        super.widgetDisposed(event);
        this.m_isDisposed = true;
    }

    private void setStateOfModeSelection() {
        if (this.m_licenseFileRadioButton.getSelection()) {
            this.m_textFieldLicenseFilePath.setEnabled(true);
            this.m_textFieldActivationCode.setEnabled(false);
            this.m_requestActivationCodeBasedLicenseButton.setEnabled(false);
            this.m_useActivationCode = false;
        } else {
            this.m_textFieldLicenseFilePath.setEnabled(false);
            this.m_requestActivationCodeBasedLicenseButton.setEnabled(this.m_activationCodeText != null && !this.m_activationCodeText.isEmpty() && this.m_connectionMode == ConnectionMode.ONLINE);
            this.m_textFieldActivationCode.setEnabled(true);
            this.m_textFieldActivationCode.modifyText(null);
            this.m_useActivationCode = true;
        }
    }
}

