/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.ConnectionAnchor;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigureRouter;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeConnectionFigureAnchor;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewUtilities;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphViewNodeConnectionFigureRouter
extends DrawConnectionFigureRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewNodeConnectionFigureRouter.class);
    private static final int ANGLE_TOLERANCE = 12;
    private static final int VERTEX_DISTANCE = 2;
    private static final int TOP_BOTTOM_DISPLACEMENT = 8;
    private static final int RIGHT_LEFT_DISPLACEMENT = 3;
    private static final ConnectionInfoComparator CONNECTION_INFO_COMPARATOR = new ConnectionInfoComparator();
    private final PointIterator m_sourcePointIterator = new PointIterator();
    private final PointIterator m_targetPointIterator = new PointIterator();
    private final Set<ConnectionKey> m_cycleOfTwoKeys = new THashSet();

    static final PointInfo createPointInfo(Rectangle bounds, BoundsLocation boundsLocation) {
        assert (bounds != null) : "Parameter 'bounds' of method 'createPointInfo' must not be null";
        assert (boundsLocation != null) : "Parameter 'boundsLocation' of method 'createPointInfo' must not be null";
        switch (boundsLocation) {
            case TOP_1: {
                Point top1 = bounds.getTop();
                top1.x -= 8;
                return new PointInfo(top1, top1.getTranslated(0, -1), bounds, boundsLocation);
            }
            case TOP_2: {
                Point top2 = bounds.getTop();
                top2.x += 8;
                return new PointInfo(top2, top2.getTranslated(0, -1), bounds, boundsLocation);
            }
            case BOTTOM_1: {
                Point bottom1 = bounds.getBottom();
                bottom1.x += 8;
                return new PointInfo(bottom1, bottom1.getTranslated(0, 1), bounds, boundsLocation);
            }
            case BOTTOM_2: {
                Point bottom2 = bounds.getBottom();
                bottom2.x -= 8;
                return new PointInfo(bottom2, bottom2.getTranslated(0, 1), bounds, boundsLocation);
            }
            case RIGHT_1: {
                Point right1 = bounds.getRight();
                right1.y -= 3;
                return new PointInfo(right1, right1.getTranslated(1, 0), bounds, boundsLocation);
            }
            case RIGHT_2: {
                Point right2 = bounds.getRight();
                right2.y += 3;
                return new PointInfo(right2, right2.getTranslated(1, 0), bounds, boundsLocation);
            }
            case LEFT_1: {
                Point left1 = bounds.getLeft();
                left1.y += 3;
                return new PointInfo(left1, left1.getTranslated(-1, 0), bounds, boundsLocation);
            }
            case LEFT_2: {
                Point left2 = bounds.getLeft();
                left2.y -= 3;
                return new PointInfo(left2, left2.getTranslated(-1, 0), bounds, boundsLocation);
            }
            case TOP_RIGHT: {
                return new PointInfo(bounds.getTopRight(), bounds.getTopRight().getTranslated(1, -1), bounds, boundsLocation);
            }
            case BOTTOM_RIGHT: {
                return new PointInfo(bounds.getBottomRight(), bounds.getBottomRight().getTranslated(1, 1), bounds, boundsLocation);
            }
            case BOTTOM_LEFT: {
                return new PointInfo(bounds.getBottomLeft(), bounds.getBottomLeft().getTranslated(-1, 1), bounds, boundsLocation);
            }
            case TOP_LEFT: {
                return new PointInfo(bounds.getTopLeft(), bounds.getTopLeft().getTranslated(-1, -1), bounds, boundsLocation);
            }
        }
        assert (false) : "Unhandled bounds location: " + String.valueOf((Object)boundsLocation);
        return null;
    }

    private static int getDegrees(Point source, Point target) {
        int roundedAngle;
        assert (source != null) : "Parameter 'source' of method 'getDegrees' must not be null";
        assert (target != null) : "Parameter 'target' of method 'getDegrees' must not be null";
        double theta = Math.atan2(target.y - source.y, target.x - source.x);
        double angle = Math.toDegrees(theta += 1.5707963267948966);
        if (angle < 0.0) {
            angle += 360.0;
        }
        if ((roundedAngle = (int)Math.round(angle)) == 360) {
            roundedAngle = 0;
        }
        return roundedAngle;
    }

    private static int getLineLength(Point source, Point target) {
        assert (source != null) : "Parameter 'source' of method 'getLineLength' must not be null";
        assert (target != null) : "Parameter 'target' of method 'getLineLength' must not be null";
        assert (source != target) : "Same instances";
        if (source.equals(target)) {
            return 0;
        }
        double length = Math.sqrt(Math.pow(target.x - source.x, 2.0) + Math.pow(target.y - source.y, 2.0));
        return (int)Math.round(length);
    }

    private static boolean isValidBoundsLocationCombination(BoundsLocation source, BoundsLocation target) {
        assert (source != null) : "Parameter 'source' of method 'isValidBoundsLocationCombination' must not be null";
        assert (target != null) : "Parameter 'target' of method 'isValidBoundsLocationCombination' must not be null";
        if (source.isTop() && target.isTop()) {
            return false;
        }
        if (source.isBottom() && target.isBottom()) {
            return false;
        }
        if (source.isRight() && target.isRight()) {
            return false;
        }
        if (source.isLeft() && target.isLeft()) {
            return false;
        }
        if (BoundsLocation.TOP_1.equals((Object)source) && BoundsLocation.BOTTOM_1.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.TOP_2.equals((Object)source) && BoundsLocation.BOTTOM_2.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.BOTTOM_1.equals((Object)source) && BoundsLocation.TOP_1.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.BOTTOM_2.equals((Object)source) && BoundsLocation.TOP_2.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.RIGHT_1.equals((Object)source) && BoundsLocation.LEFT_1.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.RIGHT_2.equals((Object)source) && BoundsLocation.LEFT_2.equals((Object)target)) {
            return false;
        }
        if (BoundsLocation.LEFT_1.equals((Object)source) && BoundsLocation.RIGHT_1.equals((Object)target)) {
            return false;
        }
        return !BoundsLocation.LEFT_2.equals((Object)source) || !BoundsLocation.RIGHT_2.equals((Object)target);
    }

    private static boolean acceptHorizontally(int degrees) {
        return (258 > degrees || degrees > 282) && (78 > degrees || degrees > 102);
    }

    private static boolean acceptVertically(int degrees) {
        return !(348 <= degrees && degrees <= 360 || degrees >= 0 && degrees <= 12) && (168 > degrees || degrees > 192);
    }

    private static boolean isValidAngle(BoundsLocation sourceBoundsLocation, BoundsLocation targetBoundsLocation, int degrees) {
        assert (sourceBoundsLocation != null) : "Parameter 'sourceBoundsLocation' of method 'isValidAngle' must not be null";
        assert (targetBoundsLocation != null) : "Parameter 'targetBoundsLocation' of method 'isValidAngle' must not be null";
        if (sourceBoundsLocation.isBottom() && (BoundsLocation.BOTTOM_LEFT.equals((Object)targetBoundsLocation) || BoundsLocation.BOTTOM_RIGHT.equals((Object)targetBoundsLocation)) && !GraphViewNodeConnectionFigureRouter.acceptVertically(degrees)) {
            return false;
        }
        if (sourceBoundsLocation.isTop() && (BoundsLocation.TOP_LEFT.equals((Object)targetBoundsLocation) || BoundsLocation.TOP_RIGHT.equals((Object)targetBoundsLocation)) && !GraphViewNodeConnectionFigureRouter.acceptVertically(degrees)) {
            return false;
        }
        if ((sourceBoundsLocation.isTop() || sourceBoundsLocation.isBottom() || targetBoundsLocation.isTop() || targetBoundsLocation.isBottom()) && !GraphViewNodeConnectionFigureRouter.acceptHorizontally(degrees)) {
            return false;
        }
        return !sourceBoundsLocation.isLeft() && !sourceBoundsLocation.isRight() && !targetBoundsLocation.isLeft() && !targetBoundsLocation.isRight() || GraphViewNodeConnectionFigureRouter.acceptVertically(degrees);
    }

    private static final int isValid(PointInfo sourcePointInfo, PointInfo targetPointInfo) {
        int lineLength;
        assert (sourcePointInfo != null) : "Parameter 'sourcePointInfo' of method 'isValid' must not be null";
        assert (targetPointInfo != null) : "Parameter 'targetPointInfo' of method 'isValid' must not be null";
        Rectangle lineBounds = new Rectangle(sourcePointInfo.getPointForBoumdsCheck(), targetPointInfo.getPointForBoumdsCheck());
        if (!lineBounds.intersects(sourcePointInfo.getBounds()) && !lineBounds.intersects(targetPointInfo.getBounds()) && (lineLength = GraphViewNodeConnectionFigureRouter.getLineLength(sourcePointInfo.getPoint(), targetPointInfo.getPoint())) > 16 && GraphViewNodeConnectionFigureRouter.isValidAngle(sourcePointInfo.getBoundsLocation(), targetPointInfo.getBoundsLocation(), GraphViewNodeConnectionFigureRouter.getDegrees(sourcePointInfo.getPoint(), targetPointInfo.getPoint()))) {
            return lineLength;
        }
        return 0;
    }

    @Override
    public void invalidate(Connection connection) {
        this.m_cycleOfTwoKeys.clear();
    }

    private void addFromToTopLine(GraphViewNode source, GraphViewNode target, BoundsLocation from) {
        assert (source != null) : "Parameter 'source' of method 'addFromToTopLine' must not be null";
        assert (target != null) : "Parameter 'target' of method 'addFromToTopLine' must not be null";
        assert (source != target) : "Same instances";
        assert (from != null) : "Parameter 'from' of method 'addFromToTopLine' must not be null";
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_LEFT));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_1));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_2));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_RIGHT));
    }

    private void addFromToRightLine(GraphViewNode source, GraphViewNode target, BoundsLocation from) {
        assert (source != null) : "Parameter 'source' of method 'addFromToRightLine' must not be null";
        assert (target != null) : "Parameter 'target' of method 'addFromToRightLine' must not be null";
        assert (source != target) : "Same instances";
        assert (from != null) : "Parameter 'from' of method 'addFromToRightLine' must not be null";
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_RIGHT));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.RIGHT_1));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.RIGHT_2));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_RIGHT));
    }

    private void addFromToBottomLine(GraphViewNode source, GraphViewNode target, BoundsLocation from) {
        assert (source != null) : "Parameter 'source' of method 'addFromToBottomLine' must not be null";
        assert (target != null) : "Parameter 'target' of method 'addFromToBottomLine' must not be null";
        assert (source != target) : "Same instances";
        assert (from != null) : "Parameter 'from' of method 'addFromToBottomLine' must not be null";
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_RIGHT));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_1));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_2));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_LEFT));
    }

    private void addFromToLeftLine(GraphViewNode source, GraphViewNode target, BoundsLocation from) {
        assert (source != null) : "Parameter 'source' of method 'addFromToLeftLine' must not be null";
        assert (target != null) : "Parameter 'target' of method 'addFromToLeftLine' must not be null";
        assert (source != target) : "Same instances";
        assert (from != null) : "Parameter 'from' of method 'addFromToLeftLine' must not be null";
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.BOTTOM_LEFT));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.LEFT_1));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.LEFT_2));
        this.m_cycleOfTwoKeys.add(new ConnectionKey(source, target, from, BoundsLocation.TOP_LEFT));
    }

    private void addCycleOfTwoKeys(GraphViewNode sourceNode, BoundsLocation sourceBoundsLocation, GraphViewNode targetNode, BoundsLocation targetBoundsLocation) {
        assert (sourceNode != null) : "Parameter 'sourceNode' of method 'addCycleOfTwoKeys' must not be null";
        assert (sourceBoundsLocation != null) : "Parameter 'sourceBoundsLocation' of method 'addCycleOfTwoKeys' must not be null";
        assert (targetNode != null) : "Parameter 'targetNode' of method 'addCycleOfTwoKeys' must not be null";
        assert (targetBoundsLocation != null) : "Parameter 'targetBoundsLocation' of method 'addCycleOfTwoKeys' must not be null";
        if (BoundsLocation.RIGHT_1 == sourceBoundsLocation && BoundsLocation.TOP_2 == targetBoundsLocation) {
            this.addFromToRightLine(targetNode, sourceNode, BoundsLocation.TOP_2);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_LEFT, BoundsLocation.TOP_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_1, BoundsLocation.TOP_RIGHT));
        } else if (BoundsLocation.BOTTOM_1 == sourceBoundsLocation && BoundsLocation.TOP_2 == targetBoundsLocation) {
            this.addFromToBottomLine(targetNode, sourceNode, BoundsLocation.TOP_2);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_1, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_LEFT, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.BOTTOM_2));
        } else if (BoundsLocation.LEFT_1 == sourceBoundsLocation && BoundsLocation.BOTTOM_LEFT == targetBoundsLocation) {
            this.addFromToLeftLine(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_1, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_2, BoundsLocation.BOTTOM_LEFT));
        } else if (BoundsLocation.RIGHT_1 == sourceBoundsLocation && BoundsLocation.TOP_RIGHT == targetBoundsLocation) {
            this.addFromToRightLine(targetNode, sourceNode, BoundsLocation.TOP_RIGHT);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_LEFT, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_1, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_2, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_LEFT, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_1, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_2, BoundsLocation.BOTTOM_RIGHT));
        } else if (BoundsLocation.TOP_RIGHT == sourceBoundsLocation && BoundsLocation.TOP_RIGHT == targetBoundsLocation) {
            this.addFromToTopLine(targetNode, sourceNode, BoundsLocation.TOP_RIGHT);
        } else if (BoundsLocation.BOTTOM_2 == sourceBoundsLocation && BoundsLocation.BOTTOM_LEFT == targetBoundsLocation) {
            this.addFromToBottomLine(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_1, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_2, BoundsLocation.BOTTOM_LEFT));
        } else if (BoundsLocation.TOP_1 == sourceBoundsLocation && BoundsLocation.RIGHT_1 == targetBoundsLocation) {
            this.addFromToTopLine(targetNode, sourceNode, BoundsLocation.RIGHT_1);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.TOP_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_2, BoundsLocation.TOP_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_2, BoundsLocation.TOP_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.TOP_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.TOP_RIGHT));
        } else if (BoundsLocation.RIGHT_1 == sourceBoundsLocation && BoundsLocation.BOTTOM_RIGHT == targetBoundsLocation) {
            this.addFromToRightLine(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_1, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_1, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_2, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_2, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.RIGHT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.BOTTOM_RIGHT));
        } else if (BoundsLocation.BOTTOM_1 == sourceBoundsLocation && BoundsLocation.RIGHT_2 == targetBoundsLocation) {
            this.addFromToBottomLine(targetNode, sourceNode, BoundsLocation.RIGHT_2);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_RIGHT, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_1, BoundsLocation.BOTTOM_RIGHT));
        } else if (BoundsLocation.BOTTOM_2 == sourceBoundsLocation && BoundsLocation.LEFT_1 == targetBoundsLocation) {
            this.addFromToBottomLine(targetNode, sourceNode, BoundsLocation.LEFT_1);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.BOTTOM_1));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.BOTTOM_RIGHT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.TOP_LEFT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.LEFT_2, BoundsLocation.BOTTOM_LEFT));
        } else if (BoundsLocation.LEFT_1 == sourceBoundsLocation && BoundsLocation.BOTTOM_2 == targetBoundsLocation) {
            this.addFromToLeftLine(targetNode, sourceNode, BoundsLocation.BOTTOM_2);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.TOP_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_LEFT, BoundsLocation.LEFT_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_1, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_LEFT));
        } else if (BoundsLocation.TOP_RIGHT == sourceBoundsLocation && BoundsLocation.RIGHT_1 == targetBoundsLocation) {
            this.addFromToTopLine(targetNode, sourceNode, BoundsLocation.RIGHT_1);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_2, BoundsLocation.TOP_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_2, BoundsLocation.TOP_1));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.RIGHT_2, BoundsLocation.TOP_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.TOP_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.TOP_1));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.TOP_2));
        } else if (BoundsLocation.TOP_1 == sourceBoundsLocation && BoundsLocation.TOP_RIGHT == targetBoundsLocation) {
            this.addFromToTopLine(targetNode, sourceNode, BoundsLocation.TOP_RIGHT);
        } else if (BoundsLocation.BOTTOM_RIGHT == sourceBoundsLocation && BoundsLocation.RIGHT_1 == targetBoundsLocation) {
            this.addFromToBottomLine(targetNode, sourceNode, BoundsLocation.RIGHT_1);
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_LEFT));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_2));
            this.m_cycleOfTwoKeys.add(new ConnectionKey(targetNode, sourceNode, BoundsLocation.BOTTOM_RIGHT, BoundsLocation.BOTTOM_1));
        } else {
            LOGGER.debug("Unhandled: " + String.valueOf((Object)sourceBoundsLocation) + " -> " + String.valueOf((Object)targetBoundsLocation));
            LOGGER.debug("Nodes: " + sourceNode.getName() + " -> " + targetNode.getName());
        }
    }

    @Override
    public void route(Connection connection) {
        assert (connection != null && connection instanceof GraphViewNodeConnectionFigure) : "Unexpected class in method 'route': " + String.valueOf(connection);
        GraphViewNodeConnectionFigure connectionFigure = (GraphViewNodeConnectionFigure)connection;
        ConnectionAnchor sourceAnchor = connectionFigure.getSourceAnchor();
        assert (sourceAnchor != null && sourceAnchor instanceof GraphViewNodeConnectionFigureAnchor) : "Unexpected class in method 'route': " + String.valueOf(sourceAnchor);
        PointList points = connection.getPoints();
        points.removeAllPoints();
        GraphViewNodeConnectionFigureAnchor connectionSourceAncor = (GraphViewNodeConnectionFigureAnchor)sourceAnchor;
        GraphViewNodeFigure source = (GraphViewNodeFigure)connectionSourceAncor.getOwner();
        GraphViewNodeFigure target = connectionSourceAncor.getOther();
        GraphViewNode sourceNode = (GraphViewNode)source.getNode();
        GraphViewNode targetNode = (GraphViewNode)target.getNode();
        Rectangle sourceBounds = source.getBounds();
        Rectangle targetBounds = target.getBounds();
        Point sourcePoint = null;
        Point targetPoint = null;
        GraphViewCycleGroupNode cycleGroupNode = (GraphViewCycleGroupNode)sourceNode.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
        if (cycleGroupNode != null && cycleGroupNode.equals(targetNode.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT))) {
            LOGGER.debug("Route: " + sourceNode.getName() + " -> " + targetNode.getName());
            LOGGER.trace("Bounds: " + String.valueOf(sourceBounds) + " -> " + String.valueOf(targetBounds));
            boolean isCycleOfTwo = GraphViewUtilities.formCycleOfTwo(sourceNode, targetNode);
            int degrees = GraphViewNodeConnectionFigureRouter.getDegrees(sourceBounds.getCenter(), targetBounds.getCenter());
            ArrayList<ConnectionInfo> connectionInfo = new ArrayList<ConnectionInfo>();
            this.m_sourcePointIterator.initialize(sourceBounds);
            while (this.m_sourcePointIterator.hasNext()) {
                PointInfo nextSourcePointInfo = this.m_sourcePointIterator.next();
                this.m_targetPointIterator.initialize(targetBounds);
                while (this.m_targetPointIterator.hasNext()) {
                    int nextLineLength;
                    PointInfo nextTargetPointInfo = this.m_targetPointIterator.next();
                    if (!GraphViewNodeConnectionFigureRouter.isValidBoundsLocationCombination(nextSourcePointInfo.getBoundsLocation(), nextTargetPointInfo.getBoundsLocation()) || (nextLineLength = GraphViewNodeConnectionFigureRouter.isValid(nextSourcePointInfo, nextTargetPointInfo)) <= 0) continue;
                    int nextDegrees = GraphViewNodeConnectionFigureRouter.getDegrees(nextSourcePointInfo.getPoint(), nextTargetPointInfo.getPoint());
                    int diff = nextDegrees > degrees ? nextDegrees - degrees : degrees - nextDegrees;
                    connectionInfo.add(new ConnectionInfo(nextLineLength, diff, nextSourcePointInfo, nextTargetPointInfo));
                }
            }
            this.m_sourcePointIterator.reset();
            this.m_targetPointIterator.reset();
            if (!connectionInfo.isEmpty()) {
                Collections.sort(connectionInfo, CONNECTION_INFO_COMPARATOR);
                if (LOGGER.isTraceEnabled()) {
                    for (ConnectionInfo next : connectionInfo) {
                        LOGGER.trace("Connection info: " + String.valueOf(next));
                    }
                }
                ConnectionInfo useConnectionInfo = null;
                if (isCycleOfTwo) {
                    for (ConnectionInfo nextConnectionInfo : connectionInfo) {
                        BoundsLocation targetBoundsLocation;
                        BoundsLocation sourceBoundsLocation = nextConnectionInfo.getSourcePointInfo().getBoundsLocation();
                        ConnectionKey nextKey = new ConnectionKey(sourceNode, targetNode, sourceBoundsLocation, targetBoundsLocation = nextConnectionInfo.getTargetPointInfo().getBoundsLocation());
                        if (!this.m_cycleOfTwoKeys.add(nextKey)) continue;
                        useConnectionInfo = nextConnectionInfo;
                        this.addCycleOfTwoKeys(sourceNode, nextConnectionInfo.getSourcePointInfo().getBoundsLocation(), targetNode, nextConnectionInfo.getTargetPointInfo().getBoundsLocation());
                        break;
                    }
                    if (useConnectionInfo == null) {
                        LOGGER.debug("No free connection found - fall back to first connection.");
                        useConnectionInfo = (ConnectionInfo)connectionInfo.get(0);
                    }
                } else {
                    useConnectionInfo = (ConnectionInfo)connectionInfo.get(0);
                }
                sourcePoint = useConnectionInfo.getSourcePointInfo().getPoint();
                targetPoint = useConnectionInfo.getTargetPointInfo().getPoint();
                BoundsLocation sourceBoundsLocation = useConnectionInfo.getSourcePointInfo().getBoundsLocation();
                BoundsLocation targetBoundsLocation = useConnectionInfo.getTargetPointInfo().getBoundsLocation();
                if (!isCycleOfTwo) {
                    if (sourceBoundsLocation.isTop()) {
                        sourcePoint = useConnectionInfo.getSourcePointInfo().getBounds().getTop();
                    } else if (sourceBoundsLocation.isRight()) {
                        sourcePoint = useConnectionInfo.getSourcePointInfo().getBounds().getRight();
                    } else if (sourceBoundsLocation.isBottom()) {
                        sourcePoint = useConnectionInfo.getSourcePointInfo().getBounds().getBottom();
                    } else if (sourceBoundsLocation.isLeft()) {
                        sourcePoint = useConnectionInfo.getSourcePointInfo().getBounds().getLeft();
                    }
                    if (targetBoundsLocation.isTop()) {
                        targetPoint = useConnectionInfo.getTargetPointInfo().getBounds().getTop();
                    } else if (targetBoundsLocation.isRight()) {
                        targetPoint = useConnectionInfo.getTargetPointInfo().getBounds().getRight();
                    } else if (targetBoundsLocation.isBottom()) {
                        targetPoint = useConnectionInfo.getTargetPointInfo().getBounds().getBottom();
                    } else if (targetBoundsLocation.isLeft()) {
                        targetPoint = useConnectionInfo.getTargetPointInfo().getBounds().getLeft();
                    }
                }
                if (sourceBoundsLocation.isCorner()) {
                    if (BoundsLocation.TOP_LEFT == sourceBoundsLocation) {
                        if (225 < degrees && degrees < 360 || degrees > 0 && degrees < 45) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y += 2;
                        }
                    } else if (BoundsLocation.TOP_RIGHT == sourceBoundsLocation) {
                        if (45 < degrees && degrees < 225) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y += 2;
                        }
                    } else if (BoundsLocation.BOTTOM_LEFT == sourceBoundsLocation) {
                        if (225 < degrees && degrees < 360 || degrees > 0 && degrees < 45) {
                            targetPoint.x += 2;
                        } else {
                            targetPoint.y -= 2;
                        }
                    } else if (BoundsLocation.BOTTOM_RIGHT == sourceBoundsLocation) {
                        if (45 < degrees && degrees < 225) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y -= 2;
                        }
                    }
                }
                if (targetBoundsLocation.isCorner()) {
                    if (BoundsLocation.TOP_LEFT == targetBoundsLocation) {
                        if (225 < degrees && degrees < 360 || degrees > 0 && degrees < 45) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y += 2;
                        }
                    } else if (BoundsLocation.TOP_RIGHT == targetBoundsLocation) {
                        if (45 < degrees && degrees < 225) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y += 2;
                        }
                    } else if (BoundsLocation.BOTTOM_LEFT == targetBoundsLocation) {
                        if (225 < degrees && degrees < 360 || degrees > 0 && degrees < 45) {
                            targetPoint.x += 2;
                        } else {
                            targetPoint.y -= 2;
                        }
                    } else if (BoundsLocation.BOTTOM_RIGHT == targetBoundsLocation) {
                        if (45 < degrees && degrees < 225) {
                            targetPoint.x -= 2;
                        } else {
                            targetPoint.y -= 2;
                        }
                    }
                }
            } else {
                sourcePoint = sourceBounds.getCenter();
                targetPoint = targetBounds.getCenter();
                LOGGER.debug("Use center points - unable to determine source/target point");
            }
        } else {
            sourcePoint = sourceBounds.getBottom();
            targetPoint = targetBounds.getTop();
        }
        assert (sourcePoint != null) : "'sourcePoint' of method 'route' must not be null";
        assert (targetPoint != null) : "'targetPoint' of method 'route' must not be null";
        source.translateToAbsolute(sourcePoint);
        connection.translateToRelative(sourcePoint);
        points.addPoint(sourcePoint);
        source.translateToAbsolute(targetPoint);
        connection.translateToRelative(targetPoint);
        points.addPoint(targetPoint);
        connection.setPoints(points);
    }

    static enum BoundsLocation {
        TOP_1(3),
        TOP_2(3),
        BOTTOM_1(3),
        BOTTOM_2(3),
        RIGHT_1(2),
        RIGHT_2(2),
        LEFT_1(2),
        LEFT_2(2),
        TOP_RIGHT(1),
        BOTTOM_RIGHT(1),
        BOTTOM_LEFT(1),
        TOP_LEFT(1);

        private final int m_weight;

        private BoundsLocation(int weight) {
            this.m_weight = weight;
        }

        int getWeight() {
            return this.m_weight;
        }

        boolean isTop() {
            switch (this) {
                case TOP_1: 
                case TOP_2: {
                    return true;
                }
            }
            return false;
        }

        boolean isBottom() {
            switch (this) {
                case BOTTOM_1: 
                case BOTTOM_2: {
                    return true;
                }
            }
            return false;
        }

        boolean isBottomTop() {
            return this.isBottom() || this.isTop();
        }

        boolean isRight() {
            switch (this) {
                case RIGHT_1: 
                case RIGHT_2: {
                    return true;
                }
            }
            return false;
        }

        boolean isLeft() {
            switch (this) {
                case LEFT_1: 
                case LEFT_2: {
                    return true;
                }
            }
            return false;
        }

        boolean isRightLeft() {
            return this.isRight() || this.isLeft();
        }

        boolean isCorner() {
            switch (this) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: 
                case BOTTOM_LEFT: 
                case TOP_LEFT: {
                    return true;
                }
            }
            return false;
        }
    }

    static final class ConnectionInfo {
        private final int m_length;
        private final int m_distance;
        private final PointInfo m_source;
        private final PointInfo m_target;

        ConnectionInfo(int length, int distance, PointInfo source, PointInfo target) {
            assert (length >= 0) : "Parameter 'length' of method 'ConnectionInfo' must not be negative";
            assert (distance >= 0) : "Parameter 'distance' of method 'ConnectionInfo' must not be negative";
            assert (source != null) : "Parameter 'source' of method 'ConnectionInfo' must not be null";
            assert (target != null) : "Parameter 'target' of method 'ConnectionInfo' must not be null";
            this.m_length = length;
            this.m_distance = distance;
            this.m_source = source;
            this.m_target = target;
        }

        int getWeight() {
            BoundsLocation sourceBoundsLocation = this.m_source.getBoundsLocation();
            BoundsLocation targetBoundsLocation = this.m_target.getBoundsLocation();
            int factor = 1;
            if (sourceBoundsLocation.isBottomTop() && targetBoundsLocation.isBottomTop() || sourceBoundsLocation.isRightLeft() && targetBoundsLocation.isRightLeft()) {
                factor = 2;
            }
            int n = sourceBoundsLocation.getWeight() * factor;
            return n += targetBoundsLocation.getWeight() * factor;
        }

        int getLength() {
            return this.m_length;
        }

        int getDistance() {
            return this.m_distance;
        }

        PointInfo getSourcePointInfo() {
            return this.m_source;
        }

        PointInfo getTargetPointInfo() {
            return this.m_target;
        }

        public String toString() {
            return "Length '" + this.m_length + "', distance '" + this.m_distance + "': " + String.valueOf((Object)this.m_source.getBoundsLocation()) + " -> " + String.valueOf((Object)this.m_target.getBoundsLocation());
        }
    }

    static final class ConnectionInfoComparator
    implements Comparator<ConnectionInfo> {
        ConnectionInfoComparator() {
        }

        @Override
        public int compare(ConnectionInfo c1, ConnectionInfo c2) {
            assert (c1 != null) : "Parameter 'c1' of method 'compare' must not be null";
            assert (c2 != null) : "Parameter 'c2' of method 'compare' must not be null";
            int compared = c1.getWeight() - c2.getWeight();
            if (compared == 0 && (compared = c1.getLength() - c2.getLength()) == 0 && (compared = c1.getDistance() - c2.getDistance()) == 0) {
                compared = 1;
            }
            return 0;
        }
    }

    static final class ConnectionKey {
        private final GraphViewNode m_node1;
        private final GraphViewNode m_node2;
        private final BoundsLocation m_boundsLocation1;
        private final BoundsLocation m_boundsLocation2;

        ConnectionKey(GraphViewNode node1, GraphViewNode node2, BoundsLocation boundsLocation1, BoundsLocation boundsLocation2) {
            assert (node1 != null) : "Parameter 'node1' of method 'ConnectionKey' must not be null";
            assert (node2 != null) : "Parameter 'node2' of method 'ConnectionKey' must not be null";
            assert (node1 != node2) : "Same nodes";
            assert (boundsLocation1 != null) : "Parameter 'boundsLocation1' of method 'ConnectionKey' must not be null";
            assert (boundsLocation2 != null) : "Parameter 'boundsLocation2' of method 'ConnectionKey' must not be null";
            this.m_node1 = node1;
            this.m_node2 = node2;
            this.m_boundsLocation1 = boundsLocation1;
            this.m_boundsLocation2 = boundsLocation2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_boundsLocation1.hashCode();
            result = 31 * result + this.m_boundsLocation2.hashCode();
            result = 31 * result + this.m_node1.hashCode();
            result = 31 * result + this.m_node2.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionKey other = (ConnectionKey)obj;
            return this.m_node1 == other.m_node1 && this.m_node2 == other.m_node2 && this.m_boundsLocation1 == other.m_boundsLocation1 && this.m_boundsLocation2 == other.m_boundsLocation2;
        }
    }

    static final class PointInfo {
        private final Point m_point;
        private final Point m_pointForBoumdsCheck;
        private final Rectangle m_bounds;
        private final BoundsLocation m_boundsLocation;

        PointInfo(Point point, Point pointForBoumdsCheck, Rectangle bounds, BoundsLocation boundsLocation) {
            assert (point != null) : "Parameter 'point' of method 'PointInfo' must not be null";
            assert (pointForBoumdsCheck != null) : "Parameter 'pointForBoumdsCheck' of method 'PointInfo' must not be null";
            assert (bounds != null) : "Parameter 'bounds' of method 'PointInfo' must not be null";
            assert (boundsLocation != null) : "Parameter 'boundsLocation' of method 'PointInfo' must not be null";
            this.m_point = point;
            this.m_pointForBoumdsCheck = pointForBoumdsCheck;
            this.m_bounds = bounds;
            this.m_boundsLocation = boundsLocation;
        }

        Point getPoint() {
            return this.m_point;
        }

        Point getPointForBoumdsCheck() {
            return this.m_pointForBoumdsCheck;
        }

        Rectangle getBounds() {
            return this.m_bounds;
        }

        BoundsLocation getBoundsLocation() {
            return this.m_boundsLocation;
        }
    }

    static final class PointIterator
    implements Iterator<PointInfo> {
        private Rectangle m_bounds;
        private int m_index;

        PointIterator() {
        }

        void reset() {
            this.m_bounds = null;
            this.m_index = 0;
        }

        void initialize(Rectangle bounds) {
            assert (bounds != null) : "Parameter 'bounds' of method 'initialize' must not be null";
            this.m_bounds = bounds;
            this.m_index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.m_bounds != null && this.m_index < BoundsLocation.values().length;
        }

        @Override
        public PointInfo next() {
            assert (this.hasNext()) : "No next element";
            BoundsLocation boundsLocation = BoundsLocation.values()[this.m_index++];
            return GraphViewNodeConnectionFigureRouter.createPointInfo(this.m_bounds, boundsLocation);
        }
    }
}

