/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.AbstractConnectionAnchor;
import com.hello2morrow.draw2d.ChopboxAnchor;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.NameMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.AutozoomMode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableEdge;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewContentFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.graph.DrawableCurvedEdge;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graph.LoopEdgeFigure;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class GraphWidget
extends DrawableWidget {
    public GraphWidget(Composite parent, SelectionProviderAdapter selectionProviderAdapter, DrawableViewLayout layout, AutozoomMode autozoomMode) {
        super(parent, selectionProviderAdapter, layout, autozoomMode);
    }

    @Override
    protected <T extends NodeAndEdgeRepresentation> void showInternal(T representation, Map<NamedElement, Color> elementToColor) {
        assert (representation != null && representation instanceof GraphRepresentation) : "Unexpected class in method 'show': " + String.valueOf(representation);
        assert (elementToColor != null) : "Parameter 'elementToColor' of method 'showInternal' must not be null";
        GraphRepresentation graphRepresentation = (GraphRepresentation)representation;
        boolean architectureEnabled = CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE);
        for (RepresentationNode nextRepresentationNode : graphRepresentation.getNodes()) {
            NamedElement nextUnderlyingObject = nextRepresentationNode.getUnderlyingObject();
            Image image = UiResourceManager.getInstance().getImage((Element)nextUnderlyingObject);
            NamedElement underlyingObject = nextUnderlyingObject;
            NameMode nameMode = RepresentationUtility.getNameMode((NamedElement)underlyingObject, (PresentationMode)representation.getPresentationMode());
            GraphNodeFigure graphFigure = new GraphNodeFigure(this, nextRepresentationNode, image, nameMode, elementToColor.get(nextUnderlyingObject));
            this.addNode(nextRepresentationNode, graphFigure);
            graphFigure.setVisible(true);
            this.addNode(graphFigure);
        }
        for (RepresentationNode nextRepresentationNode : graphRepresentation.getNodes()) {
            for (RepresentationEdge nextEdge : nextRepresentationNode.getOutgoingEdges()) {
                this.createAndAddGraphEdgeFigure(graphRepresentation, (RepresentationEdge<? extends RepresentationNode>)nextEdge, architectureEnabled);
            }
        }
    }

    @Override
    public void updateColors(Map<NamedElement, Color> elementToColor, ArchitectureFile architectureFile) {
        assert (elementToColor != null) : "Parameter 'elementToColor' of method 'updateColors' must not be null";
        NodeAndEdgeRepresentation representation = this.getUnderlyingRepresentation();
        assert (representation != null && representation instanceof GraphRepresentation) : "Unexpected class in method 'updateColors': " + String.valueOf(representation);
        IProviderId issueProviderId = architectureFile != null ? architectureFile.getIssueProviderId() : null;
        for (RepresentationNode nextRepresentationNode : representation.getNodes()) {
            NamedElement nextUnderlyingObject = nextRepresentationNode.getUnderlyingObject();
            IDrawableNode nextNode = this.getNode(nextUnderlyingObject);
            assert (nextNode != null && nextNode instanceof GraphNodeFigure) : "Unexpected class in method 'updateColors': " + String.valueOf(nextNode);
            ((GraphNodeFigure)nextNode).updateBackgroundColor(elementToColor.get(nextUnderlyingObject));
            for (RepresentationEdge edge : nextRepresentationNode.getOutgoingEdges()) {
                edge.update(issueProviderId);
            }
        }
        this.forceUpdate();
    }

    @Override
    protected void autofit() {
        IFigure contents = this.getContents();
        assert (contents != null && contents instanceof DrawableViewContentFigure) : "Unexpected class in method 'autofit': " + String.valueOf(contents);
        DrawableViewContentFigure rootFigure = (DrawableViewContentFigure)contents;
        double availableHeight = this.getClientArea().height;
        Dimension nodeLayerPreferredSize = this.getNodesLayer().getPreferredSize();
        double totalWidetHeight = nodeLayerPreferredSize.height;
        double totalWidgetWidth = nodeLayerPreferredSize.width;
        double idealScaleForWidget = availableHeight / totalWidetHeight;
        if (idealScaleForWidget > (double)1.3f) {
            rootFigure.setScale(1.3f);
        } else {
            rootFigure.setScale(idealScaleForWidget);
        }
        rootFigure.getUpdateManager().performUpdate();
        rootFigure.setPreferredSize(new Dimension((int)Math.nextUp(totalWidgetWidth), (int)Math.nextUp(totalWidetHeight)));
    }

    protected AbstractConnectionAnchor getFromAnchor(GraphNodeFigure from) {
        assert (from != null) : "Parameter 'from' of method 'getFromAnchor' must not be null";
        return new ChopboxAnchor(from);
    }

    protected AbstractConnectionAnchor getToAnchor(GraphNodeFigure to) {
        assert (to != null) : "Parameter 'to' of method 'getFromAnchor' must not be null";
        return new ChopboxAnchor(to);
    }

    private void createAndAddGraphEdgeFigure(GraphRepresentation graphRepresentation, RepresentationEdge<? extends RepresentationNode> edge, boolean architectureEnabled) {
        assert (graphRepresentation != null) : "Parameter 'graphRepresentation' of method 'createAndAddGraphEdgeFigure' must not be null";
        assert (edge != null) : "Parameter 'edge' of method 'createAndAddGraphEdgeFigure' must not be null";
        RepresentationNode from = (RepresentationNode)edge.getFrom();
        RepresentationNode to = (RepresentationNode)edge.getTo();
        GraphNodeFigure fromFigure = (GraphNodeFigure)this.getNode(from);
        assert (fromFigure != null) : "'fromMasterFigure' of method 'show' must not be null for: " + String.valueOf(from);
        GraphNodeFigure toFigure = (GraphNodeFigure)this.getNode(to);
        assert (toFigure != null) : "'toMasterFigure' of method 'show' must not be null for: " + String.valueOf(to);
        DrawableEdge edgeFigure = from.equals(to) ? new LoopEdgeFigure<GraphNodeFigure>(this, edge, fromFigure, toFigure, architectureEnabled) : new DrawableCurvedEdge(this, edge, this.getFromAnchor(fromFigure), this.getToAnchor(toFigure), architectureEnabled);
        fromFigure.addEdge(edgeFigure);
        if (!from.equals(to) && from.findEdge(to, from) != null) {
            assert (edgeFigure != null && edgeFigure instanceof DrawableCurvedEdge) : "Unexpected class in method 'createAndAddGraphEdgeFigure': " + String.valueOf(edgeFigure);
            ((DrawableCurvedEdge)edgeFigure).setDepth(20);
        }
        this.addEdge(edge, edgeFigure);
        edgeFigure.setSelected(fromFigure.isSelected() || toFigure.isSelected());
        edgeFigure.setPaintViolationsOnly(this.showOnlyViolations());
        edgeFigure.setHideSelfArcs(this.hideSelfArcs());
        this.addEdge(edgeFigure);
    }

    public void setSelection(Collection<IDrawableFigure> items, boolean notifySelectionChanged) {
        assert (items != null) : "Parameter 'items' of method 'setSelection' must not be null";
        this.selected(items, false, notifySelectionChanged);
    }

    @Override
    protected RepresentationElement innerSelected(IDrawableFigure figure) {
        RepresentationNode element = null;
        if (figure instanceof GraphNodeFigure) {
            GraphNodeFigure treeNodeMasterFigure = (GraphNodeFigure)figure;
            element = treeNodeMasterFigure.getRepresentationElement();
        } else {
            assert (figure != null && figure instanceof IDrawableNode.IDrawableEdge) : "Unexpected class in method 'selected': " + String.valueOf(figure);
            IDrawableNode.IDrawableEdge edgeFigure = (IDrawableNode.IDrawableEdge)figure;
            GraphNodeFigure from = (GraphNodeFigure)edgeFigure.getFrom();
            GraphNodeFigure to = (GraphNodeFigure)edgeFigure.getTo();
            RepresentationEdge graphEdge = from.getRepresentationElement().findEdge(from.getRepresentationElement(), to.getRepresentationElement());
            assert (graphEdge != null) : "'treeEdge' of method 'selected' must not be null";
            element = graphEdge;
        }
        assert (element != null) : "'element' of method 'selected' must not be null";
        figure.setSelected(true);
        this.addToFullElementSelection(figure);
        return element;
    }

    @Override
    protected RepresentationElement innerDeselect(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'treeFigure' of method 'deselected' must not be null";
        RepresentationNode element = null;
        if (figure instanceof GraphNodeFigure) {
            GraphNodeFigure treeNodeMasterFigure = (GraphNodeFigure)figure;
            element = treeNodeMasterFigure.getRepresentationElement();
        } else {
            assert (figure != null && figure instanceof IDrawableNode.IDrawableEdge) : "Unexpected class in method 'selected': " + String.valueOf(figure);
            IDrawableNode.IDrawableEdge edgeFigure = (IDrawableNode.IDrawableEdge)figure;
            GraphNodeFigure from = (GraphNodeFigure)edgeFigure.getFrom();
            GraphNodeFigure to = (GraphNodeFigure)edgeFigure.getTo();
            RepresentationEdge treeEdge = from.getRepresentationElement().findEdge(from.getRepresentationElement(), to.getRepresentationElement());
            assert (treeEdge != null) : "'treeEdge' of method 'selected' must not be null";
            element = treeEdge;
        }
        figure.setSelected(false);
        this.removeFromFullElementSelection(figure);
        return element;
    }

    @Override
    protected boolean edgesHavePrecedence() {
        return false;
    }

    @Override
    public Set<CoreParserDependencyType> getParserDependencyTypesForEdges() {
        return ((GraphRepresentation)this.getUnderlyingRepresentation()).getParserDependencyTypesForEdges();
    }
}

