/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.TextSearchData;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class TextSearchDialog
extends StandardDialog
implements SelectionListener {
    private static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String WHOLE_WORD = "WHOLE_WORD";
    private static final String REGEXP = "REGEXP";
    private static final String TEXT_REPLACE = "TEXT_REPLACE";
    private static final String TEXT_FIND = "TEXT_FIND";
    private static TextSearchDialog s_dialog;
    private static String s_searchText;
    private static String s_replaceText;
    private TextSearchData m_textSearchData;
    private ITextSearchHandler m_provider;
    private ValidatingTextWidget m_textFind;
    private ValidatingTextWidget m_textReplace;
    private Label m_replaceLabel;
    private Button m_btnFind;
    private Button m_btnReplaceFind;
    private Button m_btnReplace;
    private Button m_btnReplaceAll;
    private Button m_checkCaseSensitive;
    private Button m_checkWholeWord;
    private Button m_checkRegex;

    static {
        s_searchText = "";
        s_replaceText = "";
    }

    public static TextSearchData show(ITextSearchHandler provider, Shell shell) {
        TextSearchData data;
        assert (provider != null) : "Parameter 'provider' of method 'show' must not be null";
        assert (shell != null) : "Parameter 'shell' of method 'show' must not be null";
        if (s_dialog == null) {
            s_dialog = new TextSearchDialog(provider, shell);
            data = TextSearchDialog.s_dialog.m_textSearchData;
            s_dialog.open();
        } else {
            s_dialog.reset(provider);
            data = TextSearchDialog.s_dialog.m_textSearchData;
        }
        return data;
    }

    public static TextSearchData connectIfPossible(ITextSearchHandler provider, TextSearchData textSearchData) {
        assert (provider != null) : "Parameter 'provider' of method 'connectIfPossible' must not be null";
        if (s_dialog != null) {
            s_dialog.connect(provider);
            TextSearchDialog.s_dialog.m_textSearchData.setSearchText(s_searchText);
            TextSearchDialog.s_dialog.m_textSearchData.setReplaceText(s_replaceText);
            return TextSearchDialog.s_dialog.m_textSearchData;
        }
        if (textSearchData != null) {
            if (!provider.isTextSearchDataCompatible(textSearchData)) {
                TextSearchData updatedTextSearchData = TextSearchDialog.updateTextSearchData(provider, textSearchData);
                updatedTextSearchData.setSearchText(s_searchText);
                updatedTextSearchData.setReplaceText(s_replaceText);
                return updatedTextSearchData;
            }
            textSearchData.setSearchText(s_searchText);
            textSearchData.setReplaceText(s_replaceText);
        }
        return null;
    }

    public static void revealNextOccurrence(ITextSearchHandler provider, TextSearchData data) {
        assert (provider != null) : "Parameter 'provider' of method 'revealNextOccurrence' must not be null";
        assert (data != null) : "Parameter 'data' of method 'revealNextOccurrence' must not be null";
        assert (data.isFindPossible()) : "Not search text available";
        provider.updateTextSearchData(data, ITextSearchHandler.UpdateOperation.REVEAL_NEXT_OCCURRENCE);
    }

    private TextSearchDialog(ITextSearchHandler provider, Shell shell) {
        super(shell, "Find", 2160);
        assert (provider != null) : "Parameter 'provider' of method 'TextSearchDialog' must not be null";
        this.m_provider = provider;
        this.m_textSearchData = provider.getTextSearchData();
        this.setBlockOnOpen(false);
    }

    private void reset(ITextSearchHandler provider) {
        boolean useRegexp;
        assert (provider != null) : "Parameter 'provider' of method 'reset' must not be null";
        this.m_provider = provider;
        provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.RESET);
        String selectedText = this.m_textSearchData.getSelectedTextInfo().getSelectedText();
        List lines = StringUtility.toList((String)StringUtility.harmonizeNewLineBreaks((String)selectedText));
        boolean isMultiLineInput = lines.size() > 1;
        boolean bl = useRegexp = this.m_checkRegex.getSelection() || isMultiLineInput;
        if (useRegexp) {
            selectedText = BaseTextSearchHandler.escapeLinesForRegexp(lines);
        }
        this.m_textFind.setText(selectedText);
        this.m_textFind.getTextField().setSelection(0, selectedText.length());
        this.m_textFind.validate(true);
        this.m_textFind.setFocus();
        if (this.m_provider.supportsReplace()) {
            this.m_textReplace.validate(true);
        }
        this.applySupportsReplaceState();
    }

    private void connect(ITextSearchHandler provider) {
        assert (provider != null) : "Parameter 'provider' of method 'connect' must not be null";
        this.m_provider = provider;
        if (!provider.isTextSearchDataCompatible(this.m_textSearchData)) {
            this.m_textSearchData = TextSearchDialog.updateTextSearchData(provider, this.m_textSearchData);
        }
        provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.CONNECT);
        this.applySupportsReplaceState();
    }

    private static TextSearchData updateTextSearchData(ITextSearchHandler handler, TextSearchData textSearchData) {
        assert (handler != null) : "Parameter 'handler' of method 'updateTextSearchData' must not be null";
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'updateTextSearchData' must not be null";
        TextSearchData newTextSearchData = handler.getTextSearchData();
        newTextSearchData.setSearchText(textSearchData.getSearchText());
        if (handler.supportsReplace()) {
            newTextSearchData.setReplaceText(textSearchData.getReplaceText());
        }
        newTextSearchData.setCaseSensitive(textSearchData.isCaseSensitive());
        newTextSearchData.setWholeWord(textSearchData.isWholeWord());
        return newTextSearchData;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        Label findLabel = new Label(composite, 0);
        findLabel.setText("Find:");
        findLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.m_textFind = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult validationResult = TextSearchDialog.this.m_textSearchData.isRegularExpression() ? TextSearchDialog.this.m_provider.isValidRegularSearchExpression(newInput) : new ValidationResult(StringUtility.areEqual((String)currentInput, (String)newInput));
                TextSearchDialog.this.m_textSearchData.setSearchText(newInput == null || validationResult.isFailure() ? "" : newInput);
                TextSearchDialog.this.m_textReplace.validate(false);
                TextSearchDialog.this.updatePossibleActionsState();
                return validationResult;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                TextSearchDialog.this.updatePossibleActionsState();
            }
        }, "", false, false, 2048);
        GridData textFindGridData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.m_textFind.setLayoutData(textFindGridData);
        this.m_replaceLabel = new Label(composite, 0);
        this.m_replaceLabel.setText("Replace with:");
        this.m_replaceLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.m_textReplace = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult validationResult = TextSearchDialog.this.m_textSearchData.isRegularExpression() ? TextSearchDialog.this.m_provider.isValidRegularReplaceExpression(TextSearchDialog.this.m_textFind.getTextField().getText(), newInput, TextSearchDialog.this.m_textSearchData.getSelectedTextInfo().getSelectedText()) : new ValidationResult(StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    TextSearchDialog.this.m_textSearchData.setReplaceText(newInput);
                }
                return validationResult;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                TextSearchDialog.this.updatePossibleActionsState();
            }
        }, "", false, false, 2048);
        GridData textReplaceGridData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.m_textReplace.setLayoutData(textReplaceGridData);
        Composite optionsComposite = new Composite(composite, 0);
        optionsComposite.setLayoutData((Object)new GridData(1, 0x1000008, false, false, 2, 1));
        optionsComposite.setLayout((Layout)new GridLayout(1, true));
        this.m_checkCaseSensitive = new Button(optionsComposite, 32);
        this.m_checkCaseSensitive.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_checkCaseSensitive.setText("Case sensitive");
        this.m_checkCaseSensitive.addSelectionListener((SelectionListener)this);
        this.m_checkWholeWord = new Button(optionsComposite, 32);
        this.m_checkWholeWord.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_checkWholeWord.setText("Whole word");
        this.m_checkWholeWord.addSelectionListener((SelectionListener)this);
        this.m_checkRegex = new Button(optionsComposite, 32);
        this.m_checkRegex.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_checkRegex.setText("Regular expressions");
        this.m_checkRegex.addSelectionListener((SelectionListener)this);
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, false, 2, 1));
        buttonsComposite.setLayout((Layout)new GridLayout(2, true));
        this.m_btnFind = new Button(buttonsComposite, 8);
        this.m_btnFind.setText("Find");
        this.m_btnFind.setSelection(true);
        this.m_btnFind.setEnabled(false);
        this.m_btnFind.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_btnFind.addSelectionListener((SelectionListener)this);
        this.m_btnReplaceFind = new Button(buttonsComposite, 8);
        this.m_btnReplaceFind.setText("Replace/Find");
        this.m_btnReplaceFind.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_btnReplaceFind.setEnabled(false);
        this.m_btnReplaceFind.addSelectionListener((SelectionListener)this);
        this.m_btnReplace = new Button(buttonsComposite, 8);
        this.m_btnReplace.setText("Replace");
        this.m_btnReplace.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_btnReplace.setEnabled(false);
        this.m_btnReplace.addSelectionListener((SelectionListener)this);
        this.m_btnReplaceAll = new Button(buttonsComposite, 8);
        this.m_btnReplaceAll.setText("Replace All");
        this.m_btnReplaceAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_btnReplaceAll.setEnabled(false);
        this.m_btnReplaceAll.addSelectionListener((SelectionListener)this);
        this.getShell().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (TextSearchDialog.this.m_provider != null && TextSearchDialog.this.m_provider.canConnect()) {
                    TextSearchDialog.this.connect(TextSearchDialog.this.m_provider);
                }
            }
        });
        this.getShell().setDefaultButton(this.m_btnFind);
    }

    @Override
    public boolean hasValidData() {
        return true;
    }

    @Override
    protected int getNumberOfColumns() {
        return 4;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                TextSearchDialog.this.close();
            }
        });
    }

    private void applySupportsReplaceState() {
        assert (this.m_provider != null) : "Parameter 'getProvider()' of method 'applyReplaceState' must not be null";
        boolean enable = this.m_provider.supportsReplace();
        this.m_replaceLabel.setEnabled(enable);
        this.m_textReplace.setEnabled(enable);
        if (enable) {
            this.changeTitle("Find/Replace in " + this.m_provider.getConnectedTo());
        } else {
            this.changeTitle("Find in " + this.m_provider.getConnectedTo());
        }
        this.updatePossibleActionsState();
    }

    private void updatePossibleActionsState() {
        this.m_btnFind.setEnabled(this.m_textSearchData.isFindPossible());
        boolean supportsReplace = this.m_provider.supportsReplace();
        boolean replacePossible = this.m_provider.isReplacePossible(this.m_textSearchData);
        boolean findDiffersReplace = !this.m_textFind.getTextField().getText().equals(this.m_textReplace.getTextField().getText());
        boolean enabled = supportsReplace && replacePossible && findDiffersReplace;
        this.m_btnReplace.setEnabled(enabled);
        this.m_btnReplaceFind.setEnabled(enabled);
        this.m_btnReplaceAll.setEnabled(enabled);
        this.m_textReplace.setEnabled(supportsReplace);
        this.m_checkWholeWord.setEnabled(!this.m_checkRegex.getSelection());
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        if (!this.m_provider.canConnect()) {
            return;
        }
        if (event.getSource() == this.m_btnFind) {
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.BUTTON_FIND_CLICKED);
            s_searchText = this.m_textFind.getTextField().getText();
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_btnReplaceFind) {
            s_replaceText = this.m_textFind.getTextField().getText();
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.BUTTON_REPLACE_FIND_CLICKED);
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_btnReplace) {
            s_replaceText = this.m_textFind.getTextField().getText();
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.BUTTON_REPLACE_CLICKED);
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_btnReplaceAll) {
            s_replaceText = this.m_textFind.getTextField().getText();
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.BUTTON_REPLACE_ALL_CLICKED);
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_checkCaseSensitive) {
            this.m_textSearchData.setCaseSensitive(this.m_checkCaseSensitive.getSelection());
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.CHECK_CASE_SENSITIVE_CLICKED);
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_checkWholeWord) {
            this.m_textSearchData.setWholeWord(this.m_checkWholeWord.getSelection());
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.CHECK_WHOLE_WORD_CLICKED);
            this.updatePossibleActionsState();
        } else if (event.getSource() == this.m_checkRegex) {
            this.m_textSearchData.setRegularExpression(this.m_checkRegex.getSelection());
            this.m_provider.updateTextSearchData(this.m_textSearchData, ITextSearchHandler.UpdateOperation.CHECK_REGULAR_EXPRESSION_CLICKED);
            IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.ui.swt");
            settings.putBoolean(WHOLE_WORD, this.m_checkWholeWord.getSelection());
            this.m_textFind.validate(false);
            this.m_textReplace.validate(false);
            this.updatePossibleActionsState();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public boolean close() {
        s_dialog = null;
        return super.close();
    }

    @Override
    protected void applyData() {
        boolean useRegexp;
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        boolean caseSensitive = settings.getBoolean(CASE_SENSITIVE, false);
        boolean wholeWord = settings.getBoolean(WHOLE_WORD, false);
        boolean regexp = settings.getBoolean(REGEXP, false);
        String initialFindText = this.m_textSearchData.getSearchText();
        if (initialFindText.isEmpty()) {
            initialFindText = settings.get(TEXT_FIND, "");
            useRegexp = regexp;
        } else {
            List lines = StringUtility.toList((String)StringUtility.harmonizeNewLineBreaks((String)initialFindText));
            boolean isMultiLineInput = lines.size() > 1;
            boolean bl = useRegexp = regexp || isMultiLineInput;
            if (useRegexp) {
                initialFindText = BaseTextSearchHandler.escapeLinesForRegexp(lines);
            }
        }
        this.m_textSearchData.setCaseSensitive(caseSensitive);
        this.m_textSearchData.setWholeWord(wholeWord && !useRegexp);
        this.m_textSearchData.setRegularExpression(useRegexp);
        this.m_textSearchData.setSearchText(initialFindText);
        this.m_textFind.setText(initialFindText);
        s_searchText = initialFindText;
        if (!s_searchText.isEmpty()) {
            this.m_textFind.getTextField().setSelection(0, s_searchText.length());
        }
        if (this.m_provider.supportsReplace()) {
            String initialReplaceText = this.m_textSearchData.getReplaceText();
            if (initialReplaceText.isEmpty()) {
                initialReplaceText = settings.get(TEXT_REPLACE, "");
            }
            this.m_textReplace.setText(initialReplaceText);
            this.m_textSearchData.setReplaceText(initialReplaceText);
            s_replaceText = initialReplaceText;
        }
        this.m_checkRegex.setSelection(useRegexp);
        this.m_checkCaseSensitive.setSelection(caseSensitive);
        this.m_checkWholeWord.setSelection(wholeWord);
        this.m_textFind.setFocus();
    }

    @Override
    protected IEclipsePreferences saveData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        settings.put(TEXT_FIND, this.m_textFind.getTextField().getText());
        if (this.m_provider.supportsReplace()) {
            settings.put(TEXT_REPLACE, this.m_textReplace.getTextField().getText());
        }
        settings.putBoolean(CASE_SENSITIVE, this.m_checkCaseSensitive.getSelection());
        settings.putBoolean(WHOLE_WORD, this.m_checkWholeWord.getSelection());
        settings.putBoolean(REGEXP, this.m_checkRegex.getSelection());
        return settings;
    }

    @Override
    protected IDialogId getDialogId() {
        return UiSwtDialogId.TEXT_SEARCH_DIALOG;
    }
}

