/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeViewerBasedView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleGroupBasedViewerComparator;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleGroupsViewContentProvider;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CycleGroupsView
extends TreeViewerBasedView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CycleGroupsView.class);
    private static final String FIRST_COLUMN = "Cycle";
    private final Map<IAnalyzerId, AnalyzerResult> m_analyzerResults = new THashMap();
    private final CycleGroupsViewContentProvider m_contentProvider = new CycleGroupsViewContentProvider();
    private TreeViewer m_treeViewer;
    private TreeViewerColumn m_treeViewerFirstColumn;
    private CycleGroupBasedViewerComparator m_comparator;
    private TreeBasedTextSearchHandler m_textSearchHandler;

    @Override
    public IViewId getViewId() {
        return ViewId.CYCLE_GROUPS_VIEW;
    }

    @Override
    protected TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    @Override
    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }

    @Override
    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    private void finishUpdate() {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED && !this.m_analyzerResults.isEmpty()) {
            Object[] expanded = this.m_treeViewer.getExpandedElements();
            this.m_treeViewer.expandToLevel(2);
            int cycles = 0;
            TreeItem[] treeItemArray = this.m_treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem nextItem = treeItemArray[n2];
                cycles += nextItem.getItemCount();
                ++n2;
            }
            this.m_treeViewerFirstColumn.getColumn().setText("Cycle [" + cycles + " " + StringUtility.pluralize((String)"element", (int)cycles) + "]");
            if (this.m_contentProvider.hasFiltered(this.m_analyzerResults.values())) {
                this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
            } else {
                this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
            }
            this.m_treeViewer.setExpandedElements(expanded);
        } else {
            this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
            this.m_treeViewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        }
    }

    public boolean getHideIgnored() {
        return this.m_contentProvider.getHideIgnored();
    }

    public void setHideIgnored(boolean hide) {
        if (this.m_contentProvider.setHideIgnored(hide)) {
            this.m_treeViewer.getTree().setRedraw(false);
            this.m_treeViewer.refresh();
            this.finishUpdate();
            this.m_treeViewer.getTree().setRedraw(true);
        }
    }

    public boolean getHideDuplicates() {
        return this.m_contentProvider.getHideDuplicates();
    }

    public void setHideDuplicates(boolean hide) {
        if (this.m_contentProvider.setHideDuplicates(hide)) {
            this.m_treeViewer.getTree().setRedraw(false);
            this.m_treeViewer.refresh();
            this.finishUpdate();
            this.m_treeViewer.getTree().setRedraw(true);
        }
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        this.m_treeViewer = new TreeViewer(viewContentArea, 66306);
        this.m_treeViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_treeViewer.setFilters(new ViewerFilter[]{this.m_contentProvider});
        this.m_comparator = new CycleGroupBasedViewerComparator();
        this.m_treeViewer.setComparator((ViewerComparator)this.m_comparator);
        this.m_textSearchHandler = new TreeBasedTextSearchHandler(this.m_treeViewer, this.getViewId().getPresentationName());
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_treeViewerFirstColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        this.m_treeViewerFirstColumn.getColumn().setWidth(320);
        this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        this.m_treeViewerFirstColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                }
                NamedElement underlyingElement = ((NamedElement)element).getElement();
                if (underlyingElement instanceof AnalyzerResult || underlyingElement instanceof CycleGroup || underlyingElement instanceof IRecursiveElement) {
                    return underlyingElement.getPresentationName(false);
                }
                return underlyingElement.getPresentationName(true);
            }

            public String getToolTipText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getToolTipText': " + String.valueOf(element)));
                }
                NamedElement underlyingElement = ((NamedElement)element).getElement();
                if (underlyingElement instanceof AnalyzerResult || underlyingElement instanceof CycleGroup || underlyingElement instanceof IRecursiveElement) {
                    return null;
                }
                return underlyingElement.getPresentationName(false);
            }

            public Image getImage(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(element)));
                }
                return UiResourceManager.getInstance().getImage((Element)((NamedElement)element));
            }
        });
        this.m_treeViewerFirstColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CycleGroupsView.this.m_comparator.setSort(CycleGroupBasedViewerComparator.Sort.NAME);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn sizeColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        sizeColumn.getColumn().setWidth(140);
        sizeColumn.getColumn().setText("Count");
        sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof AnalyzerResult) {
                    text = CycleGroupsView.this.m_contentProvider.getNumberOfNotFiltered(((AnalyzerResult)obj).getChildren(AnalyzerCycleGroup.class)) + " Cycle Group(s)";
                } else if (obj instanceof AnalyzerCycleGroup) {
                    text = ((AnalyzerCycleGroup)obj).getNumberOfCyclicElements() + " Cyclic Elements";
                }
                return text;
            }
        });
        sizeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CycleGroupsView.this.m_comparator.setSort(CycleGroupBasedViewerComparator.Sort.SIZE);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn scopeColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        scopeColumn.getColumn().setWidth(300);
        scopeColumn.getColumn().setText("Scope");
        scopeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                NamedElement scope;
                String text = null;
                if (obj instanceof AnalyzerCycleGroup && (scope = ((AnalyzerCycleGroup)obj).getScope()) != null) {
                    text = scope.getPresentationName(true);
                }
                return text;
            }

            public Image getImage(Object obj) {
                NamedElement scope;
                Image image = null;
                if (obj instanceof AnalyzerCycleGroup && (scope = ((AnalyzerCycleGroup)obj).getScope()) != null) {
                    image = UiResourceManager.getInstance().getImage((Element)scope);
                }
                return image;
            }
        });
        scopeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CycleGroupsView.this.m_comparator.setSort(CycleGroupBasedViewerComparator.Sort.SCOPE);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn locColumn = new TreeViewerColumn(this.m_treeViewer, 131072);
        locColumn.getColumn().setWidth(140);
        locColumn.getColumn().setText("Involved Lines of Code");
        locColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof AnalyzerCycleGroup) {
                    int loc = ((AnalyzerCycleGroup)obj).getLinesOfCodeOfInvolvedSourceFiles();
                    if (loc < 0) {
                        return "n/a";
                    }
                    return NumberUtility.format((Number)loc);
                }
                return null;
            }
        });
        locColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CycleGroupsView.this.m_comparator.setSort(CycleGroupBasedViewerComparator.Sort.LOC);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn resolutionColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        resolutionColumn.getColumn().setWidth(100);
        resolutionColumn.getColumn().setText("Resolution");
        resolutionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null) {
                        StringBuilder resolutionText = new StringBuilder();
                        if (associatedIssue.getResolution() != null) {
                            Resolution resolution = (Resolution)associatedIssue.getResolution();
                            if (resolution.ignores()) {
                                resolutionText.append("Ignored");
                            } else {
                                resolutionText.append("Task");
                                resolutionText.append(" ");
                                resolutionText.append("[");
                                resolutionText.append(resolution.getPriority().getPresentationName());
                                resolutionText.append("]");
                            }
                            text = resolutionText.toString();
                        }
                    }
                    if (text == null && !cycleGroup.isDuplicate()) {
                        text = cycleGroup.isDuplicate() ? "n/a" : "None";
                    }
                }
                return text;
            }

            public Image getImage(Object obj) {
                Image image = null;
                if (obj instanceof AnalyzerCycleGroup) {
                    Resolution resolution;
                    AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null && (resolution = (Resolution)associatedIssue.getResolution()) != null) {
                        image = resolution.ignores() ? UiResourceManager.getInstance().getImage("Ignore") : UiResourceManager.getInstance().getImage("Fix");
                    }
                    if (image == null && !cycleGroup.isDuplicate()) {
                        image = UiResourceManager.getInstance().getImage("None");
                    }
                }
                return image;
            }
        });
        resolutionColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CycleGroupsView.this.m_comparator.setSort(CycleGroupBasedViewerComparator.Sort.RESOLUTION_PRIORITY);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn duplicateOfColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        duplicateOfColumn.getColumn().setWidth(250);
        duplicateOfColumn.getColumn().setText("Duplicate Of");
        duplicateOfColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup duplicateOf = ((AnalyzerCycleGroup)obj).getDuplicateOf();
                    if (duplicateOf == null) {
                        return "";
                    }
                    return duplicateOf.getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(element)));
                }
                if (element instanceof AnalyzerCycleGroup && ((AnalyzerCycleGroup)element).isDuplicate()) {
                    return UiResourceManager.getInstance().getImage((Element)((NamedElement)element));
                }
                return null;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_treeViewer);
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult result;
                if (CycleGroupsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (result = event.getResult()).hasChildren(false, new Class[]{AnalyzerCycleGroup.class})) {
                    CycleGroupsView.this.m_analyzerResults.put(result.getId(), result);
                    LOGGER.debug("Added analyzer result");
                    CycleGroupsView.this.show(false, true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (CycleGroupsView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    for (Analyzer next : event.getAnalyzers()) {
                        CycleGroupsView.this.m_analyzerResults.remove(next.getId());
                    }
                    LOGGER.debug("Removed analyzer results {}", (Object)event.getAnalyzers());
                    CycleGroupsView.this.show(false, false);
                }
            }
        });
    }

    @Override
    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof NamedElement) {
            return (NamedElement)element.getElement();
        }
        return null;
    }

    @Override
    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        ArrayList<AnalyzerCycleGroup> cycleGroups = new ArrayList<AnalyzerCycleGroup>(elements.size());
        for (Element element : elements) {
            assert (element instanceof AnalyzerCycleGroup) : "Unexpected class in method 'finishShowInView': " + String.valueOf(element);
            cycleGroups.add((AnalyzerCycleGroup)element);
        }
        if (this.m_contentProvider.matchFilter(cycleGroups)) {
            this.m_treeViewer.refresh();
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
        this.removeListeners();
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection(cycleGroups));
        this.addListeners();
        super.finishShowInView(sourceViewId, elements, options);
    }

    private void show(boolean tryRefresh, boolean restoreNavigationState) {
        NavigationState state;
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        if (this.m_treeViewer.getInput() == null || !tryRefresh) {
            this.m_treeViewer.setInput(this.m_analyzerResults.values());
        } else {
            this.m_treeViewer.refresh();
        }
        if (restoreNavigationState && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            TreeBasedViewNavigationStateUtility.restoreViewState(this.m_treeViewer, state, this.getElementResolver());
        }
        if (!tryRefresh) {
            this.m_textSearchHandler.requestNewFindInfo();
        }
        this.finishUpdate();
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        for (Analyzer analyzer : ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getChildren(Analyzer.class)) {
            if (analyzer.getId().getGroup() != AnalyzerGroup.CYCLES || analyzer.getState() != AnalyzerState.FINISHED) continue;
            AnalyzerResult result = analyzer.getResult();
            this.m_analyzerResults.put(result.getId(), result);
        }
        this.show(false, mode == WorkbenchView.ShowMode.AWAKE);
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        boolean tryRefresh = true;
        if (modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
            this.m_analyzerResults.clear();
            tryRefresh = false;
        } else {
            Iterator<Map.Entry<IAnalyzerId, AnalyzerResult>> iterator = this.m_analyzerResults.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IAnalyzerId, AnalyzerResult> next = iterator.next();
                if (next.getValue().isValid()) continue;
                tryRefresh = false;
                iterator.remove();
            }
        }
        LOGGER.debug("softwareSystemModified. Modifications={}, tryRefresh={}", modification, (Object)tryRefresh);
        this.show(tryRefresh, true);
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    private void reset() {
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_analyzerResults.clear();
        this.m_treeViewer.setInput(null);
        this.finishUpdate();
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.reset();
    }

    @Override
    public List<Element> getSelectedElements() {
        assert (this.m_treeViewer != null) : "'m_propertyTableViewer' of method 'getSelected' must not be null";
        IStructuredSelection selection = (IStructuredSelection)this.m_treeViewer.getSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        for (Object next : selection.toList()) {
            if (!(next instanceof Element)) continue;
            selected.add((Element)next);
        }
        return selected;
    }

    public void setSelectedCycleGroups(List<String> groupNames) {
        assert (groupNames != null && !groupNames.isEmpty()) : "Parameter 'groupNames' of method 'setSelectedCycleGroups' must not be empty";
        ArrayList<AnalyzerCycleGroup> cycleGroups = new ArrayList<AnalyzerCycleGroup>();
        for (Map.Entry<IAnalyzerId, AnalyzerResult> entry : this.m_analyzerResults.entrySet()) {
            for (AnalyzerCycleGroup group : entry.getValue().getChildren(AnalyzerCycleGroup.class)) {
                if (!group.isValid() || !groupNames.contains(group.getName())) continue;
                cycleGroups.add(group);
            }
        }
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection(cycleGroups), true);
        for (AnalyzerCycleGroup group : cycleGroups) {
            if (!group.isValid() || this.m_treeViewer.getExpandedState((Object)group)) continue;
            this.m_treeViewer.setExpandedState((Object)group, true);
        }
    }
}

